/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.queue;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.openapi.base.queue.OpenQueueConsumer;
import kd.bos.openapi.base.queue.OpenQueueType;
import kd.bos.openapi.base.queue.consumer.ActionConsumer;
import kd.bos.openapi.base.queue.consumer.EmptyConsumer;
import kd.bos.openapi.base.queue.consumer.PollingConsumer;
import kd.bos.openapi.base.queue.impl.db.OpenDbQueueMgr;
import kd.bos.threads.ThreadPools;

public class OpenQueueMgr {
    private static final OpenQueueMgr instance = new OpenQueueMgr();
    private static final Map<String, OpenQueueConsumer> typeConsumers = new HashMap<String, OpenQueueConsumer>();
    private static final Log log = LogFactory.getLog(OpenQueueMgr.class);

    private OpenQueueMgr() {
    }

    public static OpenQueueMgr get() {
        return instance;
    }

    public void startService() {
        ThreadPools.executeOnce((String)"openapi queue service", () -> {
            AtomicInteger count = new AtomicInteger(0);
            List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
            accounts.forEach(account -> {
                RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
                try (AutoCloseable ignored = rc.setupThreadRequestContext();){
                    if (OpenDbQueueMgr.getOpenQueueEnabled()) {
                        OpenDbQueueMgr.getLoader();
                        count.getAndIncrement();
                    }
                }
                catch (Exception e) {
                    ExceptionLogger.log((String)"start openapi queue service error", (Throwable)e);
                }
            });
            log.info("OpenApi-Queue Service started, Current Cluster started account count:" + count.get());
        });
    }

    public OpenQueueConsumer findConsumeByQueue(String queue, String type) {
        OpenQueueConsumer consumer = typeConsumers.get(type);
        if (consumer == null) {
            consumer = typeConsumers.get(OpenQueueType.None.toString());
        }
        return consumer;
    }

    private static void initQueueConsumer() {
        typeConsumers.put(OpenQueueType.ApiAction.toString(), new ActionConsumer());
        typeConsumers.put(OpenQueueType.Pooling.toString(), new PollingConsumer());
        typeConsumers.put(OpenQueueType.None.toString(), new EmptyConsumer());
    }

    static {
        OpenQueueMgr.initQueueConsumer();
    }
}

