/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.queue.consumer;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.queue.OpenQueueAcker;
import kd.bos.openapi.base.queue.OpenQueueConsumer;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.model.OpenApiAsyncMsgModel;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;

public class ActionConsumer
implements OpenQueueConsumer<OpenApiAsyncMsgModel> {
    private static Log logger = LogFactory.getLog(ActionConsumer.class);

    @Override
    public void onMessage(OpenApiAsyncMsgModel model, long msgId, boolean resend, OpenQueueAcker acker) {
        try {
            long reqId = model.getReqId();
            if (reqId <= 0L) {
                acker.discard(msgId, "AsyncApi's reqId cannot be null.");
                return;
            }
            int apiType = model.getApiServiceType();
            ApiServiceType apiServiceType = ApiServiceType.get((int)apiType);
            OpenApiDataServiceFactory.getOpenApiAsyncDataService().executeApi(apiServiceType, reqId);
            acker.ack(msgId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            acker.discard(msgId, e.getMessage());
        }
    }
}

