/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.queue.impl.db;

import java.util.Collections;
import kd.bos.openapi.base.queue.OpenQueueAcker;
import kd.bos.openapi.base.queue.OpenQueueItemStatus;
import kd.bos.openapi.base.queue.impl.db.OpenDbQueueSaver;

public class OpenDbQueueAcker
implements OpenQueueAcker {
    private boolean isAck = false;

    @Override
    public void ack(long msgId) {
        if (this.isAck) {
            return;
        }
        this.isAck = true;
        OpenDbQueueSaver.cmpAndSetQueueItemStatus(msgId, Collections.singleton(OpenQueueItemStatus.R1), OpenQueueItemStatus.F1);
    }

    @Override
    public void deny(long msgId, String errMsg) {
        if (this.isAck) {
            return;
        }
        this.isAck = true;
        OpenDbQueueSaver.reEnQueue(msgId, errMsg);
    }

    @Override
    public void discard(long msgId, String errMsg) {
        if (this.isAck) {
            return;
        }
        this.isAck = true;
        OpenDbQueueSaver.setQueueItemStatus(msgId, OpenQueueItemStatus.E1, errMsg);
    }
}

