/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.queue.impl.db;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.db.RequestContextInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.openapi.base.queue.OpenQueueItem;
import kd.bos.openapi.base.queue.impl.db.OpenDbQueueMgr;

public class OpenDbQueueNotifier {
    private static final Log log = LogFactory.getLog(OpenDbQueueNotifier.class);
    private static long lastNotifyDate = 0L;

    public static void notify(OpenQueueItem item) {
        Date now = new Date();
        if (now.compareTo(item.getScheduleTime()) < 0) {
            return;
        }
        if (OpenDbQueueMgr.getLoader().runNow(item)) {
            return;
        }
        if (System.currentTimeMillis() - lastNotifyDate > 3000L) {
            lastNotifyDate = System.currentTimeMillis();
            Object[] params = new Object[]{RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), item.getId()};
            BroadcastService.broadcastMessageWithApp((String)"open", (String)OpenDbQueueNotifier.class.getName(), (String)"broadcastNotify", (Object[])params);
        }
    }

    public static void broadcastNotify(String tenantId, String accountId, long msgId) {
        RequestContextInfo rc = new RequestContextInfo(tenantId, accountId);
        try (AutoCloseable ignore = rc.setupThreadRequestContext();){
            OpenDbQueueMgr.getLoader().runNow(msgId);
        }
        catch (Exception ignore2) {
            log.error("Open-Exception\uff1a" + ignore2.getMessage(), (Throwable)ignore2);
        }
    }
}

