/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.queue.impl.db;

import java.io.IOException;
import java.util.Date;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.id.ID;
import kd.bos.openapi.base.queue.OpenQueueItem;
import kd.bos.openapi.base.queue.OpenQueueItemStatus;
import kd.bos.openapi.base.queue.OpenQueueUtil;
import kd.bos.openapi.common.constant.ApiConstant;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.util.JSONUtils;
import kd.bos.util.NetAddressUtils;

public class OpenDbQueueSaver {
    public static void add(OpenQueueItem item) {
        String fctx = "";
        try {
            fctx = JSONUtils.toString((Object)item.getRequestContext());
        }
        catch (IOException ex) {
            fctx = "";
        }
        String errMsg2 = StringUtil.trim((String)item.getErrMsg(), (int)400);
        if (errMsg2 == null) {
            errMsg2 = "";
        }
        String remark2 = StringUtil.trim((String)item.getRemark(), (int)200);
        SqlBuilder sql = new SqlBuilder().append("insert into t_openapi_queue (fid,ftype,fqueue,fdata,fstatus,fpriority,fscheduletime,fdeliveryCount,fqueuetag,freqid,fcreatetime,fctx,ferrMsg,fremark) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{item.getId(), item.getType().getCode(), item.getQueue(), item.getData(), item.getStatus(), item.getPriority().getCode(), item.getScheduleTime(), item.getDeliveryCount(), OpenQueueUtil.getHostTag(), item.getReqId(), new Date(), fctx, errMsg2, remark2});
        DB.execute((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);
    }

    public static void reEnQueue(long msgId, String errMsg) {
        String errMsg2 = StringUtil.trim((String)errMsg, (int)400);
        SqlBuilder sql = new SqlBuilder().append("UPDATE t_openapi_queue set fstatus=?,fstarttime=?, fmodifytime=?, fscheduleTime=?,ferrMsg=? WHERE fid=?", new Object[]{OpenQueueItemStatus.C1, null, null, new Date(), errMsg2, msgId});
        DB.update((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);
    }

    public static boolean setRunning(long msgId, long workerId) {
        String host = ID.toStringId((long)workerId) + ":" + NetAddressUtils.getLocalIpAddress();
        SqlBuilder sql = new SqlBuilder().append("UPDATE t_openapi_queue set fstatus=?,fstarttime=?,fdeliveryHost=? WHERE fid=? AND fstatus = ?", new Object[]{OpenQueueItemStatus.R1, new Date(), host, msgId, OpenQueueItemStatus.C1});
        int updateCount = DB.update((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);
        return updateCount > 0;
    }

    public static void setQueueItemStatus(long msgId, OpenQueueItemStatus status, String errMsg) {
        String errMsg2 = "";
        if (status == OpenQueueItemStatus.E1 || status == OpenQueueItemStatus.T1) {
            errMsg2 = StringUtil.trim((String)errMsg, (int)400);
        }
        SqlBuilder sql = new SqlBuilder().append("UPDATE t_openapi_queue set fstatus=?,fmodifytime=?,ferrMsg=? WHERE fid=?", new Object[]{status, new Date(), errMsg2, msgId});
        DB.update((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);
    }

    public static boolean cmpAndSetQueueItemStatus(long msgId, Set<OpenQueueItemStatus> expectStatus, OpenQueueItemStatus newStatus) {
        int updateCount;
        SqlBuilder sql = newStatus == OpenQueueItemStatus.E1 || newStatus == OpenQueueItemStatus.T1 ? new SqlBuilder().append("UPDATE t_openapi_queue set fstatus=?,fmodifytime=? WHERE fid=?", new Object[]{newStatus, new Date(), msgId}) : new SqlBuilder().append("UPDATE t_openapi_queue set fstatus=?,fmodifytime=?,ferrMsg='' WHERE fid=?", new Object[]{newStatus, new Date(), msgId});
        if (expectStatus != null && !expectStatus.isEmpty()) {
            if (expectStatus.size() > 1) {
                sql.append(" AND ", new Object[0]).appendIn("fstatus", expectStatus.toArray(new Object[0]));
            } else {
                sql.append(" AND ", new Object[0]).append("fstatus = ?", new Object[]{expectStatus.toArray(new Object[0])[0]});
            }
        }
        return (updateCount = DB.update((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql)) > 0;
    }
}

