/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.script.function.db;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.openapi.base.script.OpenApiScriptUtil;
import kd.bos.openapi.base.script.core.OpenApiTraceNativeFunction;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.trace.TraceSpan;

public abstract class AbstractDb
implements OpenApiTraceNativeFunction {
    private static final String BOS_OPEN_BASE = "bos-open-base";

    @Override
    public String traceType() {
        return "OpenAPI.Script.DB";
    }

    protected DataSet getQueryDataSet(Object[] args, String functionName, TraceSpan traceSpan) {
        OpenApiScriptUtil.checkParam(traceSpan, functionName, args, "routeKey", "ksql", "params");
        String routeKey = DataUtil.s((Object)args[0]);
        this.checkRouteKey(functionName, routeKey);
        String sql = DataUtil.s((Object)args[1]);
        this.checkSql(functionName, sql);
        List params = (List)args[2];
        return DB.queryDataSet((String)(AbstractDb.class.getName() + "." + functionName), (DBRoute)DBRoute.of((String)routeKey), (String)sql, (Object[])(params == null ? null : params.toArray()));
    }

    protected int update(Object[] args, String functionName, TraceSpan traceSpan) {
        OpenApiScriptUtil.checkParam(traceSpan, functionName, args, "routeKey", "ksql", "params");
        String routeKey = DataUtil.s((Object)args[0]);
        this.checkRouteKey(functionName, routeKey);
        String sql = DataUtil.s((Object)args[1]);
        this.checkSql(functionName, sql);
        List params = (List)args[2];
        return DB.update((DBRoute)DBRoute.of((String)routeKey), (String)sql, (Object[])params.toArray());
    }

    protected boolean execute(Object[] args, String functionName, TraceSpan traceSpan) {
        OpenApiScriptUtil.checkParam(traceSpan, functionName, args, "routeKey", "ksql", "params");
        String routeKey = DataUtil.s((Object)args[0]);
        this.checkRouteKey(functionName, routeKey);
        String sql = DataUtil.s((Object)args[1]);
        this.checkSql(functionName, sql);
        List params = (List)args[2];
        return DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)sql, (Object[])(params == null ? null : params.toArray()));
    }

    protected int[] executeBatch(Object[] args, String functionName, TraceSpan traceSpan) {
        OpenApiScriptUtil.checkParam(traceSpan, functionName, args, "routeKey", "ksql", "params");
        String routeKey = DataUtil.s((Object)args[0]);
        this.checkRouteKey(functionName, routeKey);
        String sql = DataUtil.s((Object)args[1]);
        this.checkSql(functionName, sql);
        List paramList = (List)args[2];
        if (CollectionUtil.isEmpty((Collection)paramList)) {
            throw new OpenApiException(ApiErrorCode.SCRIPT_ERROR, String.format(ResManager.loadKDString((String)"%s\uff1a params \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractDb_0", (String)BOS_OPEN_BASE, (Object[])new Object[0]), functionName), new Object[0]);
        }
        List params = paramList.stream().map(List::toArray).collect(Collectors.toList());
        return DB.executeBatch((DBRoute)DBRoute.of((String)routeKey), (String)sql, params);
    }

    private void checkRouteKey(String functionName, String routeKey) {
        if (StringUtil.isEmpty((String)routeKey)) {
            throw new OpenApiException(ApiErrorCode.SCRIPT_ERROR, String.format(ResManager.loadKDString((String)"%s\uff1a routeKey \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractDb_1", (String)BOS_OPEN_BASE, (Object[])new Object[0]), functionName), new Object[0]);
        }
    }

    private void checkSql(String functionName, String sql) {
        if (StringUtil.isEmpty((String)sql)) {
            throw new OpenApiException(ApiErrorCode.SCRIPT_ERROR, String.format(ResManager.loadKDString((String)"%s\uff1a sql \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractDb_2", (String)BOS_OPEN_BASE, (Object[])new Object[0]), functionName), new Object[0]);
        }
    }
}

