/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.script.function.db;

import java.util.ArrayList;
import java.util.Map;
import javax.script.ScriptContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.isc.util.db.DbUtil;
import kd.bos.openapi.base.script.function.db.AbstractDb;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.trace.TraceSpan;

public class QueryList
extends AbstractDb {
    private static final long MAX_SIZE = 0x2000000L;

    @Override
    public Object callWithTrace(ScriptContext ctx, Object[] args, TraceSpan traceSpan) {
        try (DataSet dataSet = this.getQueryDataSet(args, this.name(), traceSpan);){
            ArrayList<Map> result = new ArrayList<Map>(16);
            RowMeta rowMeta = dataSet.getRowMeta();
            long size = 0L;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Map map = rowMeta.toMap(row);
                if ((size += DbUtil.getObjectSize((Object)map)) > 0x2000000L) {
                    throw new OpenApiException(ApiErrorCode.HTTP_BODY_TOO_LARGE, String.format(ResManager.loadKDString((String)"DB.queryList \u67e5\u8be2\u6570\u636e\u8d85\u8fc7\u6700\u5927\u503c %d \u5b57\u8282\u3002", (String)"QueryList_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), 0x2000000L), new Object[0]);
                }
                result.add(map);
            }
            ArrayList<Map> arrayList = result;
            return arrayList;
        }
    }

    public String name() {
        return "queryList";
    }
}

