/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.auth.impl;

import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.openapi.base.util.DistributeCacheUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class AbstractAuthCheckService {
    private static final Log log = LogFactory.getLog(AbstractAuthCheckService.class);
    private static final String SignCacheKey = "SignAuthCheck";
    private static final String SIGNATURE_TIME_RANGE_MINUTES = "signature_time_range_minutes";

    protected void checkDateTimeAndSignture(String signature, String signatureNonce, String timestamp, String accountId) {
        if (StringUtil.isEmpty((String)signature)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u7f3a\u5c11signature\u53c2\u6570\u3002", (String)"SignAuthCheckServiceImpl_12", (String)"bos-open-base", (Object[])new Object[0]), new Object[0]);
        }
        if (StringUtil.isEmpty((String)signatureNonce)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u7f3a\u5c11signatureNonce\u53c2\u6570\u3002", (String)"SignAuthCheckServiceImpl_7", (String)"bos-open-base", (Object[])new Object[0]), new Object[0]);
        }
        if (StringUtil.isEmpty((String)timestamp)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:\u7f3a\u5c11timestamp\u53c2\u6570\u3002", (String)"SignAuthCheckServiceImpl_8", (String)"bos-open-base", (Object[])new Object[0]), new Object[0]);
        }
        Date sDate = null;
        sDate = kd.bos.util.StringUtils.isNumericString((String)timestamp) ? DateUtil.getTime((String)timestamp) : DateUtils.parseDateTime((String)timestamp, (String)"yyyy-MM-dd HH:mm:ss");
        if (sDate == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:timestamp\u53c2\u6570\u4e0d\u662f\u6b63\u786e\u7684\u65e5\u671f\u683c\u5f0f\uff0c\u6b63\u786e\u7684\u683c\u5f0f\u662f\uff1a{0}", (String)"SignAuthCheckServiceImpl_9", (String)"bos-open-base", (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"}), new Object[0]);
        }
        int rangMiutes = this.getSignRangeMinutes(accountId);
        Date now = new Date();
        if (Math.abs(now.getTime() - sDate.getTime()) / 60000L > (long)rangMiutes) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:timestamp\u53c2\u6570\u4e0d\u5728\u6b63\u786e\u7684\u65f6\u95f4\u8303\u56f4\u3002", (String)"SignAuthCheckServiceImpl_10", (String)"bos-open-base", (Object[])new Object[0]), new Object[0]);
        }
        String currentNonce = DistributeCacheUtil.getCacheByKey(SignCacheKey, signatureNonce, accountId);
        if (StringUtil.isNotEmpty((String)currentNonce)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u672c\u6b21\u53c2\u6570signatureNonce:{0}\u5df2\u7ecf\u8c03\u7528\u8fc7\u4e86\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u8c03\u7528\u3002", (String)"SignAuthCheckServiceImpl_11", (String)"bos-open-base", (Object[])new Object[]{currentNonce}), new Object[0]);
        }
        DistributeCacheUtil.setCacheByKey(SignCacheKey, signatureNonce, "1", accountId, rangMiutes * 60);
    }

    private int getSignRangeMinutes(String accountId) {
        int returnValue = 10;
        String signRangeMinuteString = System.getProperty(accountId + "_" + SIGNATURE_TIME_RANGE_MINUTES);
        if (StringUtils.isEmpty((CharSequence)signRangeMinuteString)) {
            signRangeMinuteString = System.getProperty(SIGNATURE_TIME_RANGE_MINUTES);
        }
        if (StringUtils.isNotEmpty((CharSequence)signRangeMinuteString)) {
            try {
                returnValue = Integer.parseInt(signRangeMinuteString);
            }
            catch (Exception e) {
                log.error("getSignRangeMinutes:" + e.getMessage(), (Throwable)e);
            }
        }
        return returnValue;
    }
}

