/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.auth.impl;

import java.util.Base64;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.security.auth.AuthCheckService;
import kd.bos.openapi.base.util.DistributeCacheUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.service.authorize.model.AccessTokenInfo;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.service.authorize.model.OAuth2Authentication;

public class AccessTokenAuthCheckServiceImpl
implements AuthCheckService {
    private static final Log log = LogFactory.getLog(AccessTokenAuthCheckServiceImpl.class);

    @Override
    public AuthResult doAuthCheck(AuthInfo authInfo) {
        if (authInfo == null || StringUtil.isEmpty((String)authInfo.getAccessToken())) {
            return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u53c2\u6570\u4e3a\u7a7a", (String)"BasicAuthCheckServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        String accessToken = authInfo.getAccessToken();
        String tokenKey = "ACCESS_TOKEN_KEY_" + accessToken;
        String oauthAuthJsonString = DistributeCacheUtil.getCacheByKey("AUTH_ACCESS_TOKEN_CACHE", tokenKey, "CACHE_OPENAPI_AUTH");
        if (StringUtil.isEmpty((String)oauthAuthJsonString)) {
            return AuthResult.fail((String)ResManager.loadKDString((String)"AccessToken\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0ctoken\u5df2\u8fc7\u671f", (String)"BasicAuthCheckServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        OAuth2Authentication auth2Authentication = (OAuth2Authentication)JacksonUtil.readValue((String)oauthAuthJsonString, OAuth2Authentication.class);
        if (auth2Authentication == null) {
            return AuthResult.fail((String)ResManager.loadKDString((String)"AccessToken\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0ctoken\u5df2\u8fc7\u671f", (String)"BasicAuthCheckServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        String realToken = "";
        try {
            String oldTokenBase = accessToken.substring("OPENAPIAUTH_".length());
            realToken = new String(Base64.getUrlDecoder().decode(oldTokenBase));
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, ResManager.loadKDString((String)"AccessToken\u8ba4\u8bc1\u672a\u901a\u8fc7\u3002", (String)"OAuth2Filter_2", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
        }
        OAuth2Authentication accessTokenAuth = new OAuth2Authentication();
        AccessTokenInfo accessTokenInfo = new AccessTokenInfo();
        accessTokenInfo.setToken(realToken);
        accessTokenAuth.setToken(accessTokenInfo);
        accessTokenAuth.setAccountId(authInfo.getAccountId());
        ApiCommonResult result = ApiSecurityFactory.getAccessTokenService().verifyAccessToken(accessTokenAuth);
        if (!result.getStatus().booleanValue()) {
            return AuthResult.fail((String)ResManager.loadKDString((String)"AccessToken\u8ba4\u8bc1\u4e0d\u901a\u8fc7", (String)"BasicAuthCheckServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        AuthResult authResult = new AuthResult();
        authResult.setThirdId(auth2Authentication.getThirdId());
        authResult.setThirdAppNumber(auth2Authentication.getThirdAppNumber());
        authResult.setAgentUserId(auth2Authentication.getAgentUserId());
        authResult.setStatus(result.getStatus().booleanValue());
        authResult.setAccessToken(realToken);
        authResult.setAccountId(auth2Authentication.getAccountId());
        return authResult;
    }
}

