/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.auth.impl;

import java.util.Collection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.openapi.base.security.auth.AuthCheckService;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.security.model.BaseAuthInfoDto;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;

public class BasicAuthCheckServiceImpl
implements AuthCheckService {
    @Override
    public AuthResult doAuthCheck(AuthInfo authInfo) {
        if (authInfo == null || StringUtil.isEmpty((String)authInfo.getAccessKey())) {
            return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u53c2\u6570\u4e3a\u7a7a", (String)"BasicAuthCheckServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        String signEncode = EncrypterFactory.getEncrypter().encode(authInfo.getAccessKey());
        BaseAuthInfoDto baseAuthResult = ThirdAppSecurityUtil.getBaseAuthInfoBySign(authInfo.getAccountId(), signEncode);
        if (!baseAuthResult.isBasicAuth()) {
            return AuthResult.fail((String)ResManager.loadKDString((String)"\u57fa\u672c\u8ba4\u8bc1\u672a\u5f00\u542f\uff0c\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c", (String)"BasicAuthCheckServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        Open3rdappsDto thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndAppId(authInfo.getAccountId(), baseAuthResult.getThirdNumber());
        if (thirdApp == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\u3002", (String)"DigestAuthCheckServiceImpl_4", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        if (thirdApp.isEnableAgency() && (CollectionUtil.isEmpty((Collection)thirdApp.getAgentUserIdList()) || !thirdApp.getAgentUserIdList().contains(baseAuthResult.getAgentUserId()))) {
            throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\u672a\u8bbe\u7f6e\u4ee3\u7406\u7528\u6237\u6216\u7528\u6237\u4e0d\u5728\u8be5\u4ee3\u7406\u7528\u6237\u4e2d\u3002", (String)"DigestAuthCheckServiceImpl_3", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        AuthResult result = new AuthResult();
        result.setThirdId(baseAuthResult.getThirdId());
        result.setThirdAppNumber(baseAuthResult.getThirdNumber());
        result.setAgentUserId(baseAuthResult.getAgentUserId());
        result.setStatus(baseAuthResult.isStatus());
        return result;
    }
}

