/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.auth.impl;

import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.utils.LoginUtils;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.security.auth.AuthCheckService;
import kd.bos.openapi.base.security.auth.impl.AbstractAuthCheckService;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.security.model.BaseAuthInfoDto;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;

public class DigestAuthCheckServiceImpl
extends AbstractAuthCheckService
implements AuthCheckService {
    private static final Log log = LogFactory.getLog(DigestAuthCheckServiceImpl.class);

    @Override
    public AuthResult doAuthCheck(AuthInfo authInfo) {
        if (authInfo == null || authInfo.getSignInfo() == null) {
            return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u53c2\u6570\u4e3a\u7a7a", (String)"DigestAuthCheckServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        String accountId = StringUtil.isEmpty((String)authInfo.getAccountId()) ? authInfo.getSignInfo().getAccountId() : authInfo.getAccountId();
        this.checkDateTimeAndSignture(authInfo.getSignInfo().getSignature(), authInfo.getSignInfo().getSignatureNonce(), authInfo.getSignInfo().getDateTime(), accountId);
        AuthResult result = new AuthResult();
        BaseAuthInfoDto basicCheckResult = null;
        Long agentUserId = null;
        Open3rdappsDto thirdApp = null;
        if (authInfo.isCommonAuth()) {
            if (StringUtil.isEmpty((String)authInfo.getAccessKey())) {
                return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u53c2\u6570\uff08\u57fa\u672c\u8ba4\u8bc1Secret Key\uff09\u4e3a\u7a7a", (String)"DigestAuthCheckServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            String signEncode = EncrypterFactory.getEncrypter().encode(authInfo.getAccessKey());
            basicCheckResult = ThirdAppSecurityUtil.getBaseAuthInfoBySign(accountId, signEncode);
            if (!basicCheckResult.isBasicAuth()) {
                return AuthResult.fail((String)ResManager.loadKDString((String)"\u57fa\u672c\u8ba4\u8bc1\u672a\u542f\u7528\u3002", (String)"DigestAuthCheckServiceImpl_5", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            agentUserId = basicCheckResult.getAgentUserId();
            if (agentUserId == null || agentUserId == 0L) {
                return AuthResult.fail((String)ResManager.loadKDString((String)"\u57fa\u672c\u8ba4\u8bc1\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"DigestAuthCheckServiceImpl_6", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            authInfo.setUser(basicCheckResult.getAgentUserId().toString());
            if (basicCheckResult.getThirdId() == null || basicCheckResult.getThirdId() == 0L) {
                return AuthResult.fail((String)ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528ID\u4e3a\u7a7a", (String)"DigestAuthCheckServiceImpl_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            authInfo.getSignInfo().setThirdId(basicCheckResult.getThirdId());
            authInfo.getSignInfo().setThirdAppNumber(basicCheckResult.getThirdNumber());
            thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndAppId(accountId, basicCheckResult.getThirdNumber());
        } else {
            String appId = StringUtil.isEmpty((String)authInfo.getThirdAppNumber()) ? authInfo.getSignInfo().getThirdAppNumber() : authInfo.getThirdAppNumber();
            thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndAppId(accountId, appId);
            if (thirdApp == null) {
                result.setMessage("invalidAppId");
                result.setStatus(false);
                return result;
            }
            Account account = AccountUtils.getAccountById((String)accountId);
            UserProperType aType = UserProperType.getUserProperTypeByString((String)authInfo.getUserType());
            if (aType == null) {
                throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef:usertype\u53c2\u6570\u4e0d\u6b63\u786e\u3002", (String)"DigestFilter_9", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
            }
            Map userInfo = LoginUtils.getUserInfoByAPIUserType((Account)account, (String)authInfo.getUser(), (String)authInfo.getUserType(), (Lang)Lang.from((String)authInfo.getLanguage()));
            if (userInfo == null || userInfo.get("fid") == null) {
                throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"DigestAuthCheckServiceImpl_2", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
            }
            agentUserId = Long.parseLong((String)userInfo.get("fid"));
        }
        if (thirdApp.isEnableAgency() && (CollectionUtil.isEmpty((Collection)thirdApp.getAgentUserIdList()) || !thirdApp.getAgentUserIdList().contains(agentUserId))) {
            throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\u672a\u8bbe\u7f6e\u4ee3\u7406\u7528\u6237\u6216\u7528\u6237\u4e0d\u5728\u8be5\u4ee3\u7406\u7528\u6237\u4e2d\u3002", (String)"DigestAuthCheckServiceImpl_3", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        boolean signResult = false;
        try {
            signResult = ApiSecurityFactory.getSignService().vertifySign(authInfo.getSignInfo());
        }
        catch (Exception e) {
            result.setMessage("invalidAppId");
            log.info("invalidAppId:" + e.getMessage(), (Object)e);
        }
        result.setStatus(signResult);
        result.setAgentUserId(agentUserId);
        if (thirdApp != null) {
            result.setThirdAppNumber(thirdApp.getNumber());
            result.setThirdId(thirdApp.getFid());
        }
        return result;
    }
}

