/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.auth.impl;

import java.util.Date;
import java.util.UUID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.security.auth.ResultHandleService;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.openapi.security.model.ResponseSecurityDto;
import kd.bos.openapi.security.model.SignInfoDto;
import kd.bos.service.authorize.model.AuthTypeEnum;
import org.eclipse.jetty.util.ajax.JSON;

public class DigestResultHandleServiceImpl
implements ResultHandleService {
    private static final Log log = LogFactory.getLog(DigestResultHandleServiceImpl.class);

    @Override
    public <T> Object doResultHandle(ResponseSecurityDto<T> responseSecurityDto) {
        Object result = responseSecurityDto.getData();
        Open3rdappsDto thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndThirdId(responseSecurityDto.getAccountId(), responseSecurityDto.getThirdId());
        if (!thirdApp.isResultSignHandle()) {
            return result;
        }
        SignInfoDto signInfo = new SignInfoDto();
        signInfo.setContent(JSON.toString((Object)responseSecurityDto.getData()));
        signInfo.setThirdId(responseSecurityDto.getThirdId());
        signInfo.setThirdAppNumber(responseSecurityDto.getThirdAppNumber());
        String timestamp = DateUtil.convertToStr((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        signInfo.setDateTime(timestamp);
        String uuid = UUID.randomUUID().toString();
        signInfo.setSignatureNonce(uuid);
        signInfo.setAuthType(AuthTypeEnum.AUTH_DIGEST.getId());
        signInfo.setAccountId(responseSecurityDto.getAccountId());
        String signure = ApiSecurityFactory.getSignService().signing(signInfo);
        responseSecurityDto.setSignature(signure);
        return responseSecurityDto;
    }
}

