/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.auth.impl;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.security.auth.AuthCheckService;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.spi.OpenApiServiceManager;
import kd.bos.openapi.security.model.BaseAuthInfoDto;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.service.authorize.model.JwtInfo;

public class JwtAuthCheckServiceImpl
implements AuthCheckService {
    private static final Log log = LogFactory.getLog(JwtAuthCheckServiceImpl.class);

    @Override
    public AuthResult doAuthCheck(AuthInfo authInfo) {
        Map userMap;
        if (authInfo == null || authInfo.getJwtInfo() == null) {
            return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u53c2\u6570\u4e3a\u7a7a", (String)"JwtAuthCheckServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        JwtInfo jwtInfo = authInfo.getJwtInfo();
        BaseAuthInfoDto basicCheckResult = null;
        if (authInfo.isCommonAuth()) {
            if (StringUtil.isEmpty((String)authInfo.getAccessKey())) {
                return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u53c2\u6570\u4e3a\u7a7a", (String)"JwtAuthCheckServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            String signEncode = EncrypterFactory.getEncrypter().encode(authInfo.getAccessKey());
            basicCheckResult = ThirdAppSecurityUtil.getBaseAuthInfoBySign(authInfo.getAccountId(), signEncode);
            authInfo.setUser(basicCheckResult.getAgentUserId().toString());
            jwtInfo.setThirdId(basicCheckResult.getThirdId());
            jwtInfo.setThirdAppNumber(basicCheckResult.getThirdNumber());
        }
        try {
            userMap = (Map)ApiSecurityFactory.getSignService().versifyJWTToken(jwtInfo);
        }
        catch (Exception e) {
            log.info("JWT failed:" + e.getMessage(), (Object)e);
            return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8ba4\u8bc1\u5931\u8d25", (String)"JwtAuthCheckServiceImpl_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        if (userMap == null) {
            return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a", (String)"JwtAuthCheckServiceImpl_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        AuthResult result = new AuthResult();
        result.setStatus(true);
        result.setUserInfo(userMap);
        if (authInfo.isCommonAuth()) {
            if (basicCheckResult == null || basicCheckResult.getThirdId() == null) {
                return AuthResult.fail((String)ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528ID\u4e3a\u7a7a", (String)"JwtAuthCheckServiceImpl_2", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            result.setThirdAppNumber(basicCheckResult.getThirdNumber());
            result.setThirdId(basicCheckResult.getThirdId());
        } else {
            Open3rdappsDto thirdApp = OpenApiServiceManager.getOpenApiAuthService().getThirdAppDtoByNum(authInfo.getJwtInfo().getThirdAppNumber(), authInfo.getJwtInfo().getAccountId());
            if (thirdApp == null || thirdApp.getFid() == null) {
                return AuthResult.fail((String)ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528ID\u4e3a\u7a7a", (String)"JwtAuthCheckServiceImpl_2", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            result.setThirdAppNumber(thirdApp.getNumber());
            result.setThirdId(thirdApp.getFid());
        }
        return result;
    }

    public <T> String generateJWTToken(JwtInfo<T> jwtInfo) {
        Open3rdappsDto thirdApp = OpenApiServiceManager.getOpenApiAuthService().getThirdAppDtoByNum(jwtInfo.getThirdAppNumber(), jwtInfo.getAccountId());
        if (thirdApp.isJwtAuthEnable()) {
            return ApiSecurityFactory.getSignService().generateJWTToken(jwtInfo);
        }
        throw new OpenApiException(ApiErrorCode.Data_Invalid, "The thirdApp's JwtAuthEnable is false.", new Object[0]);
    }
}

