/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.auth.impl;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.security.auth.AuthCheckService;
import kd.bos.openapi.base.security.auth.impl.AbstractAuthCheckService;
import kd.bos.openapi.base.util.DistributeCacheUtil;
import kd.bos.openapi.base.util.ShaSignUtils;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.security.ApiSecurityService;
import kd.bos.openapi.security.CertKeyUtil;
import kd.bos.openapi.security.model.BaseAuthInfoDto;
import kd.bos.openapi.security.model.CertificateInfo;
import kd.bos.openapi.security.model.EncryptionEnum;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.openapi.security.model.RequestSecurityDto;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;

public class SignAuthCheckServiceImpl
extends AbstractAuthCheckService
implements AuthCheckService {
    private static final Log log = LogFactory.getLog(SignAuthCheckServiceImpl.class);

    @Override
    public AuthResult doAuthCheck(AuthInfo authInfo) {
        if (authInfo == null || StringUtil.isEmpty((String)authInfo.getAccessKey())) {
            return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u53c2\u6570\u4e3a\u7a7a", (String)"SignAuthCheckServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        String signEncode = EncrypterFactory.getEncrypter().encode(authInfo.getAccessKey());
        BaseAuthInfoDto baseAuthResult = ThirdAppSecurityUtil.getBaseAuthInfoBySign(authInfo.getAccountId(), signEncode);
        if (baseAuthResult == null || baseAuthResult.getThirdId() == null) {
            return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8bf7\u68c0\u67e5OpenApiSign", (String)"SignAuthCheckServiceImpl_3", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        }
        AuthResult result = new AuthResult();
        result.setThirdId(baseAuthResult.getThirdId());
        result.setThirdAppNumber(baseAuthResult.getThirdNumber());
        result.setAgentUserId(baseAuthResult.getAgentUserId());
        try {
            Open3rdappsDto thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndThirdId(authInfo.getAccountId(), result.getThirdId());
            if (thirdApp == null || thirdApp.getSignType() == null) {
                throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\u7b7e\u540d\u8ba4\u8bc1\u3002", (String)"SignAuthCheckServiceImpl_15", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
            }
            if (thirdApp.isEnableAgency() && (CollectionUtil.isEmpty((Collection)thirdApp.getAgentUserIdList()) || !thirdApp.getAgentUserIdList().contains(baseAuthResult.getAgentUserId()))) {
                throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\u672a\u8bbe\u7f6e\u4ee3\u7406\u7528\u6237\u6216\u7528\u6237\u4e0d\u5728\u8be5\u4ee3\u7406\u7528\u6237\u4e2d\u3002", (String)"DigestAuthCheckServiceImpl_3", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
            }
            if (!thirdApp.isSignAuthEnable()) {
                return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u672a\u542f\u52a8\u7b7e\u540d\u8ba4\u8bc1", (String)"SignAuthCheckServiceImpl_5", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            if (!thirdApp.isEncryptAllApi() && thirdApp.getEncryptApiMap().isEmpty() || !thirdApp.isEncryptAllApi() && !thirdApp.isEncryptApi(authInfo.getUrl())) {
                return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u672a\u914d\u7f6e\u52a0\u5bc6API\u5217\u8868", (String)"SignAuthCheckServiceImpl_6", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            if (StringUtil.isEmpty((String)authInfo.getSignInfo().getContent())) {
                return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u53c2\u6570content\u4e3a\u7a7a", (String)"SignAuthCheckServiceImpl_10", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            boolean signCheckResult = false;
            boolean isThirdCall = true;
            ApiSecurityService apiSecurityService = ApiSecurityFactory.getApiSecurityService();
            String body = authInfo.getSignInfo().getContent();
            RequestSecurityDto dto = (RequestSecurityDto)JSON.toJavaObject((JSON)JSON.parseObject((String)body), RequestSecurityDto.class);
            if (dto == null) {
                return AuthResult.fail((String)ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e0d\u901a\u8fc7\uff0c\u53c2\u6570\u4e3a\u7a7a", (String)"SignAuthCheckServiceImpl_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            CertificateInfo bosCertificateInfo = (CertificateInfo)thirdApp.getCertMaps().get(CertKeyUtil.getCertKey((String)"5", (String)"0"));
            CertificateInfo thirdCertificateInfo = (CertificateInfo)thirdApp.getCertMaps().get(CertKeyUtil.getCertKey((String)"5", (String)"1"));
            switch (thirdApp.getSignType().intValue()) {
                case 1: {
                    String signShaKey = EncryptUtil.decode((String)thirdApp.getSignShaKey());
                    String signString = dto.getSignature();
                    String timestamp = dto.getTimestamp();
                    String signatureNonce = dto.getSignatureNonce();
                    this.checkDateTimeAndSignture(dto.getSignature(), dto.getSignatureNonce(), dto.getTimestamp(), authInfo.getAccountId());
                    dto.setSignature(null);
                    String signContext = JSON.toJSONString((Object)dto);
                    StringBuilder sb = ShaSignUtils.getSignatureString(timestamp, signatureNonce, signContext);
                    String signStr = ApiSecurityFactory.getSignService().signBySha256(sb.toString(), signShaKey);
                    signCheckResult = signString.equalsIgnoreCase(signStr);
                    break;
                }
                case 2: {
                    String sense = StringUtil.isEmpty((String)authInfo.getSense()) ? "1" : authInfo.getSense();
                    isThirdCall = "1".equals(sense);
                    String signString = dto.getSignature();
                    dto.setSignature(null);
                    String signStr = isThirdCall ? apiSecurityService.unSignByPublicKey(signString, thirdCertificateInfo.getPublicKeyBase64()) : apiSecurityService.unSignByPublicKey(signString, bosCertificateInfo.getPublicKeyBase64());
                    signCheckResult = JSON.toJSONString((Object)dto).equalsIgnoreCase(signStr);
                }
            }
            if (!signCheckResult) {
                return AuthResult.fail((String)ResManager.loadKDString((String)"\u7b7e\u540d\u8ba4\u8bc1\u5931\u8d25", (String)"SignAuthCheckServiceImpl_4", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            String dgtlEnvlpStr = "";
            switch (thirdApp.getSignType().intValue()) {
                case 1: {
                    dgtlEnvlpStr = apiSecurityService.unSignByPrivateKey(dto.getDgtlEnvlp(), bosCertificateInfo.getPrivateKeyBase64());
                    break;
                }
                case 2: {
                    if (isThirdCall) {
                        dgtlEnvlpStr = apiSecurityService.unSignByPrivateKey(dto.getDgtlEnvlp(), bosCertificateInfo.getPrivateKeyBase64());
                        break;
                    }
                    dgtlEnvlpStr = apiSecurityService.unSignByPrivateKey(dto.getDgtlEnvlp(), thirdCertificateInfo.getPrivateKeyBase64());
                    break;
                }
            }
            String decryptData = apiSecurityService.decrypt(dto.getEncryptData(), EncryptionEnum.getEncryption((Long)thirdApp.getEncryption()), dgtlEnvlpStr);
            result.setStatus(true);
            result.setData(decryptData);
            result.setAuthType(authInfo.getAuthType());
            DistributeCacheUtil.setCacheByKey("SignAuthRequestCache", RequestContext.get().getTraceId(), authInfo.getSignInfo().getContent(), authInfo.getAccountId(), 10);
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u7b7e\u540d\u8ba4\u8bc1\u5931\u8d25:{0}", (String)"SignAuthCheckServiceImpl_4", (String)ResSystemType.BASE.getType(), (Object[])new Object[]{e.getMessage()});
            log.error("SignAuthCheckServiceImpl error:" + e.getMessage(), (Throwable)e);
            return AuthResult.fail((String)msg);
        }
        return result;
    }
}

