/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.auth.impl;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.UUID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.security.auth.ResultHandleService;
import kd.bos.openapi.base.util.ShaSignUtils;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.security.ApiSecurityService;
import kd.bos.openapi.security.CertKeyUtil;
import kd.bos.openapi.security.model.CertificateInfo;
import kd.bos.openapi.security.model.EncryptInfo;
import kd.bos.openapi.security.model.EncryptionEnum;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.openapi.security.model.ResponseSecurityDto;

public class SignResultHandleServiceImpl
implements ResultHandleService {
    private static final Log log = LogFactory.getLog(SignResultHandleServiceImpl.class);

    @Override
    public <T> Object doResultHandle(ResponseSecurityDto<T> responseSecurityDto) {
        Open3rdappsDto thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndThirdId(responseSecurityDto.getAccountId(), responseSecurityDto.getThirdId());
        if (!thirdApp.isSignAuthEnable()) {
            log.info("thirdApp signAuthEnable is false");
            return responseSecurityDto.getData();
        }
        if (!thirdApp.isEncryptAllApi() && thirdApp.getEncryptApiMap().isEmpty() || !thirdApp.isEncryptAllApi() && !thirdApp.isEncryptApi(responseSecurityDto.getUrl())) {
            log.info("thirdApp encrypt api list is null");
            return responseSecurityDto.getData();
        }
        String encryptInfoContent = "";
        if (responseSecurityDto.getData() != null) {
            if (responseSecurityDto.getData() instanceof OpenApiResult) {
                OpenApiResult openApiResult = (OpenApiResult)responseSecurityDto.getData();
                if (openApiResult.getData() != null) {
                    encryptInfoContent = JSON.toJSONString((Object)openApiResult.getData());
                    openApiResult.setData(null);
                }
            } else {
                encryptInfoContent = JSON.toJSONString((Object)responseSecurityDto.getData());
                responseSecurityDto.setData(null);
            }
        }
        String sense = responseSecurityDto.getSense();
        boolean isThirdCall = "1".equals(sense);
        if (ApiSecurityFactory.isSecurityLogOpen()) {
            log.info("doResultHandle---------sense:" + sense + " thirdId:" + responseSecurityDto.getThirdId());
        }
        ApiSecurityService apiSecurityService = ApiSecurityFactory.getApiSecurityService();
        try {
            CertificateInfo bosCertificateInfo = (CertificateInfo)thirdApp.getCertMaps().get(CertKeyUtil.getCertKey((String)"5", (String)"0"));
            CertificateInfo thirdCertificateInfo = (CertificateInfo)thirdApp.getCertMaps().get(CertKeyUtil.getCertKey((String)"5", (String)"1"));
            if (!StringUtil.isEmpty((String)encryptInfoContent)) {
                EncryptInfo encodeInfo = null;
                switch (thirdApp.getSignType().intValue()) {
                    case 1: {
                        encodeInfo = apiSecurityService.encrypt(encryptInfoContent, EncryptionEnum.getEncryption((Long)thirdApp.getEncryption()), null, bosCertificateInfo.getPrivateKeyBase64());
                        break;
                    }
                    case 2: {
                        if (isThirdCall) {
                            encodeInfo = apiSecurityService.encrypt(encryptInfoContent, EncryptionEnum.getEncryption((Long)thirdApp.getEncryption()), thirdCertificateInfo.getPublicKeyBase64(), null);
                            break;
                        }
                        encodeInfo = apiSecurityService.encrypt(encryptInfoContent, EncryptionEnum.getEncryption((Long)thirdApp.getEncryption()), bosCertificateInfo.getPublicKeyBase64(), null);
                        break;
                    }
                }
                if (encodeInfo != null) {
                    responseSecurityDto.setEncryptData(encodeInfo.getEncryptInfo());
                    responseSecurityDto.setDgtlEnvlp(encodeInfo.getDgtlEnvlp());
                }
            }
            switch (thirdApp.getSignType().intValue()) {
                case 1: {
                    String signShaKey = EncryptUtil.decode((String)thirdApp.getSignShaKey());
                    String uuid = UUID.randomUUID().toString();
                    String timestamp = DateUtil.convertToStr((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
                    responseSecurityDto.setSignatureNonce(uuid);
                    responseSecurityDto.setTimestamp(timestamp);
                    String signContent = JSON.toJSONString(responseSecurityDto);
                    StringBuilder sb = ShaSignUtils.getSignatureString(timestamp, uuid, signContent);
                    String signStr = ApiSecurityFactory.getSignService().signBySha256(sb.toString(), signShaKey);
                    responseSecurityDto.setSignature(signStr);
                    break;
                }
                case 2: {
                    String signString = JSON.toJSONString(responseSecurityDto);
                    String sign = "";
                    sign = isThirdCall ? apiSecurityService.signByPrivateKey(signString, bosCertificateInfo.getPrivateKeyBase64()) : apiSecurityService.signByPrivateKey(signString, thirdCertificateInfo.getPrivateKeyBase64());
                    responseSecurityDto.setSignature(sign);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "doResultHandle  error:" + e.getMessage(), new Object[0]);
        }
        return responseSecurityDto;
    }
}

