/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.security.oauth.token.impl;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.kscript.exception.Uuid;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.user.LoginUserService;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.security.oauth.token.impl.AbstractApiTokenService;
import kd.bos.openapi.base.util.DistributeCacheUtil;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiAuthContext;
import kd.bos.openapi.security.model.ApiAuthResultDto;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.openapi.security.oauth.token.AccessTokenInfoDto;
import kd.bos.openapi.security.oauth.token.AccessTokenRequestDto;
import kd.bos.openapi.security.oauth.token.ApiAuthVerifyResultDto;
import kd.bos.service.authorize.model.AccessTokenInfo;
import kd.bos.service.authorize.model.AccessTokenRequest;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.JwtInfo;
import kd.bos.service.authorize.model.OAuth2Authentication;
import kd.bos.service.authorize.model.RefreshTokenInfo;

public class ApiTokenServiceImpl
extends AbstractApiTokenService {
    private static final Log log = LogFactory.getLog(ApiTokenServiceImpl.class);

    public ApiCommonResult<ApiAuthResultDto> getToken() {
        ApiCommonResult result;
        Map requestMap = (Map)OpenApiAuthContext.getContext().getContextMap().get("Request.Arg0");
        String clientId = (String)requestMap.get("client_id");
        String clientSecret = (String)requestMap.get("client_secret");
        String userName = (String)requestMap.get("username");
        String nonce = (String)requestMap.get("nonce");
        String timestamp = (String)requestMap.get("timestamp");
        this.checkDateTimeAndSignture(nonce, timestamp, OpenApiAuthContext.getContext().getTenantId());
        String accountId = OpenApiAuthContext.getContext().getCurrentCenter().getAccountId();
        this.checkLock(clientId, clientSecret, accountId);
        String language = (String)OpenApiAuthContext.getContext().getHeaders().get("Accept-Language");
        if (StringUtil.isEmpty((String)language)) {
            language = (String)requestMap.get("language");
        }
        Lang lang = null;
        lang = StringUtil.isNotEmpty((String)language) ? Lang.from((String)language) : Lang.from((String)"zh_CN");
        if (StringUtil.isEmpty((String)userName)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff1ausername\u4e3a\u7a7a\u3002", (String)"ApiTokenServiceImpl_15", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        Map userInfo = LoginUserService.getErpUserInfoByUserName((Account)OpenApiAuthContext.getContext().getCurrentCenter(), (String)userName, (String)lang.toString());
        if (userInfo == null || userInfo.get("fid") == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff1ausername\uff1a\u7528\u6237\u65e0\u6548\u6216\u4e0d\u53ef\u7528\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"ApiTokenServiceImpl_16", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), userName), new Object[0]);
        }
        Long agentUserId = Long.parseLong((String)userInfo.get("fid"));
        Open3rdappsDto thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndAppId(accountId, clientId);
        if (thirdApp.getEnableStartDate() != null && thirdApp.getEnableEndDate() != null && !DateUtil.isValidInDateTime((Date)thirdApp.getEnableStartDate(), (Date)thirdApp.getEnableEndDate(), (Date)new Date())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\uff08client_id\uff09\u5df2\u8fc7\u671f\u3002", (String)"ApiTokenServiceImpl_21", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        if (CollectionUtil.isEmpty((Collection)thirdApp.getAgentUserIdList()) || !thirdApp.getAgentUserIdList().contains(agentUserId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\uff08client_id\uff09\u7684\u4ee3\u7406\u7528\u6237\u4e3a\u7a7a\u6216userName\u4e0d\u5728\u4ee3\u7406\u7528\u6237\u4e2d\u3002", (String)"ApiTokenServiceImpl_17", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        AccessTokenRequestDto accessTokenRequest = new AccessTokenRequestDto();
        accessTokenRequest.setAccountId(accountId);
        accessTokenRequest.setThirdId(thirdApp.getFid());
        accessTokenRequest.setThirdAppNumber(clientId);
        accessTokenRequest.setTenantId(OpenApiAuthContext.getContext().getCurrentCenter().getTenantId());
        accessTokenRequest.setAgentUserId(agentUserId);
        accessTokenRequest.setLang(lang.toString());
        accessTokenRequest.setRequest(OpenApiAuthContext.getContext().getRequest());
        String ipAddress = OpenApiAuthContext.getContext().getIp();
        if (StringUtil.isNotEmpty((String)ipAddress)) {
            String nowFirstIp = ipAddress.split(",")[0];
            accessTokenRequest.setIp(nowFirstIp);
        }
        if (!(result = ApiSecurityFactory.getAccessTokenService().generateAccessToken((AccessTokenRequest)accessTokenRequest)).getStatus().booleanValue()) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"AccessToken\u83b7\u53d6\u5931\u8d25\uff1a%1$s\u3002", (String)"ApiTokenServiceImpl_6", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), result.getMessage()), new Object[0]);
        }
        long expiresIn = ((AccessTokenInfo)result.getData()).getExpires() - new Date().getTime();
        ((AccessTokenInfo)result.getData()).setToken(this.getNewToken(((AccessTokenInfo)result.getData()).getToken()));
        String idToken = "";
        String newIdToken = "";
        if (thirdApp.isJwtAuthEnable()) {
            JwtInfo jwtInfo = new JwtInfo();
            jwtInfo.setThirdAppNumber(clientId);
            jwtInfo.setAccountId(accountId);
            jwtInfo.setTenantId(OpenApiAuthContext.getContext().getTenantId());
            jwtInfo.setData((Object)userInfo);
            jwtInfo.setExpires(((AccessTokenInfo)result.getData()).getExpires());
            idToken = ApiSecurityFactory.getSignService().generateJWTToken(jwtInfo);
        }
        if (thirdApp.isJwtAuthEnable() && StringUtil.isNotEmpty((String)idToken)) {
            newIdToken = this.getNewToken(idToken);
        }
        AccessTokenInfoDto accessTokenInfoDto = this.saveThirdAppAndTokenRelation(accessTokenRequest, (ApiCommonResult<AccessTokenInfo>)result, newIdToken, expiresIn);
        ApiAuthResultDto apiAuthResultDto = new ApiAuthResultDto();
        apiAuthResultDto.setAccess_token(((AccessTokenInfo)result.getData()).getToken());
        apiAuthResultDto.setExpires_in(Integer.valueOf((int)expiresIn));
        apiAuthResultDto.setToken_type("Bearer");
        apiAuthResultDto.setRefresh_token(accessTokenInfoDto.getRefreshToken().getRefreshToken());
        apiAuthResultDto.setLanguage(lang.toString());
        apiAuthResultDto.setScope("API");
        if (thirdApp.isJwtAuthEnable()) {
            apiAuthResultDto.setId_token(newIdToken);
            apiAuthResultDto.setId_token_expires_in(Integer.valueOf((int)expiresIn));
        }
        ApiCommonResult ApiResult = ApiCommonResult.getSuccessResult((String)"0", (String)"");
        ApiResult.setData((Object)apiAuthResultDto);
        return ApiResult;
    }

    public ApiCommonResult<ApiAuthResultDto> refreshToken() {
        Map requestMap = (Map)OpenApiAuthContext.getContext().getContextMap().get("Request.Arg0");
        String clientId = (String)requestMap.get("client_id");
        String accountId = OpenApiAuthContext.getContext().getCurrentCenter().getAccountId();
        String nonce = (String)requestMap.get("nonce");
        String timestamp = (String)requestMap.get("timestamp");
        this.checkDateTimeAndSignture(nonce, timestamp, OpenApiAuthContext.getContext().getTenantId());
        String grant_type = (String)requestMap.get("grant_type");
        if (!"refresh_token".equals(grant_type)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff1agrant_type\u7684\u503c\u4e0d\u662frefresh_token\u3002", (String)"ApiTokenServiceImpl_2", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        String refreshToken = (String)requestMap.get("refresh_token");
        if (StringUtil.isEmpty((String)refreshToken)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: %1$s\u4e3a\u7a7a\u3002", (String)"ApiTokenCustomServiceImpl_3", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), "refresh_token"), new Object[0]);
        }
        Open3rdappsDto thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndAppId(accountId, clientId);
        AccessTokenRequestDto accessTokenRequest = new AccessTokenRequestDto();
        accessTokenRequest.setAccountId(accountId);
        accessTokenRequest.setTenantId(OpenApiAuthContext.getContext().getCurrentCenter().getTenantId());
        String ipAddress = OpenApiAuthContext.getContext().getIp();
        if (StringUtil.isNotEmpty((String)ipAddress)) {
            String nowFirstIp = ipAddress.split(",")[0];
            accessTokenRequest.setIp(nowFirstIp);
        }
        accessTokenRequest.setThirdId(thirdApp.getFid());
        if (CollectionUtil.isEmpty((Collection)thirdApp.getAgentUserIdList()) || thirdApp.getAgentUserIdList().get(0) == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\uff08client_id\uff09\u7684\u4ee3\u7406\u7528\u6237\u4e3a\u7a7a\u3002", (String)"ApiTokenServiceImpl_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        accessTokenRequest.setAgentUserId((Long)thirdApp.getAgentUserIdList().get(0));
        OAuth2Authentication oAuth2Authentication = new OAuth2Authentication();
        oAuth2Authentication.setAccountId(accountId);
        oAuth2Authentication.setAgentUserId((Long)thirdApp.getAgentUserIdList().get(0));
        oAuth2Authentication.setThirdAppNumber(clientId);
        oAuth2Authentication.setThirdId(thirdApp.getFid());
        String key = "REFRESH_TOKEN_KEY_" + clientId + "_" + refreshToken;
        String refreshTokenString = DistributeCacheUtil.getCacheByKey("AUTH_REFRESH_TOKEN_CACHE", key, "CACHE_OPENAPI_AUTH");
        if (StringUtil.isEmpty((String)refreshTokenString)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: refresh_token\u65e0\u6548\u6216\u5df2\u88ab\u4f7f\u7528\u3002", (String)"ApiTokenServiceImpl_7", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        RefreshTokenInfo refreshTokenInfo = (RefreshTokenInfo)JacksonUtil.readValue((String)refreshTokenString, RefreshTokenInfo.class);
        if (refreshTokenInfo == null || refreshTokenInfo.getRefreshTokenExpire() <= new Date().getTime()) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: refresh_token\u65e0\u6548\u6216\u5df2\u88ab\u4f7f\u7528\u3002", (String)"ApiTokenServiceImpl_7", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        String newToken = EncrypterFactory.getEncrypter().decode(refreshTokenInfo.getAccessToken());
        String realToken = this.getRealToken(newToken);
        AccessTokenInfo token = new AccessTokenInfo();
        token.setToken(realToken);
        token.setTokenType("access_token");
        oAuth2Authentication.setToken(token);
        ApiCommonResult result = ApiSecurityFactory.getAccessTokenService().refreshAccessToken(oAuth2Authentication);
        if (!result.getStatus().booleanValue()) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"AccessToken\u5237\u65b0\u5931\u8d25\uff1a%1$s\u3002", (String)"ApiTokenServiceImpl_5", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), result.getMessage()), new Object[0]);
        }
        Date now = new Date();
        long expiresIn = ((AccessTokenInfo)result.getData()).getExpires() - now.getTime();
        String tokenKey = "ACCESS_TOKEN_KEY_" + refreshTokenInfo.getAccessToken();
        String oauth2AuthenticationString = DistributeCacheUtil.getCacheByKey("AUTH_ACCESS_TOKEN_CACHE", tokenKey, "CACHE_OPENAPI_AUTH");
        if (StringUtil.isEmpty((String)oauth2AuthenticationString)) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: \u83b7\u53d6\u6388\u6743\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"ApiTokenServiceImpl_7", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        OAuth2Authentication authentication = (OAuth2Authentication)JacksonUtil.readValue((String)oauth2AuthenticationString, OAuth2Authentication.class);
        if (authentication == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: \u83b7\u53d6\u6388\u6743\u4fe1\u606f\u9519\u8bef\u3002", (String)"ApiTokenServiceImpl_7", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        authentication.getToken().setExpires(((AccessTokenInfo)result.getData()).getExpires());
        String refreshTokenNew = Uuid.create();
        RefreshTokenInfo refreshTokenDto = new RefreshTokenInfo();
        refreshTokenDto.setRefreshToken(refreshTokenNew);
        refreshTokenDto.setAccessToken(refreshTokenInfo.getAccessToken());
        refreshTokenDto.setRefreshTokenExpire(new Date().getTime() + 86400000L);
        authentication.setRefreshTokenInfo(refreshTokenDto);
        AccessTokenInfo accessTokenInfo = authentication.getToken();
        if (accessTokenInfo == null) {
            accessTokenInfo = new AccessTokenInfo();
            accessTokenInfo.setTokenType("access_token");
            accessTokenInfo.setToken(refreshTokenInfo.getAccessToken());
        }
        accessTokenInfo.setExpires(((AccessTokenInfo)result.getData()).getExpires());
        authentication.setToken(accessTokenInfo);
        DistributeCacheUtil.setCacheByKey("AUTH_ACCESS_TOKEN_CACHE", tokenKey, JacksonUtil.writeValueAsString((Object)authentication), "CACHE_OPENAPI_AUTH", (int)(expiresIn / 1000L));
        key = "REFRESH_TOKEN_KEY_" + clientId + "_" + refreshTokenDto.getRefreshToken();
        DistributeCacheUtil.setCacheByKey("AUTH_REFRESH_TOKEN_CACHE", key, JacksonUtil.writeValueAsString((Object)refreshTokenDto), "CACHE_OPENAPI_AUTH", 86400);
        String oldKey = "REFRESH_TOKEN_KEY_" + clientId + "_" + refreshToken;
        DistributeCacheUtil.removeCacheByKey("AUTH_REFRESH_TOKEN_CACHE", oldKey, "CACHE_OPENAPI_AUTH");
        ApiAuthResultDto apiAuthResultDto = new ApiAuthResultDto();
        apiAuthResultDto.setAccess_token(newToken);
        apiAuthResultDto.setExpires_in(Integer.valueOf((int)expiresIn));
        apiAuthResultDto.setToken_type("Bearer");
        apiAuthResultDto.setScope("API");
        apiAuthResultDto.setRefresh_token(authentication.getRefreshTokenInfo().getRefreshToken());
        if (thirdApp.isJwtAuthEnable() && authentication.getIdToken() != null) {
            apiAuthResultDto.setId_token(authentication.getIdToken().getToken());
            long jwtExpiresIn = authentication.getIdToken().getExpires() - now.getTime();
            apiAuthResultDto.setId_token_expires_in(Integer.valueOf((int)jwtExpiresIn));
        }
        ApiCommonResult ApiResult = ApiCommonResult.getSuccessResult((String)"0", (String)"");
        ApiResult.setData((Object)apiAuthResultDto);
        return ApiResult;
    }

    public ApiCommonResult<ApiAuthVerifyResultDto> verifyToken() {
        String realToken;
        Map requestMap = (Map)OpenApiAuthContext.getContext().getContextMap().get("Request.Arg0");
        String clientId = (String)requestMap.get("client_id");
        String accountId = OpenApiAuthContext.getContext().getCurrentCenter().getAccountId();
        String nonce = (String)requestMap.get("nonce");
        String timestamp = (String)requestMap.get("timestamp");
        this.checkDateTimeAndSignture(nonce, timestamp, OpenApiAuthContext.getContext().getTenantId());
        String tokenTypeHint = (String)requestMap.get("token_type_hint");
        if (StringUtil.isEmpty((String)tokenTypeHint) || !"access_token".equals(tokenTypeHint) && !"refresh_token".equals(tokenTypeHint) && !"id_token".equals(tokenTypeHint)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: %1$s\u53ea\u80fd\u662faccess_token,refresh_token,id_token\u5176\u4e2d\u4e00\u4e2a\u3002", (String)"ApiTokenServiceImpl_19", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), "token_type_hint"), new Object[0]);
        }
        String tokenParam = (String)requestMap.get("token");
        if (StringUtil.isEmpty((String)tokenParam)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: %1$s\u4e3a\u7a7a\u3002", (String)"OauthTokenUtil_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), "token"), new Object[0]);
        }
        long expireIn = 0L;
        ApiCommonResult result = ApiCommonResult.getFailResult((String)ApiErrorCode.HTTP_BAD_REQUEST.getStatusCode(), (String)"");
        if ("access_token".equals(tokenTypeHint)) {
            realToken = this.getRealToken(tokenParam);
            OAuth2Authentication oAuth2Authentication = new OAuth2Authentication();
            oAuth2Authentication.setAccountId(accountId);
            AccessTokenInfo tokenInfo = new AccessTokenInfo();
            tokenInfo.setToken(realToken);
            tokenInfo.setTokenType("access_token");
            oAuth2Authentication.setToken(tokenInfo);
            ApiCommonResult accessTokenResult = ApiSecurityFactory.getAccessTokenService().verifyAccessToken(oAuth2Authentication);
            if (accessTokenResult.getStatus().booleanValue()) {
                result = ApiCommonResult.getSuccessResult((String)"0", (String)"");
                result.setData(accessTokenResult.getData());
                expireIn = ((AccessTokenInfo)accessTokenResult.getData()).getExpires() - new Date().getTime();
            } else {
                result = ApiCommonResult.getFailResult((String)ApiErrorCode.Data_NoAuth.getStatusCode(), (String)"AccessToken verify failed.");
            }
        } else if ("refresh_token".equals(tokenTypeHint)) {
            result = this.verifyRefreshToken(clientId, tokenParam);
            if (result.getStatus().booleanValue()) {
                expireIn = ((AccessTokenInfo)result.getData()).getExpires() - new Date().getTime();
            }
        } else if ("id_token".equals(tokenTypeHint)) {
            realToken = this.getRealToken(tokenParam);
            JwtInfo jwtInfo = new JwtInfo();
            jwtInfo.setJwt(realToken);
            jwtInfo.setAccountId(accountId);
            jwtInfo.setThirdAppNumber(clientId);
            Map resultJwt = null;
            try {
                resultJwt = (Map)ApiSecurityFactory.getSignService().versifyJWTToken(jwtInfo);
                result = resultJwt != null ? ApiCommonResult.getSuccessResult((String)"0", (String)"") : ApiCommonResult.getFailResult((String)ApiErrorCode.Data_NoAuth.getStatusCode(), (String)ResManager.loadKDString((String)"JWT(id_token) \u9a8c\u8bc1\u5931\u8d25\uff1a\u5df2\u8fc7\u671f\u3002", (String)"ApiTokenServiceImpl_12", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            catch (OpenApiException e) {
                result = ApiCommonResult.getFailResult((String)ApiErrorCode.Data_NoAuth.getStatusCode(), (String)ResManager.loadKDString((String)"JWT(id_token) \u9a8c\u8bc1\u5931\u8d25\uff1a\u5df2\u8fc7\u671f\u3002", (String)"ApiTokenServiceImpl_12", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            }
            expireIn = -1L;
        }
        ApiAuthVerifyResultDto apiAuthVerifyResultDto = new ApiAuthVerifyResultDto();
        if (expireIn != -1L) {
            apiAuthVerifyResultDto.setExpires_in(Integer.valueOf((int)expireIn));
        }
        apiAuthVerifyResultDto.setActive(result.getStatus());
        apiAuthVerifyResultDto.setScope("API");
        ApiCommonResult ApiResult = ApiCommonResult.getSuccessResult((String)"0", (String)"");
        ApiResult.setData((Object)apiAuthVerifyResultDto);
        ApiResult.setStatus(result.getStatus());
        return ApiResult;
    }

    public ApiCommonResult<Boolean> withdrawToken() {
        Map requestMap = (Map)OpenApiAuthContext.getContext().getContextMap().get("Request.Arg0");
        String clientId = (String)requestMap.get("client_id");
        String clientSecret = (String)requestMap.get("client_secret");
        String accountId = OpenApiAuthContext.getContext().getCurrentCenter().getAccountId();
        String nonce = (String)requestMap.get("nonce");
        String timestamp = (String)requestMap.get("timestamp");
        this.checkDateTimeAndSignture(nonce, timestamp, OpenApiAuthContext.getContext().getTenantId());
        this.checkLock(clientId, clientSecret, accountId);
        Open3rdappsDto thirdApp = ThirdAppSecurityUtil.getThirdByAccountAndAppId(accountId, clientId);
        String tokenTypeHint = (String)requestMap.get("token_type_hint");
        if (StringUtil.isEmpty((String)tokenTypeHint) || !"access_token".equals(tokenTypeHint) && !"refresh_token".equals(tokenTypeHint)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: %1$s\u53ea\u80fd\u662faccess_token,refresh_token\u5176\u4e2d\u4e00\u4e2a\u3002", (String)"ApiTokenServiceImpl_20", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), "token_type_hint"), new Object[0]);
        }
        String tokenParam = (String)requestMap.get("token");
        if (StringUtil.isEmpty((String)tokenParam)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: %1$s\u4e3a\u7a7a\u3002", (String)"OauthTokenUtil_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), "token"), new Object[0]);
        }
        ApiCommonResult result = ApiCommonResult.getFailResult((String)ApiErrorCode.HTTP_BAD_REQUEST.getStatusCode(), (String)"");
        if ("access_token".equals(tokenTypeHint)) {
            String tokenKey = "ACCESS_TOKEN_KEY_" + tokenParam;
            String accessTokenExits = DistributeCacheUtil.getCacheByKey("AUTH_ACCESS_TOKEN_CACHE", tokenKey, "CACHE_OPENAPI_AUTH");
            if (StringUtil.isEmpty((String)accessTokenExits)) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff1atoken\u65e0\u6548\uff0c\u65e0\u6cd5\u64a4\u56detoken\u3002", (String)"ApiTokenServiceImpl_4", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
            }
            String realToken = this.getRealToken(tokenParam);
            OAuth2Authentication oAuth2Authentication = new OAuth2Authentication();
            oAuth2Authentication.setAccountId(accountId);
            oAuth2Authentication.setThirdAppNumber(clientId);
            oAuth2Authentication.setThirdId(thirdApp.getFid());
            AccessTokenInfo tokenInfo = new AccessTokenInfo();
            tokenInfo.setToken(realToken);
            tokenInfo.setTokenType("access_token");
            oAuth2Authentication.setToken(tokenInfo);
            ApiCommonResult tokenResult = null;
            tokenResult = ApiSecurityFactory.getAccessTokenService().withdrawAccessToken(oAuth2Authentication);
            if (!tokenResult.getStatus().booleanValue()) {
                throw new OpenApiException(ApiErrorCode.Data_UpdateFail, String.format(ResManager.loadKDString((String)"AccessToken \u64a4\u56de\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"ApiTokenServiceImpl_14", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), result.getMessage()), new Object[0]);
            }
            tokenInfo = new AccessTokenInfo();
            tokenInfo.setToken(tokenParam);
            tokenInfo.setTokenType(tokenTypeHint);
            oAuth2Authentication.setToken(tokenInfo);
            DistributeCacheUtil.removeCacheByKey("AUTH_ACCESS_TOKEN_CACHE", tokenKey, "CACHE_OPENAPI_AUTH");
            result = tokenResult.getStatus() != false ? ApiCommonResult.getSuccessResult((String)"0", (String)"true") : ApiCommonResult.getFailResult((String)ApiErrorCode.Data_NoAuth.getStatusCode(), (String)ResManager.loadKDString((String)"AccessToken \u64a4\u56de\u5931\u8d25\u3002", (String)"ApiTokenServiceImpl_13", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
            result.setData((Object)tokenResult.getStatus());
        } else if ("refresh_token".equals(tokenTypeHint)) {
            String key = "REFRESH_TOKEN_KEY_" + clientId + "_" + tokenParam;
            String refreshTokenExits = DistributeCacheUtil.getCacheByKey("AUTH_REFRESH_TOKEN_CACHE", key, "CACHE_OPENAPI_AUTH");
            if (StringUtil.isEmpty((String)refreshTokenExits)) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff1atoken\u65e0\u6548\uff0c\u65e0\u6cd5\u64a4\u56detoken\u3002", (String)"ApiTokenServiceImpl_4", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
            }
            DistributeCacheUtil.removeCacheByKey("AUTH_REFRESH_TOKEN_CACHE", key, "CACHE_OPENAPI_AUTH");
            result = ApiCommonResult.getSuccessResult((String)"0", (String)"true");
        }
        return result;
    }

    private AccessTokenInfoDto saveThirdAppAndTokenRelation(AccessTokenRequestDto accessTokenRequest, ApiCommonResult<AccessTokenInfo> result, String newIdToken, long expiresIn) {
        String clientId = accessTokenRequest.getThirdAppNumber();
        String accessToken = ((AccessTokenInfo)result.getData()).getToken();
        Long expires = ((AccessTokenInfo)result.getData()).getExpires();
        String refreshToken = Uuid.create();
        RefreshTokenInfo refreshTokenDto = new RefreshTokenInfo();
        refreshTokenDto.setRefreshToken(refreshToken);
        refreshTokenDto.setAccessToken(accessToken);
        refreshTokenDto.setRefreshTokenExpire(new Date().getTime() + 86400000L);
        String responseType = "token";
        if (StringUtil.isNotEmpty((String)newIdToken)) {
            responseType = "id_token token";
        }
        OAuth2Authentication oAuth2Authentication = new OAuth2Authentication();
        AccessTokenInfo accessTokenInfo = new AccessTokenInfo();
        accessTokenInfo.setToken(accessToken);
        accessTokenInfo.setExpires(expires);
        accessTokenInfo.setTokenType("access_token");
        AccessTokenInfo idTokenInfo = new AccessTokenInfo();
        idTokenInfo.setTokenType("jwt_token");
        idTokenInfo.setToken(newIdToken);
        idTokenInfo.setExpires(expires);
        oAuth2Authentication.setToken(accessTokenInfo);
        oAuth2Authentication.setThirdId(accessTokenRequest.getThirdId());
        oAuth2Authentication.setThirdAppNumber(accessTokenRequest.getThirdAppNumber());
        oAuth2Authentication.setAgentUserId(accessTokenRequest.getAgentUserId());
        oAuth2Authentication.setAccountId(accessTokenRequest.getAccountId());
        oAuth2Authentication.setIdToken(idTokenInfo);
        oAuth2Authentication.setRefreshTokenInfo(refreshTokenDto);
        oAuth2Authentication.setResponseType(responseType);
        String tokenKey = "ACCESS_TOKEN_KEY_" + oAuth2Authentication.getToken().getToken();
        DistributeCacheUtil.setCacheByKey("AUTH_ACCESS_TOKEN_CACHE", tokenKey, JacksonUtil.writeValueAsString((Object)oAuth2Authentication), "CACHE_OPENAPI_AUTH", (int)(expiresIn / 1000L));
        String key = "REFRESH_TOKEN_KEY_" + clientId + "_" + refreshToken;
        DistributeCacheUtil.setCacheByKey("AUTH_REFRESH_TOKEN_CACHE", key, JacksonUtil.writeValueAsString((Object)refreshTokenDto), "CACHE_OPENAPI_AUTH", 86400);
        AccessTokenInfoDto accessTokenInfoDto = new AccessTokenInfoDto();
        accessTokenInfoDto.setRefreshToken(refreshTokenDto);
        return accessTokenInfoDto;
    }

    private ApiCommonResult verifyRefreshToken(String clientId, String refreshToken) {
        String key = "REFRESH_TOKEN_KEY_" + clientId + "_" + refreshToken;
        String refreshTokenString = DistributeCacheUtil.getCacheByKey("AUTH_REFRESH_TOKEN_CACHE", key, "CACHE_OPENAPI_AUTH");
        ApiCommonResult result = ApiCommonResult.getFailResult((String)ApiErrorCode.Data_NoAuth.getStatusCode(), (String)ResManager.loadKDString((String)"refresh_token \u9a8c\u8bc1\u5931\u8d25\uff1a\u5df2\u8fc7\u671f\u3002", (String)"ApiTokenServiceImpl_11", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]));
        if (StringUtil.isEmpty((String)refreshTokenString)) {
            return result;
        }
        Date now = new Date();
        RefreshTokenInfo refreshTokenInfo = (RefreshTokenInfo)JacksonUtil.readValue((String)refreshTokenString, RefreshTokenInfo.class);
        if (refreshTokenInfo == null || refreshTokenInfo.getRefreshTokenExpire() <= now.getTime()) {
            return result;
        }
        result = ApiCommonResult.getSuccessResult((String)"0", (String)"");
        AccessTokenInfo accessTokenInfo = new AccessTokenInfo();
        accessTokenInfo.setExpires(Long.valueOf(refreshTokenInfo.getRefreshTokenExpire()));
        result.setData((Object)accessTokenInfo);
        return result;
    }
}

