/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.statdata;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.dataservice.OpenApiDataServiceImpl;

public class ApiStatUtil {
    private static Log log = LogFactory.getLog(ApiStatUtil.class);

    public static Date beforeOneHourToNowDate() {
        long current = System.currentTimeMillis();
        long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        long twelve = zero + 86400000L - 1L;
        return new Timestamp(twelve);
    }

    public static List<Account> getAllAccountsOfCurrentEnv() {
        return AccountUtils.getAllAccountsOfCurrentEnv();
    }

    public static boolean getMCApiStatEnable() {
        return "true".equalsIgnoreCase(System.getProperty("openapi.stat.enable", "true"));
    }

    public static boolean getApiStatEnableParameter() {
        try {
            OpenApiDataServiceImpl openApiDataService = new OpenApiDataServiceImpl();
            String enabledStr = openApiDataService.getSysParameter("api_stat", "true");
            return "true".equals(enabledStr);
        }
        catch (Exception ex) {
            String accountId = "";
            String tenantId = "";
            String errorMsg = ex.getMessage();
            RequestContext rc = RequestContext.get();
            if (rc != null) {
                accountId = rc.getAccountId();
                tenantId = rc.getTenantId();
            }
            log.warn(String.format("OpenApiStatData-An error occurred while getting ApiStatEnableParameter: tenantId:%s, accountId:%s, errorMsg:", tenantId, accountId, errorMsg));
            return false;
        }
    }

    public static RequestContext createRequstContext(String accountId, String tenantId) {
        RequestContext context = RequestContext.create();
        context.setAccountId(accountId);
        context.setTenantId(tenantId);
        return context;
    }
}

