/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.statdata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.statdata.ApiStatUtil;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang3.RandomUtils;

public class UploadStatDataTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(UploadStatDataTask.class);
    private static final String QUERYSTRING = "?project=cosmic&store=server_beacon";
    private static final String URL = "https://bj2-api.kingdee.com/laddercs/ladderlog";
    public static final String CLIENT_ID = "226794";
    public static final String OPENAPI_STATDATA = "openapi_statdata";
    public static final String PROJECT_VALUE = "cosmic";
    public static final String STORE_VALUE = "server_beacon";
    public static final String JOINIMPROVEMENT = "joinimprovement";
    public static final String MC_TENANT_IDS = "mc.tenant.ids";
    public static final String ISSHIPHASH = "is_ship_hash";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String envType;
        block16: {
            String json = System.getProperty(MC_TENANT_IDS);
            envType = System.getProperty("env.type");
            String joinimprovement = "";
            if (json != null && !json.isEmpty()) {
                try {
                    JSONArray array = JSON.parseArray((String)json);
                    for (int i = 0; i < array.size(); ++i) {
                        JSONObject jsonObject = array.getJSONObject(i);
                        if (!jsonObject.containsKey((Object)JOINIMPROVEMENT)) continue;
                        joinimprovement = jsonObject.getString(JOINIMPROVEMENT);
                        break;
                    }
                    if (!"true".equalsIgnoreCase(joinimprovement)) {
                        return;
                    }
                    break block16;
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6MC\u53c2\u6570\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                    return;
                }
            }
            return;
        }
        if (!ApiStatUtil.getMCApiStatEnable()) {
            return;
        }
        String isHash = System.getProperty(ISSHIPHASH);
        if (!"true".equalsIgnoreCase(isHash)) {
            Calendar calendar = Calendar.getInstance();
            int hour = calendar.get(11);
            int var = hour % 5;
            if (Integer.parseInt(requestContext.getAccountId().substring(14)) % 5 != var) {
                return;
            }
        }
        log.info(String.format("%s UploadStatDataTask\u5f00\u59cb\u6267\u884c\u6bcf\u65e5API\u8c03\u7528\u7edf\u8ba1\u4fe1\u606f\u4efb\u52a1", LocalDateTime.now()));
        try {
            DynamicObject lastSuccessTime = QueryServiceHelper.queryOne((String)OPENAPI_STATDATA, (String)"time,type", (QFilter[])new QFilter("type", "=", (Object)99).toArray());
            LocalDateTime now = LocalDateTime.now();
            now = now.minus(30L, ChronoUnit.DAYS);
            ZoneId zoneId = ZoneId.systemDefault();
            Long timeBefore30 = now.atZone(zoneId).toInstant().toEpochMilli();
            Long queryTime = lastSuccessTime == null ? timeBefore30 : Long.valueOf(Math.max(lastSuccessTime.getLong("time"), timeBefore30));
            QFilter[] qFilters = QFilterUtil.builder().put(new QFilter("type", "=", (Object)2)).put(new QFilter("time", ">", (Object)DateUtil.getDateWithoutHour((Date)new Date(queryTime)).getTime())).put(new QFilter("time", "<", (Object)DateUtil.getDateWithoutHour((Date)new Date()).getTime())).build();
            DynamicObjectCollection data = QueryServiceHelper.query((String)OPENAPI_STATDATA, (String)"time,cnt,successcnt,cost,apiid,apiid.number,apiid.name,apiid.urlformat,apiid.appid.number", (QFilter[])qFilters);
            ArrayList bodyMap = new ArrayList();
            Map productInfo = LicenseServiceHelper.getProductInfo();
            String prodInstCode = (String)productInfo.get("prodInstCode");
            HashMap<String, Object> statMap = new HashMap<String, Object>();
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            if (CollectionUtil.isEmpty((Collection)data)) {
                fieldMap.put("total", "0");
                fieldMap.put("api_id", "0");
                fieldMap.put("api_number", "0");
                fieldMap.put("fail_cnt", "0");
                fieldMap.put("api_name", "null");
                fieldMap.put("api_url", "/");
                fieldMap.put("env_type", envType);
                statMap.put("var", OpenJsonUtil.toJson(fieldMap));
                statMap.put("app_id", "null");
                statMap.put("time", DateUtil.getTimeAt8AM((Date)DateUtil.getDateAdd((Date)new Date(), (int)6, (int)-1)));
                statMap.put("cost", "0");
                statMap.put("ctime", System.currentTimeMillis());
                statMap.put("tenant_id", requestContext.getTenantId());
                statMap.put("tenant_code", requestContext.getTenantCode());
                statMap.put("event_name", "api_stat");
                statMap.put("dc_id", requestContext.getAccountId());
                statMap.put("instance_number", prodInstCode);
                bodyMap.add(statMap);
            } else {
                data.stream().forEach(it -> {
                    fieldMap.put("total", it.getString("cnt"));
                    fieldMap.put("api_id", it.getString("apiid"));
                    fieldMap.put("api_number", it.getString("apiid.number"));
                    fieldMap.put("fail_cnt", (String)(it.getInt("cnt") - it.getInt("successcnt")));
                    fieldMap.put("api_name", it.getString("apiid.name"));
                    fieldMap.put("api_url", it.getString("apiid.urlformat"));
                    fieldMap.put("env_type", envType);
                    statMap.put("var", OpenJsonUtil.toJson((Object)fieldMap));
                    statMap.put("app_id", it.getString("apiid.appid.number"));
                    statMap.put("time", it.getString("time"));
                    statMap.put("cost", it.getString("cost"));
                    statMap.put("ctime", System.currentTimeMillis());
                    statMap.put("tenant_id", requestContext.getTenantId());
                    statMap.put("tenant_code", requestContext.getTenantCode());
                    statMap.put("event_name", "api_stat");
                    statMap.put("dc_id", requestContext.getAccountId());
                    statMap.put("instance_number", prodInstCode);
                    bodyMap.add(statMap);
                });
            }
            Map<String, String> header = this.getPostHeader();
            String urlStr = URL.concat(QUERYSTRING);
            String result = HttpClientUtils.postjson((String)urlStr, header, (String)OpenJsonUtil.toJson(bodyMap));
            JSONObject resb = JSON.parseObject((String)result);
            if (resb.containsKey((Object)"errcode") && resb.getInteger("errcode") == 0) {
                if (lastSuccessTime != null) {
                    String sql = "DELETE from t_openapi_statdata_sum where  ftype=99 ";
                    DB.execute((DBRoute)DBRoute.basedata, (String)sql);
                }
                this.InsertIntoDB();
            } else {
                log.error("\u6570\u636e\u4e0a\u62a5\u8bf7\u6c42\u5931\u8d25", (Object)resb.getString("description"));
            }
        }
        catch (ParseException e) {
            log.error("UploadStatDataTask\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
        catch (Exception e) {
            log.error("UploadStatDataTask\u8c03\u7528\u63a5\u53e3\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
    }

    private void InsertIntoDB() throws ParseException {
        String sql = "INSERT INTO t_openapi_statdata_sum(ftime,fapiid,fthirdid,fcnt,fsuccesscnt,fcost,ftype)  VALUES(?,0,0,0,0,0,?) ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FTime", -5, (Object)new Date().getTime()), new SqlParameter(":FType", 4, (Object)99)};
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
    }

    private Map<String, String> getPostHeader() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("X-Api-ClientID", CLIENT_ID);
        map.put("X-Api-Auth-Version", "2.0");
        Long timeStamp = new Date().getTime();
        map.put("X-Api-TimeStamp", String.valueOf(timeStamp));
        map.put("X-Api-SignHeaders", "X-Api-TimeStamp,X-Api-Nonce");
        int randomNum = RandomUtils.nextInt((int)0, (int)Integer.MAX_VALUE);
        map.put("X-Api-Nonce", String.valueOf(randomNum));
        map.put("X-Api-Signature", this.getSignCode(timeStamp, randomNum));
        return map;
    }

    private String getSignCode(Long timeStamp, int random) {
        StringBuilder signBuilder = new StringBuilder();
        signBuilder.append("POST");
        signBuilder.append("\n");
        try {
            signBuilder.append(URLEncoder.encode("/laddercs/ladderlog", "UTF-8"));
            signBuilder.append("\n");
            signBuilder.append(URLEncoder.encode("project", "UTF-8"));
            signBuilder.append("=");
            signBuilder.append(URLEncoder.encode(PROJECT_VALUE, "UTF-8"));
            signBuilder.append("&");
            signBuilder.append(URLEncoder.encode("store", "UTF-8"));
            signBuilder.append("=");
            signBuilder.append(URLEncoder.encode(STORE_VALUE, "UTF-8"));
            signBuilder.append("\n");
            signBuilder.append("x-api-nonce:");
            signBuilder.append(random);
            signBuilder.append("\n");
            signBuilder.append("x-api-timestamp:");
            signBuilder.append(timeStamp);
            signBuilder.append("\n");
            String secret = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("openapi_uploadstat_crt", "8ecfbb191ef7149eade36e72518b99f5");
            String target = this.genFinalSign(signBuilder.toString(), secret);
            return target;
        }
        catch (UnsupportedEncodingException e) {
            log.error("UploadStatDataTask \u751f\u6210\u7b7e\u540d\u65f6\uff0c\u8f6c\u7801\u5931\u8d25", (Throwable)e);
            return signBuilder.toString();
        }
    }

    private String genFinalSign(String sign, String key) {
        SecretKeySpec signKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), EncryptUtil.HMAC_SHA_256);
        Mac mac = null;
        try {
            mac = Mac.getInstance(EncryptUtil.HMAC_SHA_256);
            mac.init(signKey);
            byte[] rawHmac = mac.doFinal(sign.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(UploadStatDataTask.hex(rawHmac).getBytes());
        }
        catch (Exception var6) {
            throw new OpenApiException((Throwable)var6, ApiErrorCode.SIGN_ERROR, "An error occurred during genSHA256:" + var6.getMessage(), new Object[0]);
        }
    }

    private static String hex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            int decimal = b & 0xFF;
            String hex = Integer.toHexString(decimal);
            if (hex.length() % 2 == 1) {
                hex = "0" + hex;
            }
            result.append(hex);
        }
        return result.toString();
    }
}

