/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.task;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.model.AlarmTypeEnum;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.OpenApiAlarmSdkUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OpenApiCaclCostTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(OpenApiCaclCostTask.class);
    private static final int TIMECOST_THREHOLD = 1000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        int costDataCount = this.cleanCostData();
        int alarmLogCount = this.cleanAlarmLog();
        log.info("\u6162\u63a5\u53e3\u7edf\u8ba1\u6570\u636e\u6e05\u7406\u6570\uff1a" + costDataCount + " \u6d88\u606f\u9884\u8b66\u65e5\u5fd7\u6e05\u7406\u6570\uff1a" + alarmLogCount);
        this.caclCost();
    }

    private int cleanAlarmLog() {
        String sysDays = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_log_days", "30");
        Date timeBefore30Day = DateUtil.getDateAdd((Date)new Date(), (int)5, (int)(-Integer.parseInt(sysDays)));
        QFilter[] qFilters = new QFilter[]{new QFilter("createtime", "<", (Object)timeBefore30Day)};
        if (QueryServiceHelper.exists((String)"openapi_alarmlog", (QFilter[])qFilters)) {
            return DeleteServiceHelper.delete((String)"openapi_alarmlog", (QFilter[])qFilters);
        }
        return 0;
    }

    private int cleanCostData() {
        String sysDays = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_log_days", "30");
        Date timeBefore30Day = DateUtil.getDateAdd((Date)new Date(), (int)5, (int)(-Integer.parseInt(sysDays)));
        QFilter[] qFilters = new QFilter[]{new QFilter("createtime", "<", (Object)timeBefore30Day)};
        if (QueryServiceHelper.exists((String)"openapi_costdata", (QFilter[])qFilters)) {
            return DeleteServiceHelper.delete((String)"openapi_costdata", (QFilter[])qFilters);
        }
        return 0;
    }

    private void caclCost() {
        try {
            String threshold = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("costdata_threshold", "10000");
            if ("0".equals(threshold)) {
                return;
            }
            String querySql = "select fapiid,furl,avg(ftimecost) as avgcost,count(fapiid) as count,max(ftimecost) as maxcost from t_openapi_log_data where fopdate >= ? and fopdate < ? and ftimecost > ?  group by fapiid,furl having avg(ftimecost) > ?;";
            Object[] params = new SqlParameter[4];
            Date now = new Date();
            Date startDate = DateUtil.getDateWithoutHour((Date)DateUtil.getDateAdd((Date)now, (int)10, (int)-24));
            Date endDate = DateUtil.getDateWithoutHour((Date)now);
            params[0] = new SqlParameter(":fopdate", 91, (Object)startDate);
            params[1] = new SqlParameter(":fopdate", 91, (Object)endDate);
            params[2] = new SqlParameter(":ftimecost", 4, (Object)1000);
            params[3] = new SqlParameter(":avgcost", 4, (Object)threshold);
            DB.query((DBRoute)DBRoute.log, (String)querySql, (Object[])params, rs -> {
                ArrayList<String> urls = new ArrayList<String>(8);
                while (rs.next()) {
                    DynamicObject costData = BusinessDataServiceHelper.newDynamicObject((String)"openapi_costdata");
                    String furl = rs.getString("furl");
                    costData.set("url", (Object)StringUtil.substring((Object)furl, (int)400));
                    urls.add(furl);
                    costData.set("avgcost", (Object)rs.getLong("avgcost"));
                    costData.set("count", (Object)rs.getLong("count"));
                    costData.set("maxcost", (Object)rs.getLong("maxcost"));
                    costData.set("createtime", (Object)now);
                    long fapiid = rs.getLong("fapiid");
                    DynamicObject api = QueryServiceHelper.queryOne((String)"openapi_apilist", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("urlformat", "=", (Object)furl)});
                    if (fapiid > 0L) {
                        costData.set("apiid", (Object)rs.getLong("fapiid"));
                    } else {
                        costData.set("apiid", api != null ? Long.valueOf(api.getLong("id")) : "0");
                    }
                    costData.set("apiname", (Object)(api != null ? StringUtil.substring((Object)api.getString("name"), (int)100) : ""));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{costData});
                }
                this.sendMsg(urls);
                return null;
            });
        }
        catch (ParseException e) {
            log.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff01", (Object)e);
        }
    }

    private void sendMsg(List<String> urls) {
        if (CollectionUtil.isEmpty(urls)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("requestTime", DateUtil.convertToStr((String)"yyyy-MM-dd", (Date)DateUtil.getDateAdd((Date)new Date(), (int)10, (int)-24)));
        map.put("count", String.valueOf(urls.size()));
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        String accountName = account != null ? account.getAccountName() : "";
        map.put("accountName", accountName);
        String urlmsg = "";
        urlmsg = urls.size() > 2 ? urls.get(0) + "\u3001" + urls.get(1) + "..." : String.join((CharSequence)"\u3001", urls);
        map.put("requestUrl", urlmsg);
        OpenApiAlarmSdkUtil.sendMsg((AlarmTypeEnum)AlarmTypeEnum.SLOWINTERFACE, map);
    }
}

