/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.util;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CacheUtil;
import kd.bos.openapi.common.util.StringUtil;

public class CommonConfigUtil {
    private static final Log log = LogFactory.getLog(CommonConfigUtil.class);
    public static final int OPENAPI_UNITTEST_TYPE = 6;
    public static final int COMMON_CONFIG_TYPE_PLUGIN = 7;
    private static final String CACHE_TYPE_COMMON_CONFIG_PREFIX = "COMMON_CONFIG_TYPE_";

    public static void setValue(int type, String key, String value) {
        String accountId = RequestContext.get().getAccountId();
        if (StringUtil.isEmpty((String)key)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The value is null.", new Object[0]);
        }
        try (TXHandle handle = TX.requiresNew();){
            Object[] params;
            String sql = "SELECT fid,fcomkey, fcomvalue, fdesc FROM t_openapi_common where ftype=? and fcomkey=? ";
            boolean hasData = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new SqlParameter[]{new SqlParameter(":ftype", 4, (Object)type), new SqlParameter(":fcomkey", 12, (Object)key)}, rs -> {
                boolean result = false;
                while (rs.next()) {
                    if (rs.getLong("fid") == 0L) continue;
                    result = true;
                }
                return result;
            });
            if (hasData) {
                sql = "DELETE from t_openapi_common where ftype=? and fcomkey=? ";
                params = new SqlParameter[]{new SqlParameter(":ftype", 4, (Object)type), new SqlParameter(":fcomkey", 12, (Object)key)};
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
                String cacheType = CACHE_TYPE_COMMON_CONFIG_PREFIX + type;
                CacheUtil.removeCacheByKey((String)cacheType, (String)key, (String)accountId);
            }
            sql = "INSERT INTO t_openapi_common(fid,fcomkey,fcomvalue,ftype,fenable,fmodifytime) VALUES(?,?,?,?,'1',?) ";
            params = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)DB.genLongId((String)"t_openapi_common")), new SqlParameter(":fcomkey", 12, (Object)key), new SqlParameter(":fcomvalue", 12, (Object)value), new SqlParameter(":ftype", 4, (Object)type), new SqlParameter(":fmodifytime", 93, (Object)new Timestamp(new Date().getTime()))};
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
        }
    }

    public static String getValue(int type, String key) {
        String sql = "SELECT fcomkey, fcomvalue, fdesc FROM t_openapi_common where ftype=? and fcomkey=? and fenable='1' ";
        Map result = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new SqlParameter[]{new SqlParameter(":ftype", 4, (Object)type), new SqlParameter(":fcomkey", 12, (Object)key)}, rs -> {
            HashMap<String, String> params = new HashMap<String, String>(3);
            while (rs.next()) {
                String value = rs.getString("fcomvalue");
                if (EncrypterFactory.getEncrypter().isEncrypted(value)) {
                    value = EncrypterFactory.getEncrypter().decode(value);
                }
                params.put(rs.getString("fcomkey"), value);
            }
            return params;
        });
        if (result != null && result.size() > 0) {
            return (String)result.get(key);
        }
        return "";
    }

    public String getValueWithLocalCache(int type, String key) {
        return CommonConfigUtil.getValueWithLocalCache(type, key, RequestContext.get().getAccountId());
    }

    public static String getValueWithLocalCache(int type, String key, String accountId) {
        String cacheType = CACHE_TYPE_COMMON_CONFIG_PREFIX + type;
        Object value = CacheUtil.getCacheByKey((String)cacheType, (String)key, (String)accountId);
        if (value == null) {
            value = CommonConfigUtil.getValue(type, key, accountId);
        }
        if (value == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "There is not data in openapi common config.", new Object[0]);
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static String getValue(int type, String key, String accountId) {
        String valueString = "";
        Account account = AccountUtils.getAccountById((String)accountId);
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            String sql = "SELECT fcomkey, fcomvalue, fdesc FROM t_openapi_common where ftype=? and fcomkey=? and fenable='1' ";
            Object[] params = new SqlParameter[]{new SqlParameter(":ftype", 4, (Object)type), new SqlParameter(":fcomkey", 12, (Object)key)};
            valueString = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
                if (rs.next()) {
                    return rs.getString("fcomvalue");
                }
                return null;
            });
        }
        catch (Exception e) {
            log.error("CommonConfigUtil.getValue error:" + e.getMessage(), (Throwable)e);
        }
        return valueString;
    }
}

