/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class DynamicObjectUtil {
    public static List<Map<String, Object>> serializeToListMap(DynamicObject[] objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(objects.length);
        for (DynamicObject object : objects) {
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(object.getDynamicObjectType());
            binder.setOnlyDbProperty(false);
            DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)binder);
            Map map = jsr.serializeToMap((Object)object, null);
            list.add(map);
        }
        return list;
    }

    public static Map<String, Object> serializeToMap(DynamicObject object) {
        if (object == null) {
            return null;
        }
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(object.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)binder);
        Map map = jsr.serializeToMap((Object)object, null);
        return map;
    }

    public static List<Map<String, Object>> serializeToMap(DynamicObject[] objects, DynamicObjectType dt) {
        return DynamicObjectUtil.serializeToMap(objects, dt, false);
    }

    public static List<Map<String, Object>> serializeToMap(DynamicObject[] objects, DynamicObjectType dt, boolean isSerializeDefaultValue) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return Collections.emptyList();
        }
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dt);
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(isSerializeDefaultValue);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)binder);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(objects.length);
        for (DynamicObject object : objects) {
            Map map = jsr.serializeToMap((Object)object, null);
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, Object>> serializeToMapWithOutDefaultValue(DynamicObject[] objects, DynamicObjectType dt) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return Collections.emptyList();
        }
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dt);
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)binder);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(objects.length);
        for (DynamicObject object : objects) {
            Map map = jsr.serializeToMap((Object)object, null);
            list.add(map);
        }
        return list;
    }

    public static List<DynamicObject> deserializeFromMap(List<Map<String, Object>> objects, DynamicObjectType dt) {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return Collections.emptyList();
        }
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dt);
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(true);
        DcJsonSerializer jsr = new DcJsonSerializer((DcBinder)binder);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(objects.size());
        for (Map<String, Object> object : objects) {
            DynamicObject dynamicObject = (DynamicObject)jsr.deserializeFromMap(object, null);
            list.add(dynamicObject);
        }
        return list;
    }
}

