/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLException;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.util.DisCardUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientOpenUtils
extends HttpClientUtils {
    private static final Log logger = LogFactory.getLog(HttpClientOpenUtils.class);
    private static int default_connectionTimeout = Integer.getInteger("httpclient.connectionTimeout", 30000);
    private static int default_readTimeout = Integer.getInteger("httpclient.readTimeout", 60000);
    private static String SCHEME_HTTPS = "https";
    private static int DEFAULT_MAX_TOTAL = 1000;
    private static int DEFAULT_MAX_RETRY_TIMES = 3;
    private static PoolingHttpClientConnectionManager CONNECTION_MANAGER = null;

    public static HttpClient createClient(boolean isRetry, boolean isSchemaHttps) {
        if (!isRetry & !isSchemaHttps) {
            return HttpClients.createDefault();
        }
        if (isSchemaHttps) {
            return HttpClientOpenUtils.wrapperHttpClient((int)default_connectionTimeout, (int)default_readTimeout);
        }
        PoolingHttpClientConnectionManager connectionManager = CONNECTION_MANAGER;
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager);
        HttpRequestRetryHandler handler = (arg0, retryTimes, arg2) -> {
            boolean idempotent;
            if (retryTimes >= DEFAULT_MAX_RETRY_TIMES) {
                return false;
            }
            if (arg0 instanceof UnknownHostException || arg0 instanceof ConnectTimeoutException || !(arg0 instanceof SSLException) || arg0 instanceof NoHttpResponseException) {
                return true;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)arg2);
            HttpRequest request = clientContext.getRequest();
            boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
            return idempotent;
        };
        httpClientBuilder.setRetryHandler(handler);
        return httpClientBuilder.build();
    }

    public static RequestConfig getRequestConfig(int connectionTimeout, int readTimeout) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectionTimeout).setSocketTimeout(readTimeout).setConnectionRequestTimeout(readTimeout).setCookieSpec("compatibility").build();
        return requestConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHTMLContent(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(in));
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                logger.error("getHTMLContent error", (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static String post(String url, Map<String, String> header, String body) throws IOException {
        return HttpClientOpenUtils.post(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String post(String url, Map<String, String> header, String body, int connectionTimeout, int readTimeout) throws IOException {
        StringEntity entity = new StringEntity(body, "UTF-8");
        return HttpClientOpenUtils.post(url, header, (HttpEntity)entity, connectionTimeout, readTimeout, false);
    }

    public static String post(String url, Map<String, String> header, HttpEntity httpEntity) throws IOException {
        return HttpClientOpenUtils.post(url, header, httpEntity, default_connectionTimeout, default_readTimeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> header, HttpEntity httpEntity, int connectionTimeout, int readTimeout, boolean isRetry) throws IOException {
        HttpClient client = null;
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        client = HttpClientOpenUtils.createClient(isRetry, SCHEME_HTTPS.equals(uri.getScheme()));
        if (client == null) {
            throw new KDException(new ErrorCode("400", "HttpClient is null."), new Object[]{"WrapperHttpClient is null."});
        }
        post.setConfig(HttpClientOpenUtils.getRequestConfig(connectionTimeout, readTimeout));
        try {
            String data;
            for (Map.Entry<String, String> entry : header.entrySet()) {
                post.setHeader(entry.getKey(), entry.getValue());
            }
            post.setEntity(httpEntity);
            HttpResponse response = client.execute((HttpUriRequest)post);
            String string = data = HttpClientOpenUtils.getResponseResult(response);
            return string;
        }
        finally {
            post.releaseConnection();
        }
    }

    public static String postjson(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        return HttpClientOpenUtils.postjson(url, header, body, connectionTimeout, readTimeout, false);
    }

    public static String postjson(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout, boolean isRetry) throws IOException {
        String bodyJsonString = "";
        if (body != null) {
            bodyJsonString = JSONUtils.toString(body);
        }
        return HttpClientOpenUtils.postjson(url, header, bodyJsonString, connectionTimeout, readTimeout, isRetry);
    }

    public static String postjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) throws IOException {
        return HttpClientOpenUtils.postjson(url, header, json, connectionTimeout, readTimeout, false);
    }

    public static String postjson(String url, Map<String, String> header, String json) throws IOException {
        return HttpClientOpenUtils.postjson(url, header, json, default_connectionTimeout, default_readTimeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout, boolean isRetry) throws IOException {
        String CONTENT_TYPE_TEXT_JSON = "text/json;";
        String data = "";
        HttpClient client = null;
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        client = HttpClientOpenUtils.createClient(isRetry, SCHEME_HTTPS.equals(uri.getScheme()));
        if (client == null) {
            throw new KDException(new ErrorCode("400", "WrapperHttpClient is null."), new Object[]{"WrapperHttpClient is null."});
        }
        post.setConfig(HttpClientOpenUtils.getRequestConfig(connectionTimeout, readTimeout));
        try {
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
            se.setContentType("text/json;");
            se.setContentEncoding("UTF-8");
            post.setEntity((HttpEntity)se);
            HttpResponse response = client.execute((HttpUriRequest)post);
            data = HttpClientOpenUtils.getResponseResult(response);
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static String getResponseResult(HttpResponse response) throws IOException {
        String data = "";
        if (response == null) {
            return "";
        }
        HttpEntity resEntity = response.getEntity();
        Header respHeader = resEntity.getContentEncoding();
        if (respHeader == null || !"gzip".equalsIgnoreCase(respHeader.getValue()) && !"x-gzip".equalsIgnoreCase(respHeader.getValue())) {
            data = EntityUtils.toString((HttpEntity)resEntity);
        } else {
            GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
            InputStream in = gzipEntity.getContent();
            data = HttpClientOpenUtils.getHTMLContent(in);
        }
        return data;
    }

    public static String get(String url, Map<String, String> headers, Map<String, Object> body, int connectionTimeout, int readTimeout) {
        return HttpClientOpenUtils.get(url, headers, body, connectionTimeout, readTimeout, false);
    }

    public static String get(String url, Map<String, String> headers, Map<String, Object> body, int connectionTimeout, int readTimeout, boolean isRetry) {
        String content = null;
        String strBody = "";
        if (body != null && body.size() != 0) {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            try {
                for (Map.Entry<String, Object> entry : body.entrySet()) {
                    String value;
                    String key = entry.getKey();
                    String string = value = entry.getValue() != null ? entry.getValue().toString() : "";
                    if (!StringUtils.isNotEmpty((String)key)) continue;
                    params.add(new BasicNameValuePair(entry.getKey(), value));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
                strBody = EntityUtils.toString((HttpEntity)entity);
            }
            catch (IOException | ParseException var28) {
                logger.error("Http get error", var28);
            }
        }
        BufferedReader in = null;
        HttpResponse response = null;
        try {
            String destUrl = "";
            destUrl = StringUtils.isEmpty((String)strBody) ? url : (url.indexOf("?") > 0 ? url + "&" + strBody : url + "?" + strBody);
            URI uri = URI.create(destUrl);
            HttpClient client = HttpClientOpenUtils.createClient(isRetry, SCHEME_HTTPS.equals(uri.getScheme()));
            if (client == null) {
                throw new KDException(new ErrorCode("400", "WrapperHttpClient is null."), new Object[]{"WrapperHttpClient is null."});
            }
            HttpGet request = new HttpGet();
            if (headers != null && headers.size() != 0) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    if (!StringUtils.isNotEmpty((String)header.getKey())) continue;
                    request.setHeader(header.getKey(), header.getValue());
                }
            }
            request.setConfig(HttpClientOpenUtils.getRequestConfig(connectionTimeout, readTimeout));
            request.setURI(new URI(destUrl));
            response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuilder sb = new StringBuilder();
            String line = "";
            String separator = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line).append(separator);
            }
            content = sb.toString();
        }
        catch (Exception e) {
            String responeString = "";
            if (response != null) {
                responeString = OpenJsonUtil.toJson((Object)response.getEntity());
            }
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "Http get error:" + responeString, new Object[0]);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException var27) {
                    DisCardUtil.discard();
                }
            }
        }
        return content;
    }

    static {
        CONNECTION_MANAGER = new PoolingHttpClientConnectionManager();
        CONNECTION_MANAGER.setMaxTotal(DEFAULT_MAX_TOTAL);
        CONNECTION_MANAGER.setDefaultMaxPerRoute(DEFAULT_MAX_TOTAL);
    }
}

