/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.lang.reflect.InvocationTargetException;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

public class JWTUtils {
    private static final String JWT_SUBJECT = "kdjwt";
    private static final String JWT_ID = "kd";

    public static String generateJWTByMapParameters(Map<String, String> parameters, String key, long expireTime) {
        String jwtString = "";
        if (parameters != null && parameters.size() > 0 && StringUtils.isNotEmpty((CharSequence)key)) {
            Algorithm algorithm = Algorithm.HMAC256((String)key);
            JWTCreator.Builder builder = JWT.create().withSubject(JWT_SUBJECT).withIssuer(JWT_ID).withIssuedAt(new Date()).withExpiresAt(new Date(expireTime));
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                builder = builder.withClaim(parameter.getKey(), parameter.getValue());
            }
            jwtString = builder.sign(algorithm);
        }
        return jwtString;
    }

    private static <T> Map convertMap(T parameters) {
        Map params = null;
        if (parameters instanceof Map) {
            params = (Map)parameters;
        } else {
            try {
                params = BeanUtils.describe(parameters);
            }
            catch (IllegalAccessException e) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, "the parameters convert to map failed:IllegalAccessException", new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, "the parameters convert to map failed:InvocationTargetException", new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, "the parameters convert to map failed:NoSuchMethodException", new Object[0]);
            }
        }
        return params;
    }

    public static <T> String generateJWTByMapParameters(T parameters, String key, long expireTime) {
        String jwtString = "";
        if (parameters != null && StringUtils.isNotEmpty((CharSequence)key)) {
            Algorithm algorithm = Algorithm.HMAC256((String)key);
            JWTCreator.Builder builder = JWT.create().withSubject(JWT_SUBJECT).withIssuer(JWT_ID).withIssuedAt(new Date()).withExpiresAt(new Date(expireTime));
            Map params = JWTUtils.convertMap(parameters);
            for (Map.Entry parameter : params.entrySet()) {
                if (parameter == null) continue;
                String paramKey = (String)parameter.getKey();
                String paramValue = Optional.ofNullable(parameter.getValue()).orElse("");
                builder = builder.withClaim(paramKey, paramValue.toString());
            }
            jwtString = builder.sign(algorithm);
        }
        return jwtString;
    }

    public static String generateRSAJWTByMapParameters(Map<String, String> parameters, Key key, long expireTime) {
        String jwtString = "";
        if (parameters != null && parameters.size() > 0 && key != null) {
            Algorithm algorithm = Algorithm.RSA512(null, (RSAPrivateKey)((RSAPrivateKey)key));
            JWTCreator.Builder builder = JWT.create().withSubject(JWT_SUBJECT).withIssuer(JWT_ID).withIssuedAt(new Date()).withExpiresAt(new Date(expireTime));
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                builder = builder.withClaim(parameter.getKey(), parameter.getValue());
            }
            jwtString = builder.sign(algorithm);
        }
        return jwtString;
    }

    public static <T> String generateRSAJWTByMapParameters(T parameters, Key key, long expireTime) {
        String jwtString = "";
        if (parameters != null && key != null) {
            Algorithm algorithm = Algorithm.RSA512(null, (RSAPrivateKey)((RSAPrivateKey)key));
            JWTCreator.Builder builder = JWT.create().withSubject(JWT_SUBJECT).withIssuer(JWT_ID).withIssuedAt(new Date()).withExpiresAt(new Date(expireTime));
            Map params = JWTUtils.convertMap(parameters);
            for (Map.Entry parameter : params.entrySet()) {
                if (parameter == null) continue;
                String paramKey = (String)parameter.getKey();
                String paramValue = Optional.ofNullable(parameter.getValue()).orElse("");
                builder = builder.withClaim(paramKey, paramValue.toString());
            }
            jwtString = builder.sign(algorithm);
        }
        return jwtString;
    }

    public static Map<String, String> getJWTClaimsByPublicKey(Key key, String jwtString) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (key != null && StringUtils.isNotEmpty((CharSequence)jwtString)) {
            Algorithm algorithm = Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)key), null);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(new String[]{JWT_ID}).build();
            DecodedJWT jwt = verifier.verify(jwtString);
            for (String ckey : jwt.getClaims().keySet()) {
                returnMap.put(ckey, jwt.getClaim(ckey).asString());
            }
        }
        return returnMap;
    }

    public static Map<String, String> getJWTClaimsByKey(String key, String jwtString) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if (key != null && StringUtils.isNotEmpty((CharSequence)jwtString)) {
            Algorithm algorithm = Algorithm.HMAC256((String)key);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(new String[]{JWT_ID}).build();
            DecodedJWT jwt = verifier.verify(jwtString);
            for (String ckey : jwt.getClaims().keySet()) {
                returnMap.put(ckey, jwt.getClaim(ckey).asString());
            }
        }
        return returnMap;
    }
}

