/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.action.api.operation;

import java.util.Map;
import kd.bos.openapi.action.api.operation.ApiAppendEntryRows;
import kd.bos.openapi.action.api.operation.ApiAudit;
import kd.bos.openapi.action.api.operation.ApiCommonOp;
import kd.bos.openapi.action.api.operation.ApiDelete;
import kd.bos.openapi.action.api.operation.ApiDeleteEntryRows;
import kd.bos.openapi.action.api.operation.ApiDisable;
import kd.bos.openapi.action.api.operation.ApiEnable;
import kd.bos.openapi.action.api.operation.ApiQuery;
import kd.bos.openapi.action.api.operation.ApiSave;
import kd.bos.openapi.action.api.operation.ApiSubmit;
import kd.bos.openapi.action.api.operation.ApiUnAudit;
import kd.bos.openapi.action.api.operation.ApiUnSubmit;
import kd.bos.openapi.action.api.operation.upper.ApiOperation;
import kd.bos.openapi.api.model.OpenApiRequest;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.base.dataservice.OpenApiDataUtil;
import kd.bos.openapi.base.model.ApiModel;
import kd.bos.openapi.common.constant.ApiOperationType;

public enum ApiExecute {
    QUERY{

        @Override
        public ApiOperation<?, ?> create(OpenApiRequest<Map<String, Object>> request) {
            return new ApiQuery(request);
        }
    }
    ,
    SAVE{

        @Override
        public ApiOperation<?, ?> create(OpenApiRequest<Map<String, Object>> request) {
            return new ApiSave(request);
        }
    }
    ,
    DELETE{

        @Override
        public ApiOperation<?, ?> create(OpenApiRequest<Map<String, Object>> request) {
            return new ApiDelete(request);
        }
    }
    ,
    APPENDENTRYROWS{

        @Override
        ApiOperation<?, ?> create(OpenApiRequest<Map<String, Object>> request) {
            return new ApiAppendEntryRows(request);
        }
    }
    ,
    DELETEENTRYROWS{

        @Override
        ApiOperation<?, ?> create(OpenApiRequest<Map<String, Object>> request) {
            return new ApiDeleteEntryRows(request);
        }
    }
    ,
    SUBMIT{

        @Override
        ApiOperation<?, ?> create(OpenApiRequest<Map<String, Object>> request) {
            return new ApiSubmit(request);
        }
    }
    ,
    UNSUBMIT{

        @Override
        ApiOperation<?, ?> create(OpenApiRequest<Map<String, Object>> request) {
            return new ApiUnSubmit(request);
        }
    }
    ,
    AUDIT{

        @Override
        ApiOperation<?, ?> create(OpenApiRequest<Map<String, Object>> request) {
            return new ApiAudit(request);
        }
    }
    ,
    UNAUDIT{

        @Override
        ApiOperation<?, ?> create(OpenApiRequest<Map<String, Object>> request) {
            return new ApiUnAudit(request);
        }
    }
    ,
    ENABLE{

        @Override
        ApiOperation<?, ?> create(OpenApiRequest<Map<String, Object>> request) {
            return new ApiEnable(request);
        }
    }
    ,
    DISABLE{

        @Override
        ApiOperation<?, ?> create(OpenApiRequest<Map<String, Object>> request) {
            return new ApiDisable(request);
        }
    }
    ,
    $_COMMON_OP{

        @Override
        ApiOperation<?, ?> create(OpenApiRequest<Map<String, Object>> request) {
            return new ApiCommonOp(request);
        }
    };


    private static ApiExecute get(String url) {
        ApiModel api = OpenApiDataUtil.getApiModelFromCache((String)url);
        for (ApiExecute apiExecute : ApiExecute.values()) {
            if (!apiExecute.op().equalsIgnoreCase(api.getOperation())) continue;
            return apiExecute;
        }
        if (SAVE.op().equalsIgnoreCase(api.getOperationType())) {
            return SAVE;
        }
        if (DELETE.op().equalsIgnoreCase(api.getOperationType())) {
            return DELETE;
        }
        return $_COMMON_OP;
    }

    abstract ApiOperation<?, ?> create(OpenApiRequest<Map<String, Object>> var1);

    public String op() {
        if ($_COMMON_OP.name().equals(this.name())) {
            return "";
        }
        return ApiOperationType.valueOf((String)this.name()).getOp();
    }

    public static ApiServiceData<?> execute(OpenApiRequest<Map<String, Object>> openApiRequest) {
        String url = openApiRequest.getServiceApiData().getUrl();
        return ApiExecute.get(url).create(openApiRequest).execute();
    }
}

