/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.action.util;

import java.util.Collections;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.facade.coross.ControlStrategy;
import kd.bos.openapi.base.acl.ApilAclManager;
import kd.bos.openapi.base.model.ApiResponseModel;
import kd.bos.openapi.base.model.ThirdAppAclModel;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coross.CosmicCorossTransferHelper;

public class PrivacyTransDataUtil {
    private static final String BOS_OPEN_ACTION = "bos-open-action";
    private static final String OPEN_APPID = "open";
    private static final String OPENAPI = "OpenApi";

    public static Object privacyDataConvert(long entryId, String propName, String dataClassCode, Object value) {
        try {
            ControlStrategy strategy = new ControlStrategy();
            strategy.setCustom(Boolean.valueOf(false));
            strategy.setAppId(OPEN_APPID);
            strategy.setDataId(String.valueOf(entryId));
            strategy.setFieldName(propName);
            strategy.setDataClassCode(dataClassCode);
            strategy.setPipelineType(OPENAPI);
            CosmicCorossTransferHelper.register(Collections.singletonList(strategy));
            strategy.setSourcePoint(CosmicCorossTransferHelper.getSysLocation());
            strategy.setTargetPoint(PrivacyTransDataUtil.getTargetPointFrom3rdApp());
            Object executeValue = CosmicCorossTransferHelper.execute((ControlStrategy)strategy, (Object)value);
            return executeValue;
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u8de8\u5883\u6570\u636e\u8f6c\u6362\u9519\u8bef\uff0c%1$s", (String)"CosmicCorossUtil_0", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), e.getMessage()), new Object[0]);
        }
    }

    public static boolean isPrivacyTransData() {
        String thirdId = RequestContext.get().getApi3rdAppId();
        if (StringUtil.isEmpty((String)thirdId) || "null".equalsIgnoreCase(thirdId)) {
            return false;
        }
        ThirdAppAclModel appAclModel = ApilAclManager.getThirdAppAclInfoModelFromCache((String)thirdId);
        String countryNumber = appAclModel.getCountry();
        if (StringUtil.isEmpty((String)countryNumber)) {
            return false;
        }
        return !countryNumber.equals(CosmicCorossTransferHelper.getSysLocation());
    }

    public static boolean isConfigTransDataTag(List<ApiResponseModel> responseModels) {
        if (CollectionUtils.isEmpty(responseModels)) {
            return false;
        }
        for (ApiResponseModel responseModel : responseModels) {
            String dataClassCode = responseModel.getDataClassCode();
            if (!StringUtil.isNotEmpty((String)dataClassCode)) continue;
            return true;
        }
        return false;
    }

    private static String getTargetPointFrom3rdApp() {
        String thirdId = RequestContext.get().getApi3rdAppId();
        ThirdAppAclModel appAclModel = ApilAclManager.getThirdAppAclInfoModelFromCache((String)thirdId);
        String countryNumber = appAclModel.getCountry();
        if (StringUtil.isEmpty((String)countryNumber)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u63a5\u6536\u65b9\u5931\u8d25\uff0c\u201c%1$s\u201d\u8be5\u7b2c\u4e09\u65b9\u5e94\u7528\u6ca1\u6709\u914d\u7f6e\u56fd\u5bb6\u5730\u533a\u3002", (String)"CosmicCorossUtil_1", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), appAclModel.getThirdAppCode()), new Object[0]);
        }
        return countryNumber;
    }
}

