/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.api;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.kcf.ServiceContext;
import kd.bos.kcf.ServiceType;
import kd.bos.kcf.message.HttpMethod;
import kd.bos.kcf.message.KRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.query.QueryResult;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.spi.OpenApiDataService;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.kcf.utils.IdempotencyUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.api.ApiServiceLogHelper;
import kd.bos.web.api.OpenApiExceptionUtils;
import kd.bos.web.api.OpenApiLocalCache;
import kd.bos.web.api.OpenApiUtils;
import kd.bos.web.api.QueryFormatApiResult;
import kd.bos.web.api.RedisCacheUtils;
import kd.bos.web.util.DateUtil;
import org.apache.commons.codec.digest.DigestUtils;

public class ApiServiceType
extends ServiceType {
    private Log log = LogFactory.getLog(ApiServiceType.class);
    static final String SELECT = "select";
    static final String FROM = "from";
    static final String TO = "to";
    private static final String PAGE_SIZE = "page_size";
    private static final String PAGE_NO = "page_no";
    static final String FILTER = "filter";
    static final String ORDERBY = "orderby";
    static final String FORMAT = "fmt";
    static final String REQ_PARA_NUMBERS = "numbers";
    static final String REQ_PARA_IDS = "ids";
    static final String REQ_PARA_NUMBER = "number";
    static final String REQ_PARA_ID = "id";
    static final String REQ_PARA_ORG = "org";
    static final String REQ_PARA_APPID = "app";
    private static final String API_SERVICE = "ApiService";
    private static final String BOS_OPEN_ACTION = "bos-open-action";
    private static final String OPTION_VARIABLES = "optionvariables";
    private static final String API_QUERY_BY_CACHE = "api.querybycache";
    private static final String QUEYR_KSQL = "query_ksql";
    static final String FIELDS = "fields";
    static final String CONDITION = "condition";
    private String formId;
    private String op;
    int pagesize = 100;

    public String getFormId() {
        return this.formId;
    }

    public String getOperation() {
        return this.op;
    }

    private String getErrorInputPara() {
        return ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570 %s \u5f02\u5e38\u00b7", (String)"ApiServiceType_8", (String)BOS_OPEN_ACTION, (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ServiceContext ctx) {
        long timeST = System.currentTimeMillis();
        AtomicReference apiserviceId = new AtomicReference();
        try {
            IdempotencyUtil.doIdempotency((HttpServletRequest)ctx.getRequest().getRequest(), (OpenApiData)ctx.getOpenApiData(), () -> {
                Boolean checkApiForbidden;
                String operation = (String)ctx.getEnvVar("operationId");
                this.formId = (String)ctx.getEnvVar("formId");
                this.checkClientIP();
                apiserviceId.set(OpenApiUtils.getApiserviceIdforOp(this.formId, operation));
                OpenApiUtils.checkACL((String)apiserviceId.get());
                String appId = (String)ctx.getRequest().getParameter(REQ_PARA_APPID);
                this.setAppId(appId);
                if (OpenApiUtils.checkHMApiforOp(this.formId, operation, ctx.getRequest().getMethod().toString())) {
                    ctx.getResponse().fail(ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u201c\u8bf7\u6c42\u65b9\u5f0f\u201d\u4e0e\u8bbe\u7f6e\u7684\u4e0d\u5339\u914d\u3002", (String)"ApiServiceType_0", (String)BOS_OPEN_ACTION, (Object[])new Object[0]));
                    return null;
                }
                String failMessage = "";
                Boolean checkAppIsTrue = Boolean.TRUE;
                if (StringUtils.isNotBlank((CharSequence)appId)) {
                    checkAppIsTrue = (Boolean)DispatchServiceHelper.invokeBOSService((String)API_SERVICE, (String)"checkAppByAppNumber", (Object[])new Object[]{appId});
                    if (!checkAppIsTrue.booleanValue()) {
                        failMessage = String.format(ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u8fd0\u884c\u65f6\u5e94\u7528%S\u5df2\u88ab\u7981\u6b62\u8bbf\u95ee\u3002", (String)"ApiServiceType_1", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), appId);
                    }
                } else {
                    checkAppIsTrue = (Boolean)DispatchServiceHelper.invokeBOSService((String)API_SERVICE, (String)"checkAppByFormId", (Object[])new Object[]{this.formId});
                    if (!checkAppIsTrue.booleanValue()) {
                        failMessage = String.format(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5bf9\u8c61%S\u6240\u5728\u5e94\u7528\u5df2\u88ab\u7981\u6b62\u8bbf\u95ee\u3002", (String)"ApiServiceType_2", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), this.formId);
                    }
                }
                if (failMessage.isEmpty() && !(checkApiForbidden = (Boolean)DispatchServiceHelper.invokeBOSService((String)API_SERVICE, (String)"checkApiForbidden", (Object[])new Object[]{this.formId, operation})).booleanValue()) {
                    failMessage = ResManager.loadKDString((String)"\u63a5\u53e3\u4e0d\u5b58\u5728\u6216\u8005\u88ab\u7981\u6b62\u8bbf\u95ee\u3002", (String)"ApiServiceType_3", (String)BOS_OPEN_ACTION, (Object[])new Object[0]);
                }
                if (failMessage.isEmpty()) {
                    Boolean checkUserIsTrue = Boolean.TRUE;
                    try {
                        checkUserIsTrue = (Boolean)DispatchServiceHelper.invokeBOSService((String)API_SERVICE, (String)"checkApiUserIsTrue", (Object[])new Object[]{this.formId, operation});
                    }
                    catch (KDException e) {
                        ctx.getResponse().fail(e.getMessage());
                        return null;
                    }
                    if (!checkUserIsTrue.booleanValue()) {
                        failMessage = ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u6b64\u63a5\u53e3\u8bbf\u95ee\u6743\u9650\u3002", (String)"ApiServiceType_4", (String)BOS_OPEN_ACTION, (Object[])new Object[0]);
                    }
                }
                if (!failMessage.isEmpty()) {
                    ctx.getResponse().fail(failMessage);
                } else {
                    this.op = (String)ctx.getEnvVar("operationId");
                    this.invokeApiOperation(ctx);
                }
                return null;
            });
        }
        catch (KDException e) {
            OpenApiExceptionUtils.dealThrowable(e, ctx);
        }
        catch (Exception ne) {
            String errorMessage = OpenApiExceptionUtils.getErrorMsg(ne);
            ctx.getResponse().fail(errorMessage);
            this.log.error(errorMessage, (Throwable)ne);
        }
        finally {
            int timeCost = (int)(System.currentTimeMillis() - timeST);
            ApiServiceLogHelper.writeApiLog(ctx, OpenApiLocalCache.getOpenApiData((String)apiserviceId.get()), timeCost);
        }
    }

    private void checkClientIP() {
        OpenApiDataService openApiDataService = OpenApiDataServiceFactory.getOpenApiDataService();
        openApiDataService.checkClientIP();
    }

    public void meta(ServiceContext ctx) {
        HashMap<String, String> meta = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        sb.append("metadata ").append(new Date());
        meta.put("m", sb.toString());
        ctx.getResponse().success(meta);
        ctx.getResponse().end();
    }

    private void invokeApiOperation(ServiceContext ctx) {
        String data = (String)ctx.getRequest().getData();
        if (ctx.getRequest().getMethod() == HttpMethod.Post) {
            ApiServiceLogHelper.LogInfo(data);
        }
        String ret = "";
        boolean writedResponse = false;
        if ("save".equals(this.op)) {
            if (data == null) {
                ctx.getResponse().fail(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (String)"ApiServiceType_5", (String)BOS_OPEN_ACTION, (Object[])new Object[0]));
                return;
            }
            ret = this.save(this.formId, data);
        } else if ("draft".equals(this.op)) {
            ret = this.draft(this.formId, data);
        } else if ("load".equals(this.op)) {
            ret = this.load(this.formId, this.buildOpParameter(ctx.getRequest()));
        } else if ("getAttachements".equals(this.op)) {
            ret = this.executeOperation(this.formId, "getAttachements", this.buildOpParameter(ctx.getRequest()));
        } else if ("delete".equals(this.op)) {
            ret = this.delete(this.formId, this.buildBatchOpParameter(ctx.getRequest(), data));
        } else if ("audit".equals(this.op)) {
            ret = this.audit(this.formId, this.buildBatchOpParameter(ctx.getRequest(), data));
        } else if ("submit".equals(this.op)) {
            ret = this.submit(this.formId, this.buildBatchOpParameter(ctx.getRequest(), data));
        } else if ("batchsave".equals(this.op)) {
            ret = this.batchSave(this.formId, data);
        } else if ("appendentryrows".equalsIgnoreCase(this.op)) {
            ret = this.doOperation("appendEntryRows", this.formId, data);
        } else if ("deleteentryrows".equalsIgnoreCase(this.op)) {
            ret = this.doOperation("deleteEntryRows", this.formId, data);
        } else if ("enable".equals(this.op) || "disable".equals(this.op)) {
            ret = this.executeOperation(this.formId, this.op, this.buildBatchOpParameter(ctx.getRequest(), data));
        } else if ("query".equals(this.op)) {
            if ("true".equals(ctx.getRequest().getParameter("detailquery"))) {
                this.detailQuery(ctx, this.formId);
            } else {
                String select = this.getSelect(ctx);
                String filter = this.getFilter(ctx);
                String api_AllowKVQuery = System.getProperty("api.AllowKVQuery");
                if ("true".equals(api_AllowKVQuery) && StringUtils.isEmpty((CharSequence)select) && StringUtils.isEmpty((CharSequence)filter)) {
                    this.queryByParams(ctx, this.formId);
                } else {
                    this.query(ctx, this.formId);
                }
            }
            writedResponse = true;
        } else {
            ret = this.donothing(this.formId, this.op, this.buildBatchOpParameter(ctx.getRequest(), data));
        }
        if (!writedResponse) {
            ctx.getResponse().append(ret);
        }
    }

    String getSelect(ServiceContext ctx) {
        String select = (String)ctx.getRequest().getParameter(SELECT);
        if (StringUtils.isEmpty((CharSequence)select)) {
            select = (String)ctx.getRequest().getParameter(FIELDS);
        }
        return select;
    }

    String getFilter(ServiceContext ctx) {
        String filter = (String)ctx.getRequest().getParameter(FILTER);
        if (StringUtils.isEmpty((CharSequence)filter)) {
            filter = (String)ctx.getRequest().getParameter(CONDITION);
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void queryByParams(ServiceContext ctx, String entityId) {
        block30: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                paramsSetting = this.queryResultFiled();
                                select = paramsSetting.get("selectparam") == null ? "" : (String)paramsSetting.get("selectparam");
                                filter = paramsSetting.get("filterparam") == null ? "" : (String)paramsSetting.get("filterparam");
                                mustParam = paramsSetting.get("mustparam") == null ? "" : (String)paramsSetting.get("mustparam");
                                paramTypeMap = (Map)paramsSetting.get("getMap");
                                dateEqualStr = paramsSetting.get("dateEqualStr") == null ? "" : (String)paramsSetting.get("dateEqualStr");
                                cacheId = "";
                                if (!StringUtils.isEmpty((CharSequence)select) && !select.contains("*")) break block25;
                                ctx.getResponse().fail(ResManager.loadKDString((String)"select\u5b50\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6216\u8005\u542b\u6709*\u901a\u914d\u7b26\u3002", (String)"ApiServiceType_6", (String)"bos-open-action", (Object[])new Object[0]));
                                if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
                                    this.doQueryService("release", new Object[]{cacheId});
                                }
                                return;
                            }
                            paramsRequest = ctx.getRequest().getParameters();
                            isMust = this.checkMust(ctx, paramsRequest, mustParam);
                            if (isMust) break block26;
                            ctx.getResponse().fail(String.format(ResManager.loadKDString((String)"\u5fc5\u586b\u53c2\u6570%s\u5fc5\u987b\u586b\u5199\u3002", (String)"ApiServiceType_7", (String)"bos-open-action", (Object[])new Object[0]), new Object[]{mustParam}));
                            if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
                                this.doQueryService("release", new Object[]{cacheId});
                            }
                            return;
                        }
                        pageno = 0;
                        isPage = false;
                        pageSize1 = (String)paramsRequest.get("page_size");
                        pageNoStr = (String)paramsRequest.get("page_no");
                        if (pageSize1 == null || pageNoStr == null) ** GOTO lbl55
                        pageSizeIsNumeric = this.parseNumeric(pageSize1);
                        pageNoIsNumeric = this.parseNumeric(pageNoStr);
                        if (pageSizeIsNumeric > 0) {
                            this.pagesize = pageSizeIsNumeric;
                            break block27;
                        }
                        ctx.getResponse().fail(String.format(this.getErrorInputPara(), new Object[]{pageSize1}));
                        if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
                            this.doQueryService("release", new Object[]{cacheId});
                        }
                        return;
                    }
                    if (pageNoIsNumeric > 0) {
                        pageno = pageNoIsNumeric;
                        break block28;
                    }
                    ctx.getResponse().fail(String.format(this.getErrorInputPara(), new Object[]{pageNoStr}));
                    if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
                        this.doQueryService("release", new Object[]{cacheId});
                    }
                    return;
                }
                isPage = true;
lbl55:
                // 2 sources

                orderby = (String)paramsRequest.get("orderby");
                expressNullFlag = false;
                replaceStr = new ArrayList<Object>();
                paramValue = new ArrayList<Object>();
                resultQueryObjectList /* !! */  = new ArrayList<String>();
                newfilter = filter;
                if (!StringUtils.isEmpty((CharSequence)filter) && filter.contains("[")) {
                    newfilter = this.dealFilter(paramsRequest, filter, replaceStr, paramValue, dateEqualStr);
                    this.log.info("\u5c01\u88c5\u7684\u53c2\u6570\u503c{}", (Object)paramValue.toString());
                    if (newfilter.contains(" in ") || filter.contains(" not in ")) {
                        newfilter = this.dealIn(newfilter, replaceStr);
                    }
                    resultQueryObjectList /* !! */  = this.dealFinalArrayMap(paramValue, replaceStr, paramTypeMap);
                } else {
                    expressNullFlag = true;
                    resultQueryObjectList /* !! */ .add(newfilter);
                }
                this.log.info("\u5904\u7406\u540e\u7684finalArray-\u53c2\u6570\u662f\uff1a{}", (Object)resultQueryObjectList /* !! */ .toString());
                if (!this.checkFilter(ctx, newfilter)) break block29;
                if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
                    this.doQueryService("release", new Object[]{cacheId});
                }
                return;
            }
            try {
                isJsonFormat = "json".equals(ctx.getRequest().getParameter("api.resulttype"));
                prefix = new StringBuilder();
                ret = (QueryResult)this.doQueryService("startWebApiQueryByParams", new Object[]{entityId, select, newfilter, orderby, this.pagesize, resultQueryObjectList /* !! */ , expressNullFlag});
                prefix = this.dealPageData(prefix, ret, entityId, cacheId, isPage, pageno, isJsonFormat);
                ctx.getResponse().append(prefix.toString());
            }
            catch (KDException e) {
                OpenApiExceptionUtils.dealThrowable(e, ctx);
                if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
                    this.doQueryService("release", new Object[]{cacheId});
                }
                break block30;
            }
            catch (Exception ne) {
                this.log.info("\u7cfb\u7edf\u5185\u90e8\u9519\u8bef", (Object)ne);
                ctx.getResponse().fail(ne.getMessage(), "false");
                {
                    catch (Throwable var25_28) {
                        if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
                            this.doQueryService("release", new Object[]{cacheId});
                        }
                        throw var25_28;
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
                    this.doQueryService("release", new Object[]{cacheId});
                } else {
                    ** GOTO lbl108
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
                this.doQueryService("release", new Object[]{cacheId});
            }
        }
    }

    private List<Object> dealFinalArrayMap(List<Object> paramKey, List<Object> paramVlue, Map<String, String> paramTypeMap) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (int i = 0; i < paramKey.size(); ++i) {
            String paramType = paramTypeMap.get(paramKey.get(i));
            if (paramVlue.get(i) instanceof String[]) {
                String[] array = (String[])paramVlue.get(i);
                for (int j = 0; j < array.length; ++j) {
                    this.dealParamType(paramType, array[j], resultList);
                }
                continue;
            }
            this.dealParamType(paramType, paramVlue.get(i), resultList);
        }
        return resultList;
    }

    private void dealParamType(String paramType, Object value, List<Object> resultList) {
        switch (paramType) {
            case "int": {
                resultList.add(Integer.parseInt((String)value));
                break;
            }
            case "Long": {
                resultList.add(Long.parseLong((String)value));
                break;
            }
            case "Float": {
                resultList.add(Float.valueOf(Float.parseFloat((String)value)));
                break;
            }
            case "Double": {
                resultList.add(Double.parseDouble((String)value));
                break;
            }
            case "String": {
                resultList.add(value);
                break;
            }
            case "Boolean": {
                resultList.add(value);
                break;
            }
            case "Date": {
                resultList.add(DateUtil.dealDate((String)value));
            }
        }
    }

    private String dealIn(String filter, List<Object> replaceStr) {
        StringBuilder newFilter = new StringBuilder(filter);
        for (int i = 0; i < replaceStr.size(); ++i) {
            if (!(replaceStr.get(i) instanceof String[])) continue;
            this.log.info("\u5b57\u7b26\u4e32\u662f\u6570\u7ec4\u7c7b\u578b\uff1a{}", replaceStr.get(i));
            String charReplace = this.getLengthOfChar((String[])replaceStr.get(i));
            Integer indexofchar = this.getIndexof(filter, i + 1);
            newFilter.replace(indexofchar, indexofchar + 1, charReplace);
        }
        return newFilter.toString();
    }

    private String getLengthOfChar(String[] array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i == array.length - 1) {
                sb.append('?');
                continue;
            }
            sb.append("?,");
        }
        return sb.toString();
    }

    private Integer getIndexof(String newFilter, int i) {
        Pattern pattern = Pattern.compile("\\?");
        Matcher findMatcher = pattern.matcher(newFilter);
        int j = 1;
        while (findMatcher.find()) {
            if (j == i) {
                return findMatcher.start();
            }
            ++j;
        }
        return -1;
    }

    private boolean checkMust(ServiceContext ctx, Map<String, Object> paramMap, String mustParam) {
        if (StringUtils.isEmpty((CharSequence)mustParam)) {
            return true;
        }
        String[] mustOne = mustParam.split(",");
        for (int i = 0; i < mustOne.length; ++i) {
            if (null != paramMap.get(mustOne[i]) || !StringUtils.isNotEmpty((CharSequence)mustParam)) continue;
            return false;
        }
        return true;
    }

    private String dealFilter(Map<String, Object> paramMap, String filter, List<Object> replaceStr, List<Object> paramValue, String dateEqualStr) {
        ArrayList<String> resultList = new ArrayList<String>();
        List<String> paramList = ApiServiceType.getStr(filter, 0, 0, resultList);
        if (paramList.isEmpty()) {
            return "";
        }
        int count = 0;
        for (int i = 0; i < paramList.size(); ++i) {
            String requestValue;
            String noCharstr;
            String chooseStr = paramList.get(i);
            String key = noCharstr = chooseStr.substring(1, chooseStr.length() - 1);
            if (noCharstr.contains("%")) {
                key = noCharstr.replaceAll("%", " ").trim();
                this.log.info("key\u503c\u4e3a{}", (Object)key);
            }
            if (StringUtils.isEmpty((CharSequence)(requestValue = (String)paramMap.get(key)))) {
                return "";
            }
            if (noCharstr.contains("%")) {
                StringBuilder requestValueStr = new StringBuilder();
                if (noCharstr.startsWith("%")) {
                    requestValueStr.append('%');
                }
                requestValueStr.append(requestValue);
                if (noCharstr.endsWith("%")) {
                    requestValueStr.append('%');
                }
                paramValue.add(key);
                replaceStr.add(requestValueStr.toString());
            } else if (requestValue.contains(",")) {
                String[] arrayStr = requestValue.split(",");
                replaceStr.add(arrayStr);
                paramValue.add(key);
            } else {
                List<String> dateStrlist;
                if (!StringUtils.isEmpty((CharSequence)dateEqualStr) && (dateStrlist = Arrays.asList(dateEqualStr.split(","))).contains(key) && ++count != 0 && count % 2 == 0) {
                    requestValue = DateUtil.dealAddDate(requestValue);
                }
                replaceStr.add(requestValue);
                paramValue.add(key);
            }
            filter = filter.replace(chooseStr, "?");
        }
        return filter;
    }

    private static List<String> getStr(String str, int start, int end, List<String> array) {
        int newstart = str.indexOf(91, start + 1);
        int newend = str.indexOf(93, end + 1);
        if (newstart == -1 && newend == -1) {
            return array;
        }
        String current = str.substring(str.indexOf(91, start), str.indexOf(93, end) + 1);
        array.add(current);
        ApiServiceType.getStr(str, newstart + 1, newend + 1, array);
        return array;
    }

    private Map queryResultFiled() {
        String apiId = OpenApiUtils.getApiserviceIdforOp(this.formId, this.op);
        String resultMapStr = RedisCacheUtils.get(apiId, QUEYR_KSQL);
        Map<String, String> resultMap = new HashMap();
        try {
            Map param = (Map)JSON.parse((String)resultMapStr);
            if (param != null) {
                resultMap = param;
            }
        }
        catch (Exception param) {
            // empty catch block
        }
        if (resultMap.containsKey("selectparam")) {
            return resultMap;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("bizobject", "=", (Object)this.formId), new QFilter("operation", "=", (Object)"query"), new QFilter("version", "!=", (Object)"2"), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"open_apiservice_new", (String)"selectparam,filterparam,mustparam,urlparamname,urlparamtype,filter_column,filter_compare,filter_value", (QFilter[])qFilters);
        if (dynamicObjects.length == 0) {
            return resultMap;
        }
        if (dynamicObjects.length > 1) {
            String filterStr = String.format("formId:%s operation:%s", this.formId, "query");
            throw new KDException(new ErrorCode(ApiErrorCode.Data_Duplicate.toString(), String.format(ResManager.loadKDString((String)"\u67e5\u627e\u5230\u591a\u6761\u63a5\u53e3\u914d\u7f6e\u6570\u636e\uff1a\u8fc7\u6ee4\u6761\u4ef6\uff1a%s", (String)"ApiServiceType_9", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), filterStr)), new Object[0]);
        }
        String selectparam = (String)dynamicObjects[0].get("selectparam");
        String filterparam = (String)dynamicObjects[0].get("filterparam");
        String mustparam = (String)dynamicObjects[0].get("mustparam");
        DynamicObjectCollection getEntity = (DynamicObjectCollection)dynamicObjects[0].get("urlparamentryentity");
        DynamicObjectCollection filterEntity = (DynamicObjectCollection)dynamicObjects[0].get("filter_entity");
        Map getMap = this.dealGetEntity(getEntity);
        String dateEqualStr = this.getDateEqualStr(filterEntity, getMap);
        resultMap.put("selectparam", selectparam);
        resultMap.put("filterparam", filterparam);
        resultMap.put("mustparam", mustparam);
        resultMap.put("dateEqualStr", dateEqualStr);
        resultMap.put("getMap", (String)((Object)getMap));
        RedisCacheUtils.put(apiId, QUEYR_KSQL, SerializationUtils.toJsonString(resultMap));
        return resultMap;
    }

    private String getDateEqualStr(DynamicObjectCollection filterEntity, Map<String, String> getMap) {
        if (filterEntity.isEmpty() || getMap.isEmpty()) {
            return "";
        }
        ArrayList<String> dateStr = new ArrayList<String>();
        for (int i = 0; i < filterEntity.size(); ++i) {
            String filterValueName = ((DynamicObject)filterEntity.get(i)).getString("filter_value");
            String compare = ((DynamicObject)filterEntity.get(i)).getString("filter_compare");
            if (!getMap.get(filterValueName).equals("Date") || !compare.equals("=")) continue;
            dateStr.add(filterValueName);
        }
        return String.join((CharSequence)",", dateStr.toArray(new String[dateStr.size()]));
    }

    private Map dealGetEntity(DynamicObjectCollection getEntity) {
        HashMap<String, String> typeMap = new HashMap<String, String>(getEntity.size());
        for (int i = 0; i < getEntity.size(); ++i) {
            DynamicObject object = (DynamicObject)getEntity.get(i);
            String paramName = (String)object.get("urlparamname");
            String paramType = (String)object.get("urlparamtype");
            typeMap.put(paramName, paramType);
        }
        return typeMap;
    }

    private String executeOperation(String formId, String op, String data) {
        return this.doOperation("executeOperationForWeb", formId, op, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void query(ServiceContext ctx, String entityId) {
        block30: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    select = this.getSelect(ctx);
                                    cacheId = "";
                                    if (!StringUtils.isBlank((CharSequence)select) && !select.contains("*")) break block24;
                                    ctx.getResponse().fail(ResManager.loadKDString((String)"select\u5b50\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6216\u8005\u542b\u6709*\u901a\u914d\u7b26\u3002", (String)"ApiServiceType_6", (String)"bos-open-action", (Object[])new Object[0]));
                                    if (this.queryByCached(ctx) && StringUtils.isNotEmpty((CharSequence)cacheId)) {
                                        this.doQueryService("release", new Object[]{cacheId});
                                    }
                                    return;
                                }
                                if (!"null".equalsIgnoreCase(select)) break block25;
                                ctx.getResponse().fail(ResManager.loadKDString((String)"select\u5b50\u53e5\u4e0d\u80fd\u4e3anull\u3002", (String)"ApiServiceType_10", (String)"bos-open-action", (Object[])new Object[0]));
                                if (this.queryByCached(ctx) && StringUtils.isNotEmpty((CharSequence)cacheId)) {
                                    this.doQueryService("release", new Object[]{cacheId});
                                }
                                return;
                            }
                            pageno = 0;
                            isPage = false;
                            pageSize1 = (String)ctx.getRequest().getParameter("page_size");
                            pageNoStr = (String)ctx.getRequest().getParameter("page_no");
                            if (pageSize1 == null || pageNoStr == null) ** GOTO lbl48
                            pageSizeIsNumeric = this.parseNumeric(pageSize1);
                            pageNoIsNumeric = this.parseNumeric(pageNoStr);
                            if (pageSizeIsNumeric > 0) {
                                this.pagesize = pageSizeIsNumeric;
                                break block26;
                            }
                            ctx.getResponse().fail(String.format(this.getErrorInputPara(), new Object[]{pageSize1}));
                            if (this.queryByCached(ctx) && StringUtils.isNotEmpty((CharSequence)cacheId)) {
                                this.doQueryService("release", new Object[]{cacheId});
                            }
                            return;
                        }
                        if (pageNoIsNumeric > 0) {
                            pageno = pageNoIsNumeric;
                            break block27;
                        }
                        ctx.getResponse().fail(String.format(this.getErrorInputPara(), new Object[]{pageNoStr}));
                        if (this.queryByCached(ctx) && StringUtils.isNotEmpty((CharSequence)cacheId)) {
                            this.doQueryService("release", new Object[]{cacheId});
                        }
                        return;
                    }
                    isPage = true;
lbl48:
                    // 2 sources

                    orderby = (String)ctx.getRequest().getParameter("orderby");
                    fmt = (String)ctx.getRequest().getParameter("fmt");
                    filter = this.getFilter(ctx);
                    if (!this.checkFilter(ctx, filter)) break block28;
                    if (this.queryByCached(ctx) && StringUtils.isNotEmpty((CharSequence)cacheId)) {
                        this.doQueryService("release", new Object[]{cacheId});
                    }
                    return;
                }
                if (this.queryByCached(ctx)) break block29;
                isDesensitize = ctx.getEnvVar("desensitize") == null ? true : "true".equalsIgnoreCase((String)ctx.getEnvVar("desensitize"));
                result = this.doOperation("queryOT", new Object[]{entityId, select, filter, orderby, isPage != false ? pageno : 0, isPage != false ? this.pagesize : 0, isDesensitize});
                ctx.getResponse().append(result);
                if (this.queryByCached(ctx) && StringUtils.isNotEmpty((CharSequence)cacheId)) {
                    this.doQueryService("release", new Object[]{cacheId});
                }
                return;
            }
            try {
                prefix = new StringBuilder();
                ret = (QueryResult)this.doQueryService("startWebApiQuery", new Object[]{entityId, select, filter, orderby, this.pagesize});
                isJsonFormat = "json".equals(ctx.getRequest().getParameter("api.resulttype"));
                prefix = this.dealPageData(prefix, ret, entityId, cacheId, isPage, pageno, isJsonFormat);
                ctx.getResponse().append(prefix.toString());
            }
            catch (KDException e) {
                OpenApiExceptionUtils.dealThrowable(e, ctx);
                if (this.queryByCached(ctx) && StringUtils.isNotEmpty((CharSequence)cacheId)) {
                    this.doQueryService("release", new Object[]{cacheId});
                }
                break block30;
            }
            catch (Exception ne) {
                errorMessage = OpenApiExceptionUtils.getErrorMsg(ne);
                ctx.getResponse().fail(errorMessage);
                this.log.error(errorMessage, (Throwable)ne);
                {
                    catch (Throwable var15_22) {
                        if (this.queryByCached(ctx) && StringUtils.isNotEmpty((CharSequence)cacheId)) {
                            this.doQueryService("release", new Object[]{cacheId});
                        }
                        throw var15_22;
                    }
                }
                if (this.queryByCached(ctx) && StringUtils.isNotEmpty((CharSequence)cacheId)) {
                    this.doQueryService("release", new Object[]{cacheId});
                } else {
                    ** GOTO lbl98
                }
            }
            if (this.queryByCached(ctx) && StringUtils.isNotEmpty((CharSequence)cacheId)) {
                this.doQueryService("release", new Object[]{cacheId});
            }
        }
    }

    private boolean queryByCached(ServiceContext ctx) {
        boolean isJsonFormat = "json".equals(ctx.getRequest().getParameter("api.resulttype"));
        boolean mcQueryByCache = "true".equals(McConfigUtil.getPropertyByTenantWithDefault((String)RequestContext.get().getTenantId(), (String)API_QUERY_BY_CACHE, (String)"false"));
        boolean isQueryByCached = "true".equals(ctx.getRequest().getParameter("query_by_cached"));
        return mcQueryByCache || isJsonFormat || isQueryByCached;
    }

    private StringBuilder dealPageData(StringBuilder prefix, QueryResult ret, String entityId, String cacheId, boolean isPage, int pageno, boolean isJsonFormat) {
        String methodName;
        int count = ret.getRows();
        cacheId = ret.getCacheId();
        prefix.append("{\"success\":\"true\",\"status\":true,\"data\":{");
        prefix.append("\"count\":");
        prefix.append(Integer.toString(count));
        prefix.append(',');
        if (!isJsonFormat) {
            String[] flds = (String[])this.doQueryService("getFieldNames", entityId, cacheId);
            prefix.append("\"header\":[");
            for (int i = 0; i < flds.length; ++i) {
                if (i > 0) {
                    prefix.append(',');
                }
                prefix.append(flds[i]);
            }
            prefix.append("],");
        }
        prefix.append("\"rows\":[");
        String string = methodName = !isJsonFormat ? "getQuerySegment" : "getQuerySegmentJson";
        if (isPage) {
            this.pagesize = this.getQueryMaxCount(this.pagesize);
            int from = (pageno - 1) * this.pagesize;
            int to = pageno * this.pagesize;
            String text = (String)this.doQueryService(methodName, entityId, cacheId, from, to);
            prefix.append(text.substring(1, text.length() - 1));
        } else {
            int allowcount = this.getQueryMaxCount(count);
            int pagecount = allowcount / this.pagesize;
            if (allowcount % this.pagesize > 0) {
                ++pagecount;
            }
            for (int i = 1; i <= pagecount; ++i) {
                int from = (i - 1) * this.pagesize;
                int to = i * this.pagesize;
                if (i == pagecount) {
                    to = allowcount;
                }
                String text = (String)this.doQueryService(methodName, entityId, cacheId, from, to);
                if (i > 1) {
                    prefix.append(',');
                }
                prefix.append(text.substring(1, text.length() - 1));
            }
        }
        prefix.append("]}}");
        return prefix;
    }

    private int getQueryMaxCount(int count) {
        String queryMaxCount = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_query_maxpagesize", "api.mqc", "10000");
        int iMaxCount = 10000;
        if (queryMaxCount != null) {
            try {
                iMaxCount = Integer.parseInt(queryMaxCount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count > iMaxCount ? iMaxCount : count;
    }

    private boolean checkFilter(ServiceContext ctx, String filter) {
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            boolean pn;
            boolean bl = pn = Pattern.compile(Pattern.quote("insert"), 2).matcher(filter).find() || Pattern.compile(Pattern.quote("update"), 2).matcher(filter).find() || Pattern.compile(Pattern.quote("delete"), 2).matcher(filter).find();
            if (pn) {
                ctx.getResponse().fail(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u5141\u8bb8\u51fa\u73b0sql\u5173\u952e\u5b57\u3002", (String)"ApiServiceType_11", (String)BOS_OPEN_ACTION, (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public void detailQuery(ServiceContext ctx, String entityId) {
        String select = this.getSelect(ctx);
        int pageno = 0;
        boolean isPage = false;
        String pageSize1 = (String)ctx.getRequest().getParameter(PAGE_SIZE);
        String pageNoStr = (String)ctx.getRequest().getParameter(PAGE_NO);
        if (pageSize1 != null && pageNoStr != null) {
            int pageSizeIsNumeric = this.parseNumeric(pageSize1);
            int pageNoIsNumeric = this.parseNumeric(pageNoStr);
            if (pageSizeIsNumeric <= 0) {
                ctx.getResponse().fail(String.format(this.getErrorInputPara(), pageSize1));
                return;
            }
            this.pagesize = pageSizeIsNumeric;
            if (pageNoIsNumeric <= 0) {
                ctx.getResponse().fail(String.format(this.getErrorInputPara(), pageNoStr));
                return;
            }
            pageno = pageNoIsNumeric;
            isPage = true;
        }
        String orderby = (String)ctx.getRequest().getParameter(ORDERBY);
        String filter = this.getFilter(ctx);
        QueryFormatApiResult apiResult = new QueryFormatApiResult();
        List queryResultList = (List)this.doQueryService("startWebApiDetailQuery", entityId, select, filter, orderby);
        String[] headers = (String[])this.doQueryService("getFieldNamesOnDetailQuery", entityId, select);
        int count = queryResultList.size();
        apiResult.setCount(count);
        apiResult.setHeader(Arrays.asList(headers));
        if (isPage) {
            int from = (pageno - 1) * this.pagesize;
            int to = pageno * this.pagesize;
            apiResult.setRows(queryResultList.subList(from, to));
        } else {
            apiResult.setRows(queryResultList);
        }
        ctx.getResponse().success((Object)apiResult);
    }

    String[] splitString(String src, String regex) {
        if (StringUtils.isEmpty((CharSequence)src)) {
            return new String[0];
        }
        return src.split(regex);
    }

    int parseInt(String v) {
        if (StringUtils.isEmpty((CharSequence)v)) {
            return 0;
        }
        return Integer.parseInt(v);
    }

    private int parseNumeric(String string) {
        int value = 0;
        Pattern pattern = Pattern.compile("[0-9]*");
        boolean matches = pattern.matcher(string).matches();
        if (matches) {
            value = Integer.parseInt(string);
        }
        return value;
    }

    private String buildOpParameter(KRequest req) {
        String number = (String)req.getParameter(REQ_PARA_NUMBER);
        String id = (String)req.getParameter(REQ_PARA_ID);
        String org = (String)req.getParameter(REQ_PARA_ORG);
        HashMap<String, String> data = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)number)) {
            data.put(REQ_PARA_NUMBER, number);
        }
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            data.put(REQ_PARA_ID, id);
        }
        if (StringUtils.isNotEmpty((CharSequence)org)) {
            data.put(REQ_PARA_ORG, org);
        }
        return SerializationUtils.toJsonString(data);
    }

    private String buildBatchOpParameter(KRequest req, String reqData) {
        if (req.getMethod() == HttpMethod.Post) {
            return reqData;
        }
        String numbers = (String)req.getParameter(REQ_PARA_NUMBERS);
        String ids = (String)req.getParameter(REQ_PARA_IDS);
        String org = (String)req.getParameter(REQ_PARA_ORG);
        String apiOrgtype = (String)req.getParameter("api.orgtype");
        String ovs = (String)req.getParameter(OPTION_VARIABLES);
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)numbers)) {
            data.put(REQ_PARA_NUMBERS, this.splitString(numbers));
        }
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            data.put(REQ_PARA_IDS, this.splitString(ids));
        }
        if (StringUtils.isNotEmpty((CharSequence)org)) {
            data.put(REQ_PARA_ORG, org);
        }
        if (StringUtils.isNotEmpty((CharSequence)apiOrgtype)) {
            data.put("api.orgtype", apiOrgtype);
        }
        if (StringUtils.isNotEmpty((CharSequence)ovs)) {
            data.put(OPTION_VARIABLES, SerializationUtils.fromJsonString((String)ovs, Map.class));
        }
        return SerializationUtils.toJsonString(data);
    }

    private String[] splitString(String str) {
        return str.split(",");
    }

    public String delete(String formId, String data) {
        return this.doOperation("delete", formId, data);
    }

    public String load(String formId, String data) {
        return this.doOperation("loadSingle", formId, data);
    }

    public String submit(String formId, String data) {
        return this.doOperation("submit", formId, data);
    }

    public String audit(String formId, String data) {
        return this.doOperation("audit", formId, data);
    }

    private String donothing(String formId, String op, String data) {
        return this.doOperation("executeOperationForWeb", formId, op, data);
    }

    public String save(String formId, String data) {
        return this.doOperationWithRepeated("save", formId, data);
    }

    public String batchSave(String formId, String data) {
        return this.doOperationWithRepeated("batchSave", formId, data);
    }

    public String draft(String formId, String data) {
        return this.doOperationWithRepeated("draft", formId, data);
    }

    private String doOperationWithRepeated(String methodName, String formId, String data) {
        String inputPara = data;
        String hashKey = DigestUtils.sha256Hex((String)inputPara);
        String lockKey = RequestContext.get().getAccountId() + "_ChkRepSave_" + formId + "." + methodName + "_" + hashKey;
        DLock lock = DLock.create((String)lockKey, (String)("OpenApi.Save.CheckRepeatReq-" + formId + "." + methodName + "_" + hashKey));
        try {
            if (lock.tryLock(5000L)) {
                String string = this.doOperation(methodName, formId, data);
                return string;
            }
            throw new OpenApiException(ApiErrorCode.Data_Repeat_Execute, ApiErrorCode.Data_Repeat_Execute.toString(), new Object[0]);
        }
        finally {
            lock.unlock();
        }
    }

    private String doOperation(String methodName, Object ... params) {
        return (String)this.invokeBOSService(this.formId, "OperationWebApi", methodName, params);
    }

    private Object doQueryService(String methodName, Object ... params) {
        return this.invokeBOSService(this.formId, "QueryService", methodName, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeBOSService(String formId, String serviceName, String methodName, Object ... paras) {
        String appId = this.getAppId();
        if (StringUtils.isEmpty((CharSequence)appId)) {
            try {
                appId = (String)DispatchServiceHelper.invokeBOSService((String)"FormService", (String)"getAppId", (Object[])new Object[]{formId});
                this.log.info(String.format("WebApi_log invokeBOSService1 invokeBOSService FormService getAppId appId:%s", appId));
            }
            catch (Exception e) {
                this.log.warn((Throwable)e);
            }
            finally {
                if (StringUtils.isEmpty((CharSequence)appId)) {
                    this.log.info("WebApi_log invokeBOSService2 invokeBOSService finally appId:bos");
                    appId = "bos";
                }
            }
        }
        appId = appId.concat(".api.").concat(formId).concat(".").concat(methodName);
        this.log.info(String.format("WebApi_log invokeBOSService3 invokeBOSService full appId:%s", appId));
        Object invokeResult = DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)serviceName, (String)methodName, (Object[])paras);
        ApiServiceLogHelper.writeApiLogInfoApiResult(invokeResult);
        return invokeResult;
    }
}

