/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.kcf.ServiceContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.orm.query.NoSuchPropertyException;
import kd.bos.servicehelper.TimeServiceHelper;

public class OpenApiExceptionUtils {
    private static Log log = LogFactory.getLog(OpenApiExceptionUtils.class);
    private static final String CRLF = "\r\n\t";
    private static final int CauseDepth = 50;

    protected static void dealThrowable(KDException e, ServiceContext ctx) {
        Throwable detail;
        int errorcount = 0;
        for (detail = e; detail != null && errorcount++ < 50; detail = detail.getCause()) {
            if (detail.getCause() instanceof NoSuchPropertyException || detail.getMessage() != null && detail.getMessage().contains("NoSuchPropertyException")) {
                ctx.getResponse().fail(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u67e5\u8be2\u5b57\u6bb5\u662f\u5426\u5b58\u5728\u3002", (String)"OpenApiExceptionUtils_0", (String)"bos-open-action", (Object[])new Object[0]));
                return;
            }
            if (detail.getMessage() != null && detail.getMessage().contains("kv cache not exists for id")) {
                ctx.getResponse().fail(ResManager.loadKDString((String)"\u67e5\u8be2\u8d85\u51fa\u6700\u5927\u9875\u6570\u8303\u56f4\u3002", (String)"OpenApiExceptionUtils_1", (String)"bos-open-action", (Object[])new Object[0]));
                return;
            }
            if (detail.getCause() == null) break;
        }
        String errorMessage = (e.getMessage() == null ? "throwable.getMessage() is null" : e.getMessage()).concat("\r\nCaused by: ").concat(OpenApiExceptionUtils.getErrorMsg(detail));
        if ("DubboServiceLookup".equals(e.getErrorCode() != null ? e.getErrorCode().getCode() : null)) {
            ctx.getResponse().setStatusCode(400);
        }
        ctx.getResponse().fail(errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getErrorMsg(Throwable throwable) {
        if (OpenApiExceptionUtils.isShowStackTrace()) {
            String result;
            if (throwable == null) {
                return OpenApiExceptionUtils.getRequestExtInfo().concat("throwable is null");
            }
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                throwable.printStackTrace(pw);
                result = sw.toString().replace(CRLF, "   \n");
            }
            int pos = result.indexOf("(RequestContextFilter.java");
            String strMoreTemp = "... %s more\r\n";
            String splitTag = "at ";
            if (pos > 0) {
                int atindexOf = result.indexOf(splitTag, pos);
                result = result.substring(0, atindexOf).concat(String.format(strMoreTemp, result.substring(atindexOf).split(splitTag).length));
            }
            return OpenApiExceptionUtils.getRequestExtInfo().concat(result);
        }
        return String.format("TraceId: %s, For detail info, Please contact administrator to view system log.", RequestContext.get().getTraceId());
    }

    private static boolean isShowStackTrace() {
        return "true".equals(OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_openlog_showstack", "exception_showstacktrace", "false"));
    }

    static String getRequestExtInfo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return MessageFormat.format("Time:{0},TraceId:{1},WebInstanceId:{2},AccountId:{3},", sdf.format(TimeServiceHelper.now()), RequestContext.get().getTraceId(), Instance.getInstanceId(), RequestContext.get().getAccountId());
    }

    static String getRequestExtInfo(String msg) {
        return OpenApiExceptionUtils.getRequestExtInfo().concat(msg);
    }
}

