/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.api;

import kd.bos.context.RequestContext;
import kd.bos.openapi.base.util.DistributeCacheUtil;

public class RedisCacheUtils {
    private static String CacheType = "OpenApi1";

    public static void remove(String apiId, String operateType) {
        String cacheKey = RedisCacheUtils.getCacheKey(apiId, operateType);
        DistributeCacheUtil.removeCacheByKey((String)CacheType, (String)cacheKey);
    }

    static String get(String apiId, String operateType) {
        String cacheKey = RedisCacheUtils.getCacheKey(apiId, operateType);
        return DistributeCacheUtil.getCacheByKey((String)CacheType, (String)cacheKey);
    }

    static void put(String apiId, String operateType, String value) {
        String cacheKey = RedisCacheUtils.getCacheKey(apiId, operateType);
        DistributeCacheUtil.setCacheByKey((String)CacheType, (String)cacheKey, (String)value);
    }

    private static String getCacheKey(String apiId, String operateType) {
        String cacheKeyPrefix = RequestContext.get().getAccountId() + "-kapi-";
        return cacheKeyPrefix + apiId + "-" + operateType;
    }
}

