/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.open;

import java.util.EventObject;
import java.util.List;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class APIBatchAuthorizePlugin
extends AbstractFormPlugin {
    private static final String API_NUMBER = "api_number";
    private static final String API_USERS = "api_users";
    private static final String OPEN_APIAUTHORIZE = "open_apiauthorize";
    private static final String KEY_ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        List apiNumbers = (List)showParameter.getCustomParam("apiNumbers");
        if (apiNumbers != null && apiNumbers.size() > 0) {
            this.getModel().setValue(API_NUMBER, (Object)ResManager.loadKDString((String)"\u4ee5\u4e0b\u6240\u6709API", (String)"APIBatchAuthorizePlugin_0", (String)"bos-form-business", (Object[])new Object[0]), 0);
            for (int i = 1; i <= apiNumbers.size(); ++i) {
                String apiNumber = (String)apiNumbers.get(i - 1);
                QFilter[] filters = new QFilter[]{new QFilter(API_NUMBER, "=", (Object)apiNumber)};
                DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)OPEN_APIAUTHORIZE, (QFilter[])filters);
                this.getModel().createNewEntryRow(KEY_ENTRYENTITY);
                this.getModel().setValue(API_NUMBER, (Object)apiNumber, i);
                if (object == null) continue;
                DynamicObjectCollection users = object.getDynamicObjectCollection(API_USERS);
                DynamicObjectCollection value = new DynamicObjectCollection();
                if (users != null) {
                    for (DynamicObject user : users) {
                        if (user.get("fbasedataid") == null || user.getLong("fbasedataid_id") == 0L) continue;
                        value.add((Object)user);
                    }
                }
                if (value == null || value.size() <= 0) continue;
                this.getModel().setValue(API_USERS, (Object)users, i);
            }
        }
    }

    public void click(EventObject evt) {
        DynamicObjectCollection values;
        Control button = (Control)evt.getSource();
        if ("btn_ok".equals(button.getKey()) && (values = this.getModel().getEntryEntity(KEY_ENTRYENTITY)) != null && values.size() > 0) {
            Object[] objects = new DynamicObject[values.size()];
            Object[] pks = new Object[values.size()];
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)OPEN_APIAUTHORIZE);
            for (int i = 0; i < values.size(); ++i) {
                DynamicObject value = (DynamicObject)values.get(i);
                String apiNumber = value.getString(API_NUMBER);
                QFilter[] filters = new QFilter[]{new QFilter(API_NUMBER, "=", (Object)apiNumber)};
                DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)OPEN_APIAUTHORIZE, (QFilter[])filters);
                if (object != null) {
                    pks[i] = object.getPkValue();
                }
                object = new DynamicObject((DynamicObjectType)type);
                object.set(API_NUMBER, value.get(API_NUMBER));
                object.set(API_USERS, value.get(API_USERS));
                objects[i] = object;
            }
            BusinessDataWriter.delete((IDataEntityType)type, (Object[])pks);
            BusinessDataWriter.save((IDataEntityType)type, (Object[])objects);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (API_USERS.equals(e.getProperty().getName()) && e.getChangeSet()[0].getRowIndex() == 0) {
            DynamicObjectCollection users = (DynamicObjectCollection)this.getModel().getValue(API_USERS);
            int rowsizes = this.getModel().getEntryEntity(KEY_ENTRYENTITY).size();
            for (int i = 1; i < rowsizes; ++i) {
                this.getModel().setValue(API_USERS, (Object)users, i);
            }
        }
    }
}

