/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.open;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.Modify;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.utils.FormShowParameterUtils;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.common.constant.ApiOperationType;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.form.util.ApiPluginUtil;
import kd.bos.openapi.form.util.pdf.ExportAndDownloadUtil;
import kd.bos.openapi.form.util.pdf.ExportPdfForMetaSchemaAPI;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class APIServiceListPlugin
extends StandardTreeListPlugin
implements IConfirmCallBack {
    private static final Log log = LogFactory.getLog(APIServiceListPlugin.class);
    private static final String BILL_LIST_STAP = "billlistap";
    private static final String KEY_AUTHORIZE = "baritemap_authorize";
    private static final String KEY_USERAUTHORIZE = "bar_userauthorize";
    private static final String KEY_EXPORTPDF = "exportpdf";
    private static final String KEY_CREATEJSON = "tbl_createjson";
    private static final String KEY_REGISTER = "tbl_register";
    private static final String NODE_CLOUD = "cloud_";
    private static final String NODE_APP = "app_";
    private static final String FORM_APIGUIDE = "open_apiserivce_guide_new";
    private static final String OPERATE_NEW = "new";
    private static final String OPERATE_MODIFY = "modify";
    private static final String APPID = "appId";
    private static final String APPNAME = "appName";
    private static final String FORM_APISERVICE = "open_apiservice";
    private static final String FORM_APPAUTHORIZE = "open_appauthorize_list";
    private static final String TYPE_CLOUD = "cloud";
    private static final String TYPE_APP = "app";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String FORM_APISERVICE_NEW = "openapi_apilist";
    private static final String TBL_NEW = "tblnew";

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String apiNewControl = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api1_newcontrol", Boolean.FALSE.toString());
        if ("false".equalsIgnoreCase(apiNewControl)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TBL_NEW});
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.getView().getFormShowParameter().getParentFormId() == null) {
            return;
        }
        if (!"true".equals(ApiPluginUtil.getVisibleSysApi(this.getView()))) {
            e.getQFilters().add(new QFilter("is_sys_api", "=", (Object)"0"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operateKey = operate.getOperateKey();
        if (OPERATE_NEW.equals(operateKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(FORM_APIGUIDE);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            String nodeId = (String)this.getTreeListView().getTreeModel().getCurrentNodeId();
            if (nodeId.contains(NODE_APP)) {
                String appId = StringUtils.substringAfter((String)nodeId, (String)NODE_APP);
                formShowParameter.setCustomParam(APPID, (Object)appId);
            }
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "apiServiceClose");
            formShowParameter.setCloseCallBack(callBack);
            this.getView().showForm(formShowParameter);
            evt.setCancel(true);
        } else if (OPERATE_MODIFY.equals(operateKey)) {
            ListSelectedRow row = ((ListView)this.getView()).getCurrentSelectedRowInfo();
            DynamicObject apiInfo = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)FORM_APISERVICE, (String)"apiservicetype");
            if ("1".equals(apiInfo.getString("apiservicetype"))) {
                ((Modify)operate).setViewBillFormId(FORM_APISERVICE);
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
            }
        } else if (ApiOperationType.DELETE.getOp().equalsIgnoreCase(operateKey)) {
            DynamicObject[] dys;
            ListSelectedRowCollection listSelectedRows = evt.getListSelectedData();
            Object[] idList = listSelectedRows.getPrimaryKeyValues();
            for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)FORM_APISERVICE_NEW, (String)"id,urlformat,enable", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idList)})) {
                if (!"0".equals(dy.getString("enable"))) continue;
                DeleteServiceHelper.delete((String)"openapi_statdata", (QFilter[])new QFilter[]{new QFilter("apiid", "=", (Object)dy.getLong("id"))});
            }
        } else if (operateKey.equals("upgrade")) {
            ListSelectedRowCollection listSelectedRows = evt.getListSelectedData();
            Object[] idList = listSelectedRows.getPrimaryKeyValues();
            if (idList.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u9009\u4e2d\u4e00\u6761API\u3002", (String)"APIServiceListPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                DynamicObject api = BusinessDataServiceHelper.loadSingle((Object)idList[0].toString(), (String)FORM_APISERVICE_NEW);
                if (api.getString("apiservicetype").equalsIgnoreCase("1")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301AI\u670d\u52a1\u5347\u7ea7API\u3002", (String)"APIServiceListPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.setCustomParam("isUpgrade", (Object)Boolean.TRUE.toString());
                showParameter.setCustomParam("name", (Object)api.getString("name"));
                showParameter.setCustomParam("appid", api.getDynamicObject("appid") == null ? null : api.getDynamicObject("appid").getPkValue());
                showParameter.setCustomParam("httpmethod", api.get("httpmethod"));
                showParameter.setCustomParam("apiservicetype", api.get("apiservicetype"));
                showParameter.setCustomParam("discription", api.get("discription"));
                if ("0".equalsIgnoreCase(api.getString("httpmethod")) && !"query".equalsIgnoreCase("operation")) {
                    showParameter.setCustomParam("httpmethod", (Object)"1");
                }
                if (api.getString("apiservicetype").equalsIgnoreCase("0")) {
                    showParameter.setFormId(FORM_APISERVICE_NEW);
                    String operation = api.get("operation").toString();
                    if (operation.contains("batch") || operation.equalsIgnoreCase("row") || operation.equalsIgnoreCase("load") || operation.contains("andnew")) {
                        showParameter.setCustomParam("operation", (Object)"query");
                    } else {
                        showParameter.setCustomParam("operation", api.get("operation"));
                    }
                    showParameter.setCustomParam("bizobject", api.getDynamicObject("bizobject") == null ? null : api.getDynamicObject("bizobject").getPkValue());
                } else {
                    showParameter.setFormId("openapi_customapi");
                }
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (operateKey.equals("disable") || operateKey.equals("enable") || operateKey.equals("delete")) {
            LocalCacheUtil.clear(OpenApiData.class);
            LocalCacheUtil.clear((String)"apiserviceId");
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        BaseShowParameter showParameter = FormShowParameterUtils.getFormShowParameter((ClosedCallBackEvent)closedCallBackEvent);
        if (Objects.isNull(showParameter)) {
            return;
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_AUTHORIZE});
        this.addItemClickListeners(new String[]{KEY_USERAUTHORIZE});
        this.addItemClickListeners(new String[]{KEY_EXPORTPDF});
    }

    public void listRowClick(ListRowClickEvent evt) {
        DynamicObject bizApp;
        super.listRowClick(evt);
        if (evt.getCurrentListSelectedRow() == null) {
            return;
        }
        Long pkId = (Long)evt.getCurrentListSelectedRow().getPrimaryKeyValue();
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)FORM_APISERVICE);
        if (object != null && (bizApp = object.getDynamicObject(APPID)) != null) {
            String appNodeId = NODE_APP + bizApp.getPkValue();
            TreeNode appNode = this.getTreeModel().getRoot().getTreeNode(appNodeId, 2);
            if (null == appNode) {
                return;
            }
            String cloudNodeId = appNode.getParentid();
            List<TreeNode> cloudNodes = this.getCloudNodes();
            String selectCloudId = this.getPageCache().get("selectCloudId");
            if (StringUtils.isNotEmpty((CharSequence)selectCloudId)) {
                this.getTreeListView().getTreeView().collapse(selectCloudId);
            }
            for (TreeNode treeNode : cloudNodes) {
                if (!treeNode.getId().equals(cloudNodeId)) continue;
                this.getTreeListView().getTreeView().showNode(treeNode.getId());
                this.getPageCache().put("selectCloudId", treeNode.getId());
            }
            this.getTreeListView().getTreeView().focusNode(appNode);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String nodeId = this.getTreeModel().getCurrentNodeId().toString();
        if (KEY_AUTHORIZE.equals(evt.getItemKey()) && (nodeId.contains(NODE_CLOUD) || nodeId.contains(NODE_APP))) {
            TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 2);
            String appName = node.getText();
            ArrayList<String> appIds = new ArrayList<String>();
            BaseShowParameter formShowParameter = new BaseShowParameter();
            formShowParameter.setFormId(FORM_APPAUTHORIZE);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam(APPNAME, (Object)appName);
            String type = "";
            if (nodeId.contains(NODE_CLOUD)) {
                type = TYPE_CLOUD;
                List apps = node.getChildren();
                for (TreeNode app : apps) {
                    String appId = StringUtils.substringAfter((String)app.getId(), (String)"_");
                    appIds.add(appId);
                }
            } else if (nodeId.contains(NODE_APP)) {
                type = TYPE_APP;
                String appId = StringUtils.substringAfter((String)nodeId, (String)"_");
                appIds.add(appId);
                Long pkId = this.getPkIdByNumber(appId);
                if (pkId != null) {
                    formShowParameter.setPkId((Object)pkId);
                }
            }
            formShowParameter.setCustomParam("appIds", appIds);
            formShowParameter.setCustomParam("type", (Object)type);
            this.getView().showForm((FormShowParameter)formShowParameter);
        } else if (KEY_USERAUTHORIZE.equals(evt.getItemKey())) {
            ListSelectedRowCollection selectRows = this.getSelectRows();
            if (selectRows != null && selectRows.size() > 0) {
                Object[] pkIds = new Long[selectRows.size()];
                for (int i = 0; i < pkIds.length; ++i) {
                    pkIds[i] = (Long)selectRows.get(i).getPrimaryKeyValue();
                }
                Map values = BusinessDataServiceHelper.loadFromCache((Object[])pkIds, (String)FORM_APISERVICE);
                Collection apis = values.values();
                ArrayList<String> apiNumbers = new ArrayList<String>(10);
                for (DynamicObject api : apis) {
                    apiNumbers.add(api.getString("number"));
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setCustomParam("apiNumbers", apiNumbers);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setFormId("open_apiauthorize_batch");
                this.getView().showForm(showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"APIServiceListPlugin_0", (String)"bos-form-business", (Object[])new Object[0]));
            }
        } else if (KEY_EXPORTPDF.equals(evt.getItemKey())) {
            ListSelectedRowCollection selectRows = this.getSelectRows();
            if (selectRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"APIServiceListPlugin_1", (String)"bos-form-business", (Object[])new Object[0]));
                return;
            }
            String filePath = null;
            try {
                for (int i = 0; i < selectRows.size(); ++i) {
                    String name = selectRows.get(i).getName();
                    filePath = ExportPdfForMetaSchemaAPI.generatePdf((Long)selectRows.get(i).getPrimaryKeyValue());
                    ExportAndDownloadUtil.download(this.getView(), filePath, name + ".pdf", true);
                }
            }
            catch (Exception e) {
                log.info("\u5bfc\u51fapdf\u5f02\u5e38 \uff0c\u5f02\u5e38\u4fe1\u606f{}", (Object)e);
            }
        }
    }

    private Long getPkIdByNumber(String appId) {
        String sql = String.format("SELECT FID FROM T_OPEN_APPAUTHORIZE WHERE FBIZAPP = '%s' ", appId);
        Long pkId = (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getLong("fid");
                }
                return null;
            }
        });
        return pkId;
    }

    public void initializeTree(EventObject e) {
        this.initTree();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_AUTHORIZE});
    }

    private void initTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"APIServiceListPlugin_1", (String)"bos-form-business", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getCloudNodes();
        List<TreeNode> appNodes = this.getAppNodes();
        for (int i = 0; i < cloudNodes.size(); ++i) {
            this.addChildNode(cloudNodes.get(i), appNodes);
        }
        Iterator<TreeNode> it = cloudNodes.iterator();
        while (it.hasNext()) {
            TreeNode cloudNode = it.next();
            if (cloudNode.getChildren() != null && !cloudNode.getChildren().isEmpty()) continue;
            it.remove();
        }
        root.addChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        String nodeId = e.getNodeId().toString();
        List<TreeNode> childNodes = this.getChildNodes(nodeId);
        e.setChildNodes(childNodes);
    }

    private List<TreeNode> getChildNodes(String parentId) {
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode parent = root.getTreeNode(parentId, 20);
        if (parent == null || parent.getChildren() == null || parent.getChildren().isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        return parent.getChildren();
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        QFilter filter = null;
        if (nodeId.equals(this.getTreeModel().getRoot().getId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_AUTHORIZE});
        } else if (nodeId.contains(NODE_CLOUD)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_AUTHORIZE});
            filter = new QFilter(APPID, "in", this.getAppIdInCloud(nodeId));
        } else if (nodeId.contains(NODE_APP)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_AUTHORIZE});
            String appid = StringUtils.substringAfter((String)nodeId, (String)"_");
            filter = new QFilter(APPID, "=", (Object)appid);
        }
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private List<String> getAppIdInCloud(String cloudId) {
        ArrayList<String> appids = new ArrayList<String>();
        List<TreeNode> appNodes = this.getAppNodes();
        for (int i = 0; i < appNodes.size(); ++i) {
            TreeNode node = appNodes.get(i);
            String parentId = node.getParentid();
            if (!cloudId.equals(parentId)) continue;
            String nodeId = node.getId();
            String appid = StringUtils.substringAfter((String)nodeId, (String)"_");
            appids.add(appid);
        }
        return appids;
    }

    private List<TreeNode> getCloudNodes() {
        DynamicObject[] clouds;
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>(10);
        for (DynamicObject cloud : clouds = BusinessDataServiceHelper.load((String)"bos_devportal_bizcloud", (String)"id,name", null, (String)"sequence asc")) {
            TreeNode node = new TreeNode();
            String nodeID = NODE_CLOUD + cloud.getString("id");
            node.setText(cloud.getString("name"));
            node.setParentid("0");
            node.setId(nodeID);
            node.setData((Object)TYPE_CLOUD);
            cloudNode.add(node);
        }
        return cloudNode;
    }

    private List<TreeNode> getAppNodes() {
        DynamicObject[] apps;
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>(10);
        for (DynamicObject app : apps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,name,bizcloud", null)) {
            TreeNode node = new TreeNode();
            String nodeID = NODE_APP + app.getString("id");
            node.setText(app.getString("name"));
            node.setParentid(NODE_CLOUD + app.getString("bizcloud.id"));
            node.setId(nodeID);
            node.setData((Object)TYPE_APP);
            appNodes.add(node);
        }
        return appNodes;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        if (childNodes == null) {
            return null;
        }
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(cnode);
        }
        return pnode;
    }

    private ListSelectedRowCollection getSelectRows() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_STAP);
        return billList.getSelectedRows();
    }
}

