/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.open;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.plugin.open.enums.ParamTypeEnum;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class ApiChooseFieldPlugin
extends AbstractTreeListPlugin {
    private static final String APITYPE = "apiType";
    private static final String MODELTYPE = "modeltype";
    private static final String FIELDID = "fieldid";
    private static final String FIELDNAME = "fieldname";
    private static final Log log = LogFactory.getLog(ApiChooseFieldPlugin.class);
    private static final String FORM_ID_API_CHOOSE_FIELD_PAGE = "api_choosefieldpage";

    public void initialize() {
        super.initialize();
        BillList bList = (BillList)this.getControl("billlistap");
        bList.setBillFormId(FORM_ID_API_CHOOSE_FIELD_PAGE);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"f7selectedlistap"});
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object apiType = parameter.getCustomParam(APITYPE);
        if (!"2".equals(apiType)) {
            return;
        }
        String appId = (String)parameter.getCustomParam("appId");
        TreeNode root = this.treeListView.getTreeModel().getRoot();
        DynamicObjectCollection allForms = BizAppServiceHelp.getAllFormsByAppID((String)appId);
        for (DynamicObject form : allForms) {
            String formNumber;
            if (!"BillFormModel".equals(form.get(MODELTYPE)) && !"BaseFormModel".equals(form.get(MODELTYPE)) || StringUtils.isEmpty((Object)(formNumber = form.getString("number"))) || !form.getString("id").equals(form.getString("basedatafield"))) continue;
            TreeNode node = new TreeNode(root.getId(), formNumber, form.getString("name"));
            root.addChild(node);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object source = e.getSource();
        Object apiType = this.getView().getFormShowParameter().getCustomParam(APITYPE);
        if ("2".equals(apiType) && source instanceof ListView) {
            TreeNode root = this.treeListView.getTreeModel().getRoot();
            List children = root.getChildren();
            if (CollectionUtils.isEmpty((Collection)children)) {
                return;
            }
            TreeNode node = (TreeNode)children.get(0);
            TreeView treeView = this.treeListView.getTreeView();
            treeView.showNode(node.getParentid());
            treeView.focusNode(node);
            treeView.treeNodeClick(node.getParentid(), node.getId());
            this.setTreeListView(this.treeListView);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Object position = this.getView().getFormShowParameter().getCustomParam("billPosition");
        if (!Objects.isNull(position)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows();
            param.put("selectRow", selectedRows);
            param.put("position", position);
            this.getView().returnDataToParent(param);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        if (!e.getNodeId().equals(this.getTreeModel().getRoot().getId())) {
            List fieldIdList = this.getControlFilters().getFastFilter(FIELDID);
            List fieldnameList = this.getControlFilters().getFastFilter(FIELDNAME);
            if (fieldIdList != null) {
                fieldIdList.clear();
            }
            if (fieldnameList != null) {
                fieldnameList.clear();
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ChooseFieldProviderImpl());
    }

    class ChooseFieldProviderImpl
    extends ListDataProvider {
        ChooseFieldProviderImpl() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String entityId;
            FormShowParameter parameter = ApiChooseFieldPlugin.this.getView().getFormShowParameter();
            Object apiType = parameter.getCustomParam(ApiChooseFieldPlugin.APITYPE);
            if ("0".equals(apiType)) {
                String entityId2 = (String)parameter.getCustomParam("entityId");
                return this.getData(start, limit, entityId2);
            }
            if ("2".equals(apiType) && !StringUtils.isEmpty((Object)(entityId = ApiChooseFieldPlugin.this.getTreeListView().getTreeView().getTreeState().getFocusNodeId()))) {
                return this.getData(start, limit, entityId);
            }
            return new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ApiChooseFieldPlugin.FORM_ID_API_CHOOSE_FIELD_PAGE), null);
        }

        private DynamicObjectCollection getData(int start, int limit, String sourceEntityId) {
            DynamicObjectCollection col = new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ApiChooseFieldPlugin.FORM_ID_API_CHOOSE_FIELD_PAGE), null);
            try {
                ArrayList<String> entityIdList = new ArrayList<String>(10);
                ArrayList<IDataEntityProperty> list = new ArrayList<IDataEntityProperty>();
                FormShowParameter parameter = ApiChooseFieldPlugin.this.getView().getFormShowParameter();
                Object apiType = parameter.getCustomParam(ApiChooseFieldPlugin.APITYPE);
                if ("2".equals(apiType) && sourceEntityId.equals(ApiChooseFieldPlugin.this.getTreeModel().getRoot().getId())) {
                    String appId = (String)parameter.getCustomParam("appId");
                    DynamicObjectCollection allForms = BizAppServiceHelp.getAllFormsByAppID((String)appId);
                    for (DynamicObject form : allForms) {
                        String formNumber;
                        if (!"BillFormModel".equals(form.get(ApiChooseFieldPlugin.MODELTYPE)) && !"BaseFormModel".equals(form.get(ApiChooseFieldPlugin.MODELTYPE)) || StringUtils.isEmpty((Object)(formNumber = form.getString("number"))) || !form.getString("id").equals(form.getString("basedatafield"))) continue;
                        entityIdList.add(formNumber);
                    }
                } else {
                    entityIdList.add(sourceEntityId);
                }
                ProductSettingService pService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
                for (String entityId : entityIdList) {
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
                    List blackField = pService.getFormDisVisitField(entityId);
                    Map allEntities = entityType.getAllEntities();
                    for (Map.Entry allEntitiesEntry : allEntities.entrySet()) {
                        if (!(allEntitiesEntry.getValue() instanceof EntityType)) continue;
                        for (IDataEntityProperty fieldProp : ((EntityType)allEntitiesEntry.getValue()).getProperties()) {
                            if (blackField.contains(fieldProp.getName())) continue;
                            list.add(fieldProp);
                        }
                    }
                }
                String fieldid = null;
                String fieldname = null;
                String searchType = null;
                List qFilters = this.getQFilters();
                if (qFilters.size() > 0) {
                    String value = ((QFilter)qFilters.get(0)).getValue().toString();
                    String[] values = value.split("#");
                    if (values[0].contains(ApiChooseFieldPlugin.FIELDID)) {
                        fieldid = values[1];
                        searchType = ApiChooseFieldPlugin.FIELDID;
                    }
                    if (values[0].contains(ApiChooseFieldPlugin.FIELDNAME)) {
                        fieldname = values[1];
                        searchType = ApiChooseFieldPlugin.FIELDNAME;
                    }
                    searchType = values[0].contains(",") ? "both" : values[0];
                }
                HashSet<String> idSet = new HashSet<String>(16);
                for (int i = 0; i < list.size(); ++i) {
                    DynamicObject chooseField = BusinessDataServiceHelper.newDynamicObject((String)ApiChooseFieldPlugin.FORM_ID_API_CHOOSE_FIELD_PAGE);
                    IDataEntityProperty property = (IDataEntityProperty)list.get(i);
                    String number = property.getName();
                    if (number.endsWith("_id")) continue;
                    LocaleString displayName = property.getDisplayName();
                    if (StringUtils.isEmpty((Object)displayName)) {
                        displayName = i == 0 ? new LocaleString(number) : new LocaleString(property.getParent().getDisplayName().getLocaleValue().concat(".").concat(number));
                    }
                    if (property.getParent() instanceof EntryType) {
                        number = property.getParent().getName().concat(".").concat(number);
                        if (!StringUtils.isEmpty((Object)property.getDisplayName())) {
                            displayName = new LocaleString(property.getParent().getDisplayName().getLocaleValue().concat(".").concat(property.getDisplayName().getLocaleValue()));
                        }
                    }
                    String type = ParamTypeEnum.getParamTypeByPropertyType(property.getPropertyType()).getType();
                    String id = number + "/" + displayName + "/" + type;
                    if (idSet.contains(id)) continue;
                    chooseField.set("id", (Object)id);
                    chooseField.set(ApiChooseFieldPlugin.FIELDID, (Object)number);
                    chooseField.set(ApiChooseFieldPlugin.FIELDNAME, (Object)displayName);
                    chooseField.set("fieldtype", (Object)type);
                    idSet.add(id);
                    if (searchType == null) {
                        col.add((Object)chooseField);
                        continue;
                    }
                    if ("both".equals(searchType)) {
                        if (!number.contains(fieldid) && !displayName.getLocaleValue().contains(fieldname)) continue;
                        col.add((Object)chooseField);
                        continue;
                    }
                    if (ApiChooseFieldPlugin.FIELDID.equals(searchType) && number.contains(fieldid)) {
                        col.add((Object)chooseField);
                        continue;
                    }
                    if (!ApiChooseFieldPlugin.FIELDNAME.equals(searchType) || !displayName.getLocaleValue().contains(fieldname)) continue;
                    col.add((Object)chooseField);
                }
                this.getQueryResult().setDataCount(col.size());
                List subList = col.subList(start, Math.min(start + limit, col.size()));
                col = new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ApiChooseFieldPlugin.FORM_ID_API_CHOOSE_FIELD_PAGE), null);
                col.addAll((Collection)subList);
                this.getQueryResult().setCollection(col);
            }
            catch (Exception e) {
                log.error("\u5143\u6570\u636e\u3010" + sourceEntityId + "\u3011\u89e3\u6790\u5f02\u5e38\uff01", (Throwable)e);
            }
            return col;
        }
    }
}

