/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.open.utils;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.utils.StringUtils;

public class OpenApiLocalCache {
    private static final int CACHE_TIME_OUT = 1200;
    private static final int CACHE_MAX_ITEM_SIZE = 100000;
    private static final int CACHE_MAX_MEM_SIZE = 100;
    private static final String REGION = "OpenAPI";
    private static final String OpenApiService = "OpenApiService";

    private static LocalMemoryCache getLocalMemoryCache() {
        CacheConfigInfo localConfig = new CacheConfigInfo();
        localConfig.setMaxItemSize(100000);
        localConfig.setTimeout(100);
        localConfig.setTimeToLive(true);
        LocalMemoryCache localcache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(REGION, OpenApiService, localConfig);
        return localcache;
    }

    public static boolean checkIsInCache(String key) {
        Object object = OpenApiLocalCache.getLocalMemoryCache().get(key);
        return object != null;
    }

    public static Object getCacheByKey(String key) {
        return OpenApiLocalCache.getLocalMemoryCache().get(key);
    }

    public static boolean setCacheByKey(String key, Object object) {
        boolean setSuccess = false;
        if (StringUtils.isNotEmpty((CharSequence)key) && null != object) {
            OpenApiLocalCache.getLocalMemoryCache().remove(new String[]{key});
            OpenApiLocalCache.getLocalMemoryCache().put(key, object);
            setSuccess = true;
        }
        return setSuccess;
    }

    public static boolean removeCacheByKey(String key) {
        boolean setSuccess = false;
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            OpenApiLocalCache.getLocalMemoryCache().remove(new String[]{key});
            setSuccess = true;
        }
        return setSuccess;
    }
}

