/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.IPWhiteListUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.util.CertUtil;
import kd.bos.openapi.form.util.ExportUtil;
import kd.bos.openapi.form.util.pdf.ExportAndDownloadUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.util.AESUtils;

@Deprecated
public class OpenApi3rdappsPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(OpenApi3rdappsPlugin.class);
    private static final String KEY_SYSAUTH = "syspwd";
    private static final String KEY_PUBLICKEY = "publickey";
    private static final String KEY_HISSYSPD = "hisSyspwd";
    private static final String KEY_STARTIP = "startip";
    private static final String KEY_ENDIP = "endip";
    private static final String KEY_SHOWSECRETKEY = "showsecretkey";
    private static final String SECURITYPUBLICKEY = "securitypublickey";
    private static final String SECURITYPRIVATEKEY = "securityprivatekey";
    private static final String BASESIGNCODEKEY = "basesigncode";
    private static final String DISPLAYBASESIGNCODE = "displaybasesigncode";
    private static final String JWTASYMMETIC = "jwtasymmetic";
    private static final String JWTSIGNTYPE = "jwtsigntype";
    private static final String SIGNATURE_KEY = "signature_key";
    private static final String BTN_SAVE = "save";
    private static final String PWGFORMAT = "******";
    private static final String FIELD_LIMIT_COUNT = "cu_limit_tac";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_ENTRYENTITY_APISERVICE = "apiservice";
    private static final String LAST_ENABLE_TIME = "lastenabletime";
    private static final String LAST_STOP_TIME = "laststoptime";
    public static final String AGENTUSERID = "agentuserid";
    public static final String AGENTUSER_ENTIRY = "entryentity_basicauth";
    public static final String REFRESH_BASICSIGN = "refresh_basicsign";
    public static final String KEY_ISBASICAUTH = "isbasicauth";
    public static final String KEY_ALLOWALLAPI = "allowallapi";
    public static final String ADD_AGENTUSER = "newagentuser";
    public static final String KEY_AGENTUSERID = "agentuserid";
    public static final String KEY_ENABLE = "enable";
    private static final String BTN_DISENABLE = "disable";
    private static final String BTN_ENABLE = "enable";
    private static final String IS_SIGNATURE = "is_signature";
    public static final String DOWNLOADCERT = "downloadcert";
    private static final String IS_DIGEST = "is_digest";
    private static final String SIGNATURETYPE = "signature_type";

    public void registerListener(EventObject e) {
        BasedataEdit edit;
        super.registerListener(e);
        TextEdit fpublickey = (TextEdit)this.getView().getControl(KEY_PUBLICKEY);
        TextEdit securitypublickey = (TextEdit)this.getView().getControl(SECURITYPUBLICKEY);
        TextEdit basecodekey = (TextEdit)this.getView().getControl(DISPLAYBASESIGNCODE);
        TextEdit signaturekey = (TextEdit)this.getView().getControl(SIGNATURE_KEY);
        fpublickey.addClickListener((ClickListener)this);
        securitypublickey.addClickListener((ClickListener)this);
        if (basecodekey != null) {
            basecodekey.addClickListener((ClickListener)this);
        }
        if (signaturekey != null) {
            signaturekey.addClickListener((ClickListener)this);
        }
        if ((edit = (BasedataEdit)this.getControl("agentuserid")) != null) {
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit control = (BasedataEdit)this.getControl(KEY_ENTRYENTITY_APISERVICE);
        control.addBeforeF7SelectListener(o -> {
            ListShowParameter parameter = (ListShowParameter)o.getFormShowParameter();
            DynamicObjectCollection entryentity = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
            ArrayList<Object> pks = new ArrayList<Object>(16);
            for (DynamicObject object : entryentity) {
                Object apiservice = object.get(KEY_ENTRYENTITY_APISERVICE);
                if (apiservice == null) continue;
                pks.add(((DynamicObject)apiservice).getPkValue());
            }
            parameter.getListFilterParameter().setFilter(new QFilter("id", "not in", (Object)pks.toArray()).and(new QFilter("enable", "!=", (Object)"0")));
        });
        BasedataEdit agControl = (BasedataEdit)this.getControl("agentuserid");
        agControl.addBeforeF7SelectListener(o -> {
            ListShowParameter parameter = (ListShowParameter)o.getFormShowParameter();
            DynamicObjectCollection entryentity = this.getView().getModel().getEntryEntity(AGENTUSER_ENTIRY);
            ArrayList<Object> pks = new ArrayList<Object>(16);
            for (DynamicObject object : entryentity) {
                Object agentuser = object.get("agentuserid");
                if (agentuser == null) continue;
                pks.add(((DynamicObject)agentuser).getPkValue());
            }
            parameter.getListFilterParameter().setFilter(new QFilter("id", "not in", (Object)pks.toArray()).and(new QFilter("enable", "!=", (Object)"0")));
        });
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        if (StringUtils.equals((CharSequence)"bar_save", (CharSequence)evt.getItemKey())) {
            this.checkSecretKey(evt);
            if (this.isSave() && this.getModel().getValue("enable").equals("1")) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u7b2c\u4e09\u65b9\u5e94\u7528\u4fe1\u606f\u53ef\u80fd\u5f71\u54cd\u5916\u90e8\u7cfb\u7edf\u8c03\u7528\u63a5\u53e3\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4fee\u6539\uff1f", (String)"OpenApi3rdappsPlugin_23", (String)"bos-open-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("update_api"));
                evt.setCancel(true);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"rebuildcert", DOWNLOADCERT});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        if (null != this.getModel().getValue(KEY_SYSAUTH)) {
            this.getPageCache().put(KEY_HISSYSPD, this.getModel().getValue(KEY_SYSAUTH).toString());
        }
        if (((Boolean)this.getModel().getValue(KEY_ISBASICAUTH)).booleanValue()) {
            this.getModel().setValue(KEY_ALLOWALLAPI, (Object)false);
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_ALLOWALLAPI});
        }
        this.setBaseSignCodeSecret();
        this.isAllowEdit();
        this.convertIntToChar();
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
    }

    private void isAllowEdit() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"bar_save", "conentpanel"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPwdFormat();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_disable"});
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setValue(KEY_SYSAUTH, (Object)"");
        this.getModel().setValue(KEY_PUBLICKEY, (Object)"");
        this.getModel().setValue(SECURITYPUBLICKEY, (Object)"");
        this.getModel().setValue(SIGNATURE_KEY, (Object)"");
        this.getModel().deleteEntryData(AGENTUSER_ENTIRY);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    private void setPwdFormat() {
        if (((BillModel)this.getModel()).getPKValue() != null) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            if (!ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().get(KEY_SYSAUTH))) {
                proxy.setFieldProperty(KEY_SYSAUTH, "v", (Object)PWGFORMAT);
            }
            if (!ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().get(KEY_PUBLICKEY))) {
                proxy.setFieldProperty(KEY_PUBLICKEY, "v", (Object)PWGFORMAT);
            }
            if (!ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().get(SECURITYPUBLICKEY))) {
                proxy.setFieldProperty(SECURITYPUBLICKEY, "v", (Object)PWGFORMAT);
            }
            if (!ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().get(AGENTUSER_ENTIRY))) {
                proxy.setFieldProperty(BASESIGNCODEKEY, "v", (Object)PWGFORMAT);
            }
            if (!ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().get(SIGNATURE_KEY))) {
                proxy.setFieldProperty(SIGNATURE_KEY, "v", (Object)PWGFORMAT);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)evt.getSource();
            if (KEY_PUBLICKEY.equalsIgnoreCase(textEdit.getKey())) {
                this.refreshDigst(KEY_PUBLICKEY);
                this.getModel().setValue(IS_DIGEST, (Object)"1");
            } else if (SECURITYPUBLICKEY.equalsIgnoreCase(textEdit.getKey())) {
                this.refreshJWT();
            } else if (DISPLAYBASESIGNCODE.equalsIgnoreCase(textEdit.getKey())) {
                if (this.getModel().getValue(BASESIGNCODEKEY) == null || !"".equals(this.getModel().getValue(BASESIGNCODEKEY).toString())) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5237\u65b0\u79d8\u94a5\u4f1a\u5bfc\u81f4\u539f\u6709\u79d8\u94a5\u5931\u6548\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OpenApi3rdappsPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(REFRESH_BASICSIGN));
                } else {
                    this.refreshBasicAuthCode();
                }
            } else if (SIGNATURE_KEY.equalsIgnoreCase(textEdit.getKey())) {
                this.refreshDigst(SIGNATURE_KEY);
                this.getModel().setValue(IS_SIGNATURE, (Object)"1");
                if (this.getModel().getValue(SIGNATURETYPE) == null || "".equals(this.getModel().getValue(SIGNATURETYPE))) {
                    this.getModel().setValue(SIGNATURETYPE, (Object)"1");
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (BTN_SAVE.equals(operate.getOperateKey())) {
            DynamicObjectCollection dynamicObjectCollection;
            String fsecuritypublickey;
            Date enableTime = (Date)this.getModel().getValue(LAST_ENABLE_TIME);
            Date stopTime = (Date)this.getModel().getValue(LAST_STOP_TIME);
            if (enableTime != null && stopTime != null && enableTime.after(stopTime)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u6700\u540e\u542f\u7528\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7cfb\u7edf\u6700\u540e\u505c\u6b62\u65f6\u95f4\u3002", (String)"OpenApi3rdappsPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String fpublickey = this.getModel().getValue(KEY_PUBLICKEY).toString();
            if (StringUtils.isNotEmpty((CharSequence)fpublickey) && !EncrypterFactory.getEncrypter().isEncrypted(fpublickey)) {
                this.getModel().setValue(KEY_PUBLICKEY, (Object)EncrypterFactory.getEncrypter().encode(fpublickey));
            }
            if (StringUtils.isNotEmpty((CharSequence)(fsecuritypublickey = this.getModel().getValue(SECURITYPUBLICKEY).toString())) && !EncrypterFactory.getEncrypter().isEncrypted(fsecuritypublickey)) {
                this.getModel().setValue(SECURITYPUBLICKEY, (Object)EncrypterFactory.getEncrypter().encode(fsecuritypublickey));
            }
            if ((dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(AGENTUSER_ENTIRY)) != null && dynamicObjectCollection.size() > 0) {
                dynamicObjectCollection.stream().forEach(it -> {
                    String fbaseCode = it.getString(BASESIGNCODEKEY);
                    it.getString("agentuserid");
                    if (StringUtils.isNotEmpty((CharSequence)fbaseCode) && !EncrypterFactory.getEncrypter().isEncrypted(fbaseCode)) {
                        it.set(BASESIGNCODEKEY, (Object)EncrypterFactory.getEncrypter().encode(fbaseCode));
                    }
                });
            }
            this.convertCharToInt();
            String syspwd = (String)this.getModel().getValue(KEY_SYSAUTH);
            Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
            if (pkValue != 0L && this.getPageCache().get(KEY_HISSYSPD) != null && syspwd.equals(this.getPageCache().get(KEY_HISSYSPD))) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)syspwd) && !syspwd.matches("^(?![A-Za-z0-9_]+$)(?![a-z0-9_\\W]+$)(?![A-Za-z_\\W]+$)(?![A-Z0-9_\\W]+$)[a-zA-Z0-9_\\W]{16,50}$")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"AccessToken\u8ba4\u8bc1\u5bc6\u94a5\u4e0d\u7b26\u5408\u5bc6\u7801\u590d\u6742\u6027\u53ca\u957f\u5ea6\u8981\u6c42\uff0816~50\u4f4d\u5b57\u7b26\uff0c\u5927\u5c0f\u5199\u53ca\u6570\u5b57\u3001\u7279\u6b8a\u7b26\u53f7\u6df7\u5408\uff09\u3002", (String)"OpenApi3rdappsPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (ADD_AGENTUSER.equals(operate.getOperateKey()) && !this.isSave()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"OpenApi3rdappsPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private void checkSecretKey(BeforeItemClickEvent args) {
        if (((Boolean)this.getModel().getValue(IS_DIGEST)).booleanValue() && StringUtil.isEmpty((String)((String)this.getModel().getValue(KEY_PUBLICKEY)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6458\u8981\u8ba4\u8bc1\u5df2\u542f\u7528\uff0c\u8bf7\u8bbe\u7f6e\u6458\u8981\u8ba4\u8bc1\u7684\u201c\u8ba4\u8bc1\u5bc6\u94a5\u201d\u3002", (String)"OpenApi3rdappsPlugin_18", (String)"bos-open-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (((Boolean)this.getModel().getValue(JWTASYMMETIC)).booleanValue()) {
            if (StringUtil.isEmpty((String)((String)this.getModel().getValue(JWTSIGNTYPE)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"JWT\u8ba4\u8bc1\u5df2\u542f\u7528\uff0c\u8bf7\u8bbe\u7f6eJWT\u8ba4\u8bc1\u7684\u201c\u7b7e\u540d\u7b56\u7565\u201d\u3002", (String)"OpenApi3rdappsPlugin_19", (String)"bos-open-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (StringUtil.isEmpty((String)((String)this.getModel().getValue(SECURITYPUBLICKEY)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"JWT\u8ba4\u8bc1\u5df2\u542f\u7528\uff0c\u8bf7\u8bbe\u7f6eJWT\u8ba4\u8bc1\u7684\u201c\u8ba4\u8bc1\u5bc6\u94a5\u201d\u3002", (String)"OpenApi3rdappsPlugin_20", (String)"bos-open-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (((Boolean)this.getModel().getValue(IS_SIGNATURE)).booleanValue()) {
            if (StringUtil.isEmpty((String)((String)this.getModel().getValue(SIGNATURETYPE)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b7e\u540d\u8ba4\u8bc1\u5df2\u542f\u7528\uff0c\u8bf7\u8bbe\u7f6e\u7b7e\u540d\u8ba4\u8bc1\u7684\u201c\u7b7e\u540d\u7b56\u7565\u201d\u3002", (String)"OpenApi3rdappsPlugin_21", (String)"bos-open-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (StringUtil.isEmpty((String)((String)this.getModel().getValue(SIGNATURE_KEY)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b7e\u540d\u8ba4\u8bc1\u5df2\u542f\u7528\uff0c\u8bf7\u8bbe\u7f6e\u7b7e\u540d\u8ba4\u8bc1\u7684\u201c\u8ba4\u8bc1\u5bc6\u94a5\u201d\u3002", (String)"OpenApi3rdappsPlugin_22", (String)"bos-open-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private void convertCharToInt() {
        String encryption;
        String sign_type;
        String jwtsigntype;
        String string = jwtsigntype = this.getModel().getValue(JWTSIGNTYPE) != null ? this.getModel().getValue(JWTSIGNTYPE).toString() : null;
        if ("1".equals(jwtsigntype)) {
            this.getModel().setValue("jwt_type", (Object)1);
        } else if ("2".equals(jwtsigntype)) {
            this.getModel().setValue("jwt_type", (Object)2);
        }
        String string2 = sign_type = this.getModel().getValue(SIGNATURETYPE) != null ? this.getModel().getValue(SIGNATURETYPE).toString() : null;
        if ("1".equals(sign_type)) {
            this.getModel().setValue("sign_type", (Object)1);
        } else if ("2".equals(sign_type)) {
            this.getModel().setValue("sign_type", (Object)2);
        }
        String string3 = encryption = this.getModel().getValue("encryption") != null ? this.getModel().getValue("encryption").toString() : null;
        if ("1".equals(encryption)) {
            this.getModel().setValue("apiencryption", (Object)1);
        } else if ("2".equals(encryption)) {
            this.getModel().setValue("apiencryption", (Object)2);
        } else if ("0".equals(encryption)) {
            this.getModel().setValue("apiencryption", (Object)0);
        }
    }

    private void convertIntToChar() {
        String encryption;
        String sign_type;
        String jwtsigntype;
        String string = jwtsigntype = this.getModel().getValue("jwt_type") != null ? this.getModel().getValue("jwt_type").toString() : null;
        if ("1".equals(jwtsigntype)) {
            this.getModel().setValue(JWTSIGNTYPE, (Object)"1");
        } else if ("2".equals(jwtsigntype)) {
            this.getModel().setValue(JWTSIGNTYPE, (Object)"2");
        }
        String string2 = sign_type = this.getModel().getValue("sign_type") != null ? this.getModel().getValue("sign_type").toString() : null;
        if ("1".equals(sign_type)) {
            this.getModel().setValue(SIGNATURETYPE, (Object)"1");
        } else if ("2".equals(sign_type)) {
            this.getModel().setValue(SIGNATURETYPE, (Object)"2");
        }
        String string3 = encryption = this.getModel().getValue("apiencryption") != null ? this.getModel().getValue("apiencryption").toString() : null;
        if ("1".equals(encryption)) {
            this.getModel().setValue("encryption", (Object)"1");
        } else if ("2".equals(encryption)) {
            this.getModel().setValue("encryption", (Object)"2");
        } else if ("0".equals(encryption)) {
            this.getModel().setValue("encryption", (Object)"0");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (KEY_STARTIP.equals(name) || KEY_ENDIP.equals(name)) {
            String newValue = e.getChangeSet()[0].getNewValue().toString();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!StringUtils.isEmpty((CharSequence)newValue) && !IPWhiteListUtil.isValidIpAddress((String)newValue)) {
                this.getModel().setValue(name, (Object)"", rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684IPv4\uff0c\u8303\u56f40.0.0.0 ~ 255.255.255.255\u3002", (String)"OpenApi3rdappsPlugin_4", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            String startip = (String)this.getModel().getValue(KEY_STARTIP, rowIndex);
            String endip = (String)this.getModel().getValue(KEY_ENDIP, rowIndex);
            if (!(StringUtils.isEmpty((CharSequence)startip) || StringUtils.isEmpty((CharSequence)endip) || IPWhiteListUtil.compareIp((String)startip, (String)endip))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675fIP\u5fc5\u987b\u5927\u4e8e\u8d77\u59cbIP\u3002", (String)"OpenApi3rdappsPlugin_5", (String)"bos-open-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(name, (Object)"", rowIndex);
                return;
            }
        } else if (KEY_SHOWSECRETKEY.equals(name)) {
            Boolean isShow = (Boolean)this.getModel().getValue(KEY_SHOWSECRETKEY);
            Object baseCode = this.getModel().getValue(BASESIGNCODEKEY);
            if (baseCode == null || "".equals(baseCode.toString())) {
                return;
            }
            String baseCodeStr = baseCode.toString();
            if (isShow.booleanValue()) {
                if (EncrypterFactory.getEncrypter().isEncrypted(baseCodeStr)) {
                    baseCodeStr = EncrypterFactory.getEncrypter().decode(baseCodeStr);
                }
                this.getModel().setValue(DISPLAYBASESIGNCODE, (Object)EncryptUtil.genSignWithAccountId((String)baseCodeStr, (String)RequestContext.get().getAccountId()));
            } else {
                this.getModel().setValue(DISPLAYBASESIGNCODE, (Object)PWGFORMAT);
            }
            this.getView().updateView(AGENTUSER_ENTIRY);
        } else if (KEY_ISBASICAUTH.equals(name)) {
            Boolean isBasicAuth = (Boolean)this.getModel().getValue(KEY_ISBASICAUTH);
            if (isBasicAuth.booleanValue()) {
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(AGENTUSER_ENTIRY);
                if (dynamicObjectCollection.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u82e5\u8981\u4f7f\u7528\u57fa\u672c\u8ba4\u8bc1\uff0c\u8bf7\u7ef4\u62a4\u81f3\u5c11\u4e00\u4e2a\u4ee3\u7406\u7528\u6237\u3002", (String)"OpenApi3rdappsPlugin_13", (String)"bos-open-formplugin", (Object[])new Object[0]));
                }
                this.getModel().setValue(KEY_ALLOWALLAPI, (Object)false);
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_ALLOWALLAPI});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{KEY_ALLOWALLAPI});
            }
        } else if (IS_SIGNATURE.equals(name)) {
            DynamicObjectCollection dynamicObjectCollection;
            Boolean isSignature = (Boolean)this.getModel().getValue(IS_SIGNATURE);
            if (isSignature.booleanValue() && (dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(AGENTUSER_ENTIRY)).size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u82e5\u8981\u4f7f\u7528\u7b7e\u540d\u8ba4\u8bc1\uff0c\u8bf7\u7ef4\u62a4\u81f3\u5c11\u4e00\u4e2a\u4ee3\u7406\u7528\u6237\u3002", (String)"OpenApi3rdappsPlugin_25", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
        } else if ("agentuserid".equals(name)) {
            this.refreshBasicAuthCode();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("enable".equals(operate.getOperateKey()) || BTN_DISENABLE.equals(operate.getOperateKey())) {
            if (args.getOperationResult().isSuccess()) {
                this.isAllowEdit();
            }
        } else if (BTN_SAVE.equals(operate.getOperateKey())) {
            this.getPageCache().put(KEY_HISSYSPD, this.getModel().getValue(KEY_SYSAUTH).toString());
            this.setPwdFormat();
            if (args.getOperationResult().isSuccess()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"rebuildcert", DOWNLOADCERT});
                this.isAllowEdit();
            }
        } else if ("download".equals(operate.getOperateKey())) {
            Long thirdId = (Long)this.getModel().getValue("id");
            if (thirdId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"OpenApi3rdappsPlugin_9", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                String bosOpenCert = CertUtil.createBosOpenCert(thirdId);
                if (StringUtils.isNotEmpty((CharSequence)bosOpenCert) && EncrypterFactory.getEncrypter().isEncrypted(bosOpenCert)) {
                    String decode = EncrypterFactory.getEncrypter().decode(bosOpenCert);
                    String fp = ExportUtil.createTxt(decode);
                    String fileName = "cert_" + System.currentTimeMillis() + ".txt";
                    ExportAndDownloadUtil.download(this.getView(), fp, fileName);
                }
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        } else if ("rebuild".equals(operate.getOperateKey())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u751f\u6210\u8bc1\u4e66\u540e\uff0c\u5c06\u5f71\u54cd\u6240\u6709\u52a0\u5bc6API\u7684\u8bf7\u6c42\u4e1a\u52a1\u5185\u5bb9\u548c\u54cd\u5e94\u5185\u5bb9\u7684\u52a0\u89e3\u5bc6\uff0cOPENAPI\u52a0\u89e3\u5bc6\u5747\u4f1a\u5373\u65f6\u4f7f\u7528\u66f4\u65b0\u7684\u8bc1\u4e66\u3002\u8bf7\u786e\u4fdd\u6240\u6709\u52a0\u5bc6\u63a5\u53e3\u91cd\u65b0\u8c03\u8bd5\u5e76\u80fd\u6b63\u5e38\u4f7f\u7528\u3002", (String)"OpenApi3rdappsPlugin_14", (String)"bos-open-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("rebuild_confirm"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        block8: {
            super.confirmCallBack(event);
            String eventId = event.getCallBackId();
            if (REFRESH_BASICSIGN.equalsIgnoreCase(eventId) && event.getResult() == MessageBoxResult.Yes) {
                this.refreshBasicAuthCode();
            } else if ("rebuild_confirm".equalsIgnoreCase(eventId) && event.getResult() == MessageBoxResult.Yes) {
                Long thirdId = (Long)this.getModel().getValue("id");
                try {
                    boolean newBosOpenCert = CertUtil.createNewBosOpenCert(thirdId);
                    if (newBosOpenCert) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u8bc1\u4e66\u6210\u529f\u3002", (String)"OpenApi3rdappsPlugin_16", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        break block8;
                    }
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u8bc1\u4e66\u5931\u8d25\u3002", (String)"OpenApi3rdappsPlugin_17", (String)"bos-open-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u751f\u6210\u8bc1\u4e66\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%1$s\u3002", (String)"OpenApi3rdappsPlugin_15", (String)"bos-open-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
            } else if (event.getCallBackId().equals("update_api") && event.getResult() == MessageBoxResult.Yes) {
                this.getView().invokeOperation(BTN_SAVE, OperateOption.create());
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        BasedataEdit edit = (BasedataEdit)arg0.getSource();
        if (edit.getFieldKey().equals("agentuserid") && null != this.getModel().getValue("agentuserid")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff01\u82e5\u4fee\u6539\u4ee3\u7406\u7528\u6237\uff0c\u7cfb\u7edf\u4f1a\u91cd\u65b0\u751f\u6210\u65b0\u7684\u57fa\u672c\u8ba4\u8bc1\u5bc6\u94a5\u3002", (String)"OpenApi3rdappsPlugin_7", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
    }

    private void refreshDigst(String key) {
        try {
            String base64EncodeKey = AESUtils.getBase64EncodeKey();
            this.getModel().setValue(key, (Object)base64EncodeKey);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u79f0\u52a0\u5bc6\u79d8\u94a5\u751f\u6210\u5931\u8d25!", (String)"OpenApi3rdappsPlugin_8", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
    }

    private void refreshJWT() {
        try {
            String base64EncodeKey = AESUtils.getBase64EncodeKey();
            this.getModel().setValue(SECURITYPUBLICKEY, (Object)base64EncodeKey);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u79f0\u52a0\u5bc6\u79d8\u94a5\u751f\u6210\u5931\u8d25!", (String)"OpenApi3rdappsPlugin_8", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue(JWTASYMMETIC, (Object)"1");
        this.getModel().setValue(JWTSIGNTYPE, (Object)"1");
    }

    private void refreshBasicAuthCode() {
        if (!this.isSave()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"OpenApi3rdappsPlugin_9", (String)"bos-open-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject agencyUser = (DynamicObject)this.getModel().getValue("agentuserid");
        if (agencyUser == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ee3\u7406\u7528\u6237\u3002", (String)"OpenApi3rdappsPlugin_10", (String)"bos-open-formplugin", (Object[])new Object[0]));
            return;
        }
        String resourceThirdId = ((Long)this.getModel().getValue("id")).toString();
        String agencyUserId = agencyUser.getPkValue().toString();
        String key = EncryptUtil.genSign((String)resourceThirdId, (String)agencyUserId);
        this.getModel().setValue(BASESIGNCODEKEY, (Object)key);
        this.getModel().setValue(DISPLAYBASESIGNCODE, (Object)EncryptUtil.genSignWithAccountId((String)key, (String)RequestContext.get().getAccountId()));
        this.getModel().setValue(KEY_SHOWSECRETKEY, (Object)true);
    }

    private void setBaseSignCodeSecret() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(AGENTUSER_ENTIRY);
        if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
            dynamicObjectCollection.stream().forEach(it -> it.set(DISPLAYBASESIGNCODE, (Object)PWGFORMAT));
        }
    }

    private boolean isSave() {
        String resourceThirdId = ((Long)this.getModel().getValue("id")).toString();
        return !"0".equals(resourceThirdId) && resourceThirdId != null;
    }
}

