/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.form.plugin.callback.CallBackInfo;
import kd.bos.openapi.form.plugin.callback.CallBackUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class OpenApiCallbackFormPlugin
extends AbstractFormPlugin {
    public static final String THIRDID = "thirdid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit control = (BasedataEdit)this.getControl(THIRDID);
        control.addBeforeF7SelectListener(o -> {
            DynamicObject[] ids;
            ListShowParameter parameter = (ListShowParameter)o.getFormShowParameter();
            ArrayList<Object> thirdids = new ArrayList<Object>(16);
            for (DynamicObject object : ids = BusinessDataServiceHelper.load((String)"third_app", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.apiservice.id", "=", this.getApiid()).or(new QFilter("allowallapi", "=", (Object)"1"))})) {
                Object pkValue = object.getPkValue();
                thirdids.add(pkValue);
            }
            parameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)thirdids.toArray()).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("isbasicauth", "=", (Object)"1")));
        });
        BasedataEdit agentuser = (BasedataEdit)this.getControl("agentuserid");
        agentuser.addBeforeF7SelectListener(o -> {
            ListShowParameter parameter = (ListShowParameter)o.getFormShowParameter();
            DynamicObject third = (DynamicObject)this.getModel().getValue(THIRDID);
            if (third == null) {
                return;
            }
            ArrayList<Object> agentuserids = new ArrayList<Object>(16);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"third_app", (String)"entryentity_basicauth.agentuserid.id,entryentity_basicauth.agentuserid.name", (QFilter[])new QFilter[]{new QFilter("id", "=", third.getPkValue())});
            for (DynamicObject object : query) {
                Object pkValue = object.get("entryentity_basicauth.agentuserid.id");
                agentuserids.add(pkValue);
            }
            Long apiid = (Long)this.getApiid();
            QFilter[] qFilters = new QFilter[]{new QFilter("apiid", "=", (Object)apiid).and(new QFilter(THIRDID, "=", third.getPkValue()))};
            DynamicObjectCollection entryentity = QueryServiceHelper.query((String)"openapi_callback", (String)"id,agentuserid.id", (QFilter[])qFilters);
            ArrayList<Long> pks = new ArrayList<Long>(16);
            for (DynamicObject object : entryentity) {
                Long agentuserid = object.getLong("agentuserid.id");
                if (agentuserid == null) continue;
                pks.add(agentuserid);
            }
            if (CollectionUtil.isNotEmpty(pks)) {
                parameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)agentuserids.toArray()).and(new QFilter("id", "not in", (Object)pks.toArray())));
            } else {
                parameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)agentuserids.toArray()));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object apiid = this.getApiid();
        if (apiid != null) {
            this.getModel().setValue("apiid", apiid);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        String propName = e.getProperty().getName();
        if (THIRDID.equals(propName) && (value = this.getModel().getValue(THIRDID)) == null) {
            this.getModel().setValue("agentuserid", null);
        }
    }

    private Object getApiid() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object apiid = formShowParameter.getCustomParam("apiid");
        return apiid;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equalsIgnoreCase(operateKey) && args.getOperationResult().isSuccess() && args.getOperationResult().isSuccess()) {
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("callbackUrl", this.getCallBackUrl());
            FormShowParameter p = new FormShowParameter();
            p.setFormId("openapi_success");
            p.setCustomParams(param);
            p.getOpenStyle().setShowType(ShowType.InCurrentForm);
            this.getView().showForm(p);
        }
    }

    public String getCallBackUrl() {
        DynamicObject third = (DynamicObject)this.getModel().getValue(THIRDID);
        DynamicObject agentuser = (DynamicObject)this.getModel().getValue("agentuserid");
        Long thirdid = third.getLong("id");
        Long agentuserid = agentuser.getLong("id");
        Long apiid = (Long)this.getApiid();
        CallBackInfo callbackUrl = CallBackUtil.findCallbackUrl(thirdid, agentuserid, apiid);
        return callbackUrl.getCommUrl();
    }
}

