/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.openapi.base.acl.ApilAclManager;
import kd.bos.openapi.base.custom.CustomApiUtil;
import kd.bos.openapi.base.custom.info.CustomApiErrorCode;
import kd.bos.openapi.base.custom.info.CustomApiHeader;
import kd.bos.openapi.base.custom.info.CustomApiInfo;
import kd.bos.openapi.base.custom.info.CustomApiParam;
import kd.bos.openapi.common.constant.ApiDefType;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.ApiStatus;
import kd.bos.openapi.common.constant.AsyncTypeEnum;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.constant.PluginTypeEnum;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.util.ApiPluginUtil;
import kd.bos.openapi.form.util.FormOpener;
import kd.bos.openapi.form.util.MserviceUtil;
import kd.bos.openapi.form.util.OpenApiDataToJsonFormatUtils;
import kd.bos.openapi.form.util.OpenApiTestUtil;
import kd.bos.openapi.form.util.PathvariablePluginUtil;
import kd.bos.openapi.form.util.WsdlExportUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import org.apache.commons.lang3.RandomStringUtils;

public class OpenApiCustomApiFormPlugin
extends AbstractBasePlugIn
implements CellClickListener,
TreeNodeClickListener {
    private static final String ISV_KINGDEE = "kingdee";
    private static final String BODYTAB = "bodytab";
    private static final String KEY_URLFORMAT = "urlformat";
    private static final String KEY_PLUGIN = "plugin";
    private static final String KEY_CUSTOM_SORT = "customsort";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_APISERVICETYPE = "apiservicetype";
    private static final String KEY_APPID = "appid";
    private static final String KEY_HEADER_ENTRY = "headerentryentity";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String KEY_IS_ONLY_THIRDAPP_AUTH = "isonlythirdappauth";
    private static final String KEY_ALLOWGUEST = "allowguest";
    private static final String HTTPMETHOD = "httpmethod";
    public static final String BODYENTRYENTITY = "bodyentryentity";
    public static final String TABAP = "tabap";
    private static final String PARAM_TYPE = "$type";
    private static final String PARAM_DATA = "$data";
    public static final String GET_PROP_FROM_OBJ = "getPropFromObj";
    private static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String PID = "pid";
    public static final String ID = "id";
    public static final String BODYPREVIEW = "bodypreview";
    public static final String RESPENTRYENTITY = "respentryentity";
    public static final String RESPPREVIEW = "resppreview";
    public static final String FILTER_COLUMN = "filter_column";
    public static final String PARAMNAME = "paramname";
    public static final String BODY_LEVEL = "body_level";
    public static final String REQMULVALUE = "is_req_mul_value";
    public static final String RESPMULVALUE = "is_resp_mul_value";
    public static final String RESPPARAMNAME = "respparamname";
    public static final String RESP_LEVEL = "resp_level";
    private static final String HEADERNAME = "headername";
    public static final String IS_BODY_CUSTOM = "is_body_custom";
    public static final String PARAMTYPE = "paramtype";
    public static final String RESPPARAMTYPE = "respparamtype";
    public static final String EXAMPLE = "example";
    public static final String RESPEXAMPLE = "respexample";
    public static final String BODYPARAMDES = "bodyparamdes";
    public static final String RESPDES = "respdes";
    public static final String MUST = "must";
    public static final String RESPPARAMMUST = "respparammust";
    private static final String PLUGIN_MATCH = "\\[.+\\]";
    private static final String ENABLE = "enable";
    private static final String STATUS = "status";
    private static final String METHODNAME = "methodname";
    private static final String CLASSNAME = "classname";
    private static final String[] urlformatArr = new String[]{"/v2", "", "/{appId}", "/{servicename}"};
    private static final String NAMESPACEFORMAT = "(http|https)://([\\w.]+\\/?)S*";
    private static final String NAMESPACE = "namespace";
    private static final String SYNC = "sync";
    private static final String SYNC_OK = "sync_ok";
    public static final String APIDEFTYPE = "apideftype";
    public static final String INPUTPARAM = "wsinputparam";
    public static final String OUTPUTPARAM = "wsoutputparam";
    private static final String BOS_OPEN_FORMPLUGIN = "bos-open-formplugin";
    private static final String GEN_WSDL = "genwsdl";
    public static final String ISPATHVARIABLE = "ispathvariable";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_PLUGIN, FILTER_COLUMN, "indigesttemplate", "outdigesttemplate"});
    }

    public void initialize() {
        super.initialize();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BaseShowParameter showParameter = (BaseShowParameter)e.getFormShowParameter();
        String type = (String)showParameter.getCustomParam(KEY_APISERVICETYPE);
        if ("2".equals(type)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49API", (String)"OpenApiCustomApiFormPlugin_37", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OpenApiCustomApiFormPlugin.upgradeApi(formShowParameter, this.getModel());
        Object apiServiceType = formShowParameter.getCustomParam(KEY_APISERVICETYPE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_apiauthorize"});
        String isvId = ISVServiceHelper.getISVInfo().getId();
        this.getModel().setValue("isvid", (Object)isvId);
        ComboEdit opCombo = (ComboEdit)this.getControl(APIDEFTYPE);
        opCombo.setComboItems(this.buildApiDefTypeComboItem());
        this.getModel().setValue(APIDEFTYPE, (Object)ApiDefType.AUTOSCAN.getCode());
        if (StringUtils.isNotBlank((Object)apiServiceType)) {
            this.getModel().setValue(KEY_APISERVICETYPE, apiServiceType);
            String urlformat = "";
            CharSequence[] urlArr = (String[])urlformatArr.clone();
            if ("2".equals(apiServiceType)) {
                String groupId;
                String isasync = (String)formShowParameter.getCustomParam("isasync");
                if (StringUtil.isNotEmpty((String)isasync) && "true".equals(isasync)) {
                    this.getModel().setValue("isasync", (Object)AsyncTypeEnum.ASYNC.getValue());
                    urlArr[0] = (String)urlArr[0] + "/async";
                }
                if (!ISV_KINGDEE.equals(isvId)) {
                    urlArr[1] = "/" + isvId;
                }
                urlformat = String.join((CharSequence)"", urlArr);
                this.getModel().setValue(KEY_URLFORMAT, (Object)urlformat);
                Map creMap = formShowParameter.getCustomParams();
                Object paramAppid = creMap.get(KEY_APPID);
                if (StringUtils.isNotBlank((Object)creMap) && paramAppid != null) {
                    this.getModel().setValue(KEY_APPID, paramAppid);
                    this.updateUrlFormat();
                    Object paramCusid = creMap.get("cusid");
                    if (paramCusid != null) {
                        this.getModel().setValue(KEY_CUSTOM_SORT, paramCusid);
                    }
                }
                if (creMap.size() > 0 && creMap.get("groupId") != null && !"customgroup-sys".equals(groupId = creMap.get("groupId").toString()) && StringUtil.isNotEmpty((String)groupId)) {
                    DynamicObject group = BusinessDataServiceHelper.loadSingle((String)"open_customgroup", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)groupId)});
                    this.getModel().setValue("group", (Object)group);
                }
            }
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"number", HTTPMETHOD});
        Tab tabap = (Tab)this.getView().getControl(TABAP);
        tabap.activeTab(BODYTAB);
        if (null != this.getModel().getValue(APIDEFTYPE) && !ApiDefType.AUTOSCAN.getCode().equalsIgnoreCase(this.getModel().getValue(APIDEFTYPE).toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SYNC});
        }
        ApiPluginUtil.buildHeader(this.getModel());
        ApiPluginUtil.bodyOrQueryTabVisible(this.getView());
        this.getModel().setValue("cosmicver", (Object)ApiPluginUtil.getCosmicVer());
        ApiPluginUtil.isVisiableAnonymous(this.getView());
        this.getView().getPageCache().put("isNew", "true");
        this.getView().setVisible(Boolean.FALSE, new String[]{"hiddenplugin"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"pvurlformat"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String className = (String)this.getModel().getValue(CLASSNAME);
        String methodName = (String)this.getModel().getValue(METHODNAME);
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
        try {
            String appId = bizApp.getString("number");
            Boolean hasApiControllerAnnotation = CustomApiUtil.isHasApiControllerAnnotation((String)appId, (String)className);
            Set<Object> methodNames = new HashSet(8);
            methodNames = hasApiControllerAnnotation == false && MserviceUtil.isHadRegistMservice(className) != false ? MserviceUtil.getMethodNamesByClassName(className) : CustomApiUtil.getMethodNames((String)appId, (String)className);
            this.buildMethodNameCombo(methodNames);
            if (!methodNames.contains(methodName)) {
                this.clearValue(METHODNAME);
            }
        }
        catch (OpenApiException openApiException) {
            this.clearValue(METHODNAME);
            this.getView().showTipNotification(openApiException.getMessage());
        }
        catch (Exception ex) {
            FormOpener.showErrorMessage(this.getView(), new OpenApiException((Throwable)ex, ApiErrorCode.ERROR, String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u65b9\u6cd5\u5217\u8868\u5931\u8d25\uff1a%s", (String)"OpenApiCustomApiFormPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), DataUtil.getMessage((Throwable)ex)), new Object[0]));
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"number", KEY_APPID, CLASSNAME, METHODNAME, HTTPMETHOD});
        Tab tabap = (Tab)this.getView().getControl(TABAP);
        tabap.activeTab(BODYTAB);
        if (null != this.getModel().getValue(APIDEFTYPE) && !ApiDefType.AUTOSCAN.getCode().equalsIgnoreCase(this.getModel().getValue(APIDEFTYPE).toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SYNC});
        }
        ApiPluginUtil.preSetHeader(this.getModel());
        ApiPluginUtil.visitButtonControl(this.getModel(), this.getView());
        ApiPluginUtil.bodyOrQueryTabVisible(this.getView());
        this.getView().setVisible(Boolean.FALSE, new String[]{"forbidden"});
        ApiPluginUtil.isVisiableAnonymous(this.getView());
        ApiPluginUtil.beforeLoadGetExtEntry(this.getModel(), "openapi_customapi");
        this.getView().setVisible(Boolean.FALSE, new String[]{"hiddenplugin"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"pvurlformat"});
    }

    public static void upgradeApi(FormShowParameter baseShowParameter, IDataModel iDataModel) {
        String isUpgrade = (String)baseShowParameter.getCustomParam("isUpgrade");
        if ("true".equalsIgnoreCase(isUpgrade)) {
            iDataModel.setValue(NAME, baseShowParameter.getCustomParam(NAME));
            iDataModel.setValue(KEY_APPID, baseShowParameter.getCustomParam(KEY_APPID));
            iDataModel.setValue(HTTPMETHOD, baseShowParameter.getCustomParam(HTTPMETHOD));
            iDataModel.setValue("discription", baseShowParameter.getCustomParam("discription"));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        String type = (String)showParameter.getCustomParam(KEY_APISERVICETYPE);
        if (StringUtils.isEmpty((CharSequence)type)) {
            type = this.getModel().getValue(KEY_APISERVICETYPE).toString();
        }
        if ("2".equals(type)) {
            BasedataEdit sort = (BasedataEdit)this.getControl(KEY_CUSTOM_SORT);
            sort.setMustInput(true);
        }
        if ("prod".equals(System.getProperty("env.type"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"testapi"});
        }
        this.initParamType(RESPPARAMTYPE, null);
        ApiPluginUtil.setFullUrlformat(this.getModel());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        try {
            if (args.getSource() instanceof AbstractOperate) {
                AbstractOperate operate = (AbstractOperate)args.getSource();
                String operateKey = operate.getOperateKey();
                if ("save".equals(operateKey)) {
                    if (!"true".equals(this.getView().getPageCache().get("isSaveIgnoreIsvId"))) {
                        ApiPluginUtil.checkIsKingdee(this.getModel());
                    }
                    this.saveApiOperation(args);
                    String ver = this.getModel().getValue("cosmicver") == null ? "" : this.getModel().getValue("cosmicver").toString();
                    ApiPluginUtil.matchCosmicVer(ver, this.getView());
                    String pluginInfoStr = (String)this.getModel().getValue(KEY_PLUGIN);
                    String appId = this.getAppId();
                    ApiPluginUtil.checkPlugin(appId, "", pluginInfoStr, args, this.getView(), this.getModel());
                    PathvariablePluginUtil.handlePvUrlformat(this.getModel(), this.getView(), "openapi_customapi");
                    ApiPluginUtil.beforeSaveSetExtEntry(this.getModel(), "openapi_customapi");
                } else if ("close".equals(operateKey)) {
                    this.getModel().setDataChanged(false);
                } else if (!SYNC.equals(operateKey) && GEN_WSDL.equals(operateKey)) {
                    WsdlExportUtil.checkWebserviceInfo((String)this.getModel().getValue(NAMESPACE), (String)this.getModel().getValue(INPUTPARAM), (String)this.getModel().getValue(OUTPUTPARAM));
                }
            }
        }
        catch (KDException e) {
            args.setCancel(true);
            this.getView().showErrorNotification(e.getMessage());
        }
        catch (Exception e) {
            args.setCancel(true);
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        try {
            if (BODYPREVIEW.equals(opKey)) {
                this.paramPreview(BODYENTRYENTITY);
            } else if (RESPPREVIEW.equals(opKey)) {
                this.paramPreview(RESPENTRYENTITY);
            } else if ("close".equals(opKey)) {
                if ("0".equals(this.getModel().getDataEntity().getPkValue().toString())) {
                    this.getView().returnDataToParent((Object)"norefresh");
                }
            } else if ("save".equals(opKey) && args.getOperationResult().isSuccess()) {
                String url = (String)this.getModel().getValue(KEY_URLFORMAT);
                ApilAclManager.removeApiAclModel((String)url);
                this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
                this.getView().getPageCache().put("isNew", "false");
                ApiPluginUtil.setFullUrlformat(this.getModel());
            } else if ("forbidden".equals(opKey) && args.getOperationResult().isSuccess()) {
                this.getView().invokeOperation("disable");
                String url = (String)this.getModel().getValue(KEY_URLFORMAT);
                ApilAclManager.removeApiAclModel((String)url);
            } else if ("publish".equals(opKey) && args.getOperationResult().isSuccess()) {
                this.getView().invokeOperation(ENABLE);
                String url = (String)this.getModel().getValue(KEY_URLFORMAT);
                ApilAclManager.removeApiAclModel((String)url);
            } else if ("disable".equals(opKey) || ENABLE.equals(opKey) && args.getOperationResult().isSuccess()) {
                args.getOperationResult().setShowMessage(false);
            } else if (GEN_WSDL.equals(opKey)) {
                String urlformat = (String)this.getModel().getValue(KEY_URLFORMAT);
                urlformat = PathvariablePluginUtil.replaceUrlPathVariableToExample(this.getModel(), urlformat);
                String url = RequestContext.get().getClientFullContextPath() + "kapi" + urlformat + "?wsdl";
                WsdlExportUtil.exportWsdl(this.getView(), url, RequestContext.get().getGlobalSessionId(), (String)this.getModel().getValue("number"));
            }
        }
        catch (KDException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void paramPreview(String entryKey) {
        String className = (String)this.getModel().getValue(CLASSNAME);
        String methodName = (String)this.getModel().getValue(METHODNAME);
        String httpMethod = (String)this.getModel().getValue(HTTPMETHOD);
        String inputParam = (String)this.getModel().getValue(INPUTPARAM);
        String outputParam = (String)this.getModel().getValue(OUTPUTPARAM);
        String nameSpace = (String)this.getModel().getValue(NAMESPACE);
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
        String apiDefType = this.getModel().getValue(APIDEFTYPE).toString();
        if (ApiDefType.AUTOSCAN.getCode().equalsIgnoreCase(apiDefType) && (StringUtil.isEmpty((String)className) || StringUtil.isEmpty((String)methodName) || bizApp == null)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6240\u5c5e\u5e94\u7528\uff0c\u7c7b\u540d\uff0c\u65b9\u6cd5\u540d\u662f\u5426\u4e3a\u7a7a\u3002", (String)"OpenApiCustomApiFormPlugin_10", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(entryKey);
        String jsonStr = null;
        Map<String, Object> resultObj = OpenApiDataToJsonFormatUtils.transferToMap(dynamicObjects, entryKey);
        jsonStr = JsonUtil.format(resultObj);
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("preData", jsonStr);
        param.put("isGetMethod", "0".equals(httpMethod) && entryKey.equalsIgnoreCase(BODYENTRYENTITY) ? Boolean.TRUE : Boolean.FALSE);
        param.put("preUrl", this.getModel().getValue(KEY_URLFORMAT));
        param.put("apiServiceType", ApiServiceType.CUSTOM.getOperation());
        param.put("previewType", entryKey);
        param.put(INPUTPARAM, inputParam);
        param.put(OUTPUTPARAM, outputParam);
        param.put(NAMESPACE, nameSpace);
        FormOpener.showForm((AbstractFormPlugin)this, "openapi_struct_preview", ResManager.loadKDString((String)"\u6570\u636e\u9884\u89c8", (String)"OpenApiCustomApiFormPlugin_11", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), param, null);
    }

    private void openTestApiForm() {
        String className = (String)this.getModel().getValue(CLASSNAME);
        String methodName = (String)this.getModel().getValue(METHODNAME);
        String httpMethod = (String)this.getModel().getValue(HTTPMETHOD);
        String apiDefType = this.getModel().getValue(APIDEFTYPE).toString();
        String inputParam = (String)this.getModel().getValue(INPUTPARAM);
        String outputParam = (String)this.getModel().getValue(OUTPUTPARAM);
        String nameSpace = (String)this.getModel().getValue(NAMESPACE);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(BODYENTRYENTITY);
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
        if (StringUtil.isEmpty((String)className) || StringUtil.isEmpty((String)methodName) || bizApp == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6240\u5c5e\u5e94\u7528\uff0c\u7c7b\u540d\uff0c\u65b9\u6cd5\u540d\u662f\u5426\u4e3a\u7a7a\u3002", (String)"OpenApiCustomApiFormPlugin_10", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        Map<String, Object> resultObj = OpenApiDataToJsonFormatUtils.transferToMap(dynamicObjects, BODYENTRYENTITY);
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("preData", JsonUtil.format(resultObj));
        param.put("isGetMethod", "0".equals(httpMethod) ? Boolean.TRUE : Boolean.FALSE);
        param.put("preUrl", this.getModel().getValue(KEY_URLFORMAT));
        param.put("apiServiceType", ApiServiceType.CUSTOM.getOperation());
        param.put(INPUTPARAM, inputParam);
        param.put(OUTPUTPARAM, outputParam);
        param.put(NAMESPACE, nameSpace);
        FormOpener.showApiTestForm((AbstractFormPlugin)this, ResManager.loadKDString((String)"API\u6d4b\u8bd5", (String)"OpenApiCustomApiFormPlugin_12", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), param, null);
    }

    private Object setDefaultValue(String dateType, Object obj) {
        if (obj != null) {
            return obj;
        }
        return JSON.toJSONString((Object)DataType.getDefaultValue((String)dateType), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    private void addTreeEntryProps(String entryKey, List<CustomApiParam> dataList) {
        for (int i = 0; i < dataList.size(); ++i) {
            CustomApiParam data = dataList.get(i);
            this.buildCustomApiParam(entryKey, (Object)0, data);
        }
    }

    private void buildCustomApiParam(String entryKey, Object pid, CustomApiParam param) {
        if (param == null) {
            return;
        }
        DynamicObjectType objectType = this.getModel().getEntryEntity(entryKey).getDynamicObjectType();
        String paramName = BODYENTRYENTITY.equals(entryKey) ? PARAMNAME : RESPPARAMNAME;
        String paramType = BODYENTRYENTITY.equals(entryKey) ? PARAMTYPE : RESPPARAMTYPE;
        String isMust = BODYENTRYENTITY.equals(entryKey) ? MUST : RESPPARAMMUST;
        String example = BODYENTRYENTITY.equals(entryKey) ? EXAMPLE : RESPEXAMPLE;
        String desc = BODYENTRYENTITY.equals(entryKey) ? BODYPARAMDES : RESPDES;
        String levelName = BODYENTRYENTITY.equals(entryKey) ? BODY_LEVEL : RESP_LEVEL;
        String isMulValue = BODYENTRYENTITY.equals(entryKey) ? REQMULVALUE : RESPMULVALUE;
        DynamicObject entry = new DynamicObject(objectType);
        entry.set(paramName, (Object)param.getParamName());
        entry.set(paramType, (Object)param.getParamType());
        entry.set(isMust, (Object)(param.isRequired() ? "1" : "0"));
        entry.set(example, (Object)(param.getExample() == null || param.getExample().equals("") ? "-" : JacksonUtil.writeValueAsString((Object)param.getExample())));
        entry.set(desc, (Object)param.getDesc());
        entry.set(levelName, (Object)param.getLevel());
        entry.set(PID, pid);
        this.getModel().createNewEntryRow(entryKey, entry);
        int index = this.getModel().getEntryRowCount(entryKey);
        this.getModel().setValue(isMulValue, (Object)param.isMulValue(), index - 1);
        ApiPluginUtil.handleMulLang(this.getModel(), desc, param.getDescML(), index);
        ApiPluginUtil.handleMulLang(this.getModel(), example, param.getExampleML(), index);
        if (BODYENTRYENTITY.equals(entryKey)) {
            this.getModel().setValue(ISPATHVARIABLE, (Object)param.isPathVariable(), index - 1);
        }
        if (param.getChildList() != null && param.getChildList().size() > 0) {
            param.getChildList().forEach(it -> this.buildCustomApiParam(entryKey, entry.get(ID), (CustomApiParam)it));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals("testapi")) {
            this.openTestApiForm();
        } else if (evt.getItemKey().equals(SYNC)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u52a0\u8f7d\u65b9\u6cd5\u4fe1\u606f\u4f1a\u6e05\u7a7a\u5f53\u524dAPI\u7684\u4fe1\u606f\u5e76\u83b7\u53d6\u6700\u65b0\u7684\u65b9\u6cd5\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OpenApiCustomApiFormPlugin_13", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(SYNC_OK));
        } else if (evt.getItemKey().equals("callbackurl")) {
            ApiPluginUtil.callbackUrl((AbstractFormPlugin)this);
        }
    }

    private void syncApiInfo() {
        String className = (String)this.getModel().getValue(CLASSNAME);
        String methodName = (String)this.getModel().getValue(METHODNAME);
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
        if (bizApp == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u5e94\u7528\u3002", (String)"OpenApiCustomApiFormPlugin_14", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtil.isEmpty((String)className)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7c7b\u540d\u3002", (String)"OpenApiCustomApiFormPlugin_15", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtil.isEmpty((String)methodName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b9\u6cd5\u540d\u3002", (String)"OpenApiCustomApiFormPlugin_16", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        try {
            this.clearApiInfo();
            Boolean hasApiControllerAnnotation = CustomApiUtil.isHasApiControllerAnnotation((String)bizApp.getString("number"), (String)className);
            if (!hasApiControllerAnnotation.booleanValue() && MserviceUtil.isHadRegistMservice(className).booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{HTTPMETHOD});
            }
            this.getModel().deleteEntryData(KEY_HEADER_ENTRY);
            this.getModel().deleteEntryData("errorcodeentity");
            ApiPluginUtil.buildHeader(this.getModel());
            this.setApiInfo(className, methodName);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u8f7d\u6210\u529f\u3002", (String)"OpenApiCustomApiFormPlugin_17", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (KEY_PLUGIN.equals(control.getKey())) {
            String bizAppId;
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ide_plugins");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pluginRegister"));
            String plugins = (String)this.getModel().getValue(KEY_PLUGIN);
            DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APPID);
            if (StringUtils.isNotBlank((Object)app) && StringUtils.isNotBlank((CharSequence)(bizAppId = app.getString(ID)))) {
                formShowParameter.setCustomParam("bizappid", (Object)bizAppId);
                formShowParameter.setCustomParam("scriptfiltertype", (Object)"webapi");
            }
            if (this.isUseNewVersionPlugin() && StringUtils.isNotBlank((CharSequence)plugins)) {
                formShowParameter.setCustomParam("value", SerializationUtils.fromJsonString((String)plugins, List.class));
            }
            this.getView().showForm(formShowParameter);
        } else if ("indigesttemplate".equals(control.getKey()) || "outdigesttemplate".equals(control.getKey())) {
            ApiPluginUtil.digestLogFormShow(control.getKey(), this.getModel(), this.getView(), this.getPluginName());
        }
    }

    private boolean isUseNewVersionPlugin() {
        String pluginInfoStr = (String)this.getModel().getValue(KEY_PLUGIN);
        return StringUtils.isBlank((CharSequence)pluginInfoStr) || pluginInfoStr.matches(PLUGIN_MATCH);
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        String className = (String)this.getModel().getValue(CLASSNAME);
        String methodName = (String)this.getModel().getValue(METHODNAME);
        if (ApiPluginUtil.isSaveIgnoreIsvId(propName).booleanValue()) {
            if (!"false".equals(this.getView().getPageCache().get("isSaveIgnoreIsvId"))) {
                this.getView().getPageCache().put("isSaveIgnoreIsvId", "true");
            }
        } else {
            this.getView().getPageCache().put("isSaveIgnoreIsvId", "false");
        }
        if (KEY_APPID.equals(propName)) {
            this.updateUrlFormat();
            try {
                this.setApiInfo(className, methodName);
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
        } else if ("number".equals(propName)) {
            if (ApiPluginUtil.validateNumberAndUrlFormat(null, (AbstractFormPlugin)this)) {
                this.updateUrlFormat();
            }
        } else if (HTTPMETHOD.equals(propName)) {
            ApiPluginUtil.bodyOrQueryTabVisible(this.getView());
        } else if (CLASSNAME.equalsIgnoreCase(propName)) {
            String classname = (String)this.getModel().getValue(CLASSNAME);
            this.getMethodNamesByClassName(classname);
        } else if (METHODNAME.equalsIgnoreCase(propName)) {
            this.clearApiInfo();
            try {
                this.getModel().deleteEntryData(KEY_HEADER_ENTRY);
                this.getModel().deleteEntryData("errorcodeentity");
                ApiPluginUtil.buildHeader(this.getModel());
                this.setApiInfo(className, methodName);
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
        } else if (HEADERNAME.equals(propName)) {
            String newVar = DataUtil.s((Object)e.getChangeSet()[0].getNewValue());
            ApiPluginUtil.dealHeaderWhenChanged(this.getModel(), this.getView(), newVar);
        } else if ("cosmicver".equals(propName)) {
            try {
                ApiPluginUtil.matchCosmicVer(DataUtil.s((Object)e.getChangeSet()[0].getNewValue()), this.getView());
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
        } else if (KEY_IS_ONLY_THIRDAPP_AUTH.equalsIgnoreCase(propName)) {
            ApiPluginUtil.visitButtonControl(this.getModel(), this.getView());
        } else if (KEY_ALLOWGUEST.equals(propName)) {
            ApiPluginUtil.allowguestControl(this.getModel(), this.getView());
        } else if ("headerdefaultvalue".equals(propName)) {
            ApiPluginUtil.validatorHeaders(this.getModel(), this.getView());
        }
    }

    private void setNameSpace(String className) {
        try {
            String namespace = CustomApiUtil.getNameSpace((String)this.getAppId(), (String)className);
            this.getModel().setValue(NAMESPACE, (Object)namespace);
        }
        catch (OpenApiException openApiException) {
            ComboEdit combo = (ComboEdit)this.getView().getControl(METHODNAME);
            combo.setComboItems(Collections.EMPTY_LIST);
            this.clearApiInfo();
            this.clearValue(METHODNAME);
            this.getView().showTipNotification(openApiException.getMessage());
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), new OpenApiException((Throwable)e, ApiErrorCode.ERROR, String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u547d\u540d\u7a7a\u95f4\u5931\u8d25\uff1a%s", (String)"OpenApiCustomApiFormPlugin_19", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), DataUtil.getMessage((Throwable)e)), new Object[0]));
        }
    }

    private String getAppId() {
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
        if (bizApp == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u5e94\u7528\u3002", (String)"OpenApiCustomApiFormPlugin_14", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), new Object[0]);
        }
        return bizApp.getString("number");
    }

    private void initParamType(String controlName, EnumSet<DataType> excludes) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(controlName);
        EnumSet dataTypes = DataType.getServiceDataType();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(dataTypes.size());
        for (DataType dataType : dataTypes) {
            if (excludes != null && excludes.contains(dataType)) continue;
            ComboItem item = new ComboItem();
            item.setValue(dataType.type());
            item.setCaption(new LocaleString(dataType.type()));
            items.add(item);
        }
        combo.setComboItems(items);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("bar_save".equals(key)) {
            ApiPluginUtil.confirmBeforeSave(this.getView(), evt);
        } else if ("testapi".equals(key)) {
            Long pk = (Long)this.getModel().getDataEntity().getPkValue();
            if (pk <= 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58API\u3002", (String)"OpenApiCustomApiFormPlugin_20", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
            String enable = this.getModel().getDataEntity().getString(STATUS);
            if (ApiStatus.DISABLE.getCode().equals(enable)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u72b6\u6001\u65e0\u6cd5\u6d4b\u8bd5\u3002", (String)"OpenApiCustomApiFormPlugin_21", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                evt.setCancel(true);
            }
            ApiPluginUtil.createTest3rdApp(evt, this);
        } else if (SYNC.equals(key)) {
            try {
                String className = (String)this.getModel().getValue(CLASSNAME);
                if (StringUtil.isEmpty((String)className)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OpenApiCustomApiFormPlugin_38", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
                if (CustomApiUtil.isHasApiControllerAnnotation((String)bizApp.getString("number"), (String)className).booleanValue()) {
                    this.checkNumberIsChange(evt);
                }
            }
            catch (Exception e) {
                this.getView().showTipNotification(e.getMessage());
                evt.setCancel(true);
            }
        }
    }

    private void checkNumberIsChange(BeforeItemClickEvent evt) {
        String newNumber;
        String methodName;
        String oldNumber = (String)this.getModel().getValue("number");
        String className = (String)this.getModel().getValue("className");
        CustomApiInfo customApiInfo = this.getCustomApiInfo(className, methodName = (String)this.getModel().getValue("methodName"));
        if (customApiInfo != null && !(newNumber = customApiInfo.getNumber()).equalsIgnoreCase(oldNumber)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u4e2d\u7684API\u7f16\u7801\u3001\u8bf7\u6c42\u5730\u5740\u5df2\u53d8\u66f4\uff0c\u4e0d\u5141\u8bb8\u91cd\u8f7d\u65b9\u6cd5\u4fe1\u606f\u3002", (String)"OpenApiCustomApiFormPlugin_32", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String eventId = event.getCallBackId();
        if (SYNC_OK.equalsIgnoreCase(eventId) && event.getResult() == MessageBoxResult.Yes) {
            this.syncApiInfo();
        } else if (event.getCallBackId().equals("apitest")) {
            if (event.getResult() == MessageBoxResult.Yes) {
                OpenApiTestUtil util = new OpenApiTestUtil();
                util.createUnittestApp();
                this.openTestApiForm();
            }
        } else if (event.getCallBackId().equals("update_api") && event.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("save", OperateOption.create());
        }
    }

    private void updateUrlFormat() {
        String isvId = ISVServiceHelper.getISVInfo().getId();
        CharSequence[] urlFormatClone = (String[])urlformatArr.clone();
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
        String appId = null;
        if (bizApp != null) {
            appId = bizApp.getString("number");
        }
        String isasync = (String)this.getModel().getValue("isasync");
        if (AsyncTypeEnum.ASYNC.getValue().equals(isasync)) {
            urlFormatClone[0] = urlFormatClone[0] + "/async";
        }
        String serviceName = (String)this.getModel().getValue("number");
        String modelIsvid = this.getModel().getValue("isvid").toString();
        if (StringUtil.isEmpty((String)isvId) && StringUtil.isEmpty((String)modelIsvid) || StringUtil.isNotEmpty((String)isvId) && StringUtil.isEmpty((String)modelIsvid)) {
            if (!ISV_KINGDEE.equalsIgnoreCase(isvId)) {
                urlFormatClone[1] = "/" + isvId;
            }
        } else if ((StringUtil.isEmpty((String)isvId) && StringUtil.isNotEmpty((String)modelIsvid) || StringUtil.isNotEmpty((String)isvId) && StringUtil.isNotEmpty((String)modelIsvid)) && !ISV_KINGDEE.equalsIgnoreCase(modelIsvid)) {
            urlFormatClone[1] = "/" + modelIsvid;
        }
        if (StringUtil.isNotEmpty((String)appId)) {
            urlFormatClone[2] = "/" + appId;
        }
        if (StringUtil.isNotEmpty((String)serviceName)) {
            urlFormatClone[3] = "/" + serviceName;
        }
        String urlFormat = String.join((CharSequence)"", urlFormatClone);
        this.getModel().setValue(KEY_URLFORMAT, (Object)urlFormat);
    }

    private void saveApiOperation(BeforeDoOperationEventArgs evt) {
        ApiPluginUtil.validateNumberAndUrlFormat(evt, (AbstractFormPlugin)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String parentFormId = "";
        if (null != this.getView().getParentView()) {
            parentFormId = this.getView().getParentView().getFormShowParameter().getFormId();
        }
        if (parentFormId.equals("openapi_apilist_tmp")) {
            if ("0".equals(this.getModel().getDataEntity().getPkValue().toString())) {
                this.getView().returnDataToParent((Object)"norefresh");
            } else {
                this.getView().returnDataToParent((Object)"refresh");
            }
        }
        e.setCheckDataChange(false);
    }

    public void cellClick(CellClickEvent evt) {
        this.cellClickHandle(evt);
    }

    public void cellDoubleClick(CellClickEvent evt) {
        this.cellClickHandle(evt);
    }

    private void cellClickHandle(CellClickEvent evt) {
        String fieldKey = evt.getFieldKey();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
    }

    private void getMethodNamesByClassName(String className) {
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
        if (bizApp == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u5e94\u7528\u3002", (String)"OpenApiCustomApiFormPlugin_14", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        try {
            String appId = bizApp.getString("number");
            Boolean hasApiControllerAnnotation = CustomApiUtil.isHasApiControllerAnnotation((String)appId, (String)className);
            HashSet<String> methodNames = new HashSet(8);
            if (!hasApiControllerAnnotation.booleanValue() && MserviceUtil.isHadRegistMservice(className).booleanValue()) {
                this.getModel().setValue("plugintype", (Object)PluginTypeEnum.MSERVICE.getValue());
                methodNames = MserviceUtil.getMethodNamesByClassName(className);
            } else {
                this.getModel().setValue("plugintype", (Object)PluginTypeEnum.DEFAULT.getValue());
                methodNames = CustomApiUtil.getMethodNames((String)appId, (String)className);
            }
            ComboEdit combo = (ComboEdit)this.getView().getControl(METHODNAME);
            if (CollectionUtil.isNotEmpty(methodNames)) {
                this.buildMethodNameCombo(methodNames);
            } else {
                combo.setComboItems(Collections.EMPTY_LIST);
                this.clearApiInfo();
                this.clearValue(METHODNAME);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s \u7684\u65b9\u6cd5\u4e3a\u7a7a\u3002", (String)"OpenApiCustomApiFormPlugin_27", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), className));
            }
            this.setNameSpace(className);
        }
        catch (OpenApiException openApiException) {
            ComboEdit combo = (ComboEdit)this.getView().getControl(METHODNAME);
            combo.setComboItems(Collections.EMPTY_LIST);
            this.clearApiInfo();
            this.clearValue(METHODNAME);
            this.getView().showTipNotification(openApiException.getMessage());
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), new OpenApiException((Throwable)e, ApiErrorCode.ERROR, String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u65b9\u6cd5\u5931\u8d25\uff1a%s", (String)"OpenApiCustomApiFormPlugin_28", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), DataUtil.getMessage((Throwable)e)), new Object[0]));
        }
    }

    private void buildMethodNameCombo(Set<String> methodNames) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(METHODNAME);
        ArrayList items = new ArrayList(methodNames.size());
        methodNames.stream().forEach(it -> {
            ComboItem item = new ComboItem();
            item.setValue(it);
            item.setCaption(new LocaleString(it));
            items.add(item);
        });
        combo.setComboItems(items);
    }

    private void setApiInfo(String className, String methodName) {
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
        if (bizApp == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u5e94\u7528\u3002", (String)"OpenApiCustomApiFormPlugin_14", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        if (className == null || methodName == null) {
            return;
        }
        this.clearApiInfo();
        if (!CustomApiUtil.isHasApiControllerAnnotation((String)bizApp.getString("number"), (String)className).booleanValue() && MserviceUtil.isHadRegistMservice(className).booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{HTTPMETHOD});
            this.setMserviceApiInfo(className, methodName);
            return;
        }
        CustomApiInfo customApiInfo = this.getCustomApiInfo(className, methodName);
        if (customApiInfo != null) {
            int index;
            DynamicObject entry;
            DynamicObjectType objectType;
            this.getModel().setValue("number", (Object)customApiInfo.getNumber());
            this.getModel().setValue(HTTPMETHOD, (Object)customApiInfo.getHttpMethod().getCode());
            this.setWebServiceInfo(className, methodName);
            ApiPluginUtil.handleMulLang(this.getModel(), NAME, customApiInfo.getNameML());
            if (CollectionUtil.isNotEmpty((Collection)customApiInfo.getRequest())) {
                this.addTreeEntryProps(BODYENTRYENTITY, customApiInfo.getRequest());
            }
            if (CollectionUtil.isNotEmpty((Collection)customApiInfo.getResponse())) {
                this.addTreeEntryProps(RESPENTRYENTITY, customApiInfo.getResponse());
            }
            if (CollectionUtil.isNotEmpty((Collection)customApiInfo.getHeaders())) {
                objectType = this.getModel().getEntryEntity(KEY_HEADER_ENTRY).getDynamicObjectType();
                for (CustomApiHeader header : customApiInfo.getHeaders()) {
                    entry = new DynamicObject(objectType);
                    entry.set(HEADERNAME, (Object)header.getName());
                    entry.set("headervalue", (Object)header.getDesc());
                    entry.set("headerdes", (Object)header.getExample());
                    this.getModel().createNewEntryRow(KEY_HEADER_ENTRY, entry);
                    index = this.getModel().getEntryRowCount(KEY_HEADER_ENTRY);
                    ApiPluginUtil.handleMulLang(this.getModel(), "headervalue", header.getDescML(), index);
                    ApiPluginUtil.handleMulLang(this.getModel(), "headerdes", header.getExampleML(), index);
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)customApiInfo.getErrorCodes())) {
                objectType = this.getModel().getEntryEntity("errorcodeentity").getDynamicObjectType();
                for (CustomApiErrorCode errorCode : customApiInfo.getErrorCodes()) {
                    entry = new DynamicObject(objectType);
                    entry.set("errorcode", (Object)errorCode.getCode());
                    entry.set("errorcodedesc", (Object)errorCode.getDesc());
                    this.getModel().createNewEntryRow("errorcodeentity", entry);
                    index = this.getModel().getEntryRowCount("errorcodeentity");
                    ApiPluginUtil.handleMulLang(this.getModel(), "errorcodedesc", errorCode.getDescML(), index);
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684API\u4fe1\u606f\u3002", (String)"OpenApiCustomApiFormPlugin_29", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
    }

    private void setMserviceApiInfo(String className, String methodName) {
        List<MServiceDefineMeta.MethodDefine> methodDefines = MserviceUtil.getMethodInfosByClassName(className);
        if (!CollectionUtil.isNotEmpty(methodDefines)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684API\u4fe1\u606f\u3002", (String)"OpenApiCustomApiFormPlugin_29", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        this.setWebServiceInfo(className, methodName);
        for (MServiceDefineMeta.MethodDefine methodDefine : methodDefines) {
            if (!methodName.equals(methodDefine.getServiceMethodName())) continue;
            List serviceMethodParam = methodDefine.getServiceMethodParams();
            this.getModel().setValue(NAME, (Object)methodDefine.getServiceMethodName());
            String serviceMethodPath = methodDefine.getServiceMethodPath();
            if (serviceMethodPath.startsWith("/")) {
                serviceMethodPath = serviceMethodPath.substring(1);
            }
            this.getModel().setValue("number", (Object)serviceMethodPath);
            if (CollectionUtil.isNotEmpty((Collection)serviceMethodParam)) {
                this.addBodyTreeEntryProps(BODYENTRYENTITY, serviceMethodParam);
            }
            MServiceDefineMeta.ParamDefine methodReturnParamDefine = methodDefine.getServiceMethodReturnParamDefine();
            this.buildRespStruct();
            this.addRespTreeEntryProps(RESPENTRYENTITY, methodReturnParamDefine);
            break;
        }
    }

    private void addRespTreeEntryProps(String entryKey, MServiceDefineMeta.ParamDefine methodReturnParamDefine) {
        MServiceDefineMeta.ParamDefine data = new MServiceDefineMeta.ParamDefine();
        data.setName("data");
        data.setSimpleTypeStr(methodReturnParamDefine != null ? methodReturnParamDefine.getSimpleTypeStr() : "Object");
        data.setChildParamDefines(methodReturnParamDefine != null ? methodReturnParamDefine.getChildParamDefines() : null);
        data.setLevel(0);
        data.setDescribe("data");
        data.setArray(Boolean.FALSE.booleanValue());
        this.buildCustomApiParam(entryKey, (Object)0, data);
    }

    private void buildRespStruct() {
        DynamicObjectType objectType = this.getModel().getEntryEntity(RESPENTRYENTITY).getDynamicObjectType();
        DynamicObject entry = new DynamicObject(objectType);
        entry.set(RESPPARAMNAME, (Object)STATUS);
        entry.set(RESPPARAMTYPE, (Object)"boolean");
        entry.set(RESP_LEVEL, (Object)1);
        entry.set(RESPMULVALUE, (Object)"0");
        this.getModel().createNewEntryRow(RESPENTRYENTITY, entry);
        ApiPluginUtil.handleMulLang(this.getModel(), RESPDES, (ILocaleString)new LocaleString("Status: true - Success, false - Failed"), 1);
        ApiPluginUtil.handleMulLang(this.getModel(), RESPEXAMPLE, (ILocaleString)new LocaleString("false"), 1);
        DynamicObject entry1 = new DynamicObject(objectType);
        entry1.set(RESPPARAMNAME, (Object)"errorCode");
        entry1.set(RESPPARAMTYPE, (Object)"String");
        entry1.set(RESP_LEVEL, (Object)1);
        entry1.set(RESPMULVALUE, (Object)"0");
        this.getModel().createNewEntryRow(RESPENTRYENTITY, entry1);
        ApiPluginUtil.handleMulLang(this.getModel(), RESPDES, (ILocaleString)new LocaleString("ErrorCode"), 2);
        ApiPluginUtil.handleMulLang(this.getModel(), RESPEXAMPLE, (ILocaleString)new LocaleString(JSON.toJSONString((Object)RandomStringUtils.randomAlphanumeric((int)5))), 2);
        DynamicObject entry2 = new DynamicObject(objectType);
        entry2.set(RESPPARAMNAME, (Object)"message");
        entry2.set(RESPPARAMTYPE, (Object)"String");
        entry2.set(RESP_LEVEL, (Object)1);
        entry2.set(RESPMULVALUE, (Object)"0");
        this.getModel().createNewEntryRow(RESPENTRYENTITY, entry2);
        ApiPluginUtil.handleMulLang(this.getModel(), RESPDES, (ILocaleString)new LocaleString("Error Message"), 3);
        ApiPluginUtil.handleMulLang(this.getModel(), RESPEXAMPLE, (ILocaleString)new LocaleString(JSON.toJSONString((Object)RandomStringUtils.randomAlphanumeric((int)5))), 3);
    }

    private void addBodyTreeEntryProps(String entryKey, List<MServiceDefineMeta.ParamDefine> serviceMethodParam) {
        for (int i = 0; i < serviceMethodParam.size(); ++i) {
            MServiceDefineMeta.ParamDefine param = serviceMethodParam.get(i);
            this.buildCustomApiParam(entryKey, (Object)0, param);
        }
    }

    private void buildCustomApiParam(String entryKey, Object pid, MServiceDefineMeta.ParamDefine param) {
        if (param == null) {
            return;
        }
        DynamicObjectType objectType = this.getModel().getEntryEntity(entryKey).getDynamicObjectType();
        String paramName = BODYENTRYENTITY.equals(entryKey) ? PARAMNAME : RESPPARAMNAME;
        String paramType = BODYENTRYENTITY.equals(entryKey) ? PARAMTYPE : RESPPARAMTYPE;
        String isMust = BODYENTRYENTITY.equals(entryKey) ? MUST : RESPPARAMMUST;
        String example = BODYENTRYENTITY.equals(entryKey) ? EXAMPLE : RESPEXAMPLE;
        String desc = BODYENTRYENTITY.equals(entryKey) ? BODYPARAMDES : RESPDES;
        String levelName = BODYENTRYENTITY.equals(entryKey) ? BODY_LEVEL : RESP_LEVEL;
        String isMulValue = BODYENTRYENTITY.equals(entryKey) ? REQMULVALUE : RESPMULVALUE;
        DynamicObject entry = new DynamicObject(objectType);
        entry.set(paramName, (Object)param.getName());
        String simpleTypeStr = param.getSimpleTypeStr();
        entry.set(paramType, (Object)simpleTypeStr);
        entry.set(isMust, (Object)(param.isRequired() ? "1" : "0"));
        entry.set(levelName, (Object)(param.getLevel() + 1));
        entry.set(isMulValue, (Object)param.isMulValue());
        entry.set(PID, pid);
        this.getModel().createNewEntryRow(entryKey, entry);
        int index = this.getModel().getEntryRowCount(entryKey);
        this.getModel().setValue(isMulValue, (Object)param.isMulValue(), index - 1);
        ApiPluginUtil.handleMulLang(this.getModel(), desc, (ILocaleString)new LocaleString(param.getDescribe()), index);
        ApiPluginUtil.handleMulLang(this.getModel(), example, (ILocaleString)new LocaleString(JSON.toJSONString((Object)param.getExample(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat})), index);
        if (param.getChildParamDefines() != null && param.getChildParamDefines().size() > 0) {
            param.getChildParamDefines().forEach(it -> this.buildCustomApiParam(entryKey, entry.get(ID), (MServiceDefineMeta.ParamDefine)it));
        }
    }

    private void setWebServiceInfo(String className, String methodName) {
        this.getModel().setValue(INPUTPARAM, (Object)methodName);
        this.getModel().setValue(OUTPUTPARAM, (Object)(methodName + "Response"));
        String nameSpace = this.getModel().getValue(NAMESPACE).toString();
        if (StringUtil.isEmpty((String)nameSpace)) {
            this.setNameSpace(className);
        }
    }

    private CustomApiInfo getCustomApiInfo(String className, String methodName) {
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
        if (bizApp == null) {
            return null;
        }
        String customApiInfoJson = this.getPageCache().get(className + "_" + methodName);
        CustomApiInfo customApiInfo = customApiInfoJson != null ? (CustomApiInfo)JsonUtil.parseObject((Object)customApiInfoJson, CustomApiInfo.class, (Feature[])new Feature[0]) : CustomApiUtil.getCustomApiInfo((String)bizApp.getString("number"), (String)className, (String)methodName);
        return customApiInfo;
    }

    private void clearApiInfo() {
        this.clearValue("number", HTTPMETHOD, INPUTPARAM, OUTPUTPARAM);
        this.getModel().deleteEntryData(BODYENTRYENTITY);
        this.getModel().deleteEntryData(RESPENTRYENTITY);
    }

    private void clearValue(String ... args) {
        for (String arg : args) {
            this.getModel().setValue(arg, null);
        }
    }

    private List<ComboItem> buildApiDefTypeComboItem() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (ApiDefType type : ApiDefType.values()) {
            items.add(new ComboItem(new LocaleString(type.getName()), String.valueOf(type.getCode())));
        }
        return items;
    }

    public void afterCopyData(EventObject e) {
        String isvId = ISVServiceHelper.getISVInfo().getId();
        this.getModel().setValue("isvid", (Object)isvId);
        this.getView().getPageCache().put("isNew", "true");
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        String className = (String)this.getModel().getValue(CLASSNAME);
        String methodName = (String)this.getModel().getValue(METHODNAME);
        this.getMethodNamesByClassName(className);
        try {
            this.setApiInfo(className, methodName);
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"hiddenplugin"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"pvurlformat"});
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        String isasync = (String)showParameter.getCustomParam("isasync");
        ApiPluginUtil.updateAsyncUrlFlag(isasync, this.getModel());
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object object;
        super.closedCallBack(event);
        if (event.getActionId().equals("openapi_testapi_l")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_test"});
        }
        if ((object = event.getReturnData()) == null) {
            return;
        }
        try {
            Map reMap = (Map)object;
            String actionId = event.getActionId();
            if ("pluginRegister".equals(actionId)) {
                if (!reMap.isEmpty()) {
                    List pluginList = (List)reMap.get("value");
                    this.getModel().setValue(KEY_PLUGIN, (Object)SerializationUtils.toJsonString((Object)pluginList));
                }
            } else if ("indigesttemplate".equals(actionId) || "outdigesttemplate".equals(actionId)) {
                String script_text = (String)reMap.get("script_text");
                this.getModel().setValue(actionId, (Object)script_text);
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }
}

