/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IconProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.open.enums.ParamTypeEnum;
import kd.bos.openapi.base.util.DynamicPropertyUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.resource.MulLangUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.ComparatorUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.common.util.Triple;
import kd.bos.openapi.form.plugin.OpenApiFormPlugin;
import kd.bos.openapi.form.util.FormOpener;
import kd.bos.xdb.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiEntityPropertyPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener,
RowClickEventListener,
SearchEnterListener,
HyperLinkClickListener {
    private static Logger logger = LoggerFactory.getLogger(OpenApiEntityPropertyPlugin.class);
    private static final String DATA_TYPE = "data_type";
    private static final String PARAM_TYPE = "$type";
    public static final String OPERATION = "$operation";
    private static final String PARAM_DATA = "$data";
    private static final String NUMBER = "number";
    private static final String FULL_NUMBER = "full_number";
    private static final String KEY_TREE = "treeviewap";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_ENTRY_SELECT = "entryselect";
    private static final String KEY_SEARCH = "searchap";
    private static final String KEY_BTN_OK = "btn_ok";
    private static final String KEY_BTN_CANCEL = "btn_cancel";
    public static final String ML_STRING = "ml_string";
    public static final String A_ML_STRING = "@ml_string";
    public static final String REF = "REF";
    public static final String A_REF = "@REF";
    private static final String IS_BATCH = "$isBatch";
    public static final String ENTITY_ID = "entityId";
    public static final String NAME = "name";
    public static final String ENTRIES = "Entries";
    public static final String REQUIRED = "required";
    public static final String PARENT_DATA_TYPE = "parent_data_type";
    public static final String A_ENTRIES = "@Entries";
    public static final String $_ROW = "$row";
    public static final String $_SHOW_PROPERTY = "$ShowProperty";
    public static final String VALUE = "value";
    public static final String ENABLE_REF = "enable_ref";
    public static final String DATA_SCHEMA = "data_schema";
    public static final String IS_PARENT = "is_parent";
    public static final String NOT_SELECT = "not_select";
    public static final String SELECT_ROWS_HIS = "SelectRowsHis";
    public static final String MAX_A_REF_MINUS_2 = "@REF";
    public static final String MAX_A_REF_MINUS_1 = "@REF@REF";
    public static final String MAX_A_REF = "@REF@REF@REF";
    public static final String MAX_A_REF_PLUS_1 = "@REF@REF@REF@REF";
    public static final String MAX_ENTRIES_A_REF = "@Entries@REF@REF";
    public static final String MAX_ENTRIES_A_REF_PLUS_1 = "@Entries@REF@REF@REF";
    public static final String PARENT_ALL_TYPE = "parent_all_type";
    private static final String BOS_OPEN_FORMPLUGIN = "bos-open-formplugin";
    public static final String ISLINKENTRY = "islinkentry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_CANCEL, KEY_ENTRY_ENTITY});
        EntryGrid entry = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        entry.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String entityId = DataUtil.s(params.get(ENTITY_ID));
        if (entityId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u4e1a\u52a1\u5bf9\u8c61\u5b9e\u4f53ID\uff0c\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u6027\u3002", (String)"OpenApiEntityPropertyPlugin_0", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(IS_BATCH, DataUtil.s((Object)params.getOrDefault(IS_BATCH, Boolean.TRUE)));
        this.getPageCache().put(PARAM_TYPE, DataUtil.s(params.get(PARAM_TYPE)));
        this.getPageCache().put($_ROW, DataUtil.s(params.get($_ROW)));
        this.getPageCache().put($_SHOW_PROPERTY, DataUtil.s((Object)params.getOrDefault($_SHOW_PROPERTY, ShowProperty.PROPERTY.name())));
        this.getPageCache().put(ENABLE_REF, DataUtil.s((Object)params.getOrDefault(ENABLE_REF, Boolean.TRUE)));
        this.getPageCache().put(ISLINKENTRY, DataUtil.s((Object)params.getOrDefault(ISLINKENTRY, Boolean.FALSE)));
        this.getPageCache().put(OPERATION, DataUtil.s(params.get(OPERATION)));
        this.initTree(entityId);
        this.isMul();
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        try {
            MainEntityType entityType;
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
            String currNodeId = evt.getNodeId().toString();
            String currId = currNodeId.substring(0, currNodeId.indexOf(64));
            DynamicProperty currProp = null;
            DynamicProperty parentProp = null;
            int index = currNodeId.indexOf(46);
            if (index > 0) {
                String[] nums = currId.split("\\.");
                MainEntityType main = EntityMetadataCache.getDataEntityType((String)nums[0]);
                Triple<DynamicObjectType, DynamicProperty, DynamicProperty> triple = this.getCurrProperty(nums, (DynamicObjectType)main, 1, null);
                entityType = (DynamicObjectType)triple.getA();
                currProp = (DynamicProperty)triple.getB();
                parentProp = (DynamicProperty)triple.getC();
            } else {
                entityType = EntityMetadataCache.getDataEntityType((String)currId);
            }
            List<TreeNode> childNodes = this.getChildNodes(currNodeId, currId, (DynamicObjectType)entityType, parentProp, currProp);
            treeView.addNodes(childNodes);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private List<TreeNode> getChildNodes(String currNodeId, String currId, DynamicObjectType entityType, DynamicProperty parentProp, DynamicProperty currProp) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
        String show = this.getPageCache().get($_SHOW_PROPERTY);
        boolean isParentRef = currNodeId.contains(".") && currNodeId.endsWith("@REF");
        Triple<Boolean, Set<String>, Boolean> refPropPair = this.getRefProp(currProp, null);
        for (IDataEntityProperty property : entityType.getProperties()) {
            Triple<Boolean, Set<String>, Boolean> refProp;
            if (((Boolean)refPropPair.getA()).booleanValue() && !((Set)refPropPair.getB()).contains(property.getName()) || DynamicPropertyUtil.notIncludeProperty((IDataEntityProperty)property) || property instanceof FlexProp || property instanceof LinkEntryProp && !this.getPageCache().get(ISLINKENTRY).equalsIgnoreCase("true") || currProp instanceof MulBasedataProp && (property instanceof MulBasedataProp || property instanceof EntryProp) || parentProp instanceof MulBasedataProp) continue;
            String type = this.getPropertyType(property);
            if (isParentRef && !REF.equals(type) || !REF.equals(type) && !ENTRIES.equals(type) || ShowProperty.PROPERTY.name().equals(show) && !REF.equals(type) || ShowProperty.ENTRIES.name().equals(show) && REF.equals(type) || ShowProperty.REF.name().equals(show) && ENTRIES.equals(type) || ShowProperty.NOT_MB_PROPERTY.name().equals(show) && property instanceof MulBasedataProp || this.notDbField(property)) continue;
            TreeNode childNode = new TreeNode();
            childNode.setParentid(currNodeId);
            childNode.setType(property.getClass().getSimpleName());
            String text = this.getPropertyName(property).getLocaleValue();
            String id = currId + "." + property.getName() + currNodeId.substring(currNodeId.indexOf(64));
            if (REF.equals(type)) {
                if ((id = id + "@REF").endsWith(MAX_A_REF_PLUS_1) || id.endsWith(MAX_ENTRIES_A_REF_PLUS_1)) continue;
                refProp = this.getRefProp((DynamicProperty)property, entityType);
                if (!id.endsWith(MAX_A_REF) && !id.endsWith(MAX_ENTRIES_A_REF) && ((Boolean)refProp.getA()).booleanValue() && ((Boolean)refProp.getC()).booleanValue()) {
                    childNode.setChildren(new ArrayList());
                }
            } else if (ML_STRING.equals(type)) {
                id = id + A_ML_STRING;
            } else if (ENTRIES.equals(type)) {
                childNode.setChildren(new ArrayList());
                if (property instanceof MulBasedataProp) {
                    text = String.format(ResManager.loadKDString((String)"%s [ \u591a\u9009\u57fa\u7840\u8d44\u6599 ]", (String)"OpenApiEntityPropertyPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), text);
                    refProp = this.getRefProp((DynamicProperty)property, entityType);
                    if (!((Boolean)refProp.getA()).booleanValue() || !((Boolean)refProp.getC()).booleanValue()) {
                        childNode.setChildren(null);
                    }
                } else if (property instanceof FlexProp) {
                    text = String.format(ResManager.loadKDString((String)"%s [ \u5f39\u6027\u57df ]", (String)"OpenApiEntityPropertyPlugin_2", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), text);
                    childNode.setChildren(null);
                } else {
                    text = String.format(ResManager.loadKDString((String)"%s [ \u5206\u5f55 ]", (String)"OpenApiEntityPropertyPlugin_3", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), text);
                }
                id = id + A_ENTRIES;
            }
            if (currProp instanceof MulBasedataProp) {
                childNode.setChildren(null);
            }
            childNode.setId(id);
            childNode.setText(text);
            childNodes.add(childNode);
        }
        return childNodes;
    }

    private boolean notDbField(IDataEntityProperty property) {
        String operation = this.getPageCache().get(OPERATION);
        if (!"query".equals(operation)) {
            return false;
        }
        boolean notDbField = StringUtils.isBlank((CharSequence)property.getAlias()) && property.isDbIgnore();
        return notDbField;
    }

    private Triple<DynamicObjectType, DynamicProperty, DynamicProperty> getCurrProperty(String[] nums, DynamicObjectType entityType, int index, DynamicProperty parent) {
        if (nums.length == 1) {
            return new Triple((Object)entityType, null, (Object)parent);
        }
        String num = nums[index];
        DynamicProperty property = entityType.getProperty(num);
        if (property instanceof FlexProp) {
            FlexProp prop = (FlexProp)property;
            DynamicObjectType objectType = prop.getFlexDataType();
            return new Triple((Object)objectType, (Object)property, (Object)parent);
        }
        if (property instanceof BasedataProp) {
            BasedataProp prop = (BasedataProp)property;
            String entityId = prop.getBaseEntityId();
            MainEntityType objectType = EntityMetadataCache.getDataEntityType((String)entityId);
            if (++index == nums.length) {
                return new Triple((Object)objectType, (Object)property, (Object)parent);
            }
            return this.getCurrProperty(nums, (DynamicObjectType)objectType, index, (DynamicProperty)prop);
        }
        if (property instanceof MuliLangTextProp) {
            if (++index != nums.length) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u5b57\u6bb5 %1$s \u4e0d\u662f\u672b\u7ea7\u3002", (String)"OpenApiEntityPropertyPlugin_4", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), new Object[0]);
            }
            MuliLangTextProp prop = (MuliLangTextProp)property;
            MainEntityType type = MainEntityType.Empty;
            type.getProperties().clear();
            for (Map.Entry entry : prop.getDisplayName().entrySet()) {
                TextProp textProp = new TextProp();
                textProp.setName((String)entry.getKey());
                textProp.setDisplayName(new LocaleString((String)entry.getKey()));
                type.getProperties().add((Object)textProp);
            }
            return new Triple((Object)type, (Object)property, (Object)parent);
        }
        if (property instanceof EntryProp) {
            EntryProp prop = (EntryProp)property;
            DynamicObjectType type = prop.getDynamicCollectionItemPropertyType();
            if (++index == nums.length) {
                return new Triple((Object)type, (Object)property, (Object)parent);
            }
            return this.getCurrProperty(nums, type, index, (DynamicProperty)prop);
        }
        if (property instanceof MulBasedataProp) {
            MulBasedataProp prop = (MulBasedataProp)property;
            String entityId = prop.getBaseEntityId();
            MainEntityType objectType = EntityMetadataCache.getDataEntityType((String)entityId);
            if (++index == nums.length) {
                return new Triple((Object)objectType, (Object)property, (Object)parent);
            }
            return this.getCurrProperty(nums, (DynamicObjectType)objectType, index, (DynamicProperty)prop);
        }
        if (property instanceof RefBillProp) {
            RefBillProp prop = (RefBillProp)property;
            String entityId = prop.getBillEntityId();
            MainEntityType objectType = EntityMetadataCache.getDataEntityType((String)entityId);
            if (++index == nums.length) {
                return new Triple((Object)objectType, (Object)property, (Object)parent);
            }
            return this.getCurrProperty(nums, (DynamicObjectType)objectType, index, (DynamicProperty)prop);
        }
        throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u89e3\u6790\u5c5e\u6027 %s \u5931\u8d25", (String)"OpenApiEntityPropertyPlugin_5", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), new Object[]{num});
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        try {
            String currNodeId = evt.getNodeId().toString();
            if (null != this.getPageCache().get("currNodeId") && this.getPageCache().get("currNodeId").equals(currNodeId)) {
                return;
            }
            int index = currNodeId.indexOf(46);
            this.getPageCache().put(SELECT_ROWS_HIS, null);
            if (index > 0) {
                String currId = currNodeId.substring(0, currNodeId.indexOf(64));
                String[] nums = currId.split("\\.");
                MainEntityType main = EntityMetadataCache.getDataEntityType((String)nums[0]);
                Triple<DynamicObjectType, DynamicProperty, DynamicProperty> triple = this.getCurrProperty(nums, (DynamicObjectType)main, 1, null);
                DynamicObjectType entityType = (DynamicObjectType)triple.getA();
                this.showNodeProperty(currId.substring(currId.indexOf(46) + 1), entityType, currNodeId, evt.getParentNodeId().toString(), (DynamicProperty)triple.getB(), (DynamicProperty)triple.getC());
            } else {
                String currId = currNodeId.substring(0, currNodeId.indexOf(64));
                MainEntityType main = EntityMetadataCache.getDataEntityType((String)currId);
                this.showNodeProperty(null, (DynamicObjectType)main, "@REF", "", null, null);
            }
            if (!currNodeId.equals(this.getPageCache().get("currNodeId"))) {
                this.entryRowSelect(currNodeId);
            }
            this.getPageCache().put("currNodeId", currNodeId);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void initTree(String entityId) {
        MainEntityType main = EntityMetadataCache.getDataEntityType((String)entityId);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.deleteAllNodes();
        treeView.setMulti(false);
        String nodeId = entityId + "@REF";
        this.getPageCache().put("currNodeId", nodeId);
        TreeNode root = new TreeNode(null, nodeId, main.getDisplayName().getLocaleValue(), true);
        root.setExpend(true);
        root.setType(REF);
        root.setChildren(new ArrayList());
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.expand(nodeId);
        treeView.focusNode(root);
        List<TreeNode> childNodes = this.getChildNodes(nodeId, entityId, (DynamicObjectType)main, null, null);
        treeView.addNodes(childNodes);
        this.showNodeProperty(null, (DynamicObjectType)main, "@REF", "", null, null);
    }

    private void showNodeProperty(String parentNum, DynamicObjectType type, String parentNodeId, String parentParentNodeId, DynamicProperty currProp, DynamicProperty parentProp) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        collection.clear();
        boolean isParentRef = !parentNodeId.equals("@REF") && parentNodeId.endsWith("@REF");
        String parentDataType = this.getParentDataType(parentParentNodeId, parentNodeId);
        if (currProp instanceof FlexProp) {
            this.initProp("id", parentNum, currProp, collection, parentDataType);
            this.initProp(NUMBER, parentNum, currProp, collection, parentDataType);
            this.initProp(NAME, parentNum, currProp, collection, parentDataType);
            this.getView().updateView(KEY_ENTRY_ENTITY);
            return;
        }
        Triple<Boolean, Set<String>, Boolean> refProp = this.getRefProp(currProp, type);
        String show = this.getPageCache().get($_SHOW_PROPERTY);
        boolean isSelectFirst = false;
        if (show.contains(ShowProperty.ENTRIES.name())) {
            IDataEntityType parent;
            EntryProp entryProp;
            if (currProp instanceof EntryProp) {
                entryProp = (EntryProp)currProp;
                this.initParentProperty(collection.addNew(), parentNum, entryProp.getName(), this.getPropertyName((IDataEntityProperty)entryProp), this.getPropertyType((IDataEntityProperty)entryProp), this.getDefaultValue((IDataEntityProperty)entryProp), entryProp.getClass().getSimpleName(), entryProp.isEntryMustInput(), parentParentNodeId);
                isSelectFirst = true;
            } else if (currProp instanceof MulBasedataProp) {
                entryProp = (MulBasedataProp)currProp;
                this.initParentProperty(collection.addNew(), parentNum, entryProp.getName(), this.getPropertyName((IDataEntityProperty)entryProp), this.getPropertyType((IDataEntityProperty)entryProp), this.getDefaultValue((IDataEntityProperty)entryProp), entryProp.getClass().getSimpleName(), entryProp.isMustInput(), parentParentNodeId);
                isSelectFirst = true;
            } else if (parentParentNodeId != null && parentParentNodeId.endsWith(A_ENTRIES) && (parent = currProp.getParent()) instanceof EntryType) {
                EntryProp entryProp2 = (EntryProp)parent.getParent().getProperties().get((Object)parent.getName());
                this.initParentProperty(collection.addNew(), parentNum.substring(0, parentNum.lastIndexOf(46)), entryProp2.getName(), this.getPropertyName((IDataEntityProperty)entryProp2), this.getPropertyType((IDataEntityProperty)entryProp2), this.getDefaultValue((IDataEntityProperty)entryProp2), entryProp2.getClass().getSimpleName(), entryProp2.isEntryMustInput(), parentParentNodeId.substring(0, parentParentNodeId.lastIndexOf(64)));
                isSelectFirst = true;
            }
        }
        for (IDataEntityProperty property : type.getProperties()) {
            String dataType;
            if (((Boolean)refProp.getA()).booleanValue() && !((Set)refProp.getB()).contains(property.getName()) || DynamicPropertyUtil.notIncludeProperty((IDataEntityProperty)property) || currProp instanceof RefBillProp && !property.getName().equals("id") && !property.getName().equals("billno") || REF.equals(dataType = this.getPropertyType(property)) || isParentRef && REF.equals(dataType) || StringUtils.isNotEmpty((CharSequence)parentParentNodeId) && parentParentNodeId.contains("@") && isParentRef && ENTRIES.equals(dataType) || (ShowProperty.ONLY_PROPERTY.name().equals(show) || ShowProperty.NOT_MB_PROPERTY.name().equals(show) || ShowProperty.REAL_ENTRIES.name().equals(show)) && (REF.equals(dataType) || ENTRIES.equals(dataType)) || ShowProperty.PROPERTY.name().equals(show) && (ENTRIES.equals(dataType) || DataType.FLEX.type().equals(dataType)) || ShowProperty.ENTRIES.name().equals(show) && (REF.equals(dataType) || ENTRIES.equals(dataType)) || ShowProperty.REF.name().equals(show) && ENTRIES.equals(dataType) || ShowProperty.REF_ENTRIES.name().equals(show) && ENTRIES.equals(dataType) || this.notDbField(property)) continue;
            DynamicObject row = collection.addNew();
            row.set(NUMBER, (Object)property.getName());
            row.set(FULL_NUMBER, (Object)((StringUtils.isEmpty((CharSequence)parentNum) ? "" : parentNum + ".") + property.getName()));
            row.set(NAME, (Object)this.getPropertyName2((IDataEntityProperty)currProp, property));
            row.set(DATA_TYPE, (Object)dataType);
            boolean required = false;
            if (property instanceof FieldProp) {
                required = ((FieldProp)property).isMustInput();
            } else if (property instanceof EntryProp) {
                required = ((EntryProp)property).isEntryMustInput();
            } else if (property instanceof BasedataProp) {
                required = ((BasedataProp)property).isMustInput();
            } else if (property instanceof MulBasedataProp) {
                required = ((MulBasedataProp)property).isMustInput();
            }
            row.set(REQUIRED, (Object)required);
            row.set(PARENT_DATA_TYPE, (Object)parentDataType);
            row.set(VALUE, this.getDefaultValue(property));
            row.set(DATA_SCHEMA, (Object)property.getClass().getSimpleName());
            row.set(PARENT_ALL_TYPE, this.getParentAllType(parentNodeId));
            if (!(property instanceof ComboProp) || property instanceof MulComboProp || property instanceof ItemClassTypeProp || !"respentryentity".equals(this.getPageCache().get(PARAM_TYPE))) continue;
            this.initComboPropTitle(parentNum, parentNodeId, currProp, collection, parentDataType, property, dataType, required);
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private void initComboPropTitle(String parentNum, String parentNodeId, DynamicProperty currProp, DynamicObjectCollection collection, String parentDataType, IDataEntityProperty property, String dataType, boolean required) {
        DynamicObject row = collection.addNew();
        row.set(NUMBER, (Object)(property.getName() + "_title"));
        row.set(FULL_NUMBER, (Object)((StringUtils.isEmpty((CharSequence)parentNum) ? "" : parentNum + ".") + property.getName() + "_title"));
        LocaleString ls = new LocaleString();
        LocaleString comboStr = this.getComboItem(property);
        comboStr.forEach((k, v) -> {
            String preStr = currProp == null ? (String)this.getPropertyName(property).getItem(k) : (String)this.getPropertyName((IDataEntityProperty)currProp).getItem(k) + "." + (String)this.getPropertyName(property).getItem(k);
            LocaleString titleLs = ResManager.getLocaleString((String)"%1$s_\u6807\u9898(\u82e5\u8fd4\u56de\u6807\u9898\u8bf7\u540c\u6b65\u8fd4\u56de\u5bf9\u5e94\u6807\u9898\u503c)%2$s", (String)"OpenApiEntityPropertyPlugin_14", (String)BOS_OPEN_FORMPLUGIN);
            String str = String.format(titleLs.getItem(k) != null ? (String)titleLs.getItem(k) : titleLs.toString(), preStr, comboStr);
            ls.setItem(k, (Object)str);
        });
        this.handleMulLang(ls, (OrmLocaleValue)row.getLocaleString(NAME));
        row.set(DATA_TYPE, (Object)dataType);
        row.set(REQUIRED, (Object)required);
        row.set(PARENT_DATA_TYPE, (Object)parentDataType);
        ComboProp prop = (ComboProp)property;
        String value = "00";
        if (prop.getComboItems().size() > 0) {
            value = ((ValueMapItem)prop.getComboItems().get(0)).getName().getLocaleValue();
        }
        row.set(VALUE, (Object)JSON.toJSONString((Object)value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
        row.set(DATA_SCHEMA, (Object)"$combofield_titleProp$");
        row.set(PARENT_ALL_TYPE, this.getParentAllType(parentNodeId));
    }

    private Object getParentAllType(String parentNodeId) {
        return parentNodeId.substring(parentNodeId.indexOf(64) + 4);
    }

    private void initParentProperty(DynamicObject row, String parentNum, String name, LocaleString propertyName, String propertyType, Object defaultValue, String classSimpleName, boolean isMustInput, String parentNodeId) {
        row.set(NUMBER, (Object)name);
        row.set(FULL_NUMBER, (Object)parentNum);
        this.handleMulLang(propertyName, (OrmLocaleValue)row.getLocaleString(NAME));
        row.set(DATA_TYPE, (Object)propertyType);
        row.set(PARENT_DATA_TYPE, (Object)"XXX@Entries");
        row.set(VALUE, defaultValue);
        row.set(DATA_SCHEMA, (Object)classSimpleName);
        row.set(IS_PARENT, (Object)Boolean.TRUE);
        row.set(REQUIRED, (Object)isMustInput);
        row.set(PARENT_ALL_TYPE, this.getParentAllType(parentNodeId));
    }

    private void handleMulLang(LocaleString src, OrmLocaleValue tar) {
        if (src == null || tar == null) {
            return;
        }
        tar.clear();
        tar.putAll((Map)src);
    }

    private void initProp(String propNum, String parentNum, DynamicProperty currProp, DynamicObjectCollection collection, String parentDataType) {
        DynamicObject row = collection.addNew();
        row.set(NUMBER, (Object)propNum);
        row.set(FULL_NUMBER, (Object)((StringUtils.isEmpty((CharSequence)parentNum) ? "" : parentNum + ".") + propNum));
        OrmLocaleValue nameLs = (OrmLocaleValue)row.getLocaleString(NAME);
        if ("id".equals(propNum)) {
            this.handleMulLang(MulLangUtil.getLocaleStringBySingle((String)"id"), nameLs);
        } else if (NUMBER.equals(propNum)) {
            this.handleMulLang(ResManager.getLocaleString((String)"\u7f16\u7801", (String)"OpenApiEntityPropertyPlugin_6", (String)BOS_OPEN_FORMPLUGIN), nameLs);
        } else {
            this.handleMulLang(ResManager.getLocaleString((String)"\u540d\u79f0", (String)"OpenApiEntityPropertyPlugin_7", (String)BOS_OPEN_FORMPLUGIN), nameLs);
        }
        row.set(NAME, (Object)nameLs);
        row.set(DATA_TYPE, (Object)("id".equals(propNum) ? DataType.LONG.type() : DataType.STRING.type()));
        row.set(REQUIRED, (Object)Boolean.FALSE);
        row.set(PARENT_DATA_TYPE, (Object)parentDataType);
        row.set(VALUE, (Object)("\"" + ("id".equals(propNum) ? DataType.LONG.defaultValue() : DataType.STRING.defaultValue()) + "\""));
        row.set(DATA_SCHEMA, (Object)("id".equals(propNum) ? LongProp.class.getSimpleName() : (NUMBER.equals(propNum) ? TextProp.class.getSimpleName() : MuliLangTextProp.class.getSimpleName())));
    }

    private String getParentDataType(String parentParentNodeId, String parentNodeId) {
        String parentParentDataType = "@";
        if (StringUtils.isNotEmpty((CharSequence)parentParentNodeId) && parentParentNodeId.contains("@")) {
            parentParentDataType = parentParentNodeId.substring(parentParentNodeId.lastIndexOf(64) + 1) + "@";
        }
        return parentParentDataType + (parentNodeId.contains("@") ? parentNodeId.substring(parentNodeId.lastIndexOf(64) + 1) : "");
    }

    private Triple<Boolean, Set<String>, Boolean> getRefProp(DynamicProperty rootProp, DynamicObjectType type) {
        boolean enableRef = DataUtil.x((Object)this.getPageCache().get(ENABLE_REF));
        if (!enableRef) {
            return new Triple((Object)Boolean.FALSE, null, null);
        }
        HashSet<String> refSet = new HashSet<String>();
        boolean isRef = false;
        boolean childHasRef = false;
        if (rootProp instanceof BasedataProp) {
            isRef = true;
            BasedataProp prop = (BasedataProp)rootProp;
            DynamicObjectType complexPropertyType = prop.getDynamicComplexPropertyType();
            for (IDataEntityProperty property : complexPropertyType.getProperties()) {
                if (property instanceof BasedataProp) {
                    childHasRef = true;
                }
                refSet.add(property.getName());
            }
        } else if (rootProp instanceof MulBasedataProp) {
            MulBasedataProp prop = (MulBasedataProp)rootProp;
            DynamicObjectType itemPropertyType = prop.getDynamicCollectionItemPropertyType();
            DynamicProperty property = itemPropertyType.getProperty("fbasedataid");
            return this.getRefProp(property, type);
        }
        return new Triple((Object)isRef, refSet, (Object)childHasRef);
    }

    private Object getDefaultValue(IDataEntityProperty property) {
        Object value = null;
        if (property instanceof MulComboProp) {
            value = "000";
        } else if (property instanceof ComboProp) {
            ComboProp prop = (ComboProp)property;
            value = prop.getDefValue();
            if (value == null) {
                value = prop.getComboItems().size() > 0 ? ((ValueMapItem)prop.getComboItems().get(0)).getValue() : "00";
            }
        } else {
            BasedataEntityType parent;
            value = property instanceof LongProp ? (property.getParent() instanceof BasedataEntityType ? ("bos_user".equals((parent = (BasedataEntityType)property.getParent()).getName()) ? DataType.INTEGER.defaultValue() : DataType.LONG.defaultValue()) : DataType.LONG.defaultValue()) : (property instanceof TextProp || property instanceof PictureProp ? DataType.STRING.defaultValue() : (property instanceof UserProp ? String.valueOf(RequestContext.get().getCurrUserId()) : (property instanceof DateProp ? DataType.DATE.defaultValue() : (property instanceof DateTimeProp ? DataType.DATE_TIME.defaultValue() : (property instanceof BooleanProp ? ((BooleanProp)property).getDefValue() : (property instanceof BigIntProp ? DataType.LONG.defaultValue() : (property instanceof IntegerProp || property instanceof TimeProp ? DataType.INTEGER.defaultValue() : (property instanceof DecimalProp ? DataType.DECIMAL.defaultValue() : (property instanceof FlexProp ? DataType.FLEX.defaultValue() : (property instanceof EntryProp || property instanceof MulBasedataProp ? DataType.ENTRIES.defaultValue() : (property instanceof BasedataProp ? "0" : (property instanceof VarcharProp ? ((VarcharProp)property).genPKValue() : (property instanceof AdminDivisionProp ? DataType.STRING.defaultValue() : (property instanceof IconProp ? DataType.STRING.defaultValue() : DataType.STRING.defaultValue()))))))))))))));
        }
        return JSON.toJSONString((Object)value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    public LocaleString getPropertyName2(IDataEntityProperty parentProp, IDataEntityProperty currProp) {
        LocaleString comboStr = this.getComboItem(currProp);
        LocaleString curr = this.getPropertyName(currProp);
        LocaleString ls = new LocaleString();
        curr.forEach((k, v) -> {
            String item = (String)comboStr.getItem(k);
            if (item == null) {
                item = "";
            }
            ls.setItem(k, (Object)(parentProp == null ? (String)curr.getItem(k) : ((String)this.getPropertyName(parentProp).getItem(k) + "." + (String)curr.getItem(k) + " " + item).trim()));
        });
        return ls;
    }

    private LocaleString getComboItem(IDataEntityProperty currProp) {
        ComboProp comboProp;
        List items;
        if (currProp instanceof BillStatusProp) {
            BillStatusProp billStatusProp = (BillStatusProp)currProp;
            List items2 = billStatusProp.getStatusItems();
            if (CollectionUtil.isNotEmpty((Collection)items2)) {
                LocaleString itemLs = new LocaleString();
                BillStatusProp.StatusItemPro pro = (BillStatusProp.StatusItemPro)items2.get(0);
                pro.getStatusName().forEach((k, v) -> itemLs.setItem(k, (Object)items2.stream().map(it -> it.getStatusKey() + ":" + (String)it.getStatusName().getItem(k)).collect(Collectors.toList()).toString()));
                return itemLs;
            }
        } else if (currProp instanceof ComboProp && CollectionUtil.isNotEmpty((Collection)(items = (comboProp = (ComboProp)currProp).getComboItems()))) {
            LocaleString itemLs = new LocaleString();
            ValueMapItem pro = (ValueMapItem)items.get(0);
            pro.getName().forEach((k, v) -> itemLs.setItem(k, (Object)items.stream().map(it -> it.getValue() + ":" + (String)it.getName().getItem(k)).collect(Collectors.toList()).toString()));
            return itemLs;
        }
        return new LocaleString("");
    }

    private LocaleString getPropertyName(IDataEntityProperty property) {
        return property.getDisplayName() == null ? MulLangUtil.getLocaleStringBySingle((String)property.getName()) : property.getDisplayName();
    }

    private String getPropertyType(IDataEntityProperty property) {
        Class clazz = property.getPropertyType();
        if (property instanceof FlexProp) {
            return DataType.FLEX.type();
        }
        if (property instanceof EntryProp) {
            return DataType.ENTRIES.type();
        }
        if (clazz.equals(ILocaleString.class)) {
            return ML_STRING;
        }
        if (property instanceof BasedataProp) {
            return REF;
        }
        if (property instanceof RefBillProp) {
            return REF;
        }
        if (property instanceof MulBasedataProp) {
            return DataType.ENTRIES.type();
        }
        if (property instanceof DateProp) {
            return DataType.DATE.type();
        }
        if (property instanceof DateTimeProp) {
            return DataType.DATE_TIME.type();
        }
        if (clazz.equals(Integer.class)) {
            return DataType.INTEGER.type();
        }
        if (property instanceof BigIntProp) {
            return DataType.LONG.type();
        }
        if (property instanceof IntegerProp) {
            return DataType.INTEGER.type();
        }
        if (property instanceof DecimalProp) {
            return DataType.DECIMAL.type();
        }
        return ParamTypeEnum.getParamTypeByPropertyType(clazz).getType();
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        this.getView().updateView(KEY_ENTRY_ENTITY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        String text = searchEnterEvent.getText();
        if (entryEntity.isEmpty() || StringUtil.isEmpty((String)text)) {
            return;
        }
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject o = (DynamicObject)entryEntity.get(i);
            String fullNumber = o.getString(FULL_NUMBER);
            String name = o.getString(NAME);
            if (!fullNumber.contains(text) && !name.contains(text)) continue;
            indexs.add(i);
        }
        if (indexs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e!", (String)"OpenApiEntityPropertyPlugin_8", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        int[] rows = indexs.stream().mapToInt(Integer::valueOf).toArray();
        grid.setRowBackcolor("#eff3fd", rows);
        grid.focusCell(rows[0], NUMBER);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_ok": {
                boolean isBatch = DataUtil.x((Object)this.getPageCache().get(IS_BATCH));
                if (isBatch) {
                    DynamicObjectCollection entrySelects = this.getModel().getEntryEntity(KEY_ENTRY_SELECT);
                    if (entrySelects.size() == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u3002", (String)"OpenApiEntityPropertyPlugin_9", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                    }
                    this.checkPropSelect("s", entrySelects);
                    break;
                }
                EntryGrid entry = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
                int[] rows = entry.getSelectRows();
                if (rows.length != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u3002", (String)"OpenApiEntityPropertyPlugin_10", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection collection = new DynamicObjectCollection();
                collection.add(this.getModel().getEntryEntity(KEY_ENTRY_ENTITY).get(rows[0]));
                this.getView().returnDataToParent(this.getBatchSelectedRowData("", collection));
                this.getView().close();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
                break;
            }
        }
    }

    private Map<String, Object> getBatchSelectedRowData(String prefix, DynamicObjectCollection entrySelects) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(entrySelects.size());
        for (DynamicObject entrySelect : entrySelects) {
            list.add(this.toMap(prefix, entrySelect));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put(PARAM_TYPE, this.getPageCache().get(PARAM_TYPE));
        map.put($_ROW, this.getPageCache().get($_ROW));
        List collect = list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Map>(Comparator.comparing(it -> DataUtil.s(it.get(FULL_NUMBER)), ComparatorUtil.getStringComparator()))), ArrayList::new));
        map.put(PARAM_DATA, collect);
        return map;
    }

    private void checkPropSelect(String prefix, DynamicObjectCollection entrySelects) {
        String fullNumName = prefix + FULL_NUMBER;
        Set fullNumSet = entrySelects.stream().map(it -> it.getString(fullNumName)).collect(Collectors.toSet());
        TreeSet<String> notSelectSet = new TreeSet<String>(ComparatorUtil.getStringComparator());
        for (DynamicObject map : entrySelects) {
            int dotCount;
            String upNum;
            String parentAllType;
            String parentDataType;
            String fullNumber = map.getString(fullNumName);
            String[] nums = fullNumber.split("\\.");
            Pair<String, String> dataType = OpenApiFormPlugin.getParentDataType(map.getString(prefix + PARENT_DATA_TYPE));
            String ppDataType = (String)dataType.getKey();
            if (OpenApiFormPlugin.isFirstLevel(ppDataType, parentDataType = (String)dataType.getValue(), nums, parentAllType = map.getString(prefix + PARENT_ALL_TYPE)) || fullNumSet.contains(upNum = String.join((CharSequence)".", Arrays.copyOfRange(nums, 0, nums.length - (dotCount = OpenApiFormPlugin.getDotCount(ppDataType, parentDataType, parentAllType)))))) continue;
            notSelectSet.add(upNum);
        }
        if (notSelectSet.isEmpty()) {
            this.getView().returnDataToParent(this.getBatchSelectedRowData(prefix, entrySelects));
            this.getView().close();
            return;
        }
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u5c5e\u6027 %s  \u672a\u9009\u62e9\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OpenApiEntityPropertyPlugin_11", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), notSelectSet), MessageBoxOptions.YesNo, new ConfirmCallBackListener(NOT_SELECT));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (NOT_SELECT.equals(callBackId)) {
            if (event.getResult() == MessageBoxResult.No) {
                return;
            }
            DynamicObjectCollection entrySelects = this.getModel().getEntryEntity(KEY_ENTRY_SELECT);
            this.getView().returnDataToParent(this.getBatchSelectedRowData("s", entrySelects));
            this.getView().close();
        }
    }

    private Map<String, Object> toMap(String prefix, DynamicObject rowEntity) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put(NUMBER, rowEntity.get(prefix + NUMBER));
        map.put(FULL_NUMBER, rowEntity.get(prefix + FULL_NUMBER));
        map.put(NAME, rowEntity.get(prefix + NAME));
        map.put(DATA_TYPE, rowEntity.get(prefix + DATA_TYPE));
        map.put(REQUIRED, rowEntity.get(prefix + REQUIRED));
        map.put(PARENT_DATA_TYPE, rowEntity.get(prefix + PARENT_DATA_TYPE));
        map.put(VALUE, rowEntity.get(prefix + VALUE));
        map.put(DATA_SCHEMA, rowEntity.get(prefix + DATA_SCHEMA));
        map.put(IS_PARENT, rowEntity.get(prefix + IS_PARENT));
        map.put(PARENT_ALL_TYPE, rowEntity.get(prefix + PARENT_ALL_TYPE));
        return map;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        boolean isBatch = DataUtil.x((Object)this.getPageCache().get(IS_BATCH));
        if (isBatch) {
            this.addSelectFields();
            DynamicObjectCollection selects = this.getModel().getEntryEntity(KEY_ENTRY_SELECT);
            Label label = (Label)this.getView().getControl("labelcount");
            label.setText(String.format(ResManager.loadKDString((String)"\u5df2\u9009\uff08%s\uff09", (String)"OpenApiEntityPropertyPlugin_13", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), selects.size()));
        }
    }

    private void addSelectFields() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        String rowsHis = this.getPageCache().get(SELECT_ROWS_HIS);
        if (null != rowsHis) {
            JSONArray selectRowsHis = JSON.parseArray((String)rowsHis);
            if (selectRows.length - selectRowsHis.size() > 1) {
                this.alreadySelectFieldBatch();
                this.getPageCache().put(SELECT_ROWS_HIS, JSON.toJSONString((Object)selectRows));
            } else if (selectRows.length - selectRowsHis.size() < -1) {
                this.batchDeleteSelectEntryRows();
                this.getPageCache().put(SELECT_ROWS_HIS, null);
            } else {
                this.alreadySelectField();
            }
        } else if (selectRows.length > 1) {
            this.alreadySelectFieldBatch();
            this.getPageCache().put(SELECT_ROWS_HIS, JSON.toJSONString((Object)selectRows));
        } else {
            this.alreadySelectField();
        }
        this.getModel().updateCache();
    }

    private void alreadySelectField() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
        Map<String, Object> checkMap = this.entryRowIsCheck(KEY_ENTRY_ENTITY);
        if (!((Boolean)checkMap.get("isCheck")).booleanValue()) {
            int rowIndexDel = (Integer)checkMap.get("rowIndex");
            String currNodeId = this.getPageCache().get("currNodeId");
            DynamicObjectCollection selects = this.getModel().getEntryEntity(KEY_ENTRY_SELECT);
            for (DynamicObject select : selects) {
                if (!select.getString("selectfieldid").equals(currNodeId + "#" + rowIndexDel)) continue;
                this.getModel().deleteEntryRow(KEY_ENTRY_SELECT, select.getInt("seq") - 1);
                this.getView().updateView(KEY_ENTRY_SELECT);
                break;
            }
        } else {
            this.createNewSelectEntryRow(rowIndex, null);
        }
    }

    private void alreadySelectFieldBatch() {
        DynamicObjectCollection selects = this.getModel().getEntryEntity(KEY_ENTRY_SELECT);
        String currNodeId = this.getPageCache().get("currNodeId");
        if (selects.size() > 0) {
            ArrayList<Integer> delRowList = new ArrayList<Integer>();
            for (DynamicObject select : selects) {
                String currNodeId_S = StringUtils.substringBefore((String)select.getString("selectfieldid"), (String)"#");
                if (!currNodeId.equals(currNodeId_S)) continue;
                delRowList.add(select.getInt("seq") - 1);
            }
            this.getModel().deleteEntryRows(KEY_ENTRY_SELECT, delRowList.stream().mapToInt(Integer::valueOf).toArray());
        }
        this.batchCreateNewSelectEntryRows();
    }

    private void batchCreateNewSelectEntryRows() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        String currNodeId = this.getPageCache().get("currNodeId");
        for (int i : selectRows) {
            this.createNewSelectEntryRow(i, currNodeId);
        }
    }

    private void createNewSelectEntryRow(int rowIndex, String parentNodeId) {
        String name = "";
        String currNodeId = null != parentNodeId ? parentNodeId : this.getPageCache().get("currNodeId");
        name = this.getModel().getValue(FULL_NUMBER, rowIndex).toString();
        int index = this.getModel().createNewEntryRow(KEY_ENTRY_SELECT);
        this.getModel().setValue("selectfieldid", (Object)(currNodeId + "#" + rowIndex), index);
        this.getModel().setValue("sfull_number", (Object)name, index);
        this.getModel().setValue("snumber", this.getModel().getValue(NUMBER, rowIndex), index);
        this.getModel().setValue("sname", this.getModel().getValue(NAME, rowIndex), index);
        this.getModel().setValue("sdata_type", this.getModel().getValue(DATA_TYPE, rowIndex), index);
        this.getModel().setValue("srequired", this.getModel().getValue(REQUIRED, rowIndex), index);
        this.getModel().setValue("sparent_data_type", this.getModel().getValue(PARENT_DATA_TYPE, rowIndex), index);
        this.getModel().setValue("svalue", this.getModel().getValue(VALUE, rowIndex), index);
        this.getModel().setValue("sdata_schema", this.getModel().getValue(DATA_SCHEMA, rowIndex), index);
        this.getModel().setValue("sis_parent", this.getModel().getValue(IS_PARENT, rowIndex), index);
        this.getModel().setValue("sparent_all_type", this.getModel().getValue(PARENT_ALL_TYPE, rowIndex), index);
    }

    private Map<String, Object> entryRowIsCheck(String entrykey) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entrykey);
        int[] selectRows = entryGrid.getSelectRows();
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        int rowIndex = -1;
        boolean isCheck = true;
        if (this.getPageCache().get(SELECT_ROWS_HIS) == null) {
            this.getPageCache().put(SELECT_ROWS_HIS, JSON.toJSONString((Object)selectRows));
        } else {
            JSONArray selectRowsHis = JSON.parseArray((String)this.getPageCache().get(SELECT_ROWS_HIS));
            isCheck = selectRowsHis.size() < selectRows.length;
            rowIndex = this.compareWithHis(selectRows, selectRowsHis);
            this.getPageCache().put(SELECT_ROWS_HIS, JSON.toJSONString((Object)selectRows));
        }
        result.put("isCheck", isCheck);
        result.put("rowIndex", rowIndex);
        return result;
    }

    private int compareWithHis(int[] selectRows, JSONArray selectRowsHis) {
        int reRow = -1;
        List selectRowsList = Arrays.stream(selectRows).boxed().collect(Collectors.toList());
        for (Object index : selectRowsHis) {
            if (selectRowsList.contains(index)) continue;
            reRow = (Integer)index;
            break;
        }
        return reRow;
    }

    private void entryRowSelect(String currNodeId) {
        DynamicObjectCollection selects = this.getModel().getEntryEntity(KEY_ENTRY_SELECT);
        if (selects.size() > 0) {
            ArrayList<Integer> selectRows = new ArrayList<Integer>();
            for (DynamicObject select : selects) {
                String currNodeId_S = StringUtils.substringBefore((String)select.getString("selectfieldid"), (String)"#");
                if (!currNodeId_S.equals(currNodeId)) continue;
                selectRows.add(Integer.valueOf(StringUtils.substringAfter((String)select.getString("selectfieldid"), (String)"#")));
            }
            if (selectRows.size() > 0) {
                int[] selectRowsArr = selectRows.stream().mapToInt(Integer::valueOf).toArray();
                EntryGrid grid = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
                grid.selectRows(selectRowsArr, selectRowsArr[0]);
                this.getPageCache().put(SELECT_ROWS_HIS, JSON.toJSONString((Object)selectRowsArr));
            }
        }
    }

    private boolean isAlreadySelect(String selectfieldid) {
        DynamicObjectCollection selects = this.getModel().getEntryEntity(KEY_ENTRY_SELECT);
        if (selects.size() > 0) {
            for (DynamicObject select : selects) {
                if (!selectfieldid.equals(select.getString("selectfieldid"))) continue;
                return true;
            }
        }
        return false;
    }

    private void batchDeleteSelectEntryRows() {
        DynamicObjectCollection selects = this.getModel().getEntryEntity(KEY_ENTRY_SELECT);
        ArrayList<Integer> delRowsIndexList = new ArrayList<Integer>();
        String currNodeId = this.getPageCache().get("currNodeId");
        for (DynamicObject select : selects) {
            if (!select.getString("selectfieldid").contains(currNodeId)) continue;
            delRowsIndexList.add(select.getInt("seq") - 1);
        }
        this.getModel().deleteEntryRows(KEY_ENTRY_SELECT, delRowsIndexList.stream().mapToInt(Integer::valueOf).toArray());
        this.getView().updateView(KEY_ENTRY_SELECT);
    }

    private void isMul() {
        boolean isBatch = DataUtil.x((Object)this.getPageCache().get(IS_BATCH));
        if (!isBatch) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"alreadyselectflex"});
        }
        HashMap<String, Boolean> ismul = new HashMap<String, Boolean>();
        ismul.put("ismul", isBatch);
        this.getView().updateControlMetadata(KEY_ENTRY_ENTITY, ismul);
    }

    public static enum ShowProperty {
        PROPERTY,
        NOT_MB_PROPERTY,
        ONLY_PROPERTY,
        REF,
        ENTRIES,
        REAL_ENTRIES,
        REF_ENTRIES;

    }
}

