/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OpenApiInvokeCardPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String FORM_ID = "openapi_statdata";
    private static final String TOTAL_NUM = "num_invoketotal";
    private static final String SUCCESS_NUM = "num_suc_executed";
    private static final String FAIL_NUM = "num_fail_executed";
    private static final String AVERAGE_TIME = "num_average_time";
    private static final String REFRESH = "refresh";
    private static DynamicObject data = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{REFRESH});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals(REFRESH)) {
            this.getDataFromDB();
            this.setPageValue();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getDataFromDB();
        this.setPageValue();
    }

    private void getDataFromDB() {
        QFilter[] qFilters = QFilterUtil.builder().put("type", "=", (Object)9).put("time", "=", (Object)0).build();
        data = QueryServiceHelper.queryOne((String)FORM_ID, (String)"time,apiid,thirdid,cnt,successcnt,type,cost", (QFilter[])qFilters);
    }

    private void setPageValue() {
        Label labTotal = (Label)this.getControl(TOTAL_NUM);
        labTotal.setText(data == null ? "0" : String.valueOf(data.getLong("cnt")));
        Label labSuccess = (Label)this.getControl(SUCCESS_NUM);
        labSuccess.setText(data == null ? "0" : String.valueOf(data.getLong("successcnt")));
        Label labFail = (Label)this.getControl(FAIL_NUM);
        labFail.setText(data == null ? "0" : String.valueOf(data.getLong("cnt") - data.getLong("successcnt")));
        Label labCost = (Label)this.getControl(AVERAGE_TIME);
        String average = data == null ? "0" : String.valueOf(data.getLong("cost") / data.getLong("cnt"));
        labCost.setText(average);
    }
}

