/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ListboxItem;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.form.util.CustomChartHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OpenApiInvokeTrendCardPlugin
extends AbstractFormPlugin
implements ListboxClickListener {
    private static final Log log = LogFactory.getLog(OpenApiInvokeTrendCardPlugin.class);
    private static final String KEY_LISTBOXAP = "listboxap";
    private static final String KEY_POINTLINECHARTAP = "pointlinechartap";
    private static final String FORM_ID_LOG = "openapi_statdata";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private static final String HOUR = "hour";
    private static final String REFRESH = "refresh";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Listbox box = (Listbox)this.getView().getControl(KEY_LISTBOXAP);
        box.addListboxClickListener((ListboxClickListener)this);
        this.addClickListeners(new String[]{REFRESH});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            PointLineChart customchart = (PointLineChart)this.getControl(KEY_POINTLINECHARTAP);
            List<DynamicObject> dayApiData = this.get30DayApiData();
            CustomChartHelper chartHelper = new CustomChartHelper();
            chartHelper.drawChart(customchart, dayApiData, 7);
        }
        catch (ParseException ex) {
            log.info("parse error:", (Object)e);
        }
        Listbox box = (Listbox)this.getView().getControl(KEY_LISTBOXAP);
        ListboxItem listboxItem2 = new ListboxItem(DAY, ResManager.loadKDString((String)"\u65e5", (String)"OpenApiInvokeTrendCardPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
        ListboxItem listboxItem3 = new ListboxItem(HOUR, ResManager.loadKDString((String)"\u65f6", (String)"OpenApiInvokeTrendCardPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
        ArrayList<ListboxItem> itemlist = new ArrayList<ListboxItem>();
        itemlist.add(listboxItem2);
        itemlist.add(listboxItem3);
        box.addItems(itemlist);
        box.activeItem(DAY);
    }

    private List<DynamicObject> get30DayApiData() throws ParseException {
        Date timeBefore30Day = DateUtil.getDateWithoutHour((Date)DateUtil.getDateAdd((Date)new Date(), (int)6, (int)-29));
        QFilter[] qFilters30Day = QFilterUtil.builder().put("type", "=", (Object)7).put("time", ">=", (Object)timeBefore30Day.getTime()).build();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)FORM_ID_LOG, (String)"time,apiid.name,cnt,type,successcnt,cost,thirdid", (QFilter[])qFilters30Day, (String)"cnt");
        List<DynamicObject> collect = datas.stream().collect(Collectors.toList());
        return collect;
    }

    private List<DynamicObject> get24HourApiData() throws ParseException {
        Date timeBefore24Hour = DateUtil.getDateWithoutMinute((Date)DateUtil.getDateAdd((Date)new Date(), (int)10, (int)-23));
        QFilter[] qFiltersDay = QFilterUtil.builder().put("type", "=", (Object)1).put("time", ">=", (Object)timeBefore24Hour.getTime()).build();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)FORM_ID_LOG, (String)"time,apiid.name,cnt,type,successcnt,cost,thirdid", (QFilter[])qFiltersDay, (String)"time desc");
        List<DynamicObject> collect = datas.stream().collect(Collectors.toList());
        return collect;
    }

    public void listboxClick(ListboxEvent arg) {
        PointLineChart customchart = (PointLineChart)this.getControl(KEY_POINTLINECHARTAP);
        CustomChartHelper chartHelper = new CustomChartHelper();
        try {
            if (arg.getItemId().equals(DAY)) {
                chartHelper.drawChart(customchart, this.get30DayApiData(), 7);
            } else if (arg.getItemId().equals(HOUR)) {
                chartHelper.drawChart(customchart, this.get24HourApiData(), 1);
            }
        }
        catch (ParseException e) {
            log.info("parse error:", (Object)e);
        }
        customchart.refresh();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals(REFRESH)) {
            this.afterCreateNewData(evt);
        }
    }
}

