/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isc.util.dt.D;
import kd.bos.isc.util.except.IscBizException;
import kd.bos.isc.util.misc.StringUtil;

public class OpenApiJsonImportFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"view", "upload", "buttonap", "btnok"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterUpload(UploadEvent evt) {
        String arg7;
        ArrayList<String> fileUrls = new ArrayList<String>(1);
        Object[] jsonEditer = evt.getUrls();
        CodeEdit arg8 = (CodeEdit)this.getView().getControl("codeeditap");
        for (Object url : jsonEditer) {
            fileUrls.add((String)((Map)url).get("url"));
        }
        try {
            arg7 = this.getJsonData((String)fileUrls.get(0));
        }
        catch (IOException arg6) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u4eceredis\u7f13\u5b58 %1$s \u4e2d\u4e0b\u8f7d\u5931\u8d25\uff0c\u65e0\u6cd5\u5bfc\u5165\uff01", (String)"OpenApiJsonImportFormPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), (String)fileUrls.get(0)), (Throwable)arg6);
        }
        arg8.setText(arg7);
    }

    private String getJsonData(String fileUrl) throws IOException {
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String[] queryParams = new URL(fileUrl).getQuery().split("&");
        HashMap<String, String> downloadFileParams = new HashMap<String, String>(2);
        String[] content = queryParams;
        int dts = queryParams.length;
        for (int in = 0; in < dts; ++in) {
            String queryParam = content[in];
            String[] buffer = queryParam.split("=");
            downloadFileParams.put(buffer[0], buffer[1]);
        }
        TempFileCacheDownloadable.Content arg19 = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        String arg20 = "";
        try (BufferedInputStream arg21 = new BufferedInputStream(arg19.getInputStream());){
            ByteArrayOutputStream arg23 = new ByteArrayOutputStream(2048);
            int temp = arg21.read();
            while (temp >= 0) {
                if (temp != 10) {
                    arg23.write(temp);
                }
                temp = arg21.read();
            }
            arg20 = arg20 + new String(arg23.toByteArray(), StandardCharsets.UTF_8);
        }
        return arg20;
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control control;
        super.beforeClick(evt);
        if (null != this.getView().getFormShowParameter().getCustomParam("rows") && (Integer)this.getView().getFormShowParameter().getCustomParam("rows") > 0 && (control = (Control)evt.getSource()).getKey().equals("btnok")) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("json", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"Json\u5bfc\u5165\u5c06\u4f1a\u6e05\u9664\u53c2\u6570\u5e76\u65b0\u589e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OpenApiJsonImportFormPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operationKey = args.getOperateKey();
        if ("buttonap".equalsIgnoreCase(operationKey)) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        CodeEdit control = (CodeEdit)this.getView().getControl("codeeditap");
        String jsonStr = D.s((Object)control.getText());
        if (StringUtil.isEmpty((String)jsonStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165Json\u6570\u636e", (String)"OpenApiJsonImportFormPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        } else {
            JSONObject jsonDataMap;
            try {
                jsonDataMap = JSONObject.parseObject((String)jsonStr.replaceAll("\u00a0", "").replaceAll("\n", "").replaceAll("\t", "").replaceAll(" ", ""));
            }
            catch (Exception arg7) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89e3\u6790Json\u5185\u5bb9\u51fa\u9519\uff0c\u8bf7\u6821\u9a8c\uff01", (String)"OpenApiJsonImportFormPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent((Object)jsonDataMap);
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"json", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("buttonap", OperateOption.create());
        }
    }
}

