/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.Tips;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.Listbox;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.acl.ApilAclManager;
import kd.bos.openapi.base.util.ApiUriModelCacheUtil;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiOperationType;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.ApiStatus;
import kd.bos.openapi.common.constant.AsyncTypeEnum;
import kd.bos.openapi.common.constant.Version;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.OpenApiListDataProvider;
import kd.bos.openapi.form.util.ApiPluginUtil;
import kd.bos.openapi.form.util.ExportUtil;
import kd.bos.openapi.form.util.FormOpener;
import kd.bos.openapi.form.util.TreeNodeUtil;
import kd.bos.openapi.form.util.pdf.ExportAndDownloadUtil;
import kd.bos.openapi.form.util.pdf.ExportPdfForMetaSchemaAPI;
import kd.bos.openapi.form.util.swagger.SwaggerUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OpenApiListPlugin
extends StandardTreeListPlugin
implements IConfirmCallBack,
AfterF7SelectListener,
TreeNodeClickListener,
ListboxClickListener {
    private static final Log log = LogFactory.getLog(OpenApiListPlugin.class);
    private static final String BILL_LIST_STAP = "billlistap";
    private static final String TREE_VIEW = "treeview";
    private static final String KEY_AUTHORIZE = "baritemap_authorize";
    private static final String KEY_EXPORTPDF = "exportpdf";
    private static final String KEY_STATUSCH = "statusch";
    private static final String NODE_CLOUD = "cloud_";
    private static final String NODE_APP = "app_";
    private static final String NODE_BIZ = "biz_";
    private static final String NODE_CUS = "cus_";
    private static final String NODE_AI = "ai_";
    private static final String APPID = "appid";
    private static final String BIZID = "bizid";
    private static final String CUSID = "cusid";
    private static final String APPNAME = "appName";
    private static final String ENABLE = "enable";
    private static final String STATUS = "status";
    private static final String FILTER = "filter";
    private static final String OPENAPI_CLOUDID = "openapi_cloudId";
    private static final String ID = "Id";
    private static final String FIELD_VERSION = "version";
    private static final String KEY_API_SERVICE_TYPE = "apiservicetype";
    private static final String FORM_APISERVICE = "openapi_apilist";
    private static final String FORM_APISERVICE_1 = "open_apiservice_new";
    private static final String FORM_APIQUIDE = "openapi_apiquide";
    private static final String FORM_AI = "open_apiservice";
    private static final String FORM_APPAUTHORIZE = "openapi_appauthorize";
    private static final String FORM_STATUS = "openapi_apilist_status";
    private static final String FORM_OPEN_API_NEW = "openapi_apilist";
    private static final String FORM_OPEN_API_CUSTOMAPI = "openapi_customapi";
    private static final String FORM_OPEN_API_SCRIPTAPI = "openapi_scriptapi";
    private static final String FORM_OPEN_API_SERVLET = "openapi_customservlet";
    private static final String TYPE_CLOUD = "cloud";
    private static final String TYPE_APP = "app";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String FORM_LOG = "openapi_log_data";
    private static final String TBL_REF = "tblrefresh";
    private static final String TBL_OPE = "tblope";
    private static final String TBL_CUS = "tblcus";
    private static final String TBL_AI = "tblai";
    private static final String TBL_NEW = "tblnew";
    private static final String CH_CLOUD = "chcloud";
    private static final String URL_FORMAT = "urlformat";
    private static final String KEY_LOG = "log";
    public static final String EXPORT_API = "exportapi";
    public static final String EXPORT_ZIP = "exportzip";
    public static final String IMPORT_API = "importapi";
    public static final String CLOUD_UPDATE = "cloudupdate";
    public static final String EXPORT_SWAGGER = "exportswagger";
    private static final String LISTBOXITEM_CLOUDAPP = "cloudApp";
    private static final String LISTBOXITEM_CUSTOM = "custom";
    private static final String LISTBOXFLAG = "listBoxFlag";
    private static final String LISTBOXAP = "listboxap";
    private static final String CHCLOUD = "chcloud";
    private static final String ADDCUSTOMGROUP = "addcustomgroup";
    private static final String EDITCUSTOMGROUP = "editcustomgroup";
    private static final String DELETECUSTOMGROUP = "deletecustomgroup";
    public static final String CURRENT_NODE = "current_node";
    private static final String CALLBACK_NODE = "callback_node";
    private static final String DEL_NODE = "del_node";
    private static final String IS_PRESET = "is_preset";
    private static final String CURRENT_GROUP_TREENODE = "current_group_treenode";
    private static final String BATCH_GROUP = "batchgroup";
    private static final String OPENAPI_BATCHGROUP = "openapi_batchgroup";
    private static final String CUSTOMGROUP_SYS = "customgroup-sys";
    private static final String BTN_QUICKCREATE = "quickcreate";
    private static final String FORM_QUCIK_CREATE_SYNCAPI = "quick_create_syncapi";
    public static final String ISASYNC = "isasync";
    private static final String BTN_ASYNCNEW = "asyncnew";
    private static final String BTN_OPERATIONNEW = "operationnew";
    private static final String BTN_PLUGINNEW = "pluginnew";
    private static final String BTN_SCRIPTNEW = "scriptnew";
    private static final String BTN_ASYNCCOPY = "aysnccopy";

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new OpenApiListDataProvider());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit edit = (BasedataEdit)this.getControl("chcloud");
        edit.addAfterF7SelectListener((AfterF7SelectListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Listbox box = (Listbox)this.getView().getControl(LISTBOXAP);
        box.addListboxClickListener((ListboxClickListener)this);
        this.addClickListeners(new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
        if (this.isCloudAppTreeDimension()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeView tv1 = (TreeView)this.getView().getControl(TREE_VIEW);
        tv1.deleteAllNodes();
        this.initListbox();
        if (this.isCloudAppTreeDimension()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
            this.treeApp();
        } else {
            this.initCustomGroupTree();
        }
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_STAP);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && !customParams.containsKey(ISASYNC)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_QUICKCREATE, BTN_ASYNCNEW, BTN_ASYNCCOPY});
            List listFields = billList.getListFields();
            for (ListField fieldEdit : listFields) {
                if (!fieldEdit.getFieldName().equals(ISASYNC)) continue;
                billList.getView().setVisible(Boolean.valueOf(false), new String[]{ISASYNC});
            }
        } else {
            FilterContainer filterGrid = (FilterContainer)this.getControl("filtercontainerap");
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u5f02\u6b65API\u91c7\u7528\u5f02\u6b65\u4f20\u8f93\u65b9\u5f0f\uff0c\u63a5\u53e3\u8c03\u7528\u65b9\u65e0\u9700\u7b49\u5f85API\u6267\u884c\u7ed3\u679c\uff0c\u53ef\u4ee5\u7ee7\u7eed\u6267\u884c\u5176\u4ed6\u4efb\u52a1\uff0c\u4e0d\u4f1a\u9020\u6210\u4e3b\u6d41\u7a0b\u963b\u585e\uff0c\u9002\u7528\u4e8e\u5927\u6570\u636e\u91cf\u67e5\u8be2\u6216\u540c\u6b65\u573a\u666f\u3002", (String)"OpenApiListPlugin_34", (String)"bos-open-formplugin", (Object[])new Object[0])));
            filterGrid.addTips(tips);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TBL_NEW, CLOUD_UPDATE});
        }
    }

    private void initCustomGroupTree() {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.deleteAllNodes();
        TreeNode root = TreeNodeUtil.initCustomGroupTree();
        treeView.addNode(root);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getView().updateView(TREE_VIEW);
    }

    private void initListbox() {
        String dimension = this.getView().getPageCache().get(LISTBOXFLAG);
        if (StringUtil.isEmpty((String)dimension)) {
            dimension = LISTBOXITEM_CLOUDAPP;
            this.getView().getPageCache().put(LISTBOXFLAG, LISTBOXITEM_CLOUDAPP);
        }
        Listbox box = (Listbox)this.getView().getControl(LISTBOXAP);
        ListboxItem cloudAppListboxItem = new ListboxItem(LISTBOXITEM_CLOUDAPP, ResManager.loadKDString((String)"\u9ed8\u8ba4\u5206\u7ec4", (String)"OpenApiListPlugin_16", (String)"bos-open-formplugin", (Object[])new Object[0]));
        ListboxItem customListboxItem = new ListboxItem(LISTBOXITEM_CUSTOM, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49", (String)"OpenApiListPlugin_17", (String)"bos-open-formplugin", (Object[])new Object[0]));
        box.addItems(Arrays.asList(cloudAppListboxItem, customListboxItem));
        box.activeItem(dimension);
    }

    public void treeToolbarClick(EventObject e) {
    }

    public void listboxClick(ListboxEvent event) {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        BillList billList = (BillList)this.getControl(BILL_LIST_STAP);
        Search searchap = (Search)this.getControl("searchap");
        searchap.setSearchKey("");
        if (event.getItemId().equals(LISTBOXITEM_CLOUDAPP)) {
            this.getView().getPageCache().remove(CURRENT_GROUP_TREENODE);
            this.getView().getPageCache().put(LISTBOXFLAG, LISTBOXITEM_CLOUDAPP);
            this.getView().setVisible(Boolean.TRUE, new String[]{"chcloud", BTN_NEW, BTN_EDIT, BTN_DEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
            treeView.deleteAllNodes();
            TreeView tv1 = (TreeView)this.getView().getControl(TREE_VIEW);
            if (null == this.getModel().getValue("chcloud")) {
                this.treeApp();
            } else {
                DynamicObject cloud = (DynamicObject)this.getModel().getValue("chcloud");
                tv1.deleteAllNodes();
                this.cacheBuilder(cloud.getString(ID));
                this.buildTreeByCloud(tv1, cloud.getString(ID));
                this.getView().getPageCache().put("chcloud", cloud.getString(ID));
            }
        } else if (event.getItemId().equals(LISTBOXITEM_CUSTOM)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{"chcloud"});
            this.getView().getPageCache().put(LISTBOXFLAG, LISTBOXITEM_CUSTOM);
            this.initCustomGroupTree();
        }
        billList.clearSelection();
        billList.refresh();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String currGroupNumber = this.getTreeModel().getCurrentNodeId().toString();
        if (control.getKey().equals(BTN_NEW)) {
            if (this.isPreSetSort(currGroupNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u5206\u7ec4\u4e0d\u80fd\u65b0\u589e\u3002", (String)"OpenApiListPlugin_26", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.checkGroupLevelIsExceed(currGroupNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u5c42\u7ea7\u4e0d\u80fd\u8d85\u8fc7\u4e09\u7ea7\u3002", (String)"OpenApiListPlugin_31", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(CALLBACK_NODE, this.getTreeModel().getCurrentNodeId().toString());
            BillShowParameter param = new BillShowParameter();
            param.setFormId("open_customgroup");
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.ADDNEW);
            param.setCustomParam(CURRENT_NODE, (Object)this.getTreeModel().getCurrentNodeId().toString());
            param.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5206\u7ec4", (String)"OpenApiListPlugin_18", (String)"bos-open-formplugin", (Object[])new Object[0]));
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDCUSTOMGROUP));
            this.getView().showForm((FormShowParameter)param);
        } else if (control.getKey().equals(BTN_EDIT)) {
            if ("".equals(this.getTreeModel().getCurrentNodeId().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u975e\u6839\u8282\u70b9\u3002", (String)"OpenApiListPlugin_25", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.isPreSetSort(currGroupNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u5206\u7ec4\u4e0d\u80fd\u7f16\u8f91\u3002", (String)"OpenApiListPlugin_27", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(CALLBACK_NODE, this.getTreeModel().getCurrentNodeId().toString());
            BillShowParameter param = new BillShowParameter();
            param.setFormId("open_customgroup");
            param.setPkId((Object)this.getCustomGroupPkIdByNumber(this.getTreeModel().getCurrentNodeId().toString()));
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.EDIT);
            param.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91\u5206\u7ec4", (String)"OpenApiListPlugin_19", (String)"bos-open-formplugin", (Object[])new Object[0]));
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDITCUSTOMGROUP));
            this.getView().showForm((FormShowParameter)param);
        } else if (control.getKey().equals(BTN_DEL)) {
            if ("".equals(currGroupNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"OpenApiListPlugin_21", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.isPreSetSort(currGroupNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u5206\u7ec4\u4e0d\u80fd\u5220\u9664\u3002", (String)"OpenApiListPlugin_22", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(DEL_NODE, currGroupNumber);
            boolean existsApi = QueryServiceHelper.exists((String)"openapi_apilist", (QFilter[])new QFilter[]{new QFilter("group.number", "in", this.getAllChildNumber(currGroupNumber))});
            DynamicObject group = QueryServiceHelper.queryOne((String)"open_customgroup", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currGroupNumber)});
            String groupName = group.getString("name");
            if (existsApi) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u201c%1$s\u201d\u5b58\u5728\u5173\u8054API\uff0c\u5220\u9664\u540e\u8be5\u5206\u7ec4\u4e0b\u7684API\u4f1a\u5f52\u5e76\u5230\u672a\u5206\u7ec4\u91cc\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OpenApiListPlugin_20", (String)"bos-open-formplugin", (Object[])new Object[0]), groupName), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETECUSTOMGROUP));
            } else {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5206\u7ec4\u201c%1$s\u201d\uff1f", (String)"OpenApiListPlugin_24", (String)"bos-open-formplugin", (Object[])new Object[0]), groupName), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETECUSTOMGROUP));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        String treeNodeId;
        String chcloud;
        Map customParams;
        super.setFilter(e);
        if (this.getView().getFormShowParameter().getParentFormId() == null) {
            return;
        }
        List filters = e.getQFilters();
        if (!"true".equals(ApiPluginUtil.getVisibleSysApi(this.getView()))) {
            e.getQFilters().add(new QFilter("is_sys_api", "=", (Object)"0"));
        }
        if ((customParams = this.getView().getFormShowParameter().getCustomParams()) != null && customParams.containsKey(ISASYNC)) {
            e.getQFilters().add(new QFilter(ISASYNC, "=", (Object)"1"));
        } else {
            e.getQFilters().add(new QFilter(ISASYNC, "=", (Object)"0").or(new QFilter(ISASYNC, "=", (Object)" ")));
        }
        if (null != this.getView().getPageCache().get("chcloud") && this.isCloudAppTreeDimension()) {
            chcloud = this.getView().getPageCache().get("chcloud");
            e.getQFilters().add(new QFilter("appid.bizcloud.Id", "=", (Object)chcloud));
        } else if (null == this.getView().getPageCache().get("chcloud") && null != this.getModel().getValue("chcloud") && this.isCloudAppTreeDimension()) {
            chcloud = ((DynamicObject)this.getModel().getValue("chcloud")).getString(ID);
            e.getQFilters().add(new QFilter("appid.bizcloud.Id", "=", (Object)chcloud));
        }
        String curGroupTreeNode = this.getView().getPageCache().get(CURRENT_GROUP_TREENODE);
        if (null != curGroupTreeNode) {
            if (CUSTOMGROUP_SYS.equals(curGroupTreeNode)) {
                e.getQFilters().add(new QFilter("group.id", "in", Arrays.asList(0L, 1850849832719633408L)));
            } else {
                List<String> allChildId = this.getAllChildNumber(curGroupTreeNode);
                if (allChildId.size() > 0) {
                    e.getQFilters().add(new QFilter("group.number", "in", (Object)allChildId.toArray()));
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(treeNodeId = this.getTreeModel().getCurrentNodeId().toString()))) {
            Map<String, Object> nodeMap = this.rebuildNodeToMap();
            QFilter qFilter = (QFilter)nodeMap.get(FILTER);
            e.getQFilters().add(qFilter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object primaryKeyValue;
        DynamicObject api;
        ListSelectedRowCollection returnData;
        super.closedCallBack(event);
        BillList billList = (BillList)this.getControl(BILL_LIST_STAP);
        if (event.getActionId().equals(FORM_STATUS)) {
            if (null != event.getReturnData() && event.getReturnData().equals(Boolean.TRUE)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u72b6\u6001\u8f6c\u6362\u6210\u529f\u3002", (String)"OpenApiListPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                ApilAclManager.removeApiAclInfoModel((ListSelectedRowCollection)this.getSelectRows());
                billList.refresh();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u72b6\u6001\u53d8\u66f4\u3002", (String)"OpenApiListPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        } else if (event.getActionId().equals("refresh")) {
            if (null != event.getReturnData() && event.getReturnData().equals("norefresh")) {
                return;
            }
            if (null != event.getReturnData() && event.getReturnData().equals("refresh")) {
                billList.refresh();
                return;
            }
            if (null == event.getReturnData()) {
                return;
            }
            this.refreshList();
        } else if (event.getActionId().equals(IMPORT_API)) {
            if (null != event.getReturnData() && event.getReturnData().equals(Boolean.TRUE)) {
                this.refreshList();
                billList.refresh();
            }
        } else if (event.getActionId().equals(CLOUD_UPDATE)) {
            this.refreshList();
        } else if (event.getActionId().equals(ADDCUSTOMGROUP) || event.getActionId().equals(EDITCUSTOMGROUP)) {
            this.initCustomGroupTree();
            String treeNodeId = this.getPageCache().get(CALLBACK_NODE);
            if (treeNodeId != null && !"".equals(treeNodeId)) {
                TreeNode treeNode = TreeNodeUtil.getTreeNodeById(this.getTreeModel().getRoot(), treeNodeId);
                this.defaultClickNode(treeNode);
            }
        } else if (event.getActionId().equals(BATCH_GROUP)) {
            Object result = event.getReturnData();
            this.updateGroup(billList, result);
        } else if (event.getActionId().equals(FORM_QUCIK_CREATE_SYNCAPI) && (returnData = (ListSelectedRowCollection)event.getReturnData()) != null && (api = QueryServiceHelper.queryOne((String)"openapi_apilist", (String)KEY_API_SERVICE_TYPE, (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue = returnData.get(0).getPrimaryKeyValue())})) != null) {
            ApiServiceType apiServiceType = ApiServiceType.get((int)Integer.parseInt(String.valueOf(api.get(KEY_API_SERVICE_TYPE))));
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId(apiServiceType.getEntityName());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam(KEY_API_SERVICE_TYPE, (Object)String.valueOf(apiServiceType.ordinal()));
            showParameter.setCustomParam("iscopy", (Object)true);
            showParameter.setCustomParam(ISASYNC, (Object)"true");
            showParameter.setPkId(primaryKeyValue);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void defaultClickNode(TreeNode node) {
        if (node == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.focusNode(node);
        treeView.treeNodeClick(node.getParentid(), node.getId());
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes == evt.getResult() && StringUtils.equals((CharSequence)evt.getCallBackId(), (CharSequence)DELETECUSTOMGROUP)) {
            String number = this.getPageCache().get(DEL_NODE);
            this.deleteGroup(number);
        }
        if (StringUtils.equals((CharSequence)evt.getCallBackId(), (CharSequence)KEY_EXPORTPDF)) {
            ListSelectedRowCollection selectRows = this.getSelectRows();
            if (selectRows.size() > 500) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7500\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OpenApiListPlugin_33", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            String filePath = null;
            if (MessageBoxResult.Yes == evt.getResult()) {
                try {
                    Object[] ids = selectRows.getPrimaryKeyValues();
                    filePath = ExportPdfForMetaSchemaAPI.batchGeneratePdf(ids);
                    ExportAndDownloadUtil.download(this.getView(), filePath, System.currentTimeMillis() + ".pdf", true);
                }
                catch (Throwable e) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fapdf\u5f02\u5e38 \uff0c%1$s", (String)"OpenApiListPlugin_6", (String)"bos-open-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
            } else {
                for (ListSelectedRow selectRow : selectRows) {
                    try {
                        String name = selectRow.getName();
                        filePath = ExportPdfForMetaSchemaAPI.generateSinglePdf((Long)selectRow.getPrimaryKeyValue());
                        ExportAndDownloadUtil.download(this.getView(), filePath, name + ".pdf", true);
                    }
                    catch (Throwable e) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fapdf\u5f02\u5e38 \uff0c%1$s", (String)"OpenApiListPlugin_6", (String)"bos-open-formplugin", (Object[])new Object[0]), e.getMessage()));
                    }
                }
            }
        }
    }

    private void deleteGroup(String number) {
        List<String> allChildNumber = this.getAllChildNumber(number);
        Object[] apis = BusinessDataServiceHelper.load((String)"openapi_apilist", (String)"group", (QFilter[])new QFilter[]{new QFilter("group.number", "in", allChildNumber)});
        if (CollectionUtil.isNotEmpty((Object[])apis)) {
            for (Object api : apis) {
                api.set("group", null);
            }
            SaveServiceHelper.save((DynamicObject[])apis);
        }
        this.deleteChildrenGroup(number);
        this.initCustomGroupTree();
        this.defaultClickNode(this.getTreeModel().getRoot());
    }

    private List<String> getAllChildNumber(String number) {
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode targetNode = TreeNodeUtil.getTreeNodeById(root, number);
        ArrayList<String> allChildNumber = new ArrayList<String>();
        TreeNodeUtil.getAllChildId(allChildNumber, targetNode);
        return allChildNumber;
    }

    private boolean isPreSetSort(String number) {
        QFilter[] qFilters = QFilterUtil.builder().put("number", "=", (Object)number).build();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"open_customgroup", (String)IS_PRESET, (QFilter[])qFilters);
        return dynamicObject != null && dynamicObject.getBoolean(IS_PRESET);
    }

    private boolean checkGroupLevelIsExceed(String number) {
        QFilter[] qFilters = QFilterUtil.builder().put("number", "=", (Object)number).build();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"open_customgroup", (String)"level", (QFilter[])qFilters);
        return dynamicObject != null && dynamicObject.getInt("level") > 2;
    }

    private Long getCustomGroupPkIdByNumber(String number) {
        QFilter[] qFilters = QFilterUtil.builder().put("number", "=", (Object)number).build();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"open_customgroup", (String)ID, (QFilter[])qFilters);
        if (dynamicObject != null) {
            return dynamicObject.getLong(ID);
        }
        return null;
    }

    private void deleteChildrenGroup(String number) {
        List<String> childNumbers = this.getAllChildNumber(number);
        if (CollectionUtil.isNotEmpty(childNumbers)) {
            for (String childNumber : childNumbers) {
                if (childNumber.equals(number)) continue;
                this.deleteChildrenGroup(childNumber);
            }
        }
        OperationServiceHelper.executeOperate((String)"delete", (String)"open_customgroup", (Object[])new Object[]{this.getCustomGroupPkIdByNumber(number)}, (OperateOption)OperateOption.create());
    }

    public void beforeShowBill(BeforeShowBillFormEvent arg) {
        super.beforeShowBill(arg);
        BaseShowParameter showParameter = (BaseShowParameter)arg.getParameter();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)showParameter.getPkId(), (String)showParameter.getFormId(), (String)"version,apiservicetype");
        if ("2".equalsIgnoreCase(dynamicObject.getString(KEY_API_SERVICE_TYPE))) {
            showParameter.setFormId(FORM_OPEN_API_CUSTOMAPI);
        } else if ((ApiServiceType.SCRIPT.ordinal() + "").equalsIgnoreCase(dynamicObject.getString(KEY_API_SERVICE_TYPE))) {
            showParameter.setFormId(FORM_OPEN_API_SCRIPTAPI);
        } else if ((ApiServiceType.CUSTSERVLET.ordinal() + "").equalsIgnoreCase(dynamicObject.getString(KEY_API_SERVICE_TYPE))) {
            showParameter.setFormId(FORM_OPEN_API_SERVLET);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent arg) {
        ListSelectedRowCollection rows;
        super.beforeItemClick(arg);
        if ((KEY_STATUSCH.equals(arg.getItemKey()) || EXPORT_SWAGGER.equals(arg.getItemKey())) && (rows = this.getSelectRows()).size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"OpenApiListPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
            arg.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            if (BATCH_GROUP.equals(operateKey)) {
                this.createShowGroupF7Form();
            } else if (BTN_OPERATIONNEW.equals(operateKey)) {
                String entityName = ApiServiceType.OPERATION.getEntityName();
                String apiservicetype = String.valueOf(ApiServiceType.OPERATION.ordinal());
                this.showAsyncForm(entityName, apiservicetype);
            } else if (BTN_PLUGINNEW.equals(operateKey)) {
                String entityName = ApiServiceType.CUSTOM.getEntityName();
                String apiservicetype = String.valueOf(ApiServiceType.CUSTOM.ordinal());
                this.showAsyncForm(entityName, apiservicetype);
            } else if (BTN_SCRIPTNEW.equals(operateKey)) {
                String entityName = ApiServiceType.SCRIPT.getEntityName();
                String apiservicetype = String.valueOf(ApiServiceType.SCRIPT.ordinal());
                this.showAsyncForm(entityName, apiservicetype);
            } else if (BTN_QUICKCREATE.equals(operateKey)) {
                ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"openapi_apilist", (boolean)false, (int)0);
                ListFilterParameter filterParameter = new ListFilterParameter();
                QFilter[] qFilter = QFilterUtil.builder().put(KEY_API_SERVICE_TYPE, "!=", (Object)String.valueOf(ApiServiceType.AI.getCode())).put(KEY_API_SERVICE_TYPE, "!=", (Object)String.valueOf(ApiServiceType.CUSTSERVLET.getCode())).put(ISASYNC, "=", (Object)AsyncTypeEnum.SYNC.getValue()).put(Version.VERSION, "=", (Object)Version.TWO.getVer()).build();
                filterParameter.setQFilters(Arrays.asList(qFilter));
                listShowParameter.setListFilterParameter(filterParameter);
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FORM_QUCIK_CREATE_SYNCAPI));
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    private void showAsyncForm(String entityName, String apiservicetype) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(entityName);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam(KEY_API_SERVICE_TYPE, (Object)apiservicetype);
        showParameter.setCustomParam(ISASYNC, (Object)"true");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            ListSelectedRowCollection listSelectedRows = args.getListSelectedData();
            if (ApiOperationType.DELETE.getOp().equalsIgnoreCase(operateKey)) {
                Object[] idList = listSelectedRows.getPrimaryKeyValues();
                DynamicObject[] dys = BusinessDataServiceHelper.load((String)"openapi_apilist", (String)"id,urlformat,status", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idList)});
                boolean flag = true;
                for (DynamicObject dy : dys) {
                    if (ApiStatus.DISABLE.getCode().equals(dy.getString(STATUS))) {
                        ApiUriModelCacheUtil.removeApiModelCache((String)dy.getString(URL_FORMAT));
                        continue;
                    }
                    flag = false;
                }
                if (flag) {
                    String sql = "Update t_openapi_statdata_sum set fapiid= ? where ftype<=2 and fapiid = ?";
                    Object[] params = new SqlParameter[2];
                    for (Object id : idList) {
                        long apiId = DataUtil.l((Object)id);
                        if (apiId <= 0L) continue;
                        params[0] = new SqlParameter(":Fapiid", -5, (Object)(-apiId));
                        params[1] = new SqlParameter(":Fapiid", -5, (Object)apiId);
                        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
                    }
                    DeleteServiceHelper.delete((String)"openapi_callback", (QFilter[])new QFilter[]{new QFilter("apiid", "in", (Object)idList)});
                }
            } else if (KEY_STATUSCH.equalsIgnoreCase(operateKey)) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (ListSelectedRow row2 : listSelectedRows) {
                    ids.add(Long.valueOf(row2.getPrimaryKeyValue().toString()));
                }
                DynamicObjectCollection apis = QueryServiceHelper.query((String)"openapi_apilist", (String)"Id,status", (QFilter[])new QFilter(ID, "in", ids).toArray());
                String status = "";
                for (DynamicObject api : apis) {
                    if (StringUtil.isEmpty((String)status)) {
                        status = api.getString(STATUS);
                        continue;
                    }
                    if (status.equals(api.getString(STATUS))) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u76f8\u540c\u7684\u6570\u636e\u3002", (String)"OpenApiListPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(FORM_STATUS);
                showParameter.setCustomParam("pks", ids);
                showParameter.setCustomParam(STATUS, (Object)status);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FORM_STATUS));
                this.getView().showForm(showParameter);
            } else if (EXPORT_API.equals(operateKey) || EXPORT_ZIP.equals(operateKey)) {
                try {
                    if (listSelectedRows.size() > 100) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7100\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OpenApiListPlugin_13", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if (EXPORT_API.equals(operateKey)) {
                        ExportUtil.export(this.getView(), this.getSelectRows(), false);
                    }
                    String appName = this.getCurAppName();
                    ExportUtil.export(this.getView(), this.getSelectRows(), true, appName);
                }
                catch (Exception e) {
                    throw new OpenApiException((Throwable)e, ApiErrorCode.ERROR, ResManager.loadKDString((String)"\u5bfc\u51faAPI\u5f02\u5e38 \uff0c\u5f02\u5e38\u4fe1\u606f{}", (String)"OpenApiListPlugin_11", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
                }
            } else if (IMPORT_API.equals(operateKey)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("openapi_import");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT_API));
                this.getView().showForm(showParameter);
            } else if (CLOUD_UPDATE.equals(operateKey)) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("openapi_apilist");
                showParameter.setFormId("openapi_cloud_update");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCaption(ResManager.loadKDString((String)"\u4e91\u66f4\u65b0", (String)"OpenApiListPlugin_14", (String)"bos-open-formplugin", (Object[])new Object[0]));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOUD_UPDATE));
                this.getView().showForm((FormShowParameter)showParameter);
            } else if (KEY_EXPORTPDF.equals(operateKey)) {
                ListSelectedRowCollection selectRows = this.getSelectRows();
                if (selectRows.size() == 1) {
                    try {
                        String name = selectRows.get(0).getName();
                        String filePath = ExportPdfForMetaSchemaAPI.generateSinglePdf((Long)selectRows.get(0).getPrimaryKeyValue());
                        ExportAndDownloadUtil.download(this.getView(), filePath, name + ".pdf", true);
                    }
                    catch (Throwable e) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fapdf\u5f02\u5e38 \uff0c%1$s", (String)"OpenApiListPlugin_6", (String)"bos-open-formplugin", (Object[])new Object[0]), e.getMessage()));
                    }
                } else {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5408\u5e76\u5bfc\u51fa\u52fe\u9009\u7684API\u6587\u6863\uff1f", (String)"OpenApiListPlugin_32", (String)"bos-open-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_EXPORTPDF));
                }
            } else if (EXPORT_SWAGGER.equals(operateKey)) {
                ListSelectedRowCollection selectRows = this.getSelectRows();
                if (selectRows.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"OpenApiListPlugin_5", (String)"bos-form-business", (Object[])new Object[0]));
                    return;
                }
                String filePath = null;
                ArrayList<Long> apiIds = new ArrayList<Long>();
                selectRows.forEach(row -> apiIds.add((Long)row.getPrimaryKeyValue()));
                try {
                    String name = "openApi_swagger";
                    filePath = this.exportSwagger(apiIds);
                    ExportAndDownloadUtil.download(this.getView(), filePath, name + ".json", true);
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51faswagger\u5f02\u5e38 \uff0c\u5f02\u5e38\u4fe1\u606f{%s}", (String)"OpenApiListPlugin_15", (String)"bos-open-formplugin", (Object[])new Object[0]), e));
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (KEY_AUTHORIZE.equals(evt.getItemKey())) {
            String nodeId = this.getTreeModel().getCurrentNodeId().toString();
            if (!StringUtils.isEmpty((CharSequence)nodeId)) {
                if (nodeId.contains(NODE_APP) && !nodeId.contains(NODE_CUS) && !nodeId.contains(NODE_AI) && !nodeId.contains(NODE_BIZ)) {
                    TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 2);
                    String appName = node.getText();
                    ArrayList<String> appIds = new ArrayList<String>();
                    BaseShowParameter formShowParameter = new BaseShowParameter();
                    formShowParameter.setFormId(FORM_APPAUTHORIZE);
                    formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                    formShowParameter.setCustomParam(APPNAME, (Object)appName);
                    String type = "";
                    if (nodeId.contains(NODE_CLOUD)) {
                        type = TYPE_CLOUD;
                        List apps = node.getChildren();
                        for (TreeNode app : apps) {
                            String appId = StringUtils.substringAfter((String)app.getId(), (String)"_");
                            appIds.add(appId);
                        }
                    } else if (nodeId.contains(NODE_APP)) {
                        type = TYPE_APP;
                        String appId = StringUtils.substringAfter((String)nodeId, (String)"_");
                        appIds.add(appId);
                        Long pkId = this.getPkIdByNumber(appId);
                        if (pkId != null) {
                            formShowParameter.setPkId((Object)pkId);
                        }
                    }
                    formShowParameter.setCustomParam("appIds", appIds);
                    formShowParameter.setCustomParam("type", (Object)type);
                    this.getView().showForm((FormShowParameter)formShowParameter);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5bf9\u5e94\u7528\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"OpenApiListPlugin_4", (String)"bos-open-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5e94\u7528\u8282\u70b9\u3002", (String)"OpenApiListPlugin_10", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
        } else if (TBL_NEW.equals(evt.getItemKey())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(FORM_APIQUIDE);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            Map<String, Object> creMap = this.rebuildNodeToMap();
            showParameter.setCustomParams(creMap);
            if (!"false".equals(OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("isallowservletapi", "false"))) {
                StyleCss css = new StyleCss();
                css.setWidth("900");
                showParameter.getOpenStyle().setInlineStyleCss(css);
            }
            this.getView().showForm(showParameter);
        } else if (TBL_REF.equals(evt.getItemKey())) {
            if (this.isCloudAppTreeDimension()) {
                this.refreshList();
            } else {
                this.refreshListByGroup();
            }
        } else if (KEY_LOG.equals(evt.getItemKey())) {
            ListSelectedRowCollection selectRows = this.getSelectRows();
            if (selectRows == null || selectRows.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761api\u3002", (String)"OpenApiListPlugin_7", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            Object keyValue = selectRows.get(0).getPrimaryKeyValue();
            List filters = QFilterUtil.builder((String)"apiid", (String)"=", (Object)keyValue.toString()).buildList();
            OpenApiListPlugin.openBillList((AbstractFormPlugin)this, FORM_LOG, filters, ResManager.loadKDString((String)"API\u8c03\u7528\u65e5\u5fd7", (String)"OpenApiListPlugin_8", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterF7Select(AfterF7SelectEvent arg) {
        BillList billList = (BillList)this.getControl(BILL_LIST_STAP);
        TreeView tv1 = (TreeView)this.getView().getControl(TREE_VIEW);
        if (null == this.getModel().getValue("chcloud")) {
            this.treeApp();
        } else {
            DynamicObject cloud = (DynamicObject)this.getModel().getValue("chcloud");
            tv1.deleteAllNodes();
            this.cacheBuilder(cloud.getString(ID));
            this.buildTreeByCloud(tv1, cloud.getString(ID));
            this.getView().getPageCache().put("chcloud", cloud.getString(ID));
        }
        billList.clearSelection();
        billList.refresh();
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.getView().getPageCache().remove("chcloud");
        if (null != e.getNodeId() && null != e.getParentNodeId()) {
            this.getView().getPageCache().put(e.getNodeId().toString(), e.getParentNodeId().toString());
        }
        this.getView().getPageCache().remove(CURRENT_GROUP_TREENODE);
        if (!this.isCloudAppTreeDimension()) {
            if (null != e.getNodeId() && !"".equals(e.getNodeId().toString())) {
                this.getView().getPageCache().put(CURRENT_GROUP_TREENODE, e.getNodeId().toString());
            }
            this.getTreeModel().getListFilter();
        }
        BillList billList = (BillList)this.getControl(BILL_LIST_STAP);
        billList.refresh();
    }

    private ListSelectedRowCollection getSelectRows() {
        BillList billList = (BillList)this.getView().getControl(BILL_LIST_STAP);
        return billList.getSelectedRows();
    }

    private void cacheBuilder(String chCloudId) {
        String tenantCode = RequestContext.get().getTenantCode();
        IAppCache cache = AppCache.get((String)(tenantCode + ((Object)((Object)this)).getClass().getName()));
        cache.put(OPENAPI_CLOUDID, (Object)chCloudId);
    }

    private String getCacheCloud() {
        String tenantCode = RequestContext.get().getTenantCode();
        IAppCache cache = AppCache.get((String)(tenantCode + ((Object)((Object)this)).getClass().getName()));
        return (String)cache.get(OPENAPI_CLOUDID, String.class);
    }

    private void refreshList() {
        BillList billList = (BillList)this.getControl(BILL_LIST_STAP);
        TreeView tv1 = (TreeView)this.getView().getControl(TREE_VIEW);
        String treeNodeId = this.getTreeModel().getCurrentNodeId().toString();
        if (null != this.getModel().getValue("chcloud") && StringUtils.isNotEmpty((CharSequence)treeNodeId)) {
            DynamicObject chcloud = (DynamicObject)this.getModel().getValue("chcloud");
            tv1.deleteAllNodes();
            this.buildTreeByCloud(tv1, chcloud.getString(ID));
            if (StringUtils.isNotEmpty((CharSequence)this.getView().getPageCache().get(treeNodeId))) {
                tv1.focusNode(new TreeNode(null, this.getView().getPageCache().get(treeNodeId), null));
                tv1.treeNodeClick("", this.getView().getPageCache().get(treeNodeId));
            } else {
                tv1.treeNodeClick("", treeNodeId);
                tv1.focusNode(new TreeNode(null, treeNodeId, null));
            }
            this.getView().getPageCache().put("chcloud", chcloud.getString(ID));
        } else if (null == this.getModel().getValue("chcloud") && StringUtils.isNotEmpty((CharSequence)treeNodeId) && treeNodeId.equals("allApp")) {
            this.treeApp();
        }
        billList.clearSelection();
        billList.refresh();
    }

    private void refreshListByGroup() {
        BillList billList = (BillList)this.getControl(BILL_LIST_STAP);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        String treeNodeId = this.getTreeModel().getCurrentNodeId().toString();
        this.initCustomGroupTree();
        if (StringUtils.isNotEmpty((CharSequence)treeNodeId)) {
            treeView.treeNodeClick("", treeNodeId);
            treeView.focusNode(new TreeNode(null, treeNodeId, null));
        }
        billList.clearSelection();
        billList.refresh();
    }

    private boolean isCloudAppTreeDimension() {
        String listBoxFlag = this.getView().getPageCache().get(LISTBOXFLAG);
        if (StringUtil.isNotEmpty((String)listBoxFlag)) {
            return LISTBOXITEM_CLOUDAPP.equals(listBoxFlag);
        }
        return true;
    }

    private Long getPkIdByNumber(String appId) {
        String sql = String.format("SELECT FID FROM T_OPEN_APPAUTHORIZE WHERE FBIZAPP = '%s' ", appId);
        Long pkId = (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getLong("fid");
                }
                return null;
            }
        });
        return pkId;
    }

    private void treeApp() {
        TreeNode rootNode = TreeNodeUtil.buildAppTree(this.getView());
        this.getTreeModel().setRoot(rootNode);
        this.getTreeModel().setCurrentNodeId((Object)rootNode.getId());
        this.getView().updateView(TREE_VIEW);
    }

    private Map<String, Object> rebuildNodeToMap() {
        String treeNodeId = this.getTreeModel().getCurrentNodeId().toString();
        HashMap<String, Object> nodeMap = new HashMap<String, Object>(5);
        String appId = null;
        String bizId = null;
        String cusId = null;
        QFilter qFilter = null;
        if (treeNodeId.contains(NODE_APP) && !treeNodeId.contains(NODE_BIZ) && !treeNodeId.contains(NODE_CUS) && !treeNodeId.contains(NODE_AI)) {
            appId = StringUtils.substringAfter((String)treeNodeId, (String)NODE_APP);
            nodeMap.clear();
            nodeMap.put(APPID, appId);
            qFilter = new QFilter("appid.id", "=", (Object)appId);
            nodeMap.put(FILTER, qFilter);
        } else if (treeNodeId.contains(NODE_BIZ)) {
            appId = StringUtils.substringBetween((String)treeNodeId, (String)NODE_APP, (String)"_biz");
            bizId = StringUtils.substringAfter((String)treeNodeId, (String)NODE_BIZ);
            nodeMap.clear();
            nodeMap.put(APPID, appId);
            nodeMap.put(BIZID, bizId);
            qFilter = new QFilter("appid.id", "=", (Object)appId).and(new QFilter("bizobject.Id", "=", (Object)bizId));
            nodeMap.put(FILTER, qFilter);
        } else if (treeNodeId.contains(NODE_CUS) && !treeNodeId.contains("cus_api1.0")) {
            appId = StringUtils.substringBetween((String)treeNodeId, (String)NODE_APP, (String)"_cus");
            cusId = StringUtils.substringAfter((String)treeNodeId, (String)NODE_CUS);
            nodeMap.clear();
            nodeMap.put(APPID, appId);
            nodeMap.put(CUSID, cusId);
            qFilter = new QFilter("appid.id", "=", (Object)appId).and(new QFilter("customsort.Id", "=", (Object)Long.valueOf(cusId)));
            nodeMap.put(FILTER, qFilter);
        }
        if (!this.isCloudAppTreeDimension()) {
            nodeMap.put("groupId", treeNodeId);
        }
        return nodeMap;
    }

    private void buildTreeByCloud(TreeView tv1, String cloudID) {
        TreeNode root = TreeNodeUtil.buildTreeByCloud(tv1, cloudID);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getView().updateView(TREE_VIEW);
        this.defaultClickFirstNode(root.getChildren());
    }

    private void defaultClickFirstNode(List<TreeNode> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        for (TreeNode node : nodes) {
            List childNodes = node.getChildren();
            if (CollectionUtils.isEmpty((Collection)childNodes)) continue;
            TreeNode showApiInfoNode = (TreeNode)childNodes.get(0);
            TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
            treeView.showNode(showApiInfoNode.getParentid());
            treeView.focusNode(showApiInfoNode);
            treeView.treeNodeClick(showApiInfoNode.getParentid(), showApiInfoNode.getId());
            return;
        }
    }

    public static void openBillList(AbstractFormPlugin form, String entity, List<QFilter> filters, String caption) {
        ListShowParameter param = OpenApiListPlugin.getListShowParameter(entity, filters);
        param.setCaption(caption);
        form.getView().showForm((FormShowParameter)param);
    }

    private static ListShowParameter getListShowParameter(String entity, List<QFilter> filters) {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(entity);
        param.setFormId("BOS_LIST");
        param.getListFilterParameter().setQFilters(filters);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return param;
    }

    private String getCurAppName() {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        Map focusNode = treeView.getTreeState().getFocusNode();
        String appName = "";
        if (!CollectionUtil.isEmpty((Map)focusNode) && !StringUtil.isEmpty((String)((String)focusNode.get("id")))) {
            if (StringUtil.isEmpty((String)((String)focusNode.get("parentid")))) {
                appName = (String)focusNode.get("text");
            } else {
                TreeNode root = this.getTreeModel().getRoot();
                TreeNode node = TreeNodeUtil.getTreeNodeById(root, (String)focusNode.get("parentid"));
                appName = node.getText();
            }
        }
        return appName;
    }

    private String exportSwagger(List<Long> ids) {
        String fp = "." + File.separator + System.currentTimeMillis() + ".txt";
        File file = new File(fp);
        try (FileWriter fw = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fw);){
            if (!file.exists() && !file.createNewFile()) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, "An error occurred while creating the file", new Object[0]);
            }
            String swaggerJson = SwaggerUtil.genSwaggerJson(ids);
            bufferedWriter.write(swaggerJson);
        }
        catch (IOException e) {
            log.error("export swagger error", (Throwable)e);
        }
        return fp;
    }

    private void createShowGroupF7Form() {
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(true);
        para.setBillFormId("open_customgroup");
        para.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        para.getOpenStyle().setInlineStyleCss(css);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)"open_customgroup");
        para.setFormId(formConfig.getF7ListFormId());
        para.setF7Style(0);
        para.setMultiSelect(false);
        para.setShowTitle(false);
        para.setHasRight(true);
        para.setCaption(ResManager.loadKDString((String)"\u6279\u91cf\u5206\u7ec4", (String)"OpenApiListPlugin_28", (String)"bos-open-formplugin", (Object[])new Object[0]));
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BATCH_GROUP));
        this.getView().showForm((FormShowParameter)para);
    }

    private void updateGroup(BillList billList, Object result) {
        if (result instanceof ListSelectedRowCollection) {
            try {
                ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)result;
                if (!listSelectedRowCollection.isEmpty()) {
                    DynamicObject group = BusinessDataServiceHelper.loadSingle((Object)listSelectedRowCollection.get(0).getPrimaryKeyValue(), (String)"open_customgroup");
                    ListSelectedRowCollection selectedApiRows = this.getSelectedRows();
                    Object[] apiIds = selectedApiRows.getPrimaryKeyValues();
                    Object[] apis = BusinessDataServiceHelper.load((String)"openapi_apilist", (String)"group,modifytime,modifier", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)apiIds)});
                    if (group != null && CollectionUtil.isNotEmpty((Object[])apis)) {
                        for (Object api : apis) {
                            api.set("group", (Object)group);
                            api.set("modifytime", (Object)new Date());
                            api.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        }
                        SaveServiceHelper.update((DynamicObject[])apis);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5206\u7ec4\u6210\u529f\u3002", (String)"OpenApiListPlugin_29", (String)"bos-open-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                        billList.refresh();
                        billList.clearSelection();
                    }
                }
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }
}

