/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isc.util.dt.D;
import kd.bos.openapi.base.util.CommonConfigUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;

public class OpenApiParameterPlugin
extends AbstractFormPlugin {
    public static final String API_SYSCONFIG_DEV = "api_sysconfig_dev";
    public static final String KEY_API_PLUGIN = "api_global_apiplugin";
    public static final String KEY_AUTH_PLUGIN = "api_global_authplugin";
    public static final String KEY_PLUGIN_APPID = "api_global_pluginappid";
    public static final String KEY_API_LOG_LEVEL = "api_log_level";
    public static final String KEY_API_LOG_DAYS = "api_log_days";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_API_PLUGIN, KEY_AUTH_PLUGIN, "api_tokenext_plugin"});
        TextEdit codeKey = (TextEdit)this.getView().getControl("code");
        if (codeKey != null) {
            codeKey.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object sysConfig = this.getModel().getValue(API_SYSCONFIG_DEV);
        if (sysConfig != null && "true".equalsIgnoreCase(sysConfig.toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        }
        this.getModel().setValue(API_SYSCONFIG_DEV, (Object)Boolean.TRUE);
        this.logRadioControl();
    }

    private void logRadioControl() {
        String logRadioValue;
        this.getView().setVisible(Boolean.FALSE, new String[]{"none_labelap", "summary_labelap", "detail_labelap", "detail_labelap2", "full_labelap", "fulllog_days"});
        Object radiogroupfield = this.getModel().getValue(KEY_API_LOG_LEVEL);
        String string = logRadioValue = radiogroupfield != null ? radiogroupfield.toString() : "";
        if ("none".equals(logRadioValue)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"none_labelap"});
        } else if ("summary".equals(logRadioValue)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"summary_labelap"});
        } else if ("detail".equals(logRadioValue)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"detail_labelap", "detail_labelap2"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"full_labelap", "fulllog_days"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int costdata_threshold;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (KEY_PLUGIN_APPID.equals(name)) {
            List pluginList;
            String pluginAppId = this.getModel().getValue(KEY_PLUGIN_APPID) == null ? "" : ((DynamicObject)this.getModel().getValue(KEY_PLUGIN_APPID)).getString("number");
            String pluginInfo = CommonConfigUtil.getValue((int)7, (String)KEY_AUTH_PLUGIN, (String)RequestContext.get().getAccountId());
            if (StringUtil.isNotEmpty((String)pluginInfo) && CollectionUtil.isNotEmpty((Collection)(pluginList = (List)SerializationUtils.fromJsonString((String)pluginInfo, List.class)))) {
                pluginList.forEach(item -> item.put(KEY_PLUGIN_APPID, pluginAppId));
                String jsonString = SerializationUtils.toJsonString((Object)pluginList);
                CommonConfigUtil.setValue((int)7, (String)KEY_AUTH_PLUGIN, (String)jsonString);
                this.getModel().setValue(KEY_AUTH_PLUGIN, (Object)jsonString);
            }
        } else if (KEY_AUTH_PLUGIN.equals(name)) {
            String plugin = D.s((Object)this.getModel().getValue(KEY_AUTH_PLUGIN));
            if (StringUtil.isEmpty((String)plugin)) {
                CommonConfigUtil.setValue((int)7, (String)KEY_AUTH_PLUGIN, (String)"");
            }
        } else if (KEY_API_LOG_LEVEL.equals(name)) {
            this.logRadioControl();
        } else if (KEY_API_LOG_DAYS.equals(name)) {
            int day = D.i((Object)this.getModel().getValue(KEY_API_LOG_DAYS));
            if (day > 30) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5efa\u8bae\u65e5\u5fd7\u4fdd\u7559\u5929\u6570\u6700\u591a\u4fdd\u755930\u5929\uff0c\u60a8\u53ef\u4ee5\u4f7f\u7528\u65e5\u5fd7\u5f52\u6863\u529f\u80fd\u4fdd\u7559\u66f4\u4e45\u7684API\u8c03\u7528\u65e5\u5fd7\u3002", (String)"OpenApiParameterPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            }
        } else if ("costdata_threshold".equals(name) && (costdata_threshold = D.i((Object)this.getModel().getValue("costdata_threshold"))) != 0 && (costdata_threshold < 3000 || costdata_threshold > 60000)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6162\u63a5\u53e3\u9608\u503c\u8d85\u51fa\u8303\u56f4[3000,60000]\u3002", (String)"OpenApiParameterPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("costdata_threshold", (Object)"");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        try {
            if (KEY_AUTH_PLUGIN.equals(control.getKey())) {
                this.checkPluginAppId();
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("ide_plugins");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "authPluginRegister"));
                String plugins = (String)this.getModel().getValue(KEY_AUTH_PLUGIN);
                if (StringUtil.isNotEmpty((String)plugins)) {
                    formShowParameter.setCustomParam("value", SerializationUtils.fromJsonString((String)plugins, List.class));
                }
                this.getView().showForm(formShowParameter);
            } else if (KEY_API_PLUGIN.equals(control.getKey())) {
                this.checkPluginAppId();
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("ide_plugins");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "apiPluginRegister"));
                String plugins = (String)this.getModel().getValue(KEY_API_PLUGIN);
                if (StringUtil.isNotEmpty((String)plugins)) {
                    formShowParameter.setCustomParam("value", SerializationUtils.fromJsonString((String)plugins, List.class));
                }
                this.getView().showForm(formShowParameter);
            } else if ("api_tokenext_plugin".equals(control.getKey())) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("ide_plugins");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tokenextPluginRegister"));
                String plugins = (String)this.getModel().getValue("api_tokenext_plugin");
                if (StringUtil.isNotEmpty((String)plugins)) {
                    formShowParameter.setCustomParam("value", SerializationUtils.fromJsonString((String)plugins, List.class));
                }
                this.getView().showForm(formShowParameter);
            }
        }
        catch (OpenApiException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void checkPluginAppId() {
        if (this.getModel().getValue(KEY_PLUGIN_APPID) == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u63d2\u4ef6\u5e94\u7528\u3002", (String)"OpenApiParameterPlugin_0", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
        }
        DynamicObject pluginAppIdDy = (DynamicObject)this.getModel().getValue(KEY_PLUGIN_APPID);
        if (pluginAppIdDy == null || StringUtil.isEmpty((String)pluginAppIdDy.getString("id"))) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u63d2\u4ef6\u5e94\u7528\u3002", (String)"OpenApiParameterPlugin_0", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Map returnData = (Map)evt.getReturnData();
        if (returnData == null) {
            return;
        }
        try {
            boolean isSave = false;
            String plugin = "";
            if ("authPluginRegister".equalsIgnoreCase(action)) {
                if (!returnData.isEmpty()) {
                    isSave = true;
                    plugin = KEY_AUTH_PLUGIN;
                }
            } else if ("apiPluginRegister".equalsIgnoreCase(action)) {
                if (!returnData.isEmpty()) {
                    isSave = true;
                    plugin = KEY_API_PLUGIN;
                }
            } else if ("tokenextPluginRegister".equalsIgnoreCase(action) && !returnData.isEmpty()) {
                isSave = true;
                plugin = "api_tokenext_plugin";
            }
            if (isSave) {
                List pluginList = (List)returnData.get("value");
                String pluginAppId = ((DynamicObject)this.getModel().getValue(KEY_PLUGIN_APPID)).getString("number");
                if (CollectionUtil.isNotEmpty((Collection)pluginList)) {
                    boolean checkPlugin = false;
                    AtomicInteger pluginCount = new AtomicInteger();
                    pluginList.forEach(item -> {
                        if (D.x(item.get("Enabled"))) {
                            pluginCount.getAndIncrement();
                        }
                        item.put(KEY_PLUGIN_APPID, pluginAppId);
                    });
                    if (pluginCount.get() > 1) {
                        throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u63a5\u53e3\u9274\u6743\u63d2\u4ef6\u53ea\u652f\u6301\u4e00\u4e2a\u6709\u6548\u7684\u63d2\u4ef6\u3002", (String)"OpenApiParameterPlugin_1", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
                    }
                }
                String jsonString = SerializationUtils.toJsonString((Object)pluginList);
                this.getModel().setValue(plugin, (Object)jsonString);
                CommonConfigUtil.setValue((int)7, (String)plugin, (String)jsonString);
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("value too long")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u8def\u5f84\u8fc7\u957f\uff0c\u6240\u6709\u63d2\u4ef6\u8def\u5f84\u5b57\u6bb5\u5408\u8ba1\u4e0d\u80fd\u8d85\u8fc7500\u4e2a\u5b57\u7b26\u3002", (String)"OpenApiParameterPlugin_3", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]));
            }
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
    }
}

