/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.EventObject;
import java.util.HashMap;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.util.enums.FilterValueTypeEnum;

public class OpenApiScriptFilterValueFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String BTNOK = "btnok";
    private static final String BTNCANCEL = "btncancel";
    private static final String RADIOGROUPFIELD = "radiogroupfield";
    private static final String FUNTION_COMBOFIELD = "funtion_combofield";
    private static final String CODEEDITTAP = "codeeditap";
    private static final String TREEVIEWAP = "treeviewap";
    private static final String TOSCRIPTHELP = "toscripthelp";
    private static final String OPENAPI_SCRIPT_HELPER = "openapi_script_helper";
    public static final String ISFILTERVALUE = "isfiltervalue";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK, BTNCANCEL});
        this.addClickListeners(new String[]{TOSCRIPTHELP});
        TreeView treeView = (TreeView)this.getView().getControl(TREEVIEWAP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (TOSCRIPTHELP.equals(opKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(OPENAPI_SCRIPT_HELPER);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam(ISFILTERVALUE, (Object)"true");
            this.getView().showForm(showParameter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtil.equals((String)source.getKey(), (String)BTNOK)) {
            String codeText = ((CodeEdit)this.getView().getControl(CODEEDITTAP)).getText();
            String formatCodeText = codeText.replaceAll("[\\s\n\t\r]", "");
            if (StringUtil.isNotEmpty((String)codeText) && !"#{}".equals(formatCodeText) && !"<%%>".equals(formatCodeText)) {
                String radioValue = this.getModel().getValue(RADIOGROUPFIELD).toString();
                if (this.scriptFormatCheck(codeText, radioValue)) {
                    return;
                }
                boolean jsonString = JsonUtil.isJsonString((String)codeText, (boolean)true);
                if (!jsonString) {
                    codeText = JsonUtil.toJsonString((Object)codeText, (SerializerFeature[])new SerializerFeature[0]);
                }
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("codeText", codeText);
                this.getView().returnDataToParent(param);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bd4\u8f83\u5e38\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OpenApiScriptFilterValueFormPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean scriptFormatCheck(String codeText, String radioValue) {
        if ("2".equals(radioValue)) {
            if (!this.isScriptExpression(codeText)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u4ee5<%\u5f00\u5934\uff0c%>\u7ed3\u5c3e\uff0c\u524d\u540e\u4e0d\u80fd\u6709\u7a7a\u683c\u3002", (String)"OpenApiScriptFilterValueFormPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return true;
            }
        } else if ("3".equals(radioValue) && !this.isScriptFuntion(codeText)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u51fd\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u4ee5#{\u5f00\u5934\uff0c}\u7ed3\u5c3e\uff0c\u524d\u540e\u4e0d\u80fd\u6709\u7a7a\u683c\u3002", (String)"OpenApiScriptFilterValueFormPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try {
            FormShowParameter param = this.getView().getFormShowParameter();
            String obj = (String)param.getCustomParam("entryValue");
            if (StringUtil.isNotEmpty((String)obj)) {
                String entryValue = this.isArray(obj) || NUMBER_PATTERN.matcher(obj).matches() ? obj : (String)JSON.parse((String)obj);
                if (this.isScriptExpression(entryValue)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{TREEVIEWAP});
                    this.getModel().setValue(RADIOGROUPFIELD, (Object)ValueType.SCRIPTEXPRESSION.getCode());
                    this.getView().setVisible(Boolean.FALSE, new String[]{FUNTION_COMBOFIELD});
                } else if (this.isScriptFuntion(entryValue)) {
                    TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
                    this.initTree(tree);
                    this.getView().setVisible(Boolean.TRUE, new String[]{TREEVIEWAP});
                    this.getModel().setValue(RADIOGROUPFIELD, (Object)ValueType.SCRIPTFUNTION.getCode());
                    this.getView().setVisible(Boolean.TRUE, new String[]{FUNTION_COMBOFIELD});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{TREEVIEWAP});
                    this.getModel().setValue(RADIOGROUPFIELD, (Object)ValueType.NORMAL.getCode());
                    this.getView().setVisible(Boolean.FALSE, new String[]{FUNTION_COMBOFIELD});
                }
                CodeEdit edit = (CodeEdit)this.getView().getControl(CODEEDITTAP);
                edit.setText(entryValue);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{TREEVIEWAP});
                this.getModel().setValue(RADIOGROUPFIELD, (Object)ValueType.NORMAL.getCode());
                this.getView().setVisible(Boolean.FALSE, new String[]{FUNTION_COMBOFIELD});
                CodeEdit edit = (CodeEdit)this.getView().getControl(CODEEDITTAP);
                edit.setText("");
            }
            this.getView().updateView(RADIOGROUPFIELD);
            this.getView().updateView(TREEVIEWAP);
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private void initTree(TreeView tree) {
        String rootId = "0";
        TreeNode rootNode = new TreeNode(null, "0", ResManager.loadKDString((String)"\u53ef\u9009\u62e9\u9884\u7f6e\u811a\u672c\u51fd\u6570", (String)"OpenApiScriptFilterValueFormPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]), true);
        rootNode.setIsOpened(true);
        FilterValueTypeEnum[] enums = FilterValueTypeEnum.values();
        for (int i = 0; i < enums.length; ++i) {
            String curId = enums[i].getId();
            String curText = enums[i].getText();
            TreeNode tn1 = new TreeNode("0", curId, curText, false);
            tn1.setIsOpened(true);
            rootNode.addChild(tn1);
        }
        tree.addNode(rootNode);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        CodeEdit edit = (CodeEdit)this.getView().getControl(CODEEDITTAP);
        if (propName.equals(RADIOGROUPFIELD)) {
            String radioValue = this.getModel().getValue(RADIOGROUPFIELD).toString();
            edit.setText("");
            if (radioValue.equals(ValueType.SCRIPTFUNTION.getCode())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FUNTION_COMBOFIELD});
                this.getModel().setValue(FUNTION_COMBOFIELD, (Object)"");
                TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
                this.initTree(tree);
                this.getView().setVisible(Boolean.TRUE, new String[]{TREEVIEWAP});
            } else if (radioValue.equals(ValueType.SCRIPTEXPRESSION.getCode())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FUNTION_COMBOFIELD});
                edit.setText("<%\n  \n%>");
                this.getView().setVisible(Boolean.FALSE, new String[]{TREEVIEWAP});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{FUNTION_COMBOFIELD});
                this.getView().setVisible(Boolean.FALSE, new String[]{TREEVIEWAP});
            }
        } else if (propName.equals(FUNTION_COMBOFIELD)) {
            String funtionValue = this.getModel().getValue(FUNTION_COMBOFIELD).toString();
            edit.setText(funtionValue);
        }
    }

    private boolean isArray(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String str = (String)obj;
        return (str = str.replaceAll("[\\s\n\t\r]", "")).startsWith("[") && str.endsWith("]");
    }

    private boolean isScriptExpression(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String str = (String)obj;
        return str.startsWith("<%") && str.endsWith("%>");
    }

    private boolean isScriptFuntion(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String str = (String)obj;
        return str.startsWith("#{") && str.endsWith("}");
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        if (TREEVIEWAP.equals(source.getKey())) {
            String curNodeID = (String)evt.getNodeId();
            String value = FilterValueTypeEnum.getFilterValueTypeById(curNodeID);
            CodeEdit edit = (CodeEdit)this.getView().getControl(CODEEDITTAP);
            edit.setText(value);
        }
    }

    public static enum ValueType {
        NORMAL("1"),
        SCRIPTEXPRESSION("2"),
        SCRIPTFUNTION("3");

        private final String code;

        private ValueType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

