/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OpenApiStatusPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(OpenApiStatusPlugin.class);
    private static final String BTN_OK = "btnok";
    private static final String KEY_PKS = "pks";
    private static final String KEY_STATUS = "status";
    private static final String FORM_OPENAPI_APILIST = "openapi_apilist";
    public static final String ISV_KINGDEE = "kingdee";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (null != showParameter.getCustomParam(KEY_PKS)) {
            String status = (String)showParameter.getCustomParam(KEY_STATUS);
            this.getModel().setValue(KEY_STATUS, (Object)status);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        AbstractOperate operate;
        String operateKey;
        if (args.getSource() instanceof AbstractOperate && "confirm".equalsIgnoreCase(operateKey = (operate = (AbstractOperate)args.getSource()).getOperateKey())) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            List ids = (List)showParameter.getCustomParam(KEY_PKS);
            String status = (String)showParameter.getCustomParam(KEY_STATUS);
            if (status.equals(this.getModel().getValue(KEY_STATUS).toString())) {
                this.getView().returnDataToParent((Object)Boolean.FALSE);
                this.getView().close();
            } else {
                DynamicObject[] apis;
                for (DynamicObject api : apis = BusinessDataServiceHelper.load((String)FORM_OPENAPI_APILIST, (String)"status,modifytime,modifier,enable,stdmodifytime,isvid", (QFilter[])new QFilter("Id", "in", (Object)ids).toArray())) {
                    String isvId;
                    String statusNow = this.getModel().getValue(KEY_STATUS).toString();
                    api.set(KEY_STATUS, this.getModel().getValue(KEY_STATUS));
                    api.set("modifytime", (Object)new Date());
                    api.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    if (statusNow.equalsIgnoreCase(ApiStatus.DISABLE.getCode())) {
                        api.set("enable", (Object)0);
                    } else {
                        api.set("enable", (Object)1);
                    }
                    if (statusNow.equalsIgnoreCase(ApiStatus.BETA.getCode()) || !ISV_KINGDEE.equals(isvId = ISVServiceHelper.getISVInfo().getId()) || !ISV_KINGDEE.equals(api.getString("isvid"))) continue;
                    api.set("stdmodifytime", (Object)new Date());
                }
                Object[] res = SaveServiceHelper.save((DynamicObject[])apis);
                if (res.length > 0) {
                    log.info("\u66f4\u65b0\u72b6\u6001\u7684api", res);
                    this.getView().returnDataToParent((Object)Boolean.TRUE);
                    this.getView().close();
                } else {
                    this.getView().returnDataToParent((Object)Boolean.FALSE);
                    this.getView().close();
                }
            }
        }
    }
}

