/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Closeable;
import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.RestSoapType;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.IOUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.PathVariableUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.common.util.SysUtil;
import kd.bos.openapi.common.util.XmlUtil;
import kd.bos.openapi.common.wsdl.SoapUtil;
import kd.bos.openapi.form.util.FormOpener;
import kd.bos.openapi.form.util.OpenApiTestUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class OpenApiTestApiPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(OpenApiTestApiPlugin.class);
    private static final String PRE_DATA = "preData";
    private static final String PRE_URL = "preUrl";
    private static final String IS_GET_METHOD = "isGetMethod";
    private static final Integer TIME_OUT = 60000;
    public static final String JSON = "json";
    public static final String XML = "xml";
    public static final String SOAP_1_1 = "soap1_1";
    public static final String SOAP_1_2 = "soap1_2";
    public static final String ACCESSTOKEN = "accessToken";
    private String[] buttons = new String[]{"send"};
    public static final String INPUTPARAM = "wsinputparam";
    public static final String NAMESPACE = "namespace";
    private static final String BOS_FORM_BUSINESS = "bos-open-formplugin";
    private static final String X_ACGW_IDENTITY = "x-acgw-identity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.buttons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("send")) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            CodeEdit jsonCode = (CodeEdit)this.getView().getControl("jsoncode");
            Object preData = jsonCode.getText() != null ? jsonCode.getText() : parameter.getCustomParam(PRE_DATA);
            boolean isGetMethod = DataUtil.x((Object)parameter.getCustomParam(IS_GET_METHOD));
            CodeEdit edit = (CodeEdit)this.getView().getControl("jsonresult");
            CodeEdit messageEdit = (CodeEdit)this.getView().getControl("jsonmessage");
            CloseableHttpResponse response = null;
            CloseableHttpClient httpClient = null;
            try {
                OpenApiTestUtil util = new OpenApiTestUtil();
                Map<String, Object> map = util.getAccessTokenByAppId();
                if (null == map.get("access_token")) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6accessToken\u5931\u8d25\uff0c\u8be6\u7ec6\u4fe1\u606f\uff1a%1$s", (String)"OpenApiTestApiPlugin_9", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), map.get("request") != null ? map.get("request").toString() : ""));
                }
                httpClient = HttpClientBuilder.create().build();
                response = this.testApi(httpClient, parameter, preData, isGetMethod, map.get("access_token").toString());
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                JSONObject jsonObject = this.getResponseJsonObject(response, result);
                String traceId = response.getHeaders("traceId")[0].getElements()[0].getName();
                if (jsonObject != null && jsonObject.containsKey((Object)"status") && jsonObject.containsKey((Object)"errorCode")) {
                    boolean status = jsonObject.getBoolean("status");
                    String errorCode = jsonObject.getString("errorCode");
                    if (!status && ApiErrorCode.HTTP_UNAUTHORIZED.getStatusCode().equals(errorCode)) {
                        map = util.getAccessTokenByAppIdFocus();
                        response = this.testApi(httpClient, parameter, preData, isGetMethod, map.get("access_token").toString());
                        result = EntityUtils.toString((HttpEntity)response.getEntity());
                        jsonObject = this.getResponseJsonObject(response, result);
                        traceId = response.getHeaders("traceId")[0].getElements()[0].getName();
                    }
                }
                if (response.getStatusLine().getStatusCode() < 400) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u7528\u6210\u529f\u3002", (String)"OpenApiTestApiPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u7528\u5931\u8d25\u3002", (String)"OpenApiTestApiPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                }
                if (jsonObject != null && jsonObject.get((Object)"message") != null) {
                    String stack = jsonObject.get((Object)"message").toString();
                    messageEdit.setText(stack.concat("\n").concat(traceId));
                } else {
                    Header header = response.getFirstHeader("OpenApi-Message");
                    String message = "";
                    if (header != null) {
                        message = header.getValue();
                        message = message.replace("  at  ", "\n  at ");
                    }
                    messageEdit.setText(message.concat("\n").concat("traceId:" + traceId));
                }
                edit.setText(result);
            }
            catch (Throwable e) {
                try {
                    edit.setText(e.getMessage());
                    String msg = String.format(ResManager.loadKDString((String)"\u53d1\u751f\u5f02\u5e38\uff0c\u8c03\u7528\u5931\u8d25 - %1$s\u3002", (String)"OpenApiTestApiPlugin_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), e.getMessage());
                    this.getView().showErrorNotification(msg);
                    log.info("\u53d1\u751f\u5f02\u5e38\uff0c\u8c03\u7528\u5931\u8d25:", (Object)e);
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(response);
                    IOUtil.closeQuietly(httpClient);
                    throw throwable;
                }
                IOUtil.closeQuietly((Closeable)response);
                IOUtil.closeQuietly((Closeable)httpClient);
            }
            IOUtil.closeQuietly((Closeable)response);
            IOUtil.closeQuietly((Closeable)httpClient);
        }
    }

    private JSONObject getResponseJsonObject(CloseableHttpResponse response, String result) {
        if (response == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u5f02\u5e38\u3002", (String)"OpenApiTestApiPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)JsonUtil.parseJson((String)result);
        }
        catch (Exception ex) {
            log.info(ResManager.loadKDString((String)"\u6d4b\u8bd5API\u65f6\uff0c\u8fd4\u56de\u7ed3\u679c\u4e0d\u662fjson\u5bf9\u8c61 ", (String)"OpenApiTestApiPlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]) + ex);
        }
        return jsonObject;
    }

    public void afterCreateNewData(EventObject eventObject) {
        block15: {
            super.afterCreateNewData(eventObject);
            try {
                String urlvalue;
                FormShowParameter parameter = this.getView().getFormShowParameter();
                Object preData = JsonUtil.parseJson((String)((String)parameter.getCustomParam(PRE_DATA)));
                boolean isGetMethod = DataUtil.x((Object)parameter.getCustomParam(IS_GET_METHOD));
                String urlCosmic = UrlService.getDomainContextUrl();
                String preUrl = "/kapi" + parameter.getCustomParam(PRE_URL);
                Label meth = (Label)this.getControl("httpmethod");
                Label url = (Label)this.getControl("url");
                if (isGetMethod) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3", "protocol"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"url_text"});
                    meth.setText("GET");
                    Map<String, Object> getDataMap = this.getMethodData(preData);
                    if ("".equals(getDataMap.get("orderBy"))) {
                        getDataMap.remove("orderBy");
                    }
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, Object> entry : getDataMap.entrySet()) {
                        Object value;
                        if (sb.length() > 0) {
                            sb.append('&');
                        }
                        if ((value = entry.getValue()) instanceof JSONArray) {
                            JSONArray valArray = (JSONArray)value;
                            for (int i = 0; i < valArray.size(); ++i) {
                                sb.append(i == 0 ? "" : Character.valueOf('&')).append(entry.getKey()).append('=').append(valArray.get(i));
                            }
                            continue;
                        }
                        String key = entry.getKey();
                        String pathvariable = "{" + key + "}";
                        if (preUrl.contains(pathvariable)) {
                            if (sb.length() > 0) {
                                sb.replace(sb.length() - 1, sb.length(), "");
                            }
                            preUrl = preUrl.replace(pathvariable, String.valueOf(value));
                            continue;
                        }
                        sb.append(key).append('=').append(value);
                    }
                    if (StringUtil.isNotEmpty((String)sb.toString())) {
                        sb.insert(0, '?');
                    }
                    sb.insert(0, preUrl);
                    sb.insert(0, urlCosmic);
                    String json = sb.toString().trim();
                    this.getModel().setValue("url_text", (Object)json);
                    this.getPageCache().put("GetUrl", json);
                    Container con = (Container)this.getControl("splitpanelap");
                    con.setCollapse(true);
                    break block15;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"protocol", "url_text"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3"});
                CodeEdit jsonCode = (CodeEdit)this.getView().getControl("jsoncode");
                if (preData != null) {
                    String json = com.alibaba.fastjson.JSON.toJSONString((Object)preData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
                    jsonCode.setText(json);
                }
                if (PathVariableUtil.isPathVariableUri((String)(urlvalue = urlCosmic + preUrl))) {
                    Map<String, Object> getDataMap = this.getMethodData(preData);
                    for (Map.Entry<String, Object> entry : getDataMap.entrySet()) {
                        Object value = entry.getValue();
                        String key = entry.getKey();
                        String pathvariable = "{" + key + "}";
                        if (!urlvalue.contains(pathvariable)) continue;
                        urlvalue = urlvalue.replace(pathvariable, String.valueOf(value));
                    }
                }
                this.getModel().setValue("url_text", (Object)urlvalue);
                meth.setText("POST");
            }
            catch (KDException e) {
                this.getView().showErrorNotification(e.getMessage());
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (SysUtil.isProdEnv()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"send"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equalsIgnoreCase("protocol")) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Object preData = JsonUtil.parseJson((String)((String)parameter.getCustomParam(PRE_DATA)));
            String protocolType = this.getModel().getValue("protocol") == null ? JSON : this.getModel().getValue("protocol").toString();
            CodeEdit jsonCode = (CodeEdit)this.getView().getControl("jsoncode");
            jsonCode.setText(this.getReqStr(protocolType, preData));
        }
    }

    private CloseableHttpResponse testApi(CloseableHttpClient httpClient, FormShowParameter parameter, Object data, boolean isGetMethod, String token) throws Exception {
        if (null == RequestContext.get().getApi3rdAppId()) {
            RequestContext.get().setApi3rdAppId(QueryServiceHelper.queryOne((String)"third_app", (String)"Id", (QFilter[])new QFilter("number", "=", (Object)"openapi_unittest").toArray()).getString("Id"));
        }
        HashMap<String, String> header = new HashMap<String, String>(4);
        if (isGetMethod) {
            String fullUrl = this.getModel().getValue("url_text").toString().replace(' ', '+').replace("\"", "");
            return this.doGet(fullUrl, token);
        }
        String protocolType = this.getModel().getValue("protocol") == null ? JSON : this.getModel().getValue("protocol").toString();
        header.put("Content-Type", this.getHeaderValue(protocolType));
        header.put(ACCESSTOKEN, token);
        header.put("accountId", RequestContext.get().getAccountId());
        Map<String, String> identityByThirdApp = this.getIdentityByThirdApp();
        if (!CollectionUtil.isEmpty(identityByThirdApp)) {
            header.put(X_ACGW_IDENTITY, identityByThirdApp.get(X_ACGW_IDENTITY));
            log.info("api\u6d4b\u8bd5\u8bf7\u6c42\u8be6\u60c5\uff1aurl:{}\uff1bheader\u4e2dx-acgw-identity\u7684\u503c\u4e3a:{}", (Object)this.getModel().getValue("url_text").toString(), header.get(X_ACGW_IDENTITY));
        }
        String fullUrl = this.getModel().getValue("url_text").toString().replace(' ', '+').replace("\"", "");
        return this.doPost(httpClient, fullUrl, header, data.toString());
    }

    private String getReqStr(String protocolType, Object preData) {
        String reqStr;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String nameSpace = (String)parameter.getCustomParam(NAMESPACE);
        String inputParam = (String)parameter.getCustomParam(INPUTPARAM);
        if (XML.equalsIgnoreCase(protocolType)) {
            try {
                reqStr = XmlUtil.objectToXml((Object)preData, (String)inputParam);
            }
            catch (Exception e) {
                reqStr = e.getMessage();
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"send"});
        } else if (SOAP_1_1.equalsIgnoreCase(protocolType)) {
            if (preData != null && StringUtil.isEmpty((String)inputParam)) {
                reqStr = ResManager.loadKDString((String)"\u82e5\u8981\u4f7f\u7528soap\u62a5\u6587\uff0c\u8bf7\u586b\u5199webService\u4fe1\u606f\u7684\u8f93\u5165\u53c2\u6570\u540d\u3002", (String)"OpenApiTestApiPlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"send"});
            } else {
                try {
                    reqStr = SoapUtil.getSoapXml((Object)preData, (RestSoapType)RestSoapType.SOAP1_1, (String)nameSpace, (String)inputParam);
                }
                catch (Exception e) {
                    reqStr = e.getMessage();
                }
            }
        } else if (SOAP_1_2.equalsIgnoreCase(protocolType)) {
            if (preData != null && StringUtil.isEmpty((String)inputParam)) {
                reqStr = ResManager.loadKDString((String)"\u82e5\u8981\u4f7f\u7528soap\u62a5\u6587\uff0c\u8bf7\u586b\u5199webService\u4fe1\u606f\u7684\u8f93\u5165\u53c2\u6570\u540d\u3002", (String)"OpenApiTestApiPlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"send"});
            } else {
                try {
                    reqStr = SoapUtil.getSoapXml((Object)preData, (RestSoapType)RestSoapType.SOAP1_2, (String)nameSpace, (String)inputParam);
                }
                catch (Exception e) {
                    reqStr = e.getMessage();
                }
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"send"});
            reqStr = com.alibaba.fastjson.JSON.toJSONString((Object)preData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        }
        return reqStr;
    }

    private String getHeaderValue(String protocolType) {
        String header = null;
        header = XML.equalsIgnoreCase(protocolType) ? "application/xml" : (SOAP_1_1.equalsIgnoreCase(protocolType) ? "text/xml" : (SOAP_1_2.equalsIgnoreCase(protocolType) ? "application/soap+xml" : "application/json"));
        return header;
    }

    private Map<String, Object> getMethodData(Object preData) {
        if (!(preData instanceof Map)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\u3002", (String)"OpenApiTestApiPlugin_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
        Map map = (Map)preData;
        HashMap<String, Object> getDataMap = (HashMap<String, Object>)map.get("data");
        if (getDataMap == null) {
            getDataMap = new HashMap<String, Object>(map.size());
        }
        for (Map.Entry entry : map.entrySet()) {
            if ("data".equals(entry.getKey())) continue;
            getDataMap.put((String)entry.getKey(), entry.getValue());
        }
        return getDataMap;
    }

    private RequestConfig getRequestConfig() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(TIME_OUT.intValue()).setRedirectsEnabled(true).build();
        return requestConfig;
    }

    private CloseableHttpResponse doGet(String url, String token) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(url);
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        Map<String, String> identityByThirdApp = this.getIdentityByThirdApp();
        if (!CollectionUtil.isEmpty(identityByThirdApp)) {
            httpGet.setHeader(X_ACGW_IDENTITY, identityByThirdApp.get(X_ACGW_IDENTITY));
            log.info("api\u6d4b\u8bd5\u8bf7\u6c42\u8be6\u60c5\uff1aurl:{}\uff1bheader\u4e2dx-acgw-identity\u7684\u503c\u4e3a:{}", (Object)url, (Object)httpGet.getHeaders(X_ACGW_IDENTITY));
        }
        httpGet.setHeader("Content-Type", "application/x-www-form-urlencoded");
        httpGet.setHeader(ACCESSTOKEN, token);
        httpGet.setHeader("accountId", RequestContext.get().getAccountId());
        RequestConfig requestConfig = this.getRequestConfig();
        httpGet.setConfig(requestConfig);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        return response;
    }

    private Map<String, String> getIdentityByThirdApp() {
        OpenApiTestUtil util = new OpenApiTestUtil();
        Map<String, String> identityByThirdApp = util.getIdentityByThirdApp();
        return identityByThirdApp;
    }

    private CloseableHttpResponse doPost(CloseableHttpClient httpClient, String url, Map<String, String> header, String reqStr) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        String reqString = reqStr;
        StringEntity entity = new StringEntity(reqString, "UTF-8");
        RequestConfig requestConfig = this.getRequestConfig();
        httpPost.setConfig(requestConfig);
        httpPost.setEntity((HttpEntity)entity);
        Set<Map.Entry<String, String>> entrySet = header.entrySet();
        entrySet.stream().forEach(it -> httpPost.setHeader((String)it.getKey(), (String)it.getValue()));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        return response;
    }
}

