/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.cloudUpdate.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.isc.util.misc.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.open.res.model.ThirdAppApplyDto;
import kd.bos.open.res.util.ResourceClientUtil;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.security.ApiSecurityService;
import kd.bos.openapi.security.model.SignInfoDto;
import kd.bos.util.HttpClientUtils;
import org.apache.http.conn.ConnectTimeoutException;

public class OpenApiDigestAuthUtil {
    private static Log logger = LogFactory.getLog(OpenApiDigestAuthUtil.class);
    private static int CONNECTION_TIMEOUT = Integer.getInteger("httpclient.connectionTimeout", 5000);
    private static int READ_TIMEOUT = Integer.getInteger("httpclient.readTimeout", 8000);

    public static <T> CustomApiResult<T> sendDigestApiRequest(String url, Class<T> clazz, String jsonContent) throws OpenApiException {
        ThirdAppApplyDto thirdAppApplyDto = OpenApiDigestAuthUtil.getResourceClientInfo();
        return OpenApiDigestAuthUtil.doDigestApiRequest(url, thirdAppApplyDto, clazz, jsonContent);
    }

    public static <T> CustomApiResult<T> doDigestApiRequest(String url, ThirdAppApplyDto params, Class<T> clazz, String jsonContent) throws OpenApiException {
        logger.info(String.format("---------------OpenApiDigestAuthUtil.doDigestApiRequest url:%s, params:%s, jsonContent:%s", url, params, jsonContent));
        String appSecret = params.getPublickey();
        String openApiSign = params.getSecretKey();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        String timestamp = DateUtil.convertToStr((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
        String uuid = UUID.randomUUID().toString();
        headerMap.put("signatureNonce", uuid);
        headerMap.put("timestamp", timestamp);
        headerMap.put("appId", params.getThirdcode());
        headerMap.put("accountId", params.getTargetaccountid());
        headerMap.put("user", params.getThirdcode());
        headerMap.put("usertype", "UserName");
        headerMap.put("signature", OpenApiDigestAuthUtil.getSignature(jsonContent, timestamp, uuid, appSecret));
        headerMap.put("Content-Type", "application/json");
        String responseString = "";
        try {
            responseString = HttpClientUtils.postjson((String)url, headerMap, (String)jsonContent, (int)CONNECTION_TIMEOUT, (int)READ_TIMEOUT);
        }
        catch (SocketTimeoutException | ConnectTimeoutException e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, ResManager.loadKDString((String)"\u8d44\u6e90\u4e91\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"OpenApiSecurityUtil_1", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            logger.info("request.header:" + JSON.toJSONString(headerMap) + " request.body:" + jsonContent + " response-=" + responseString + " doDigestApiRequest send post error:" + e.getMessage(), (Object)e);
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, ResManager.loadKDString((String)"\u60a8\u586b\u5199\u7684\u4e91\u7aef\u5730\u5740\u65e0\u6cd5\u8fde\u63a5\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4e91\u7aef\u5730\u5740\u3002", (String)"ThirdAppApplyFormPlugin_23", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
        }
        String loginErrorCode = ApiErrorCode.LOGIN_BIZ_ERROR.getStatusCode();
        if (responseString.contains(loginErrorCode)) {
            JSONObject errorResponse = JSON.parseObject((String)responseString);
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, errorResponse.getString("errorMsg"), new Object[0]);
        }
        CustomApiResult result = null;
        try {
            result = (CustomApiResult)JSON.parseObject((String)responseString, (TypeReference)new TypeReference<CustomApiResult<T>>(){}, (Feature[])new Feature[0]);
            String dataString = JSON.toJSONString((Object)result.getData());
            Object data = JSON.toJavaObject((JSON)JSON.parseObject((String)dataString), clazz);
            result.setData(data);
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "doDigestApiRequest receive post error:" + StringUtil.getCascadeMessage((Throwable)e) + " responseString:" + responseString, new Object[]{e});
        }
        logger.info(String.format("---------------OpenApiDigestAuthUtil.doDigestApiRequest result:%s ", url, params, JSON.toJSONString((Object)result)));
        return result;
    }

    private static String getSignature(String content, String timestamp, String uuid, String publicKey) {
        SignInfoDto signInfo = new SignInfoDto();
        signInfo.setContent(content);
        signInfo.setDateTime(timestamp);
        signInfo.setSignatureNonce(uuid);
        signInfo.setAuthType("2");
        ApiSecurityService apiSecurityService = ApiSecurityFactory.getApiSecurityService();
        String encyptString = apiSecurityService.signingBySha256(publicKey, signInfo);
        return encyptString;
    }

    public static ThirdAppApplyDto getResourceClientInfo() {
        ThirdAppApplyDto thirdAppApplyDto = ResourceClientUtil.findResourceClientInfo();
        if (thirdAppApplyDto == null) {
            throw new OpenApiException(ApiErrorCode.Data_NotFound, ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"OpenApiCloudUpdatePlugin_4", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        return thirdAppApplyDto;
    }
}

