/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.importApi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isc.service.dts.bean.ImportStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.dts.ImportMode;
import kd.bos.openapi.base.dts.bean.OpenImportResponse;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.util.ExportUtil;
import kd.bos.openapi.form.util.ImportUtil;
import kd.bos.openapi.form.util.pdf.ExportAndDownloadUtil;

public class JobExecutorFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log LOG = LogFactory.getLog(JobExecutorFormPlugin.class);
    private int total = 0;
    private int index = 0;
    private List<String> fileUrls;
    private List<String> fileNames;
    private Map<String, Object> externInfo;
    private boolean flag = true;
    private boolean isFromResourceCloud = false;
    public static final String IMPORT_API = "importapi";

    public void afterCreateNewData(EventObject e) {
        this.fileUrls = (List)this.getView().getFormShowParameter().getCustomParam("fileUrls");
        this.fileNames = (List)this.getView().getFormShowParameter().getCustomParam("fileNames");
        this.externInfo = (Map)this.getView().getFormShowParameter().getCustomParam("importmodel");
        if (CollectionUtil.isNotEmpty(this.fileUrls)) {
            this.total = this.fileUrls.size();
        }
        if (this.getView().getFormShowParameter().getCustomParam("isFromResourceCloud") != null) {
            this.isFromResourceCloud = (Boolean)this.getView().getFormShowParameter().getCustomParam("isFromResourceCloud");
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"download"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("job_progress");
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u7b49\u5f85\u4e2d\u2026", (String)"JobExecutorFormPlugin_5", (String)"bos-open-formplugin", (Object[])new Object[0]));
        progressBar.start();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ArrayList<OpenImportResponse> result = new ArrayList<OpenImportResponse>();
        this.work(result);
        ProgressBar progressBar = (ProgressBar)this.getControl("job_progress");
        if (this.flag) {
            if (this.isFromResourceCloud) {
                progressBar.setPercent(100, ResManager.loadKDString((String)"\u4e91\u66f4\u65b0\u5b8c\u6210", (String)"JobExecutorFormPlugin_9", (String)"bos-open-formplugin", (Object[])new Object[0]));
            } else {
                progressBar.setPercent(100, ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210", (String)"JobExecutorFormPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
            progressBar.stop();
            this.showJobDescription("job_result", this.buildResult(result));
            this.showJobDescription("job_resultdesc", this.buildJobResultDesc(result));
            String errorStr = this.buildErrorDesc(result);
            if (StringUtil.isNotEmpty((String)errorStr) && !this.isFromResourceCloud) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"download"});
            }
            this.getView().getPageCache().put("errorLog", errorStr);
        } else {
            if (this.isFromResourceCloud) {
                progressBar.setPercent(100, ResManager.loadKDString((String)"\u4e91\u66f4\u65b0\u5931\u8d25", (String)"JobExecutorFormPlugin_10", (String)"bos-open-formplugin", (Object[])new Object[0]));
            } else {
                progressBar.setPercent(100, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"JobExecutorFormPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
            progressBar.stop();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("job_progress");
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equalsIgnoreCase("download")) {
            String errorLog = this.getView().getPageCache().get("errorLog");
            String fp = ExportUtil.createTxt(errorLog);
            String fileName = "errorLog_" + System.currentTimeMillis() + ".txt";
            try {
                ExportAndDownloadUtil.download(this.getView(), fp, fileName);
            }
            catch (Exception e) {
                LOG.error("download log error", (Throwable)e);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)Boolean.TRUE);
    }

    private void work(List<OpenImportResponse> result) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (this.isFromResourceCloud) {
            String dataStr = (String)formShowParameter.getCustomParam("jsonFromResourceCloud");
            String[] split = dataStr.split("\n");
            List<String> jsonList = Arrays.asList(split);
            HashMap<String, Object> externInfo = new HashMap<String, Object>();
            externInfo.put("IMPORT_MODE", ImportMode.OVERWRITE);
            try {
                List<OpenImportResponse> openImportResponses = ImportUtil.importDtsFromCloud(jsonList, externInfo);
                result.addAll(openImportResponses);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(" update failed");
                this.showJobDescription("job_resultdesc", DataUtil.toString((Throwable)e));
                this.showJobDescription("job_result", ResManager.loadKDString((String)"\u4e91\u66f4\u65b0\u53d1\u751f\u4e2d\u65ad\u9519\u8bef", (String)"JobExecutorFormPlugin_11", (String)"bos-open-formplugin", (Object[])new Object[0]));
                this.flag = false;
            }
            return;
        }
        for (int i = 0; i < this.total; ++i) {
            String url = this.fileUrls.get(i);
            String fileName = this.fileNames.get(i);
            try (InputStream inputStream = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(url);){
                List<OpenImportResponse> importResponses = ImportUtil.importDts(inputStream, this.externInfo);
                result.addAll(importResponses);
                ++this.index;
                continue;
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(fileName + " import failed");
                this.showJobDescription("job_resultdesc", fileName + DataUtil.toString((Throwable)ex));
                this.showJobDescription("job_result", ResManager.loadKDString((String)"\u5bfc\u5165\u53d1\u751f\u4e2d\u65ad\u9519\u8bef", (String)"JobExecutorFormPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
                this.flag = false;
                break;
            }
        }
    }

    private void showJobDescription(String controlName, String desc) {
        Label label = (Label)this.getView().getControl(controlName);
        label.setText(desc);
    }

    public String buildResult(List<OpenImportResponse> result) {
        StringBuilder desc = new StringBuilder();
        desc.append(ResManager.loadKDString((String)"\u6210\u529fAPI\uff1a%1$s\u4e2a\uff0c\u5931\u8d25API\uff1a%2$s\u4e2a\uff0c\u5ffd\u7565API\uff1a%3$s\u4e2a ", (String)"JobExecutorFormPlugin_4", (String)"bos-open-formplugin", (Object[])new Object[0]));
        int failCnt = 0;
        int ignoreCnt = 0;
        int successCnt = (int)result.stream().filter(it -> !it.isRef() && it.getStatus() == ImportStatus.SUCCESS || !it.getEntityName().equals("openapi_custom_sort") && it.isRef() && it.getStatus() == ImportStatus.SUCCESS).count();
        failCnt = (int)result.stream().filter(it -> !it.isRef() && it.getStatus() == ImportStatus.FAILED).count();
        ignoreCnt = (int)result.stream().filter(it -> !it.isRef() && it.getStatus() == ImportStatus.IGNORED).count();
        return String.format(desc.toString(), successCnt, failCnt, ignoreCnt);
    }

    public String buildJobResultDesc(List<OpenImportResponse> result) {
        StringBuilder desc = new StringBuilder();
        result.forEach(it -> {
            if (it.getStatus() == ImportStatus.FAILED) {
                String isRef = ResManager.loadKDString((String)"\uff08\u5f15\u7528\u8d44\u6e90\uff09", (String)"JobExecutorFormPlugin_7", (String)"bos-open-formplugin", (Object[])new Object[0]);
                String name = it.isRef() ? isRef + "[" + it.getEntityTitle() + "]" + it.getNumber() : "[" + it.getEntityTitle() + "]" + it.getNumber();
                desc.append(name);
                desc.append('\uff1a');
                desc.append(StringUtil.isEmpty((String)it.getMessage()) ? ResManager.loadKDString((String)"\u672a\u77e5\u9519\u8bef\u3002", (String)"JobExecutorFormPlugin_8", (String)"bos-open-formplugin", (Object[])new Object[0]) : it.getMessage());
                desc.append('\n');
            }
            if (!it.isRef() && it.getStatus() == ImportStatus.IGNORED) {
                desc.append(it.getEntityTitle());
                desc.append('_');
                desc.append(it.getNumber());
                desc.append('\uff1a');
                desc.append(ResManager.loadKDString((String)"\u5df2\u5ffd\u7565", (String)"JobExecutorFormPlugin_6", (String)"bos-open-formplugin", (Object[])new Object[0]));
                desc.append('\n');
            }
        });
        return desc.toString();
    }

    public String buildErrorDesc(List<OpenImportResponse> result) {
        StringBuilder desc = new StringBuilder();
        result.forEach(it -> {
            if (it.getStatus() == ImportStatus.FAILED) {
                String isRef = ResManager.loadKDString((String)"\uff08\u5f15\u7528\u8d44\u6e90\uff09", (String)"JobExecutorFormPlugin_7", (String)"bos-open-formplugin", (Object[])new Object[0]);
                String name = it.isRef() ? isRef + "[" + it.getEntityTitle() + "]" + it.getNumber() : "[" + it.getEntityTitle() + "]" + it.getNumber();
                desc.append(name);
                desc.append('\uff1a');
                desc.append(DataUtil.toString((Throwable)it.getErr()));
                desc.append('\n');
            }
        });
        return desc.toString();
    }

    public void onProgress(ProgressEvent progressEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (event.getActionId().equals(IMPORT_API) && null != event.getReturnData() && event.getReturnData().equals(Boolean.TRUE)) {
            this.getView().setReturnData((Object)Boolean.TRUE);
            this.getView().close();
        }
    }
}

