/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.msgalarm;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.IMsgEventListener;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OpenApiAlarmMsgListener
implements IMsgEventListener {
    private static Log logger = LogFactory.getLog(OpenApiAlarmMsgListener.class);

    public void subscribeSuccessMsgResult(Long msgId, Map<String, Object> data) {
        logger.debug("OpenApi subscribeSuccessMsgResult:" + data);
        this.reWriteAlarmLog(msgId, data);
    }

    public void subscribeFailMsgResult(Long msgId, Map<String, Object> data) {
        logger.debug("OpenApi subscribeFailMsgResult:" + data);
        this.reWriteAlarmLog(msgId, data);
    }

    private void reWriteAlarmLog(Long msgId, Map<String, Object> data) {
        if (data != null && data.size() > 0) {
            DynamicObject[] logs;
            if (!QueryServiceHelper.exists((String)"openapi_alarmlog", (QFilter[])new QFilter[]{new QFilter("channelmsgid", "=", (Object)msgId)})) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    logger.error("Thread.sleep error:" + e.getMessage(), (Throwable)e);
                }
            }
            if ((logs = BusinessDataServiceHelper.load((String)"openapi_alarmlog", (String)"status,remark", (QFilter[])new QFilter[]{new QFilter("channelmsgid", "=", (Object)msgId)})) != null && logs.length > 0) {
                if (data.containsKey("state")) {
                    logs[0].set("status", (Object)("fail".equals(data.get("state")) ? "0" : "1"));
                }
                if (data.containsKey("errorinfo")) {
                    logs[0].set("remark", (Object)StringUtil.substring((Object)data.get("errorinfo").toString(), (int)500));
                }
                SaveServiceHelper.update((DynamicObject[])logs);
            }
        }
    }
}

