/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.report;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.report.util.ReportFormUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OpenApiLogReportDataPlugin
extends AbstractReportListDataPlugin {
    private static final int THIRD = 0;
    private static final int API = 1;
    private static final int DAY = 2;

    public DataSet query(ReportQueryParam arg0, Object arg1) throws Throwable {
        ReportQueryParam param = this.getQueryParam();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(QFilter.of((String)"type=?", (Object[])new Object[]{2}));
        if (param.getFilter().getQFilters().size() > 0) {
            filters.addAll(this.qfilterReBuild(param.getFilter().getQFilters()));
        }
        this.addFilterFromTableHead(this.getQueryParam().getFilter().getTableHeadFilterItems(), filters);
        QFilter[] qfs = filters.toArray(new QFilter[filters.size()]);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"openapi_statdata", (String)"time,apiid,thirdid,cnt,successcnt,cost,type", (QFilter[])qfs, (String)"time desc");){
            String[] stringArray;
            int listBoxType;
            String sortInfo = this.getQueryParam().getSortInfo();
            GroupbyDataSet groupby = null;
            int n = listBoxType = param.getCustomParam().get("type") == null ? 2 : (Integer)param.getCustomParam().get("type");
            if (listBoxType == 1) {
                String[] stringArray2;
                groupby = dataSet.groupBy(new String[]{"apiid"});
                groupby.sum("cnt");
                groupby.sum("successcnt");
                groupby.sum("cost", "costsum");
                DataSet dataSet2 = groupby.finish().select(new String[]{"apiid", "cnt", "successcnt", "cnt - successcnt as failcnt", "costsum / cnt as costavg", "round(successcnt*100.0/cnt,2)+'%' as success_rate"});
                if (StringUtil.isNotEmpty((String)sortInfo)) {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = sortInfo;
                } else {
                    stringArray2 = new String[]{};
                }
                DataSet dataSet3 = dataSet2.orderBy(stringArray2);
                return dataSet3;
            }
            if (listBoxType == 2) {
                String[] stringArray4;
                groupby = dataSet.groupBy(new String[]{"time"});
                groupby.sum("cnt");
                groupby.sum("successcnt");
                groupby.sum("cost", "costsum");
                DataSet dataSet4 = groupby.finish().select(new String[]{"time as date", "cnt", "successcnt", "cnt - successcnt as failcnt", "costsum / cnt as costavg", "round(successcnt*100.0/cnt,2)+'%' as success_rate"});
                if (StringUtil.isNotEmpty((String)sortInfo)) {
                    String[] stringArray5 = new String[1];
                    stringArray4 = stringArray5;
                    stringArray5[0] = sortInfo;
                } else {
                    String[] stringArray6 = new String[1];
                    stringArray4 = stringArray6;
                    stringArray6[0] = "date desc";
                }
                DataSet dataSet5 = dataSet4.orderBy(stringArray4);
                return dataSet5;
            }
            if (listBoxType == 0) {
                String[] stringArray7;
                groupby = dataSet.groupBy(new String[]{"thirdid"});
                groupby.sum("cnt");
                groupby.sum("successcnt");
                groupby.sum("cost", "costsum");
                DataSet dataSet6 = groupby.finish().select(new String[]{"thirdid", "cnt", "successcnt", "cnt - successcnt as failcnt", "costsum / cnt as costavg", "round(successcnt*100.0/cnt,2)+'%' as success_rate"});
                if (StringUtil.isNotEmpty((String)sortInfo)) {
                    String[] stringArray8 = new String[1];
                    stringArray7 = stringArray8;
                    stringArray8[0] = sortInfo;
                } else {
                    stringArray7 = new String[]{};
                }
                DataSet dataSet7 = dataSet6.orderBy(stringArray7);
                return dataSet7;
            }
            groupby = dataSet.groupBy(new String[]{"apiid", "thirdid", "time"});
            groupby.sum("cnt");
            groupby.sum("successcnt");
            groupby.sum("cost", "costsum");
            DataSet dataSet8 = groupby.finish().select(new String[]{"time as date", "apiid", "thirdid", "cnt", "successcnt", "cnt - successcnt as failcnt", "costsum / cnt as costavg", "round(successcnt*100.0/cnt,2)+'%' as success_rate"});
            if (StringUtil.isNotEmpty((String)sortInfo)) {
                String[] stringArray9 = new String[1];
                stringArray = stringArray9;
                stringArray9[0] = sortInfo;
            } else {
                String[] stringArray10 = new String[1];
                stringArray = stringArray10;
                stringArray10[0] = "date desc";
            }
            DataSet dataSet9 = dataSet8.orderBy(stringArray);
            return dataSet9;
        }
    }

    private List<QFilter> qfilterReBuild(List<QFilter> qFilters) throws ParseException {
        ArrayList<QFilter> newQfilters = new ArrayList<QFilter>();
        Date timeToday0 = DateUtil.getDateWithoutHour((Date)new Date());
        Date timeBefore7Day = DateUtil.getDateWithoutHour((Date)DateUtil.getDateAdd((Date)new Date(), (int)6, (int)-7));
        Date timeBefore30Day = DateUtil.getDateWithoutHour((Date)DateUtil.getDateAdd((Date)new Date(), (int)6, (int)-30));
        Date timeBefore90Day = DateUtil.getDateWithoutHour((Date)DateUtil.getDateAdd((Date)new Date(), (int)6, (int)-90));
        Date timeBefore365Day = DateUtil.getDateWithoutHour((Date)DateUtil.getDateAdd((Date)new Date(), (int)6, (int)-365));
        for (QFilter qFilter : qFilters) {
            if (qFilter.getProperty().equals("time")) {
                switch (qFilter.getValue().toString()) {
                    case "1": {
                        newQfilters.add(QFilter.of((String)"time>=?", (Object[])new Object[]{timeToday0.getTime()}));
                        break;
                    }
                    case "2": {
                        newQfilters.add(QFilter.of((String)"time>=?", (Object[])new Object[]{timeBefore7Day.getTime()}));
                        break;
                    }
                    case "3": {
                        newQfilters.add(QFilter.of((String)"time>=?", (Object[])new Object[]{timeBefore30Day.getTime()}));
                        break;
                    }
                    case "4": {
                        newQfilters.add(QFilter.of((String)"time>=?", (Object[])new Object[]{timeBefore90Day.getTime()}));
                        break;
                    }
                    case "5": {
                        newQfilters.add(QFilter.of((String)"time>=?", (Object[])new Object[]{timeBefore365Day.getTime()}));
                        break;
                    }
                    default: {
                        newQfilters.add(QFilter.of((String)"type=?", (Object[])new Object[]{2}));
                        break;
                    }
                }
                continue;
            }
            if (qFilter.getProperty().equals("servicetype")) {
                newQfilters.add(new QFilter("apiid.apiservicetype", qFilter.getCP(), qFilter.getValue()));
                continue;
            }
            if (qFilter.getProperty().equals("app.id")) {
                newQfilters.add(new QFilter("apiid.appid", qFilter.getCP(), qFilter.getValue()));
                continue;
            }
            if (qFilter.getProperty().equals("api.id")) {
                newQfilters.add(new QFilter("apiid", qFilter.getCP(), qFilter.getValue()));
                continue;
            }
            if (qFilter.getProperty().equals("api.name")) {
                newQfilters.add(new QFilter("apiid.name", qFilter.getCP(), qFilter.getValue()).or(new QFilter("apiid.number", qFilter.getCP(), qFilter.getValue())));
                continue;
            }
            if (qFilter.getProperty().equals("third.id")) {
                newQfilters.add(new QFilter("thirdid", qFilter.getCP(), qFilter.getValue()));
                continue;
            }
            if (!qFilter.getProperty().equals("third.name")) continue;
            newQfilters.add(new QFilter("thirdid.name", qFilter.getCP(), qFilter.getValue()).or(new QFilter("thirdid.number", qFilter.getCP(), qFilter.getValue())));
        }
        return newQfilters;
    }

    private void addFilterFromTableHead(List<FilterItemInfo> items, List<QFilter> filters) {
        for (FilterItemInfo item : items) {
            QFilter q;
            Object value;
            QFilter q2;
            if (item == null) continue;
            String propName = item.getPropName();
            if ("apiurl".equals(propName)) {
                ReportFormUtil.getTableHeadFilterCompareType(item);
                q2 = new QFilter("apiid.urlformat", item.getCompareType(), item.getValue());
                filters.add(q2);
                continue;
            }
            if ("thirdappnumber".equals(propName)) {
                ReportFormUtil.getTableHeadFilterCompareType(item);
                q2 = new QFilter("thirdid.number", item.getCompareType(), item.getValue());
                filters.add(q2);
                continue;
            }
            if ("cnt".equals(propName) || "successcnt".equals(propName)) {
                value = item.getValue();
                q = new QFilter(propName, item.getCompareType(), (Object)Long.valueOf(value.toString()));
                filters.add(q);
                continue;
            }
            if ("failcnt".equals(propName)) {
                value = item.getValue();
                q = QFilter.of((String)"cnt-successcnt=?", (Object[])new Object[]{Long.valueOf(value.toString())});
                filters.add(q);
                continue;
            }
            if (!"costavg".equals(propName)) continue;
            value = item.getValue();
            q = QFilter.of((String)"cost / cnt=?", (Object[])new Object[]{Long.valueOf(value.toString())});
            filters.add(q);
        }
    }
}

