/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.mvc.report.ReportView;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.report.util.OpenApiLogTimeFilterEnum;
import kd.bos.openapi.form.plugin.report.util.ReportFormUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class OpenApiLogReportPlugin
extends AbstractReportFormPlugin
implements ListboxClickListener,
HyperLinkClickListener {
    private static final Integer THIRD = 0;
    private static final Integer API = 1;
    private static final Integer DAY = 2;
    private static final Integer DETAIL = 3;

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        HashMap<String, Integer> map = new HashMap<String, Integer>(1);
        String type = this.getPageCache().get("type");
        if (null != type) {
            if (type.equals("0")) {
                map.put("type", THIRD);
            } else if (type.equals("1")) {
                map.put("type", API);
            } else if (type.equals("2")) {
                map.put("type", DAY);
            } else {
                map.put("type", DETAIL);
            }
        }
        queryParam.setCustomParam(map);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject row : rowData) {
            DynamicObject thirdapp = row.getDynamicObject("thirdid");
            if (thirdapp == null) {
                row.set("thirdappnumber", (Object)"N/A");
                row.set("thirdappname", (Object)"N/A");
            } else {
                row.set("thirdappnumber", (Object)thirdapp.getString("number"));
                row.set("thirdappname", thirdapp.getLocaleString("name").getDefaultItem());
            }
            DynamicObject api = row.getDynamicObject("apiid");
            if (api == null) {
                row.set("apiname", (Object)"N/A");
                row.set("apiurl", (Object)"N/A");
                continue;
            }
            row.set("apiname", api.getLocaleString("name").getDefaultItem());
            row.set("apiurl", (Object)api.getString("urlformat"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Listbox box = (Listbox)this.getView().getControl("listboxap");
        box.addListboxClickListener((ListboxClickListener)this);
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        reportlistap.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Listbox box = (Listbox)this.getView().getControl("listboxap");
        ListboxItem listboxItem1 = new ListboxItem("3rd", ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528", (String)"OpenApiLogReportPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
        ListboxItem listboxItem2 = new ListboxItem("api", "API");
        ListboxItem listboxItem3 = new ListboxItem("day", ResManager.loadKDString((String)"\u5929", (String)"OpenApiLogReportPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
        ListboxItem listboxItem4 = new ListboxItem("detail", ResManager.loadKDString((String)"\u660e\u7ec6", (String)"OpenApiLogReportPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
        ArrayList<ListboxItem> itemlist = new ArrayList<ListboxItem>();
        itemlist.add(listboxItem3);
        itemlist.add(listboxItem1);
        itemlist.add(listboxItem2);
        itemlist.add(listboxItem4);
        box.addItems(itemlist);
        box.activeItem("day");
        this.setTableFieldVisible("day");
    }

    public void listboxClick(ListboxEvent arg) {
        this.setTableFieldVisible(arg.getItemId());
        ReportView view = (ReportView)this.getView();
        view.refresh();
        String itemId = arg.getItemId();
        if (itemId.equals("3rd")) {
            this.getPageCache().put("type", THIRD.toString());
        } else if (itemId.equals("api")) {
            this.getPageCache().put("type", API.toString());
        } else if (itemId.equals("day")) {
            this.getPageCache().put("type", DAY.toString());
        } else {
            this.getPageCache().put("type", DETAIL.toString());
        }
        this.getView().updateView();
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            List<String> sortList;
            List<String> filterList = Arrays.asList("apiurl", "thirdappnumber", "cnt", "successcnt", "failcnt", "costavg");
            if (filterList.contains(event.getColumnName())) {
                event.setFilter(true);
            }
            if (!(sortList = Arrays.asList("cnt", "successcnt", "failcnt", "costavg")).contains(event.getColumnName())) continue;
            event.setSort(true);
        }
    }

    private void setTableFieldVisible(String boxItemId) {
        if (boxItemId.equals("3rd")) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("thirdid", Boolean.TRUE);
            map.put("date", Boolean.TRUE);
            map.put("apiid", Boolean.TRUE);
            map.put("apiname", Boolean.TRUE);
            map.put("appname", Boolean.TRUE);
            map.put("apiurl", Boolean.TRUE);
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)"openapi_statdata_report_reportlistap_reportcolumnsmap", (String)SerializationUtils.serializeToBase64(map));
        } else if (boxItemId.equals("api")) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("thirdid", Boolean.TRUE);
            map.put("thirdappnumber", Boolean.TRUE);
            map.put("thirdappname", Boolean.TRUE);
            map.put("apiid", Boolean.TRUE);
            map.put("date", Boolean.TRUE);
            map.put("appname", Boolean.TRUE);
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)"openapi_statdata_report_reportlistap_reportcolumnsmap", (String)SerializationUtils.serializeToBase64(map));
        } else if (boxItemId.equals("day")) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("thirdid", Boolean.TRUE);
            map.put("thirdappnumber", Boolean.TRUE);
            map.put("thirdappname", Boolean.TRUE);
            map.put("apiid", Boolean.TRUE);
            map.put("apiname", Boolean.TRUE);
            map.put("apiurl", Boolean.TRUE);
            map.put("apiservicetype", Boolean.TRUE);
            map.put("appname", Boolean.TRUE);
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)"openapi_statdata_report_reportlistap_reportcolumnsmap", (String)SerializationUtils.serializeToBase64(map));
        } else {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("thirdid", Boolean.TRUE);
            map.put("apiid", Boolean.TRUE);
            map.put("thirdname", Boolean.FALSE);
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)"openapi_statdata_report_reportlistap_reportcolumnsmap", (String)SerializationUtils.serializeToBase64(map));
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        if (null != this.getPageCache().get("type") && this.getPageCache().get("type").equals(DETAIL.toString())) {
            e.getNoLinkKey().add("thirdappnumber");
            e.getNoLinkKey().add("apiurl");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String number;
        String fieldName = hyperLinkClickEvent.getFieldName();
        String type = this.getPageCache().get("type");
        if ("date".equals(fieldName) && !DETAIL.toString().equals(type)) {
            Date startDate = hyperLinkClickEvent.getRowData().getDate("date");
            Date endDate = DateUtil.getDateAdd((Date)startDate, (int)5, (int)1);
            QFilter filter = new QFilter("opdate", ">=", (Object)startDate).and(new QFilter("opdate", "<", (Object)endDate));
            ReportFormUtil.openApiLogBillList((AbstractFormPlugin)this, Collections.singletonList(filter), "");
        } else if ("date".equals(fieldName) && DETAIL.toString().equals(type)) {
            String number2;
            Date startDate = hyperLinkClickEvent.getRowData().getDate("date");
            Date endDate = DateUtil.getDateAdd((Date)startDate, (int)5, (int)1);
            QFilter filter = new QFilter("opdate", ">=", (Object)startDate).and(new QFilter("opdate", "<", (Object)endDate));
            String apiId = hyperLinkClickEvent.getRowData().getString("apiid.id");
            if (StringUtil.isNotEmpty((String)apiId)) {
                filter.and(new QFilter("apiid", "=", (Object)apiId));
            }
            if (StringUtil.isNotEmpty((String)(number2 = hyperLinkClickEvent.getRowData().getString("thirdid.number")))) {
                filter.and(new QFilter("thirdappname", "=", (Object)number2));
            }
            ReportFormUtil.openApiLogBillList((AbstractFormPlugin)this, Collections.singletonList(filter), "");
        } else if ("apiurl".equals(fieldName)) {
            String apiId = hyperLinkClickEvent.getRowData().getString("apiid.id");
            if (StringUtil.isNotEmpty((String)apiId)) {
                QFilter filter = new QFilter("apiid", "=", (Object)apiId);
                ReportFormUtil.openApiLogBillList((AbstractFormPlugin)this, Collections.singletonList(filter), this.getLogTimeFilter());
            }
        } else if ("thirdappnumber".equals(fieldName) && StringUtil.isNotEmpty((String)(number = hyperLinkClickEvent.getRowData().getString("thirdid.number")))) {
            QFilter filter = new QFilter("thirdappname", "=", (Object)number);
            ReportFormUtil.openApiLogBillList((AbstractFormPlugin)this, Collections.singletonList(filter), this.getLogTimeFilter());
        }
    }

    private String getLogTimeFilter() {
        List qFilters = this.getQueryParam().getFilter().getQFilters();
        if (CollectionUtil.isNotEmpty((Collection)qFilters)) {
            String curReportTimeFilter = ((QFilter)qFilters.get(0)).getValue().toString();
            if (StringUtil.isNotEmpty((String)curReportTimeFilter)) {
                switch (curReportTimeFilter) {
                    case "1": {
                        return OpenApiLogTimeFilterEnum.TODAY.getCode();
                    }
                    case "2": {
                        return OpenApiLogTimeFilterEnum.THISWEEK.getCode();
                    }
                    case "3": {
                        return OpenApiLogTimeFilterEnum.PAST_MONTH.getCode();
                    }
                }
                return OpenApiLogTimeFilterEnum.PAST_THREE_MONTH.getCode();
            }
            return OpenApiLogTimeFilterEnum.THISWEEK.getCode();
        }
        return OpenApiLogTimeFilterEnum.THISWEEK.getCode();
    }
}

