/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.script;

import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isc.util.dt.D;
import kd.bos.isc.util.misc.Json2;
import kd.bos.openapi.base.script.OpenApiScript;
import kd.bos.openapi.base.script.OpenApiScriptUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.common.util.SysUtil;

public class OpenApiScriptDebugPlugin
extends AbstractFormPlugin {
    private static final String EXECUTE = "execute";
    private static final String BOS_OPEN_FORMPLUGIN = "bos-open-formplugin";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (SysUtil.isProdEnv()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{EXECUTE});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        if (EXECUTE.equals(event.getOperateKey())) {
            CodeEdit scriptCode = (CodeEdit)this.getView().getControl("script_code");
            String script = D.s((Object)scriptCode.getText());
            if (StringUtil.isEmpty((String)script)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u4e3a\u7a7a\u3002", (String)"OpenApiScriptDebugPlugin_0", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            CodeEdit scriptResult = (CodeEdit)this.getView().getControl("script_result");
            try {
                Object result;
                if (OpenApiScriptUtil.isExprScript((Object)script)) {
                    result = OpenApiScriptUtil.handleExpr((String)script, Collections.emptyMap());
                } else {
                    OpenApiScript openApiScript = OpenApiScript.compile((String)script);
                    openApiScript.setTimeout(60000);
                    result = openApiScript.eval();
                }
                String json = result instanceof CharSequence ? result.toString() : Json2.toString((Object)result);
                scriptResult.setText(json);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"OpenApiScriptDebugPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
            catch (Exception e) {
                scriptResult.setText(DataUtil.toString((Throwable)e));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u3002", (String)"OpenApiScriptDebugPlugin_2", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }
}

